/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.LastValueQueue;
import org.apache.qpid.server.queue.OrderedQueueEntry;
import org.apache.qpid.server.queue.OrderedQueueEntryList;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.QueueStatistics;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastValueQueueList
extends OrderedQueueEntryList {
    private static final Logger LOGGER = LoggerFactory.getLogger(LastValueQueueList.class);
    private static final OrderedQueueEntryList.HeadCreator HEAD_CREATOR = new OrderedQueueEntryList.HeadCreator(){

        @Override
        public ConflationQueueEntry createHead(QueueEntryList list) {
            return ((LastValueQueueList)list).createHead();
        }
    };
    private final String _conflationKey;
    private final ConcurrentMap<Object, AtomicReference<ConflationQueueEntry>> _latestValuesMap = new ConcurrentHashMap<Object, AtomicReference<ConflationQueueEntry>>();
    private final ConflationQueueEntry _deleteInProgress = new ConflationQueueEntry(this);
    private final ConflationQueueEntry _newerEntryAlreadyBeenAndGone = new ConflationQueueEntry(this);

    public LastValueQueueList(LastValueQueue<?> queue, QueueStatistics queueStatistics) {
        super(queue, queueStatistics, HEAD_CREATOR);
        this._conflationKey = queue.getLvqKey();
    }

    private ConflationQueueEntry createHead() {
        return new ConflationQueueEntry(this);
    }

    protected ConflationQueueEntry createQueueEntry(ServerMessage message, MessageEnqueueRecord enqueueRecord) {
        return new ConflationQueueEntry(this, message, enqueueRecord);
    }

    @Override
    public ConflationQueueEntry add(ServerMessage message, MessageEnqueueRecord enqueueRecord) {
        ConflationQueueEntry addedEntry = (ConflationQueueEntry)super.add(message, enqueueRecord);
        Object keyValue = message.getMessageHeader().getHeader(this._conflationKey);
        if (keyValue != null) {
            boolean entryFromMapIsOlder;
            boolean keepTryingToUpdateEntryReference;
            AtomicReference<ConflationQueueEntry> entryReferenceFromMap;
            ConflationQueueEntry entryFromMap;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding entry " + addedEntry + " for message " + message.getMessageNumber() + " with conflation key " + keyValue);
            }
            AtomicReference<ConflationQueueEntry> referenceToEntry = new AtomicReference<ConflationQueueEntry>(addedEntry);
            while ((entryFromMap = (entryReferenceFromMap = this.getOrPutIfAbsent(keyValue, referenceToEntry)).get()) == this._deleteInProgress || (keepTryingToUpdateEntryReference = (entryFromMapIsOlder = entryFromMap != this._newerEntryAlreadyBeenAndGone && entryFromMap.compareTo(addedEntry) < 0) && !entryReferenceFromMap.compareAndSet(entryFromMap, addedEntry))) {
            }
            if (entryFromMap == this._newerEntryAlreadyBeenAndGone) {
                this.discardEntry(addedEntry);
            } else if (entryFromMap.compareTo(addedEntry) > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("New entry " + addedEntry.getEntryId() + " for message " + addedEntry.getMessage().getMessageNumber() + " being immediately discarded because a newer entry arrived. The newer entry is: " + entryFromMap + " for message " + entryFromMap.getMessage().getMessageNumber());
                }
                this.discardEntry(addedEntry);
            } else if (entryFromMap.compareTo(addedEntry) < 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Entry " + addedEntry + " for message " + addedEntry.getMessage().getMessageNumber() + " replacing older entry " + entryFromMap + " for message " + entryFromMap.getMessage().getMessageNumber());
                }
                this.discardEntry(entryFromMap);
            }
            addedEntry.setLatestValueReference(entryReferenceFromMap);
        }
        return addedEntry;
    }

    @Override
    public QueueEntry getLeastSignificantOldestEntry() {
        return this.getOldestEntry();
    }

    private AtomicReference<ConflationQueueEntry> getOrPutIfAbsent(Object key, AtomicReference<ConflationQueueEntry> referenceToAddedValue) {
        AtomicReference latestValueReference = this._latestValuesMap.putIfAbsent(key, referenceToAddedValue);
        if (latestValueReference == null && (latestValueReference = (AtomicReference)this._latestValuesMap.get(key)) == null) {
            return new AtomicReference<ConflationQueueEntry>(this._newerEntryAlreadyBeenAndGone);
        }
        return latestValueReference;
    }

    private void discardEntry(final QueueEntry entry) {
        if (entry.acquire()) {
            AutoCommitTransaction txn = new AutoCommitTransaction(this.getQueue().getVirtualHost().getMessageStore());
            txn.dequeue(entry.getEnqueueRecord(), new ServerTransaction.Action(){

                @Override
                public void postCommit() {
                    entry.delete();
                }

                @Override
                public void onRollback() {
                }
            });
        }
    }

    Map<Object, AtomicReference<ConflationQueueEntry>> getLatestValuesMap() {
        return Collections.unmodifiableMap(this._latestValuesMap);
    }

    final class ConflationQueueEntry
    extends OrderedQueueEntry {
        private AtomicReference<ConflationQueueEntry> _latestValueReference;

        private ConflationQueueEntry(LastValueQueueList queueEntryList) {
            super(queueEntryList);
        }

        public ConflationQueueEntry(LastValueQueueList queueEntryList, ServerMessage message, MessageEnqueueRecord messageEnqueueRecord) {
            super(queueEntryList, message, messageEnqueueRecord);
        }

        @Override
        public void release() {
            super.release();
            this.discardIfReleasedEntryIsNoLongerLatest();
        }

        @Override
        public void release(MessageInstanceConsumer<?> consumer) {
            super.release(consumer);
            this.discardIfReleasedEntryIsNoLongerLatest();
        }

        @Override
        protected void onDelete() {
            if (this._latestValueReference != null && this._latestValueReference.compareAndSet(this, LastValueQueueList.this._deleteInProgress)) {
                Object key = this.getMessage().getMessageHeader().getHeader(LastValueQueueList.this._conflationKey);
                LastValueQueueList.this._latestValuesMap.remove(key, this._latestValueReference);
            }
        }

        void setLatestValueReference(AtomicReference<ConflationQueueEntry> latestValueReference) {
            this._latestValueReference = latestValueReference;
            if (this.isDeleted()) {
                this.onDelete();
            }
        }

        private void discardIfReleasedEntryIsNoLongerLatest() {
            if (this._latestValueReference != null && this._latestValueReference.get() != this) {
                LastValueQueueList.this.discardEntry(this);
            }
        }
    }
}

