/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.message.MessageDeletedException;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.OverflowPolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.OverflowPolicyHandler;
import org.apache.qpid.server.queue.OverflowPolicyMaximumQueueDepthChangeListener;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryIterator;

public class FlowToDiskOverflowPolicyHandler
implements OverflowPolicyHandler {
    private final Handler _handler;

    FlowToDiskOverflowPolicyHandler(Queue<?> queue) {
        this._handler = new Handler(queue);
        queue.addChangeListener(this._handler);
    }

    @Override
    public void checkOverflow(QueueEntry newlyEnqueued) {
        this._handler.checkOverflow(newlyEnqueued);
    }

    private static class Handler
    extends OverflowPolicyMaximumQueueDepthChangeListener {
        private final Queue<?> _queue;

        private Handler(Queue<?> queue) {
            super(OverflowPolicy.FLOW_TO_DISK);
            this._queue = queue;
        }

        @Override
        void onMaximumQueueDepthChange(Queue<?> queue) {
            this.checkOverflow(null);
        }

        private void checkOverflow(QueueEntry newlyEnqueued) {
            long maximumQueueDepthBytes = this._queue.getMaximumQueueDepthBytes();
            long maximumQueueDepthMessages = this._queue.getMaximumQueueDepthMessages();
            if (maximumQueueDepthBytes >= 0L || maximumQueueDepthMessages >= 0L) {
                if (newlyEnqueued == null) {
                    this.flowTailToDiskIfNecessary(maximumQueueDepthBytes, maximumQueueDepthMessages);
                } else {
                    this.flowNewEntryToDiskIfNecessary(newlyEnqueued, maximumQueueDepthBytes, maximumQueueDepthMessages);
                }
            }
        }

        private void flowTailToDiskIfNecessary(long maximumQueueDepthBytes, long maximumQueueDepthMessages) {
            long queueDepthBytes = this._queue.getQueueDepthBytes();
            long queueDepthMessages = this._queue.getQueueDepthMessages();
            if (maximumQueueDepthBytes >= 0L && queueDepthBytes > maximumQueueDepthBytes || maximumQueueDepthMessages >= 0L && queueDepthMessages > maximumQueueDepthMessages) {
                long cumulativeDepthBytes = 0L;
                long cumulativeDepthMessages = 0L;
                QueueEntryIterator queueEntryIterator = this._queue.queueEntryIterator();
                while (queueEntryIterator.advance()) {
                    ServerMessage message;
                    QueueEntry node = queueEntryIterator.getNode();
                    if (node == null || node.isDeleted() || (message = node.getMessage()) == null || (cumulativeDepthBytes += message.getSizeIncludingHeader()) <= maximumQueueDepthBytes && ++cumulativeDepthMessages <= maximumQueueDepthMessages) continue;
                    this.flowToDisk(node);
                }
            }
        }

        private void flowNewEntryToDiskIfNecessary(QueueEntry newlyEnqueued, long maximumQueueDepthBytes, long maximumQueueDepthMessages) {
            long queueDepthBytes = this._queue.getQueueDepthBytes();
            long queueDepthMessages = this._queue.getQueueDepthMessages();
            if (maximumQueueDepthBytes >= 0L && queueDepthBytes > maximumQueueDepthBytes || maximumQueueDepthMessages >= 0L && queueDepthMessages > maximumQueueDepthMessages) {
                this.flowToDisk(newlyEnqueued);
            }
        }

        private void flowToDisk(QueueEntry node) {
            try (MessageReference messageReference = node.getMessage().newReference();){
                if (node.getQueue().checkValid(node)) {
                    messageReference.getMessage().getStoredMessage().flowToDisk();
                }
            }
            catch (MessageDeletedException messageDeletedException) {
                // empty catch block
            }
        }
    }
}

