/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.transport.AbstractAMQPConnection;

public class PublishAuthorisationCache {
    private final SecurityToken _token;
    private final long _publishAuthCacheTimeout;
    private final int _publishAuthCacheSize;
    private final LinkedHashMap<PublishAuthKey, Long> _publishAuthCache = new LinkedHashMap<PublishAuthKey, Long>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<PublishAuthKey, Long> eldest) {
            return this.size() > PublishAuthorisationCache.this._publishAuthCacheSize;
        }
    };

    public PublishAuthorisationCache(SecurityToken token, long publishAuthCacheTimeout, int publishAuthCacheSize) {
        this._token = token;
        this._publishAuthCacheTimeout = publishAuthCacheTimeout;
        this._publishAuthCacheSize = publishAuthCacheSize;
    }

    public void authorisePublish(MessageDestination destination, String routingKey, boolean isImmediate, long currentTime) {
        PublishAuthKey key = new PublishAuthKey(destination, routingKey, isImmediate);
        Long expiration = this._publishAuthCache.get(key);
        if (expiration == null || expiration < currentTime) {
            destination.authorisePublish(this._token, AbstractAMQPConnection.PUBLISH_ACTION_MAP_CREATOR.createMap(routingKey, isImmediate));
            this._publishAuthCache.put(key, currentTime + this._publishAuthCacheTimeout);
        }
    }

    private final class PublishAuthKey {
        private final MessageDestination _messageDestination;
        private final String _routingKey;
        private final boolean _immediate;
        private final int _hashCode;

        public PublishAuthKey(MessageDestination messageDestination, String routingKey, boolean immediate) {
            this._messageDestination = messageDestination;
            this._routingKey = routingKey;
            this._immediate = immediate;
            this._hashCode = Objects.hash(this._messageDestination, this._routingKey, this._immediate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PublishAuthKey that = (PublishAuthKey)o;
            return this._hashCode == that._hashCode && this._immediate == that._immediate && Objects.equals(this._messageDestination, that._messageDestination) && Objects.equals(this._routingKey, that._routingKey);
        }

        public int hashCode() {
            return this._hashCode;
        }
    }
}

