/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.PortMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.security.ManagedPeerCertificateTrustStore;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.util.ParameterizedTypes;
import org.apache.qpid.server.util.PortUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPort<X extends AbstractPort<X>>
extends AbstractConfiguredObject<X>
implements Port<X> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPort.class);
    private final Container<?> _container;
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private int _port;
    @ManagedAttributeField
    private KeyStore<?> _keyStore;
    @ManagedAttributeField
    private Collection<TrustStore> _trustStores;
    @ManagedAttributeField
    private Set<Transport> _transports;
    @ManagedAttributeField
    private Set<Protocol> _protocols;
    @ManagedAttributeField
    private AuthenticationProvider _authenticationProvider;
    @ManagedAttributeField
    private boolean _needClientAuth;
    @ManagedAttributeField
    private boolean _wantClientAuth;
    @ManagedAttributeField
    private TrustStore<?> _clientCertRecorder;
    @ManagedAttributeField
    private boolean _allowConfidentialOperationsOnInsecureChannels;
    @ManagedAttributeField
    private String _bindingAddress;
    private List<String> _tlsProtocolBlackList;
    private List<String> _tlsProtocolWhiteList;
    private List<String> _tlsCipherSuiteWhiteList;
    private List<String> _tlsCipherSuiteBlackList;

    public AbstractPort(Map<String, Object> attributes, Container<?> container) {
        super(container, attributes);
        this._container = container;
        this._eventLogger = container.getEventLogger();
        this._eventLogger.message(PortMessages.CREATE(this.getName()));
    }

    @Override
    public String getBindingAddress() {
        return this._bindingAddress;
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._tlsProtocolWhiteList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.protocolAllowList", "qpid.security.tls.protocolWhiteList");
        this._tlsProtocolBlackList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.protocolDenyList", "qpid.security.tls.protocolBlackList");
        this._tlsCipherSuiteWhiteList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.cipherSuiteAllowList", "qpid.security.tls.cipherSuiteWhiteList");
        this._tlsCipherSuiteBlackList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.cipherSuiteDenyList", "qpid.security.tls.cipherSuiteBlackList");
    }

    @Override
    public void validateOnCreate() {
        super.validateOnCreate();
        String bindingAddress = this.getBindingAddress();
        if (!PortUtil.isPortAvailable(bindingAddress, this.getPort())) {
            throw new IllegalConfigurationException(String.format("Cannot bind to port %d and binding address '%s'. Port is already is use.", this.getPort(), bindingAddress == null || "".equals(bindingAddress) ? "*" : bindingAddress));
        }
    }

    @Override
    public void onValidate() {
        boolean useClientAuth;
        super.onValidate();
        boolean useTLSTransport = this.isUsingTLSTransport();
        if (useTLSTransport && this.getKeyStore() == null) {
            throw new IllegalConfigurationException("Can't create a port which uses a secure transport but has no KeyStore");
        }
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
        if (this.getPort() != 0) {
            for (Port p : this._container.getChildren(Port.class)) {
                if (p == this || p.getPort() != this.getPort() && p.getBoundPort() != this.getPort()) continue;
                throw new IllegalConfigurationException("Can't add port " + this.getName() + " because port number " + this.getPort() + " is already configured for port " + p.getName());
            }
        }
        AuthenticationProvider authenticationProvider = this.getAuthenticationProvider();
        Set<Transport> transports = this.getTransports();
        this.validateAuthenticationMechanisms(authenticationProvider, transports);
        boolean bl = useClientAuth = this.getNeedClientAuth() || this.getWantClientAuth();
        if (useClientAuth && (this.getTrustStores() == null || this.getTrustStores().isEmpty())) {
            throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but has no trust stores configured.");
        }
        if (useClientAuth && !useTLSTransport) {
            throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but doesn't use SSL transport.");
        }
        if (useClientAuth && this.getClientCertRecorder() != null && !(this.getClientCertRecorder() instanceof ManagedPeerCertificateTrustStore)) {
            throw new IllegalConfigurationException("Only trust stores of type ManagedCertificateStore may be used as the client certificate recorder");
        }
    }

    private void validateAuthenticationMechanisms(AuthenticationProvider<?> authenticationProvider, Set<Transport> transports) {
        ArrayList<String> availableMechanisms = new ArrayList<String>(authenticationProvider.getMechanisms());
        if (authenticationProvider.getDisabledMechanisms() != null) {
            availableMechanisms.removeAll(authenticationProvider.getDisabledMechanisms());
        }
        if (availableMechanisms.isEmpty()) {
            throw new IllegalConfigurationException("The authentication provider '" + authenticationProvider.getName() + "' on port '" + this.getName() + "' has all authentication mechanisms disabled.");
        }
        if (this.hasNonTLSTransport(transports) && authenticationProvider.getSecureOnlyMechanisms() != null) {
            availableMechanisms.removeAll(authenticationProvider.getSecureOnlyMechanisms());
            if (availableMechanisms.isEmpty()) {
                throw new IllegalConfigurationException("The port '" + this.getName() + "' allows for non TLS connections, but all authentication mechanisms of the authentication provider '" + authenticationProvider.getName() + "' are disabled on non-secure connections.");
            }
        }
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider() {
        SystemConfig systemConfig = this.getAncestor(SystemConfig.class);
        if (systemConfig.isManagementMode()) {
            return this._container.getManagementModeAuthenticationProvider();
        }
        return this._authenticationProvider;
    }

    @Override
    public boolean isAllowConfidentialOperationsOnInsecureChannels() {
        return this._allowConfidentialOperationsOnInsecureChannels;
    }

    private boolean isUsingTLSTransport() {
        return this.isUsingTLSTransport(this.getTransports());
    }

    private boolean isUsingTLSTransport(Collection<Transport> transports) {
        return this.hasTransportOfType(transports, true);
    }

    private boolean hasNonTLSTransport(Collection<Transport> transports) {
        return this.hasTransportOfType(transports, false);
    }

    private boolean hasTransportOfType(Collection<Transport> transports, boolean secure) {
        boolean hasTransport = false;
        if (transports != null) {
            for (Transport transport : transports) {
                if (secure != transport.isSecure()) continue;
                hasTransport = true;
                break;
            }
        }
        return hasTransport;
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        boolean requiresCertificate;
        super.validateChange(proxyForValidation, changedAttributes);
        Port updated = (Port)proxyForValidation;
        if (!this.getName().equals(updated.getName())) {
            throw new IllegalConfigurationException("Changing the port name is not allowed");
        }
        if (changedAttributes.contains("port")) {
            int newPort = updated.getPort();
            if (this.getPort() != newPort && newPort != 0) {
                for (Port p : this._container.getChildren(Port.class)) {
                    if (p.getBoundPort() != newPort && p.getPort() != newPort) continue;
                    throw new IllegalConfigurationException("Port number " + newPort + " is already in use by port " + p.getName());
                }
            }
        }
        Set<Transport> transports = updated.getTransports();
        Set<Protocol> protocols = updated.getProtocols();
        boolean usesSsl = this.isUsingTLSTransport(transports);
        if (usesSsl && updated.getKeyStore() == null) {
            throw new IllegalConfigurationException("Can't create port which requires SSL but has no key store configured.");
        }
        if (changedAttributes.contains("authenticationProvider") || changedAttributes.contains("transports")) {
            this.validateAuthenticationMechanisms(updated.getAuthenticationProvider(), updated.getTransports());
        }
        boolean bl = requiresCertificate = updated.getNeedClientAuth() || updated.getWantClientAuth();
        if (usesSsl) {
            if ((updated.getTrustStores() == null || updated.getTrustStores().isEmpty()) && requiresCertificate) {
                throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but has no trust store configured.");
            }
        } else if (requiresCertificate) {
            throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but doesn't use SSL transport.");
        }
        if (requiresCertificate && updated.getClientCertRecorder() != null && !(updated.getClientCertRecorder() instanceof ManagedPeerCertificateTrustStore)) {
            throw new IllegalConfigurationException("Only trust stores of type ManagedCertificateStore may be used as the client certificate recorder");
        }
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public Set<Transport> getTransports() {
        return this._transports;
    }

    @Override
    public Set<Protocol> getProtocols() {
        return this._protocols;
    }

    @Override
    public Collection<Connection> getConnections() {
        return this.getChildren(Connection.class);
    }

    @Override
    protected ListenableFuture<Void> onDelete() {
        this._eventLogger.message(PortMessages.DELETE(this.getType(), this.getName()));
        return super.onDelete();
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> activate() {
        try {
            this.setState(this.onActivate());
        }
        catch (RuntimeException e) {
            this.setState(State.ERRORED);
            throw new IllegalConfigurationException("Unable to active port '" + this.getName() + "'of type " + this.getType() + " on " + this.getPort(), e);
        }
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    private ListenableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return Futures.immediateFuture(null);
    }

    @Override
    public NamedAddressSpace getAddressSpace(String name) {
        TreeSet<VirtualHostAlias> aliases = new TreeSet<VirtualHostAlias>(VirtualHostAlias.COMPARATOR);
        aliases.addAll(this.getChildren(VirtualHostAlias.class));
        for (VirtualHostAlias alias : aliases) {
            NamedAddressSpace addressSpace = alias.getAddressSpace(name);
            if (addressSpace == null) continue;
            return addressSpace;
        }
        return null;
    }

    protected State onActivate() {
        return State.ACTIVE;
    }

    @Override
    public List<String> getTlsProtocolWhiteList() {
        return this._tlsProtocolWhiteList;
    }

    @Override
    public List<String> getTlsProtocolBlackList() {
        return this._tlsProtocolBlackList;
    }

    @Override
    public List<String> getTlsCipherSuiteWhiteList() {
        return this._tlsCipherSuiteWhiteList;
    }

    @Override
    public List<String> getTlsCipherSuiteBlackList() {
        return this._tlsCipherSuiteBlackList;
    }

    @Override
    public List<String> getTlsProtocolAllowList() {
        return this.getTlsProtocolWhiteList();
    }

    @Override
    public List<String> getTlsProtocolDenyList() {
        return this.getTlsProtocolBlackList();
    }

    @Override
    public List<String> getTlsCipherSuiteAllowList() {
        return this.getTlsCipherSuiteWhiteList();
    }

    @Override
    public List<String> getTlsCipherSuiteDenyList() {
        return this.getTlsCipherSuiteBlackList();
    }

    @Override
    public KeyStore getKeyStore() {
        return this._keyStore;
    }

    @Override
    public Collection<TrustStore> getTrustStores() {
        return this._trustStores;
    }

    @Override
    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    @Override
    public TrustStore<?> getClientCertRecorder() {
        return this._clientCertRecorder;
    }

    @Override
    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    @Override
    public SubjectCreator getSubjectCreator(boolean secure, String host) {
        Collection<GroupProvider<?>> children = this._container.getChildren(GroupProvider.class);
        NamedAddressSpace addressSpace = host != null ? this.getAddressSpace(host) : null;
        return new SubjectCreator(this.getAuthenticationProvider(), children, addressSpace);
    }

    @Override
    protected void logOperation(String operation) {
        this._eventLogger.message(PortMessages.OPERATION(operation));
    }

    @Override
    public String toString() {
        return this.getCategoryClass().getSimpleName() + "[id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", port=" + this.getPort() + "]";
    }

    @Override
    public boolean isTlsSupported() {
        return this.getSSLContext() != null;
    }

    @Override
    public boolean updateTLS() {
        if (this.isTlsSupported()) {
            return this.updateSSLContext();
        }
        return false;
    }

    protected abstract boolean updateSSLContext();
}

