/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.NamedAddressSpace;

public class DestinationAddress {
    private final MessageDestination _messageDestination;
    private final String _routingKey;
    private final String _routingAddress;

    public DestinationAddress(NamedAddressSpace addressSpace, String routingAddress) {
        MessageDestination destination = null;
        String routingKey = routingAddress;
        if (routingAddress != null && !routingAddress.trim().equals("")) {
            String localRoutingAddress = addressSpace.getLocalAddress(routingAddress);
            if (!localRoutingAddress.contains("/")) {
                destination = addressSpace.getAttainedMessageDestination(localRoutingAddress);
                if (destination != null) {
                    routingKey = "";
                }
            } else if (!localRoutingAddress.startsWith("/")) {
                String[] parts = localRoutingAddress.split("/", 2);
                destination = addressSpace.getAttainedMessageDestination(parts[0]);
                if (destination instanceof Exchange) {
                    routingKey = parts[1];
                } else {
                    destination = null;
                }
            }
        }
        this._routingAddress = routingAddress == null ? "" : routingAddress;
        this._messageDestination = destination;
        this._routingKey = routingKey == null ? "" : routingKey;
    }

    public MessageDestination getMessageDestination() {
        return this._messageDestination;
    }

    public String getRoutingKey() {
        return this._routingKey;
    }

    public String getRoutingAddress() {
        return this._routingAddress;
    }
}

