/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.BrokerImpl;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.DescendantScope;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.auth.SocketConnectionMetaData;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.store.preferences.UserPreferencesCreator;

@ManagedObject(defaultType="Broker", amqpName="org.apache.qpid.Broker")
public interface Broker<X extends Broker<X>>
extends ConfiguredObject<X>,
EventLoggerProvider,
StatisticsGatherer,
Container<X>,
UserPreferencesCreator {
    public static final String BROKER_TYPE = "Broker";
    public static final String BUILD_VERSION = "buildVersion";
    public static final String OPERATING_SYSTEM = "operatingSystem";
    public static final String PLATFORM = "platform";
    public static final String PROCESS_PID = "processPid";
    public static final String PRODUCT_VERSION = "productVersion";
    public static final String STATISTICS_REPORTING_PERIOD = "statisticsReportingPeriod";
    public static final String STORE_PATH = "storePath";
    public static final String MODEL_VERSION = "modelVersion";
    public static final String PREFERENCE_STORE_ATTRIBUTES = "preferenceStoreAttributes";
    public static final String CHANNEL_FLOW_CONTROL_ENFORCEMENT_TIMEOUT = "channel.flowControlEnforcementTimeout";
    public static final String BROKER_FLOW_TO_DISK_THRESHOLD = "broker.flowToDiskThreshold";
    public static final String BROKER_FAIL_STARTUP_WITH_ERRORED_CHILD = "broker.failStartupWithErroredChild";
    public static final String BROKER_FAIL_STARTUP_WITH_ERRORED_CHILD_SCOPE = "broker.failStartupWithErroredChildScope";
    public static final String BROKER_MSG_AUTH = "qpid.broker_msg_auth";
    public static final String STORE_FILESYSTEM_MAX_USAGE_PERCENT = "store.filesystem.maxUsagePercent";
    public static final String QPID_AMQP_PORT = "qpid.amqp_port";
    public static final String QPID_HTTP_PORT = "qpid.http_port";
    public static final String QPID_DOCUMENTATION_URL = "qpid.helpURL";
    public static final String BROKER_STATISTICS_REPORING_PERIOD = "broker.statisticsReportingPeriod";
    public static final String NETWORK_BUFFER_SIZE = "qpid.broker.networkBufferSize";
    public static final int MINIMUM_NETWORK_BUFFER_SIZE = 65536;
    @ManagedContextDefault(name="qpid.broker.networkBufferSize")
    public static final int DEFAULT_NETWORK_BUFFER_SIZE = 262144;
    @ManagedContextDefault(name="broker.name")
    public static final String DEFAULT_BROKER_NAME = "Broker";
    @ManagedContextDefault(name="qpid.amqp_port")
    public static final String DEFAULT_AMQP_PORT_NUMBER = "5672";
    @ManagedContextDefault(name="qpid.http_port")
    public static final String DEFAULT_HTTP_PORT_NUMBER = "8080";
    @ManagedContextDefault(name="broker.flowToDiskThreshold")
    public static final long DEFAULT_FLOW_TO_DISK_THRESHOLD = (long)(0.75 * (double)BrokerImpl.getMaxDirectMemorySize());
    public static final String COMPACT_MEMORY_THRESHOLD = "qpid.compact_memory_threshold";
    @ManagedContextDefault(name="qpid.compact_memory_threshold")
    public static final long DEFAULT_COMPACT_MEMORY_THRESHOLD = (long)(0.5 * (double)BrokerImpl.getMaxDirectMemorySize());
    public static final String COMPACT_MEMORY_INTERVAL = "qpid.compact_memory_interval";
    @ManagedContextDefault(name="qpid.compact_memory_interval")
    public static final long DEFAULT_COMPACT_MEMORY_INTERVAL = 1000L;
    @ManagedContextDefault(name="channel.flowControlEnforcementTimeout")
    public static final long DEFAULT_CHANNEL_FLOW_CONTROL_ENFORCEMENT_TIMEOUT = 5000L;
    @ManagedContextDefault(name="store.filesystem.maxUsagePercent")
    public static final int DEFAULT_FILESYSTEM_MAX_USAGE_PERCENT = 90;
    @ManagedContextDefault(name="broker.failStartupWithErroredChild")
    public static final boolean DEFAULT_BROKER_FAIL_STARTUP_WITH_ERRORED_CHILD = false;
    @ManagedContextDefault(name="broker.failStartupWithErroredChildScope")
    public static final DescendantScope DEFAULT_BROKER_FAIL_STARTUP_WITH_ERRORED_CHILD_SCOPE = DescendantScope.IMMEDIATE;
    @ManagedContextDefault(name="qpid.broker_msg_auth")
    public static final boolean DEFAULT_BROKER_MSG_AUTH = false;
    @ManagedContextDefault(name="qpid.security.tls.protocolWhiteList")
    public static final String DEFAULT_SECURITY_TLS_PROTOCOL_WHITE_LIST = "[\"" + "TLSv1\\.[0-9]+".replace("\\", "\\\\") + "\"]";
    @ManagedContextDefault(name="qpid.security.tls.protocolBlackList")
    public static final String DEFAULT_SECURITY_TLS_PROTOCOL_BLACK_LIST = "[\"" + "TLSv1\\.[0-1]".replace("\\", "\\\\") + "\"]";
    @ManagedContextDefault(name="qpid.security.tls.cipherSuiteWhiteList")
    public static final String DEFAULT_SECURITY_TLS_CIPHER_SUITE_WHITE_LIST = "[]";
    @ManagedContextDefault(name="qpid.security.tls.cipherSuiteBlackList")
    public static final String DEFAULT_SECURITY_TLS_CIPHER_SUITE_BLACK_LIST = "[]";
    @ManagedContextDefault(name="qpid.helpURL")
    public static final String DEFAULT_DOCUMENTATION_URL = "http://qpid.apache.org/releases/qpid-broker-j-${qpid.version}/book/";
    @ManagedContextDefault(name="broker.statisticsReportingPeriod")
    public static final int DEFAULT_STATISTICS_REPORTING_PERIOD = 0;
    public static final String PROPERTY_DISABLED_FEATURES = "qpid.broker_disabled_features";
    @ManagedContextDefault(name="broker.housekeepingThreadCount")
    public static final int DEFAULT_HOUSEKEEPING_THREAD_COUNT = 2;
    public static final String QPID_BROKER_HOUSEKEEPING_CHECK_PERIOD = "qpid.broker.housekeepingCheckPeriod";
    @ManagedContextDefault(name="qpid.broker.housekeepingCheckPeriod")
    public static final long DEFAULT_BROKER_HOUSEKEEPING_CHECK_PERIOD = 30000L;
    public static final String BROKER_MESSAGE_COMPRESSION_ENABLED = "broker.messageCompressionEnabled";
    @ManagedContextDefault(name="broker.messageCompressionEnabled")
    public static final boolean DEFAULT_MESSAGE_COMPRESSION_ENABLED = true;
    public static final String MESSAGE_COMPRESSION_THRESHOLD_SIZE = "connection.messageCompressionThresholdSize";
    @ManagedContextDefault(name="connection.messageCompressionThresholdSize")
    public static final int DEFAULT_MESSAGE_COMPRESSION_THRESHOLD_SIZE = 102400;
    public static final String SEND_QUEUE_DELETE_OK_REGARDLESS_CLIENT_VER_REGEXP = "connection.sendQueueDeleteOkRegardlessClientVerRegexp";
    @ManagedContextDefault(name="connection.sendQueueDeleteOkRegardlessClientVerRegexp")
    public static final String DEFAULT_SEND_QUEUE_DELETE_OK_REGARDLESS_CLIENT_VER_REGEXP = "^0\\..*$";
    public static final String BROKER_DIRECT_BYTE_BUFFER_POOL_SIZE = "broker.directByteBufferPoolSize";
    @ManagedContextDefault(name="broker.directByteBufferPoolSize")
    public static final int DEFAULT_BROKER_DIRECT_BYTE_BUFFER_POOL_SIZE = 1024;
    public static final String BROKER_DIRECT_BYTE_BUFFER_POOL_SPARSITY_REALLOCATION_FRACTION = "broker.directByteBufferPoolSparsityReallocationFraction";
    @ManagedContextDefault(name="broker.directByteBufferPoolSparsityReallocationFraction")
    public static final double DEFAULT_BROKER_DIRECT_BYTE_BUFFER_POOL_SPARSITY_REALLOCATION_FRACTION = 0.5;

    @DerivedAttribute
    public String getBuildVersion();

    @DerivedAttribute
    public String getOperatingSystem();

    @DerivedAttribute
    public String getPlatform();

    @DerivedAttribute
    public String getProcessPid();

    @DerivedAttribute
    public String getProductVersion();

    @DerivedAttribute
    public int getNumberOfCores();

    @ManagedAttribute(defaultValue="${broker.statisticsReportingPeriod}", description="Period (in seconds) of the statistic report.")
    public int getStatisticsReportingPeriod();

    @ManagedAttribute(defaultValue="${broker.housekeepingThreadCount}")
    public int getHousekeepingThreadCount();

    @ManagedAttribute(defaultValue="${broker.messageCompressionEnabled}")
    public boolean isMessageCompressionEnabled();

    @ManagedAttribute(validValues={"org.apache.qpid.server.model.BrokerImpl#getAvailableConfigurationEncrypters()"})
    public String getConfidentialConfigurationEncryptionProvider();

    @DerivedAttribute(persist=true)
    public String getModelVersion();

    @Override
    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Inbound", description="Total size of all messages received by the Broker.", metricName="inbound_bytes_count")
    public long getBytesIn();

    @Override
    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Outbound", description="Total size of all messages delivered by the Broker.", metricName="outbound_bytes_count")
    public long getBytesOut();

    @Override
    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Inbound", description="Total number of messages received by the Broker.", metricName="inbound_messages_count")
    public long getMessagesIn();

    @Override
    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Outbound", description="Total number of messages delivered by the Broker.", metricName="outbound_messages_count")
    public long getMessagesOut();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Transacted Inbound", description="Total number of messages delivered by the Broker within a transaction.", metricName="inbound_transacted_messages_count")
    public long getTransactedMessagesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Transacted Outbound", description="Total number of messages received by the Broker within a transaction.", metricName="outbound_transacted_messages_count")
    public long getTransactedMessagesOut();

    @ManagedOperation(nonModifying=true, description="Initiates an orderly shutdown of the Broker.", changesConfiguredObjectState=false)
    public void initiateShutdown();

    @ManagedOperation(nonModifying=true, description="Extract configuration", paramRequiringSecure="includeSecureAttributes", changesConfiguredObjectState=false)
    public Map<String, Object> extractConfig(@Param(name="includeSecureAttributes", description="include attributes that may contain passwords or other confidential information", defaultValue="false") boolean var1);

    @DerivedAttribute(description="Maximum heap memory size")
    public long getMaximumHeapMemorySize();

    @DerivedAttribute(description="Maximum direct memory size which can be consumed by broker")
    public long getMaximumDirectMemorySize();

    @DerivedAttribute(description="JVM arguments specified on startup")
    public List<String> getJvmArguments();

    @DerivedAttribute(description="URL to broker documentation")
    public String getDocumentationUrl();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Live threads", description="Number of live threads", metricName="live_threads_total", metricDisabled=true)
    public int getNumberOfLiveThreads();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Used Heap Memory Size", description="Size of used heap memory", metricDisabled=true)
    public long getUsedHeapMemorySize();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Used Direct Memory Size", description="Size of used direct memory", metricDisabled=true)
    public long getUsedDirectMemorySize();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Direct Memory Total Capacity", description="Total capacity of direct memory allocated for the Broker process", metricName="direct_memory_capacity_bytes_total", metricDisabled=true)
    public long getDirectMemoryTotalCapacity();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Number Of Object Pending Finalization", description="Number of objects pending finalization", metricDisabled=true)
    public int getNumberOfObjectsPendingFinalization();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Number of Buffers In-Use", description="Number of direct memory buffers currently in-use.")
    public long getNumberOfBuffersInUse();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Number of Pooled Buffers", description="Number of unused direct memory buffers currently in the pool.")
    public long getNumberOfBuffersInPool();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Maximum recorded size of inbound messages", description="Maximum size of messages published into the Broker since start-up.", metricName="inbound_message_size_high_watermark")
    public long getInboundMessageSizeHighWatermark();

    @ManagedOperation(nonModifying=true, description="Restart the broker within the same JVM", changesConfiguredObjectState=false, log=true)
    public void restart();

    @ManagedOperation(nonModifying=true, description="Initiates garbage collection", changesConfiguredObjectState=false)
    public void performGC();

    @ManagedOperation(nonModifying=true, description="Collects thread stack traces and dead locks. Dumps stack traces into logs if requested", changesConfiguredObjectState=false)
    public Content getThreadStackTraces(@Param(name="appendToLog", defaultValue="false", description="If true, appends stack traces into logs") boolean var1);

    @ManagedOperation(nonModifying=true, description="Collects thread stack traces for the threads with names containing matching characters for given regular expression", changesConfiguredObjectState=false)
    public Content findThreadStackTraces(@Param(name="threadNameFindExpression", description="Regular expression to find threads with names containing matching characters") String var1);

    @ManagedOperation(nonModifying=true, description="Returns the principal of the currently authenticated user", changesConfiguredObjectState=false, skipAclCheck=true)
    public Principal getUser();

    @ManagedOperation(nonModifying=true, description="Returns metadata concerning the current connection", changesConfiguredObjectState=false, skipAclCheck=true)
    public SocketConnectionMetaData getConnectionMetaData();

    @ManagedOperation(nonModifying=true, description="Returns the groups to which the currently authenticated user belongs", changesConfiguredObjectState=false, skipAclCheck=true)
    public Set<Principal> getGroups();

    @ManagedOperation(description="Removes a user and all associated preferences from the broker's configuration", changesConfiguredObjectState=true)
    public void purgeUser(@Param(name="origin", description="The AuthenticationProvider the username is associated with") AuthenticationProvider<?> var1, @Param(name="username", description="The unqualified username that should be purged from the broker", mandatory=true) String var2);

    public Collection<VirtualHostNode<?>> getVirtualHostNodes();

    public Collection<Port<?>> getPorts();

    public Collection<AuthenticationProvider<?>> getAuthenticationProviders();

    public Collection<AccessControlProvider<?>> getAccessControlProviders();

    public NamedAddressSpace getSystemAddressSpace(String var1);

    public Collection<GroupProvider<?>> getGroupProviders();

    public VirtualHost<?> findVirtualHostByName(String var1);

    public VirtualHostNode findDefautVirtualHostNode();

    public Collection<KeyStore<?>> getKeyStores();

    public Collection<TrustStore<?>> getTrustStores();

    public boolean isManagementMode();

    @Override
    public EventLogger getEventLogger();

    @Override
    public void setEventLogger(EventLogger var1);

    public boolean isVirtualHostPropertiesNodeEnabled();

    @Override
    public AuthenticationProvider<?> getManagementModeAuthenticationProvider();

    public void assignTargetSizes();

    @Override
    public int getNetworkBufferSize();

    public ScheduledFuture<?> scheduleHouseKeepingTask(long var1, TimeUnit var3, Runnable var4);

    public ScheduledFuture<?> scheduleTask(long var1, TimeUnit var3, Runnable var4);

    @DerivedAttribute(description="Threshold direct memory size (in bytes) at which the Broker will start flowing incoming messages to disk.")
    public long getFlowToDiskThreshold();

    @DerivedAttribute(description="Threshold direct memory size (in bytes) at which the Broker will start considering to compact sparse buffers. Set to -1 to disable.")
    public long getCompactMemoryThreshold();

    @DerivedAttribute(description="Time interval (in milliseconds) between runs of the memory compactor check. See also qpid.compact_memory_threshold")
    public long getCompactMemoryInterval();

    @DerivedAttribute(description="Minimum fraction of direct memory buffer that can be occupied before the buffer is considered for compaction")
    public double getSparsityFraction();

    @DerivedAttribute
    public long getHousekeepingCheckPeriod();

    @ManagedOperation(changesConfiguredObjectState=false, nonModifying=true, description="Force direct memory buffer compaction.")
    public void compactMemory();
}

