/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.qpid.server.configuration.CommonProperties;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.plugin.ConfigurationSecretEncrypterFactory;
import org.apache.qpid.server.plugin.PluggableFactoryLoader;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.util.HousekeepingExecutor;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContainer<X extends AbstractContainer<X>>
extends AbstractConfiguredObject<X>
implements Container<X> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractContainer.class);
    private final BufferPoolMXBean _bufferPoolMXBean;
    private final List<String> _jvmArguments;
    private final long _maximumHeapSize = Runtime.getRuntime().maxMemory();
    private final long _maximumDirectMemorySize = AbstractContainer.getMaxDirectMemorySize();
    protected SystemConfig<?> _parent;
    protected EventLogger _eventLogger;
    @ManagedAttributeField(beforeSet="preEncrypterProviderSet", afterSet="postEncrypterProviderSet")
    private String _confidentialConfigurationEncryptionProvider;
    protected HousekeepingExecutor _houseKeepingTaskExecutor;
    @ManagedAttributeField
    private int _housekeepingThreadCount;
    private String _preConfidentialConfigurationEncryptionProvider;

    AbstractContainer(Map<String, Object> attributes, SystemConfig parent) {
        super(parent, attributes);
        this._parent = parent;
        this._eventLogger = parent.getEventLogger();
        this._jvmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        BufferPoolMXBean bufferPoolMXBean = null;
        List<BufferPoolMXBean> bufferPoolMXBeans = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean mBean : bufferPoolMXBeans) {
            if (!mBean.getName().equals("direct")) continue;
            bufferPoolMXBean = mBean;
            break;
        }
        this._bufferPoolMXBean = bufferPoolMXBean;
        if (attributes.get("confidentialConfigurationEncryptionProvider") != null) {
            this._confidentialConfigurationEncryptionProvider = String.valueOf(attributes.get("confidentialConfigurationEncryptionProvider"));
        }
    }

    @Override
    protected void postResolveChildren() {
        super.postResolveChildren();
        if (this._confidentialConfigurationEncryptionProvider != null) {
            this.updateEncrypter(this._confidentialConfigurationEncryptionProvider);
        }
    }

    public static Collection<String> getAvailableConfigurationEncrypters() {
        return new QpidServiceLoader().getInstancesByType(ConfigurationSecretEncrypterFactory.class).keySet();
    }

    static long getMaxDirectMemorySize() {
        long maxMemory = 0L;
        try {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            Class<?> hotSpotDiagnosticMXBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean", true, systemClassLoader);
            Class<?> vmOptionClass = Class.forName("com.sun.management.VMOption", true, systemClassLoader);
            Object hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(hotSpotDiagnosticMXBeanClass);
            Method getVMOption = hotSpotDiagnosticMXBeanClass.getDeclaredMethod("getVMOption", String.class);
            Object vmOption = getVMOption.invoke(hotSpotDiagnosticMXBean, "MaxDirectMemorySize");
            Method getValue = vmOptionClass.getDeclaredMethod("getValue", new Class[0]);
            String maxDirectMemoryAsString = (String)getValue.invoke(vmOption, new Object[0]);
            maxMemory = Long.parseLong(maxDirectMemoryAsString);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException e) {
            LOGGER.debug("Cannot determine direct memory max size using com.sun.management.HotSpotDiagnosticMXBean: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ServerScopedRuntimeException("Unexpected exception in evaluation of MaxDirectMemorySize with HotSpotDiagnosticMXBean", e.getTargetException());
        }
        if (maxMemory == 0L) {
            Pattern maxDirectMemorySizeArgumentPattern = Pattern.compile("^\\s*-XX:MaxDirectMemorySize\\s*=\\s*(\\d+)\\s*([KkMmGgTt]?)\\s*$");
            RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
            List<String> inputArguments = RuntimemxBean.getInputArguments();
            boolean argumentFound = false;
            block10: for (String argument : inputArguments) {
                Matcher matcher = maxDirectMemorySizeArgumentPattern.matcher(argument);
                if (!matcher.matches()) continue;
                argumentFound = true;
                maxMemory = Long.parseLong(matcher.group(1));
                String unit = matcher.group(2);
                char unitChar = "".equals(unit) ? (char)'\u0000' : unit.charAt(0);
                switch (unitChar) {
                    case 'K': 
                    case 'k': {
                        maxMemory *= 1024L;
                        continue block10;
                    }
                    case 'M': 
                    case 'm': {
                        maxMemory *= 0x100000L;
                        continue block10;
                    }
                    case 'G': 
                    case 'g': {
                        maxMemory *= 0x40000000L;
                        continue block10;
                    }
                    case 'T': 
                    case 't': {
                        maxMemory *= 0x10000000000L;
                        continue block10;
                    }
                    case '\u0000': {
                        continue block10;
                    }
                }
                throw new IllegalStateException("Unexpected unit character in MaxDirectMemorySize argument : " + argument);
            }
            if (maxMemory == 0L) {
                if (argumentFound) {
                    throw new IllegalArgumentException("Qpid Broker cannot operate with 0 direct memory. Please, set JVM argument MaxDirectMemorySize to non-zero value");
                }
                maxMemory = Runtime.getRuntime().maxMemory();
            }
        }
        return maxMemory;
    }

    private void updateEncrypter(String encryptionProviderType) {
        if (encryptionProviderType != null && !"".equals(encryptionProviderType.trim())) {
            PluggableFactoryLoader<ConfigurationSecretEncrypterFactory> factoryLoader = new PluggableFactoryLoader<ConfigurationSecretEncrypterFactory>(ConfigurationSecretEncrypterFactory.class);
            ConfigurationSecretEncrypterFactory factory = factoryLoader.get(encryptionProviderType);
            if (factory == null) {
                throw new IllegalConfigurationException("Unknown Configuration Secret Encryption method " + encryptionProviderType);
            }
            this.setEncrypter(factory.createEncrypter(this));
        } else {
            this.setEncrypter(null);
        }
    }

    public String getBuildVersion() {
        return CommonProperties.getBuildVersion();
    }

    public String getOperatingSystem() {
        return SystemUtils.getOSString();
    }

    public String getPlatform() {
        return System.getProperty("java.vendor") + " " + System.getProperty("java.runtime.version", System.getProperty("java.version"));
    }

    public String getProcessPid() {
        return SystemUtils.getProcessPid();
    }

    public String getProductVersion() {
        return CommonProperties.getReleaseVersion();
    }

    public int getNumberOfCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public String getConfidentialConfigurationEncryptionProvider() {
        return this._confidentialConfigurationEncryptionProvider;
    }

    public int getHousekeepingThreadCount() {
        return this._housekeepingThreadCount;
    }

    public String getModelVersion() {
        return "7.1";
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLogger;
    }

    @Override
    public void setEventLogger(EventLogger eventLogger) {
        this._eventLogger = eventLogger;
    }

    private void preEncrypterProviderSet() {
        this._preConfidentialConfigurationEncryptionProvider = this._confidentialConfigurationEncryptionProvider;
    }

    private void postEncrypterProviderSet() {
        if (!Objects.equals(this._preConfidentialConfigurationEncryptionProvider, this._confidentialConfigurationEncryptionProvider)) {
            this.updateEncrypter(this._confidentialConfigurationEncryptionProvider);
            this.forceUpdateAllSecureAttributes();
        }
    }

    public int getNumberOfLiveThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    public long getMaximumHeapMemorySize() {
        return this._maximumHeapSize;
    }

    public long getUsedHeapMemorySize() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long getMaximumDirectMemorySize() {
        return this._maximumDirectMemorySize;
    }

    public long getUsedDirectMemorySize() {
        if (this._bufferPoolMXBean == null) {
            return -1L;
        }
        return this._bufferPoolMXBean.getMemoryUsed();
    }

    public long getDirectMemoryTotalCapacity() {
        if (this._bufferPoolMXBean == null) {
            return -1L;
        }
        return this._bufferPoolMXBean.getTotalCapacity();
    }

    public int getNumberOfObjectsPendingFinalization() {
        return ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount();
    }

    public List<String> getJvmArguments() {
        return this._jvmArguments;
    }

    public void performGC() {
        this.getEventLogger().message(BrokerMessages.OPERATION("performGC"));
        System.gc();
    }

    public Content getThreadStackTraces(boolean appendToLog) {
        this.getEventLogger().message(BrokerMessages.OPERATION("getThreadStackTraces"));
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(true, true);
        StringBuilder threadDump = new StringBuilder();
        threadDump.append(String.format("Full thread dump captured %s", Instant.now())).append(System.lineSeparator());
        for (ThreadInfo threadInfo : threadInfos) {
            threadDump.append(this.getThreadStackTraces(threadInfo));
        }
        long[] deadLocks = threadMXBean.findDeadlockedThreads();
        if (deadLocks != null && deadLocks.length > 0) {
            ThreadInfo[] deadlockedThreads = threadMXBean.getThreadInfo(deadLocks);
            threadDump.append(System.lineSeparator()).append("Deadlock is detected!").append(System.lineSeparator());
            for (ThreadInfo threadInfo : deadlockedThreads) {
                threadDump.append(this.getThreadStackTraces(threadInfo));
            }
        }
        String threadStackTraces = threadDump.toString();
        if (appendToLog) {
            LOGGER.warn("Thread dump:{} {}", (Object)System.lineSeparator(), (Object)threadStackTraces);
        }
        return new ThreadStackContent(threadStackTraces);
    }

    public Content findThreadStackTraces(String threadNameFindExpression) {
        this.getEventLogger().message(BrokerMessages.OPERATION("findThreadStackTraces"));
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(true, true);
        StringBuilder threadDump = new StringBuilder();
        threadDump.append(String.format("Thread dump (names matching '%s') captured %s", threadNameFindExpression, Instant.now())).append(System.lineSeparator());
        Pattern pattern = threadNameFindExpression == null || threadNameFindExpression.equals("") ? null : Pattern.compile(threadNameFindExpression);
        for (ThreadInfo threadInfo : threadInfos) {
            if (pattern != null && !pattern.matcher(threadInfo.getThreadName()).find()) continue;
            threadDump.append(this.getThreadStackTraces(threadInfo));
        }
        return new ThreadStackContent(threadDump.toString());
    }

    private String getThreadStackTraces(ThreadInfo threadInfo) {
        String lineSeparator = System.lineSeparator();
        StringBuilder dump = new StringBuilder();
        dump.append("\"").append(threadInfo.getThreadName()).append("\"").append(" Id=").append(threadInfo.getThreadId()).append(" ").append((Object)threadInfo.getThreadState());
        if (threadInfo.getLockName() != null) {
            dump.append(" on ").append(threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            dump.append(" owned by \"").append(threadInfo.getLockOwnerName()).append("\" Id=").append(threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            dump.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            dump.append(" (in native)");
        }
        dump.append(lineSeparator);
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            dump.append("    at ").append(stackTraceElement.toString()).append(lineSeparator);
            LockInfo lockInfo = threadInfo.getLockInfo();
            if (i == 0 && lockInfo != null) {
                Thread.State threadState = threadInfo.getThreadState();
                switch (threadState) {
                    case BLOCKED: {
                        dump.append("    -  blocked on ").append(lockInfo).append(lineSeparator);
                        break;
                    }
                    case WAITING: {
                        dump.append("    -  waiting on ").append(lockInfo).append(lineSeparator);
                        break;
                    }
                    case TIMED_WAITING: {
                        dump.append("    -  waiting on ").append(lockInfo).append(lineSeparator);
                        break;
                    }
                }
            }
            for (MonitorInfo mi : threadInfo.getLockedMonitors()) {
                if (mi.getLockedStackDepth() != i) continue;
                dump.append("    -  locked ").append(mi).append(lineSeparator);
            }
        }
        LockInfo[] locks = threadInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            dump.append(lineSeparator).append("    Number of locked synchronizers = ").append(locks.length);
            dump.append(lineSeparator);
            for (LockInfo li : locks) {
                dump.append("    - " + li);
                dump.append(lineSeparator);
            }
        }
        dump.append(lineSeparator);
        return dump.toString();
    }

    public ScheduledFuture<?> scheduleHouseKeepingTask(long period, TimeUnit unit, Runnable task) {
        return this._houseKeepingTaskExecutor.scheduleAtFixedRate(task, period / 2L, period, unit);
    }

    public ScheduledFuture<?> scheduleTask(long delay, TimeUnit unit, Runnable task) {
        return this._houseKeepingTaskExecutor.schedule(task, delay, unit);
    }

    public static class ThreadStackContent
    implements Content,
    CustomRestHeaders {
        private final String _threadStackTraces;

        public ThreadStackContent(String threadStackTraces) {
            this._threadStackTraces = threadStackTraces;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            if (this._threadStackTraces != null) {
                outputStream.write(this._threadStackTraces.getBytes(Charset.forName("UTF-8")));
            }
        }

        @Override
        public void release() {
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "text/plain;charset=utf-8";
        }
    }
}

