/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.util.EnumMap;
import java.util.Map;

public interface InstanceProperties {
    public static final InstanceProperties EMPTY = new InstanceProperties(){

        @Override
        public Object getProperty(Property prop) {
            return null;
        }
    };

    public Object getProperty(Property var1);

    public static class Factory {
        public static InstanceProperties fromMap(Map<Property, Object> map) {
            EnumMap<Property, Object> props = new EnumMap<Property, Object>(map);
            return new MapInstanceProperties(props);
        }

        public static Map<Property, Object> asMap(InstanceProperties props) {
            EnumMap<Property, Object> map = new EnumMap<Property, Object>(Property.class);
            for (Property prop : Property.values()) {
                Object value = props.getProperty(prop);
                if (value == null) continue;
                map.put(prop, value);
            }
            return map;
        }

        public static InstanceProperties copy(InstanceProperties from) {
            Map<Property, Object> props = Factory.asMap(from);
            return new MapInstanceProperties(props);
        }

        private static class MapInstanceProperties
        implements InstanceProperties {
            private final Map<Property, Object> _props;

            private MapInstanceProperties(Map<Property, Object> props) {
                this._props = props;
            }

            @Override
            public Object getProperty(Property prop) {
                return this._props.get((Object)prop);
            }
        }
    }

    public static enum Property {
        REDELIVERED,
        PERSISTENT,
        MANDATORY,
        IMMEDIATE,
        EXPIRATION;

    }
}

