/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonProperties.class);
    public static final String IO_NETWORK_TRANSPORT_TIMEOUT_PROP_NAME = "qpid.io_network_transport_timeout";
    public static final int IO_NETWORK_TRANSPORT_TIMEOUT_DEFAULT = 60000;
    public static final String QPID_SECURITY_TLS_PROTOCOL_WHITE_LIST = "qpid.security.tls.protocolWhiteList";
    public static final String QPID_SECURITY_TLS_PROTOCOL_WHITE_LIST_DEFAULT = "TLSv1\\.[0-9]+";
    public static final String QPID_SECURITY_TLS_PROTOCOL_BLACK_LIST = "qpid.security.tls.protocolBlackList";
    public static final String QPID_SECURITY_TLS_PROTOCOL_BLACK_LIST_DEFAULT = "TLSv1\\.[0-1]";
    public static final String QPID_SECURITY_TLS_CIPHER_SUITE_WHITE_LIST = "qpid.security.tls.cipherSuiteWhiteList";
    public static final String QPID_SECURITY_TLS_CIPHER_SUITE_WHITE_LIST_DEFAULT = "";
    public static final String QPID_SECURITY_TLS_CIPHER_SUITE_BLACK_LIST = "qpid.security.tls.cipherSuiteBlackList";
    public static final String QPID_SECURITY_TLS_CIPHER_SUITE_BLACK_LIST_DEFAULT = "";
    public static final String QPID_SECURITY_TLS_PROTOCOL_ALLOW_LIST = "qpid.security.tls.protocolAllowList";
    public static final String QPID_SECURITY_TLS_PROTOCOL_DENY_LIST = "qpid.security.tls.protocolDenyList";
    public static final String QPID_SECURITY_TLS_CIPHER_SUITE_ALLOW_LIST = "qpid.security.tls.cipherSuiteAllowList";
    public static final String QPID_SECURITY_TLS_CIPHER_SUITE_DENY_LIST = "qpid.security.tls.cipherSuiteDenyList";
    private static final String MANIFEST_HEADER_IMPLEMENTATION_BUILD = "Implementation-Build";
    private static final String RELEASE_VERSION_SUFFIX = "qpid.version.suffix";
    private static final String DEFAULT = "unknown";
    private static final String productName;
    private static final String releaseVersion;
    private static final String buildVersion;
    private static final Properties properties;
    private static final String QPID_VERSION = "qpid.version";

    public static void ensureIsLoaded() {
    }

    public static Properties asProperties() {
        return new Properties(properties);
    }

    public static String getProductName() {
        return productName;
    }

    public static String getReleaseVersion() {
        return releaseVersion;
    }

    public static String getBuildVersion() {
        return buildVersion;
    }

    public static String getVersionString() {
        return CommonProperties.getProductName() + " - " + CommonProperties.getReleaseVersion() + " build: " + CommonProperties.getBuildVersion();
    }

    private CommonProperties() {
    }

    private static void loadProperties(Properties properties, String resourceLocation, boolean loadFromFile) {
        block17: {
            try {
                URL propertiesResource = loadFromFile ? new File(resourceLocation).toURI().toURL() : CommonProperties.class.getClassLoader().getResource(resourceLocation);
                if (propertiesResource == null) break block17;
                try (InputStream propertyStream = propertiesResource.openStream();){
                    if (propertyStream != null) {
                        properties.load(propertyStream);
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Could not load properties file '{}'.", (Object)resourceLocation, (Object)e);
                }
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Could not open properties file '{}'.", (Object)resourceLocation, (Object)e);
            }
        }
    }

    private static String getImplementationVersion(Package p) {
        String version = p.getImplementationVersion();
        if (version == null) {
            version = DEFAULT;
            String path = CommonProperties.class.getPackage().getName().replace(".", "/");
            String fallbackPath = "/" + path + "/fallback-version.txt";
            InputStream in = CommonProperties.class.getResourceAsStream(fallbackPath);
            if (in != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.US_ASCII));){
                    version = reader.readLine();
                }
                catch (Exception e) {
                    LOGGER.trace("Problem reading version from fallback resource : {} ", (Object)fallbackPath, (Object)e);
                }
            }
        }
        return version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Manifest getJarManifestFor(Class<?> clazz) {
        Manifest emptyManifest = new Manifest();
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return emptyManifest;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try (InputStream is = new URL(manifestPath).openStream();){
            Manifest manifest = new Manifest(is);
            return manifest;
        }
        catch (IOException iOException) {
            return emptyManifest;
        }
    }

    static {
        properties = new Properties();
        Manifest jarManifest = CommonProperties.getJarManifestFor(CommonProperties.class);
        Attributes mainAttributes = jarManifest.getMainAttributes();
        Package p = CommonProperties.class.getPackage();
        buildVersion = mainAttributes.getValue(MANIFEST_HEADER_IMPLEMENTATION_BUILD) != null ? mainAttributes.getValue(MANIFEST_HEADER_IMPLEMENTATION_BUILD) : DEFAULT;
        productName = p.getImplementationTitle() != null ? p.getImplementationTitle() : DEFAULT;
        String version = CommonProperties.getImplementationVersion(p);
        System.setProperty(QPID_VERSION, version);
        boolean loadFromFile = true;
        String initialProperties = System.getProperty("qpid.common_properties_file");
        if (initialProperties == null) {
            initialProperties = "qpid-common.properties";
            loadFromFile = false;
        }
        CommonProperties.loadProperties(properties, initialProperties, loadFromFile);
        String versionSuffix = properties.getProperty(RELEASE_VERSION_SUFFIX);
        releaseVersion = versionSuffix == null || "".equals(versionSuffix) ? version : version + ";" + versionSuffix;
        HashSet<String> propertyNames = new HashSet<String>(properties.stringPropertyNames());
        propertyNames.removeAll(System.getProperties().stringPropertyNames());
        for (String propName : propertyNames) {
            System.setProperty(propName, properties.getProperty(propName));
        }
    }
}

