/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.server.store.StoreException;

public class EnvHomeRegistry {
    private static final EnvHomeRegistry _instance = new EnvHomeRegistry();
    private final Set<String> _canonicalNames = new HashSet<String>();

    public static final EnvHomeRegistry getInstance() {
        return _instance;
    }

    EnvHomeRegistry() {
    }

    public synchronized void registerHome(File home) throws StoreException {
        if (home == null) {
            throw new IllegalArgumentException("home parameter cannot be null");
        }
        String canonicalForm = this.getCanonicalForm(home);
        if (this._canonicalNames.contains(canonicalForm)) {
            throw new IllegalArgumentException("JE Home " + home + " is already in use");
        }
        this._canonicalNames.add(canonicalForm);
    }

    public synchronized void deregisterHome(File home) throws StoreException {
        if (home == null) {
            throw new IllegalArgumentException("home parameter cannot be null");
        }
        String canonicalForm = this.getCanonicalForm(home);
        this._canonicalNames.remove(canonicalForm);
    }

    private String getCanonicalForm(File home) {
        try {
            return home.getCanonicalPath();
        }
        catch (IOException e) {
            throw new StoreException("Failed to resolve " + home + " into canonical form", (Throwable)e);
        }
    }
}

