/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.url;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.url.BindingURL;
import org.apache.qpid.server.url.BindingURLParser;
import org.apache.qpid.server.url.URLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQBindingURL
implements BindingURL {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQBindingURL.class);
    private final String _url;
    private String _exchangeClass = "direct";
    private String _exchangeName = "";
    private String _destinationName = "";
    private String _queueName = "";
    private String[] _bindingKeys = new String[0];
    private Map<String, String> _options;

    public AMQBindingURL(String url) throws URISyntaxException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parsing URL: " + url);
        }
        this._url = url;
        this._options = new HashMap<String, String>();
        this.parseBindingURL();
    }

    private void parseBindingURL() throws URISyntaxException {
        BindingURLParser parser = new BindingURLParser();
        parser.parse(this._url, this);
        if ("".equals(this.getExchangeName()) && !"direct".equals(this.getExchangeClass())) {
            throw new URISyntaxException(this._url, "Cannot create an address that redefines the default exchange to be a '" + this.getExchangeClass() + "' exchange.  It must be an instance of the '" + "direct" + "' exchange.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("URL Parsed: " + this);
        }
    }

    @Override
    public String getURL() {
        return this._url;
    }

    @Override
    public String getExchangeClass() {
        return this._exchangeClass;
    }

    void setExchangeClass(String exchangeClass) {
        this._exchangeClass = exchangeClass;
        if ("topic".equals(exchangeClass)) {
            this.setOption("exclusive", "true");
        }
    }

    @Override
    public String getExchangeName() {
        return this._exchangeName;
    }

    void setExchangeName(String name) {
        this._exchangeName = name;
    }

    @Override
    public String getDestinationName() {
        return this._destinationName;
    }

    void setDestinationName(String name) {
        this._destinationName = name;
    }

    @Override
    public String getQueueName() {
        return this._queueName;
    }

    void setQueueName(String name) {
        this._queueName = name;
    }

    @Override
    public String getOption(String key) {
        return this._options.get(key);
    }

    @Override
    public Map<String, Object> getConsumerOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        for (Map.Entry<String, String> option : this._options.entrySet()) {
            if (NON_CONSUMER_OPTIONS.contains(option.getKey())) continue;
            options.put(option.getKey(), option.getValue());
        }
        return options;
    }

    public void setOption(String key, String value) {
        this._options.put(key, value);
    }

    @Override
    public boolean containsOption(String key) {
        return this._options.containsKey(key);
    }

    @Override
    public String getRoutingKey() {
        if ("direct".equals(this._exchangeClass)) {
            if (this.containsOption("routingkey")) {
                return this.getOption("routingkey");
            }
            return this.getQueueName();
        }
        if (this.containsOption("routingkey")) {
            return this.getOption("routingkey");
        }
        return this.getDestinationName();
    }

    @Override
    public String[] getBindingKeys() {
        if (this._bindingKeys != null && this._bindingKeys.length > 0) {
            return this._bindingKeys;
        }
        return new String[]{this.getRoutingKey()};
    }

    void setBindingKeys(String[] keys) {
        this._bindingKeys = keys;
    }

    void setRoutingKey(String key) {
        this.setOption("routingkey", key);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._exchangeClass);
        sb.append("://");
        sb.append(this._exchangeName);
        sb.append('/');
        sb.append(this._destinationName);
        sb.append('/');
        sb.append(this._queueName);
        sb.append(URLHelper.printOptions(this._options));
        if (this.getRoutingKey() == null || this.getRoutingKey().equals("")) {
            if (!sb.toString().contains("?")) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            for (String key : this._bindingKeys) {
                sb.append("bindingkey").append("='").append(key).append("'&");
            }
            return sb.toString().substring(0, sb.toString().length() - 1);
        }
        return sb.toString();
    }
}

