/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;
import org.apache.qpid.server.protocol.v0_8.transport.ServerChannelMethodProcessor;

public class QueueDeclareBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 10;
    private final int _ticket;
    private final AMQShortString _queue;
    private final byte _bitfield0;
    private final FieldTable _arguments;

    public QueueDeclareBody(int ticket, AMQShortString queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean nowait, FieldTable arguments) {
        this._ticket = ticket;
        this._queue = queue;
        byte bitfield0 = 0;
        if (passive) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (durable) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (exclusive) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        if (autoDelete) {
            bitfield0 = (byte)(bitfield0 | 8);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 0x10);
        }
        this._bitfield0 = bitfield0;
        this._arguments = arguments;
    }

    @Override
    public int getClazz() {
        return 50;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final boolean getPassive() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getDurable() {
        return (this._bitfield0 & 2) != 0;
    }

    public final boolean getExclusive() {
        return (this._bitfield0 & 4) != 0;
    }

    public final boolean getAutoDelete() {
        return (this._bitfield0 & 8) != 0;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 0x10) != 0;
    }

    public final FieldTable getArguments() {
        return this._arguments;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._queue);
        return size += this.getSizeOf(this._arguments);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeFieldTable(buffer, this._arguments);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchQueueDeclare(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueDeclareBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("passive=");
        buf.append(this.getPassive());
        buf.append(", ");
        buf.append("durable=");
        buf.append(this.getDurable());
        buf.append(", ");
        buf.append("exclusive=");
        buf.append(this.getExclusive());
        buf.append(", ");
        buf.append("autoDelete=");
        buf.append(this.getAutoDelete());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append(", ");
        buf.append("arguments=");
        buf.append(this.getArguments());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ServerChannelMethodProcessor dispatcher) throws AMQFrameDecodingException {
        int ticket = buffer.getUnsignedShort();
        AMQShortString queue = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        byte bitfield = buffer.get();
        boolean passive = (bitfield & 1) == 1;
        boolean durable = (bitfield & 2) == 2;
        boolean exclusive = (bitfield & 4) == 4;
        boolean autoDelete = (bitfield & 8) == 8;
        boolean nowait = (bitfield & 0x10) == 16;
        FieldTable arguments = EncodingUtils.readFieldTable((QpidByteBuffer)buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveQueueDeclare(queue, passive, durable, exclusive, autoDelete, nowait, FieldTable.convertToDecodedFieldTable((FieldTable)arguments));
        }
        if (arguments != null) {
            arguments.dispose();
        }
    }
}

