/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import java.nio.ByteBuffer;
import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.transport.AMQBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQFrame;
import org.apache.qpid.server.protocol.v0_8.transport.AMQVersionAwareProtocolSession;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelMethodProcessor;
import org.apache.qpid.server.transport.ByteBufferSender;

public class ContentBody
implements AMQBody {
    public static final byte TYPE = 3;
    private QpidByteBuffer _payload;

    public ContentBody(ByteBuffer payload) {
        this._payload = QpidByteBuffer.wrap((ByteBuffer)payload.duplicate());
    }

    public ContentBody(QpidByteBuffer payload) {
        this._payload = payload.duplicate();
    }

    @Override
    public byte getFrameType() {
        return 3;
    }

    @Override
    public int getSize() {
        return this._payload == null ? 0 : this._payload.remaining();
    }

    @Override
    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws QpidException {
        session.contentBodyReceived(channelId, this);
    }

    @Override
    public long writePayload(ByteBufferSender sender) {
        if (this._payload != null) {
            try (QpidByteBuffer duplicate = this._payload.duplicate();){
                sender.send(duplicate);
            }
            return this._payload.remaining();
        }
        return 0L;
    }

    public QpidByteBuffer getPayload() {
        return this._payload;
    }

    public void dispose() {
        if (this._payload != null) {
            this._payload.dispose();
            this._payload = null;
        }
    }

    public static void process(QpidByteBuffer in, ChannelMethodProcessor methodProcessor, long bodySize) {
        try (QpidByteBuffer payload = in.view(0, (int)bodySize);){
            if (!methodProcessor.ignoreAllButCloseOk()) {
                methodProcessor.receiveMessageContent(payload);
            }
        }
        in.position(in.position() + (int)bodySize);
    }

    public static AMQFrame createAMQFrame(int channelId, ContentBody body) {
        return new AMQFrame(channelId, body);
    }
}

