/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;

public class BasicAckBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 80;
    private final long _deliveryTag;
    private final byte _bitfield0;

    public BasicAckBody(long deliveryTag, boolean multiple) {
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (multiple) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 80;
    }

    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    public final boolean getMultiple() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 9;
        return size;
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicAck(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicAckBodyImpl: ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("multiple=");
        buf.append(this.getMultiple());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ChannelMethodProcessor dispatcher) {
        boolean multiple;
        long deliveryTag = buffer.getLong();
        boolean bl = multiple = (buffer.get() & 1) != 0;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicAck(deliveryTag, multiple);
        }
    }
}

