/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.io.IOException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.ProtocolVersion;
import org.apache.qpid.server.protocol.v0_8.AMQDecoder;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.transport.AMQProtocolVersionException;
import org.apache.qpid.server.protocol.v0_8.transport.AccessRequestBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicAckBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicCancelBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicConsumeBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicGetBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicNackBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicPublishBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicQosBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicRecoverBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicRecoverSyncBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicRejectBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelCloseBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelFlowBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelFlowOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelOpenBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConfirmSelectBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionCloseBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionOpenBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionSecureOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionStartOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ConnectionTuneOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeBoundBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeDeclareBody;
import org.apache.qpid.server.protocol.v0_8.transport.ExchangeDeleteBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueBindBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueDeclareBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueDeleteBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueuePurgeBody;
import org.apache.qpid.server.protocol.v0_8.transport.QueueUnbindBody;
import org.apache.qpid.server.protocol.v0_8.transport.ServerChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.ServerMethodProcessor;

public class ServerDecoder
extends AMQDecoder<ServerMethodProcessor<? extends ServerChannelMethodProcessor>> {
    public ServerDecoder(ServerMethodProcessor<? extends ServerChannelMethodProcessor> methodProcessor) {
        super(true, methodProcessor);
    }

    public void decodeBuffer(QpidByteBuffer buf) throws AMQFrameDecodingException, AMQProtocolVersionException, IOException {
        this.decode(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processMethod(int channelId, QpidByteBuffer in) throws AMQFrameDecodingException {
        ServerMethodProcessor methodProcessor = (ServerMethodProcessor)this.getMethodProcessor();
        int classAndMethod = in.getInt();
        int classId = classAndMethod >> 16;
        int methodId = classAndMethod & 0xFFFF;
        methodProcessor.setCurrentMethod(classId, methodId);
        try {
            switch (classAndMethod) {
                case 655371: {
                    ConnectionStartOkBody.process(in, methodProcessor);
                    return;
                }
                case 655381: {
                    ConnectionSecureOkBody.process(in, methodProcessor);
                    return;
                }
                case 655391: {
                    ConnectionTuneOkBody.process(in, methodProcessor);
                    return;
                }
                case 655400: {
                    ConnectionOpenBody.process(in, methodProcessor);
                    return;
                }
                case 655410: {
                    if (methodProcessor.getProtocolVersion().equals((Object)ProtocolVersion.v0_8)) {
                        throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                    }
                    ConnectionCloseBody.process(in, methodProcessor);
                    return;
                }
                case 655411: {
                    if (methodProcessor.getProtocolVersion().equals((Object)ProtocolVersion.v0_8)) {
                        throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                    }
                    methodProcessor.receiveConnectionCloseOk();
                    return;
                }
                case 655420: {
                    if (!methodProcessor.getProtocolVersion().equals((Object)ProtocolVersion.v0_8)) throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                    ConnectionCloseBody.process(in, methodProcessor);
                    return;
                }
                case 655421: {
                    if (!methodProcessor.getProtocolVersion().equals((Object)ProtocolVersion.v0_8)) throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                    methodProcessor.receiveConnectionCloseOk();
                    return;
                }
                case 1310730: {
                    ChannelOpenBody.process(channelId, in, methodProcessor);
                    return;
                }
                case 0x140014: {
                    ChannelFlowBody.process(in, methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 1310741: {
                    ChannelFlowOkBody.process(in, methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 1310760: {
                    ChannelCloseBody.process(in, methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 1310761: {
                    ((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).receiveChannelCloseOk();
                    return;
                }
                case 1966090: {
                    AccessRequestBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 2621450: {
                    ExchangeDeclareBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 2621460: {
                    ExchangeDeleteBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 2621462: {
                    ExchangeBoundBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3276810: {
                    QueueDeclareBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3276820: {
                    QueueBindBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3276830: {
                    QueuePurgeBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3276840: {
                    QueueDeleteBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 0x320032: {
                    QueueUnbindBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932170: {
                    BasicQosBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932180: {
                    BasicConsumeBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932190: {
                    BasicCancelBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932200: {
                    BasicPublishBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932230: {
                    BasicGetBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932240: {
                    BasicAckBody.process(in, methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932250: {
                    BasicRejectBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932260: {
                    BasicRecoverBody.process(in, methodProcessor.getProtocolVersion(), (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932262: {
                    BasicRecoverSyncBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932270: {
                    BasicRecoverSyncBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 3932280: {
                    BasicNackBody.process(in, methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 0x55000A: {
                    ConfirmSelectBody.process(in, (ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId));
                    return;
                }
                case 0x5A000A: {
                    if (((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).ignoreAllButCloseOk()) return;
                    ((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).receiveTxSelect();
                    return;
                }
                case 5898260: {
                    if (((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).ignoreAllButCloseOk()) return;
                    ((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).receiveTxCommit();
                    return;
                }
                case 5898270: {
                    if (((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).ignoreAllButCloseOk()) return;
                    ((ServerChannelMethodProcessor)methodProcessor.getChannelMethodProcessor(channelId)).receiveTxRollback();
                    return;
                }
                default: {
                    throw this.newUnknownMethodException(classId, methodId, methodProcessor.getProtocolVersion());
                }
            }
        }
        finally {
            methodProcessor.setCurrentMethod(0, 0);
        }
    }
}

