/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc.bonecp;

import com.jolbox.bonecp.BoneCPConfig;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;
import org.apache.qpid.server.store.jdbc.JDBCConnectionProviderFactory;
import org.apache.qpid.server.store.jdbc.bonecp.BoneCPConnectionProvider;

@PluggableService
public class BoneCPConnectionProviderFactory
implements JDBCConnectionProviderFactory {
    static final String JDBCSTORE_PREFIX = "qpid.jdbcstore.";
    static final String BONECP_SETTING_PREFIX = "qpid.jdbcstore.bonecp.";
    static final String PARTITION_COUNT = "qpid.jdbcstore.bonecp.partitionCount";
    static final String MAX_CONNECTIONS_PER_PARTITION = "qpid.jdbcstore.bonecp.maxConnectionsPerPartition";
    static final String MIN_CONNECTIONS_PER_PARTITION = "qpid.jdbcstore.bonecp.minConnectionsPerPartition";
    private final Set<String> _supportedAttributes;

    public BoneCPConnectionProviderFactory() {
        Set names = Arrays.stream(BoneCPConfig.class.getMethods()).filter(m -> m.getName().startsWith("set") && m.getName().length() > 3 && Modifier.isPublic(m.getModifiers()) && m.getParameterCount() == 1 && (m.getParameterTypes()[0].isPrimitive() || m.getParameterTypes()[0] == String.class)).map(m -> {
            String n = m.getName().substring(3);
            n = BONECP_SETTING_PREFIX + Character.toLowerCase(n.charAt(0)) + n.substring(1);
            return n;
        }).collect(Collectors.toSet());
        this._supportedAttributes = Collections.unmodifiableSet(names);
    }

    public String getType() {
        return "BONECP";
    }

    public ConnectionProvider getConnectionProvider(String connectionUrl, String username, String password, Map<String, String> providerAttributes) throws SQLException {
        return new BoneCPConnectionProvider(connectionUrl, username, password, providerAttributes);
    }

    public Set<String> getProviderAttributeNames() {
        return this._supportedAttributes;
    }
}

