/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestPreemptiveAuthenticator;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.ExternalAuthenticationManager;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;

@PluggableService
public class SSLClientCertPreemptiveAuthenticator
implements HttpRequestPreemptiveAuthenticator {
    private static final String SSL_CLIENT_AUTH = "SSLClientAuth";
    private static final String CERTIFICATE_ATTRIBUTE_NAME = "javax.servlet.request.X509Certificate";

    @Override
    public Subject attemptAuthentication(HttpServletRequest request, HttpManagementConfiguration managementConfig) {
        AuthenticationProvider authenticationProvider = managementConfig.getAuthenticationProvider(request);
        Port<?> port = managementConfig.getPort(request);
        SubjectCreator subjectCreator = port.getSubjectCreator(request.isSecure(), request.getServerName());
        if (request.isSecure() && authenticationProvider instanceof ExternalAuthenticationManager && Collections.list(request.getAttributeNames()).contains(CERTIFICATE_ATTRIBUTE_NAME)) {
            ExternalAuthenticationManager externalAuthManager = (ExternalAuthenticationManager)authenticationProvider;
            X509Certificate[] certificates = (X509Certificate[])request.getAttribute(CERTIFICATE_ATTRIBUTE_NAME);
            if (certificates != null && certificates.length != 0) {
                X500Principal principal = certificates[0].getSubjectX500Principal();
                if (!externalAuthManager.getUseFullDN()) {
                    String dn = principal.getName("RFC2253");
                    String username = SSLUtil.getIdFromSubjectDN((String)dn);
                    principal = new UsernamePrincipal(username, authenticationProvider);
                }
                return subjectCreator.createSubjectWithGroups((Principal)new AuthenticatedPrincipal((Principal)principal));
            }
        }
        return null;
    }

    public String getType() {
        return SSL_CLIENT_AUTH;
    }
}

