/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestPreemptiveAuthenticator;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class OAuth2PreemptiveAuthenticator
implements HttpRequestPreemptiveAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2PreemptiveAuthenticator.class);
    private static final String TYPE = "OAuth2";
    private static final String BEARER_PREFIX = "Bearer ";

    @Override
    public Subject attemptAuthentication(HttpServletRequest request, HttpManagementConfiguration configuration) {
        Port<?> port = configuration.getPort(request);
        AuthenticationProvider authenticationProvider = configuration.getAuthenticationProvider(request);
        String authorizationHeader = request.getHeader("Authorization");
        String accessToken = null;
        if (authorizationHeader != null && authorizationHeader.startsWith(BEARER_PREFIX)) {
            accessToken = authorizationHeader.substring(BEARER_PREFIX.length());
        }
        if (accessToken != null && authenticationProvider instanceof OAuth2AuthenticationProvider) {
            OAuth2AuthenticationProvider oAuth2AuthProvider = (OAuth2AuthenticationProvider)authenticationProvider;
            AuthenticationResult authenticationResult = oAuth2AuthProvider.authenticateViaAccessToken(accessToken, null);
            SubjectCreator subjectCreator = port.getSubjectCreator(request.isSecure(), request.getServerName());
            SubjectAuthenticationResult result = subjectCreator.createResultWithGroups(authenticationResult);
            return result.getSubject();
        }
        return null;
    }

    public String getType() {
        return TYPE;
    }
}

