/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util.urlstreamhandler.classpath;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Properties;

public class Handler
extends URLStreamHandler {
    public static final String PROTOCOL_HANDLER_PROPERTY = "java.protocol.handler.pkgs";
    private static boolean _registered;

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        String externalForm = u.toExternalForm();
        if (externalForm.startsWith("classpath:")) {
            String path = externalForm.substring(10);
            URL resourceUrl = this.getClass().getClassLoader().getResource(path);
            if (resourceUrl == null) {
                throw new FileNotFoundException("No such resource found in the classpath: " + path);
            }
            return resourceUrl.openConnection();
        }
        throw new MalformedURLException("'" + externalForm + "' does not start with 'classpath:'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register() {
        Properties properties = System.getProperties();
        synchronized (properties) {
            if (!_registered) {
                String registeredPackages = System.getProperty(PROTOCOL_HANDLER_PROPERTY);
                String thisPackage = Handler.class.getPackage().getName();
                String packageToRegister = thisPackage.substring(0, thisPackage.lastIndexOf(46));
                System.setProperty(PROTOCOL_HANDLER_PROPERTY, registeredPackages == null ? packageToRegister : packageToRegister + "|" + registeredPackages);
                _registered = true;
            }
        }
    }
}

