/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.typedmessage.mimecontentconverter;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.qpid.server.message.mimecontentconverter.ObjectToMimeContentConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.typedmessage.TypedBytesContentWriter;
import org.apache.qpid.server.typedmessage.TypedBytesFormatException;

@PluggableService
public class ListToJmsStreamMessage
implements ObjectToMimeContentConverter<List> {
    @Override
    public String getType() {
        return this.getMimeType();
    }

    @Override
    public String getMimeType() {
        return "jms/stream-message";
    }

    @Override
    public Class<List> getObjectClass() {
        return List.class;
    }

    @Override
    public int getRank() {
        return 10;
    }

    @Override
    public boolean isAcceptable(List list) {
        if (list != null) {
            for (Object value : list) {
                if (value == null || value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Boolean || value instanceof byte[]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public byte[] toMimeContent(List list) {
        if (list == null) {
            return new byte[0];
        }
        TypedBytesContentWriter writer = new TypedBytesContentWriter();
        for (Object o : list) {
            try {
                writer.writeObject(o);
            }
            catch (TypedBytesFormatException e) {
                throw new IllegalArgumentException(String.format("Cannot convert %s instance to a TypedBytesContent object", o.getClass()), e);
            }
        }
        ByteBuffer buf = writer.getData();
        int remaining = buf.remaining();
        byte[] data = new byte[remaining];
        buf.get(data);
        return data;
    }
}

