/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.QueueMessages;
import org.apache.qpid.server.model.OverflowPolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.OverflowPolicyHandler;
import org.apache.qpid.server.queue.OverflowPolicyMaximumQueueDepthChangeListener;
import org.apache.qpid.server.queue.QueueEntry;

public class RingOverflowPolicyHandler
implements OverflowPolicyHandler {
    private final Handler _handler;

    RingOverflowPolicyHandler(Queue<?> queue, EventLogger eventLogger) {
        this._handler = new Handler(queue, eventLogger);
        queue.addChangeListener(this._handler);
    }

    @Override
    public void checkOverflow(QueueEntry newlyEnqueued) {
        this._handler.checkOverflow();
    }

    private static class Handler
    extends OverflowPolicyMaximumQueueDepthChangeListener {
        private final Queue<?> _queue;
        private final EventLogger _eventLogger;
        private final ThreadLocal<Boolean> _recursionTracker = ThreadLocal.withInitial(() -> Boolean.FALSE);

        public Handler(Queue<?> queue, EventLogger eventLogger) {
            super(OverflowPolicy.RING);
            this._queue = queue;
            this._eventLogger = eventLogger;
        }

        @Override
        void onMaximumQueueDepthChange(Queue<?> queue) {
            this.checkOverflow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkOverflow() {
            if (!this._recursionTracker.get().booleanValue()) {
                this._recursionTracker.set(Boolean.TRUE);
                try {
                    long queueDepthBytes;
                    int queueDepthMessages;
                    boolean messagesOverflow;
                    boolean bytesOverflow;
                    long maximumQueueDepthMessages = this._queue.getMaximumQueueDepthMessages();
                    long maximumQueueDepthBytes = this._queue.getMaximumQueueDepthBytes();
                    boolean overflow = false;
                    int counter = 0;
                    do {
                        QueueEntry entry;
                        queueDepthMessages = this._queue.getQueueDepthMessages();
                        queueDepthBytes = this._queue.getQueueDepthBytes();
                        messagesOverflow = maximumQueueDepthMessages >= 0L && (long)queueDepthMessages > maximumQueueDepthMessages;
                        boolean bl = bytesOverflow = maximumQueueDepthBytes >= 0L && queueDepthBytes > maximumQueueDepthBytes;
                        if (!bytesOverflow && !messagesOverflow) continue;
                        if (!overflow) {
                            overflow = true;
                        }
                        if ((entry = this._queue.getLeastSignificantOldestEntry()) != null) {
                            ++counter;
                            this._queue.deleteEntry(entry);
                            continue;
                        }
                        queueDepthMessages = this._queue.getQueueDepthMessages();
                        queueDepthBytes = this._queue.getQueueDepthBytes();
                        break;
                    } while (bytesOverflow || messagesOverflow);
                    if (overflow) {
                        this._eventLogger.message(this._queue.getLogSubject(), QueueMessages.DROPPED(counter, queueDepthBytes, queueDepthMessages, maximumQueueDepthBytes, maximumQueueDepthMessages));
                    }
                }
                finally {
                    this._recursionTracker.set(Boolean.FALSE);
                }
            }
        }
    }
}

