/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Predicate;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDeletedException;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.StateChangeListener;
import org.apache.qpid.server.util.StateChangeListenerEntry;

public abstract class QueueEntryImpl
implements QueueEntry {
    private final QueueEntryList _queueEntryList;
    private final MessageReference _message;
    private volatile Set<Object> _rejectedBy = null;
    private static final AtomicReferenceFieldUpdater<QueueEntryImpl, Set> _rejectedByUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, Set.class, "_rejectedBy");
    private static final MessageInstance.EntryState HELD_STATE = new MessageInstance.EntryState(){

        @Override
        public MessageInstance.State getState() {
            return MessageInstance.State.AVAILABLE;
        }

        public String toString() {
            return "HELD";
        }
    };
    private volatile MessageInstance.EntryState _state = AVAILABLE_STATE;
    private static final AtomicReferenceFieldUpdater<QueueEntryImpl, MessageInstance.EntryState> _stateUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, MessageInstance.EntryState.class, "_state");
    private volatile StateChangeListenerEntry<? super QueueEntry, MessageInstance.EntryState> _stateChangeListeners;
    private static final AtomicReferenceFieldUpdater<QueueEntryImpl, StateChangeListenerEntry> _listenersUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, StateChangeListenerEntry.class, "_stateChangeListeners");
    private static final AtomicLongFieldUpdater<QueueEntryImpl> _entryIdUpdater = AtomicLongFieldUpdater.newUpdater(QueueEntryImpl.class, "_entryId");
    private volatile long _entryId;
    private static final int REDELIVERED_FLAG = 1;
    private static final int PERSISTENT_FLAG = 2;
    private static final int MANDATORY_FLAG = 4;
    private static final int IMMEDIATE_FLAG = 8;
    private int _flags;
    private long _expiration;
    private volatile int _deliveryCount = -1;
    private static final AtomicIntegerFieldUpdater<QueueEntryImpl> _deliveryCountUpdater = AtomicIntegerFieldUpdater.newUpdater(QueueEntryImpl.class, "_deliveryCount");
    private final MessageEnqueueRecord _enqueueRecord;

    QueueEntryImpl(QueueEntryList queueEntryList) {
        this(queueEntryList, null, Long.MIN_VALUE, null);
        this._state = DELETED_STATE;
    }

    QueueEntryImpl(QueueEntryList queueEntryList, ServerMessage message, long entryId, MessageEnqueueRecord enqueueRecord) {
        this._queueEntryList = queueEntryList;
        this._message = message == null ? null : message.newReference(queueEntryList.getQueue());
        _entryIdUpdater.set(this, entryId);
        this.populateInstanceProperties();
        this._enqueueRecord = enqueueRecord;
    }

    QueueEntryImpl(QueueEntryList queueEntryList, ServerMessage message, MessageEnqueueRecord enqueueRecord) {
        this._queueEntryList = queueEntryList;
        this._message = message == null ? null : message.newReference(queueEntryList.getQueue());
        this.populateInstanceProperties();
        this._enqueueRecord = enqueueRecord;
    }

    private void populateInstanceProperties() {
        if (this._message != null) {
            if (this._message.getMessage().isPersistent()) {
                this.setPersistent();
            }
            this._expiration = this._message.getMessage().getExpiration();
        }
    }

    @Override
    public void setExpiration(long expiration) {
        this._expiration = expiration;
    }

    @Override
    public InstanceProperties getInstanceProperties() {
        return new EntryInstanceProperties();
    }

    void setEntryId(long entryId) {
        _entryIdUpdater.set(this, entryId);
    }

    long getEntryId() {
        return this._entryId;
    }

    @Override
    public Queue<?> getQueue() {
        return this._queueEntryList.getQueue();
    }

    @Override
    public ServerMessage getMessage() {
        return this._message == null ? null : (ServerMessage)this._message.getMessage();
    }

    @Override
    public long getSize() {
        return this.getMessage() == null ? 0L : this.getMessage().getSize();
    }

    @Override
    public long getSizeWithHeader() {
        return this.getMessage() == null ? 0L : this.getMessage().getSizeIncludingHeader();
    }

    @Override
    public boolean getDeliveredToConsumer() {
        return _deliveryCountUpdater.get(this) != -1;
    }

    @Override
    public boolean expired() {
        long expiration = this._expiration;
        if (expiration != 0L) {
            long now = System.currentTimeMillis();
            return now > expiration;
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return this._state.getState() == MessageInstance.State.AVAILABLE;
    }

    @Override
    public boolean isAcquired() {
        return this._state.getState() == MessageInstance.State.ACQUIRED;
    }

    @Override
    public boolean acquire() {
        return this.acquire(NON_CONSUMER_ACQUIRED_STATE);
    }

    @Override
    public boolean acquireOrSteal(Runnable delayedAcquisitionTask) {
        boolean acquired = this.acquire();
        if (!acquired) {
            MessageInstanceConsumer consumer = this.getAcquiringConsumer();
            acquired = this.removeAcquisitionFromConsumer(consumer);
            if (acquired) {
                consumer.acquisitionRemoved(this);
            } else if (delayedAcquisitionTask != null) {
                DelayedAcquisitionStateListener listener = new DelayedAcquisitionStateListener(delayedAcquisitionTask);
                this.addStateChangeListener(listener);
                if (this.acquireOrSteal(null)) {
                    listener.runTask();
                }
            }
        }
        return acquired;
    }

    private boolean acquire(MessageInstance.EntryState state) {
        MessageInstance.EntryState currentState;
        boolean acquired = false;
        while ((currentState = this._state).equals(AVAILABLE_STATE) && !(acquired = _stateUpdater.compareAndSet(this, currentState, state))) {
        }
        if (acquired) {
            this.notifyStateChange(AVAILABLE_STATE, state);
        }
        return acquired;
    }

    @Override
    public boolean acquire(MessageInstanceConsumer<?> consumer) {
        boolean acquired = this.acquire(((QueueConsumer)consumer).getOwningState().getUnstealableState());
        if (acquired) {
            _deliveryCountUpdater.compareAndSet(this, -1, 0);
        }
        return acquired;
    }

    @Override
    public boolean makeAcquisitionUnstealable(MessageInstanceConsumer<?> consumer) {
        MessageInstance.EntryState state = this._state;
        if (state instanceof MessageInstance.StealableConsumerAcquiredState && ((MessageInstance.StealableConsumerAcquiredState)state).getConsumer() == consumer) {
            MessageInstance.UnstealableConsumerAcquiredState unstealableState = ((MessageInstance.StealableConsumerAcquiredState)state).getUnstealableState();
            boolean updated = _stateUpdater.compareAndSet(this, state, unstealableState);
            if (updated) {
                this.notifyStateChange(state, unstealableState);
            }
            return updated;
        }
        return state instanceof MessageInstance.UnstealableConsumerAcquiredState && ((MessageInstance.UnstealableConsumerAcquiredState)state).getConsumer() == consumer;
    }

    @Override
    public boolean makeAcquisitionStealable() {
        MessageInstance.EntryState state = this._state;
        if (state instanceof MessageInstance.UnstealableConsumerAcquiredState) {
            MessageInstance.StealableConsumerAcquiredState stealableState = ((MessageInstance.UnstealableConsumerAcquiredState)state).getStealableState();
            boolean updated = _stateUpdater.compareAndSet(this, state, stealableState);
            if (updated) {
                this.notifyStateChange(state, stealableState);
            }
            return updated;
        }
        return false;
    }

    @Override
    public boolean acquiredByConsumer() {
        return this._state instanceof MessageInstance.ConsumerAcquiredState;
    }

    public QueueConsumer<?, ?> getAcquiringConsumer() {
        MessageInstance.EntryState state = this._state;
        QueueConsumer consumer = state instanceof MessageInstance.ConsumerAcquiredState ? (QueueConsumer)((MessageInstance.ConsumerAcquiredState)state).getConsumer() : null;
        return consumer;
    }

    @Override
    public boolean isAcquiredBy(MessageInstanceConsumer<?> consumer) {
        MessageInstance.EntryState state = this._state;
        return state instanceof MessageInstance.ConsumerAcquiredState && ((MessageInstance.ConsumerAcquiredState)state).getConsumer() == consumer;
    }

    @Override
    public boolean removeAcquisitionFromConsumer(MessageInstanceConsumer<?> consumer) {
        MessageInstance.EntryState state = this._state;
        if (state instanceof MessageInstance.StealableConsumerAcquiredState && ((MessageInstance.StealableConsumerAcquiredState)state).getConsumer() == consumer) {
            boolean stateWasChanged = _stateUpdater.compareAndSet(this, state, NON_CONSUMER_ACQUIRED_STATE);
            if (stateWasChanged) {
                this.notifyStateChange(state, NON_CONSUMER_ACQUIRED_STATE);
            }
            return stateWasChanged;
        }
        return false;
    }

    @Override
    public void release() {
        MessageInstance.EntryState state = this._state;
        if (state.getState() == MessageInstance.State.ACQUIRED && _stateUpdater.compareAndSet(this, state, AVAILABLE_STATE)) {
            this.postRelease(state);
        }
    }

    @Override
    public void release(MessageInstanceConsumer<?> consumer) {
        MessageInstance.EntryState state = this._state;
        if (this.isAcquiredBy(consumer) && _stateUpdater.compareAndSet(this, state, AVAILABLE_STATE)) {
            this.postRelease(state);
        }
    }

    private void postRelease(MessageInstance.EntryState previousState) {
        if (!this.getQueue().isDeleted()) {
            this.getQueue().requeue(this);
            if (previousState.getState() == MessageInstance.State.ACQUIRED) {
                this.notifyStateChange(previousState, AVAILABLE_STATE);
            }
        } else if (this.acquire()) {
            this.routeToAlternate(null, null, null);
        }
    }

    @Override
    public boolean checkHeld(long evaluationTime) {
        MessageInstance.EntryState state;
        while ((state = this._state).getState() == MessageInstance.State.AVAILABLE) {
            boolean isHeld = this.getQueue().isHeld(this, evaluationTime);
            if (state == AVAILABLE_STATE && isHeld) {
                if (!_stateUpdater.compareAndSet(this, state, HELD_STATE)) {
                    continue;
                }
            } else if (state == HELD_STATE && !isHeld) {
                if (!_stateUpdater.compareAndSet(this, state, AVAILABLE_STATE)) continue;
                this.postRelease(state);
            }
            return isHeld;
        }
        return false;
    }

    @Override
    public void reject(MessageInstanceConsumer<?> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("consumer must not be null");
        }
        if (this._rejectedBy == null) {
            _rejectedByUpdater.compareAndSet(this, null, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this._rejectedBy.add(consumer.getIdentifier());
    }

    @Override
    public boolean isRejectedBy(MessageInstanceConsumer<?> consumer) {
        return this._rejectedBy != null && this._rejectedBy.contains(consumer.getIdentifier());
    }

    private boolean dequeue() {
        MessageInstance.EntryState state = this._state;
        while (state.getState() == MessageInstance.State.ACQUIRED && !_stateUpdater.compareAndSet(this, state, DEQUEUED_STATE)) {
            state = this._state;
        }
        if (state.getState() == MessageInstance.State.ACQUIRED) {
            this.notifyStateChange(state, DEQUEUED_STATE);
            return true;
        }
        return false;
    }

    private void notifyStateChange(MessageInstance.EntryState oldState, MessageInstance.EntryState newState) {
        this._queueEntryList.updateStatsOnStateChange(this, oldState, newState);
        for (StateChangeListenerEntry entry = _listenersUpdater.get(this); entry != null; entry = entry.next()) {
            StateChangeListener<QueueEntryImpl, MessageInstance.EntryState> l = entry.getListener();
            if (l == null) continue;
            l.stateChanged(this, oldState, newState);
        }
    }

    private boolean dispose() {
        MessageInstance.EntryState state = this._state;
        if (state != DELETED_STATE && _stateUpdater.compareAndSet(this, state, DELETED_STATE)) {
            this.notifyStateChange(state, DELETED_STATE);
            this._queueEntryList.entryDeleted(this);
            this.onDelete();
            this._message.release();
            return true;
        }
        return false;
    }

    @Override
    public void delete() {
        if (this.dequeue()) {
            this.dispose();
        }
    }

    @Override
    public int routeToAlternate(Action<? super MessageInstance> action, ServerTransaction txn, Predicate<BaseQueue> predicate) {
        boolean autocommit;
        if (!this.isAcquired()) {
            throw new IllegalStateException("Illegal queue entry state. " + this + " is not acquired.");
        }
        Queue<?> currentQueue = this.getQueue();
        MessageDestination alternateBindingDestination = currentQueue.getAlternateBindingDestination();
        boolean bl = autocommit = txn == null;
        if (autocommit) {
            txn = new LocalTransaction(this.getQueue().getVirtualHost().getMessageStore());
        }
        ServerMessage message = this.getMessage();
        RoutingResult<ServerMessage> result = alternateBindingDestination != null && message.checkValid() ? alternateBindingDestination.route(message, message.getInitialRoutingAddress(), this.getInstanceProperties()) : new RoutingResult<ServerMessage>(message);
        if (predicate != null) {
            result.filter(predicate);
        }
        txn.dequeue(this.getEnqueueRecord(), new ServerTransaction.Action(){

            @Override
            public void postCommit() {
                QueueEntryImpl.this.delete();
            }

            @Override
            public void onRollback() {
            }
        });
        int enqueues = result.send(txn, action);
        if (autocommit) {
            txn.commit();
        }
        return enqueues;
    }

    @Override
    public boolean isQueueDeleted() {
        return this.getQueue().isDeleted();
    }

    @Override
    public void addStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.EntryState> listener) {
        StateChangeListenerEntry<? super MessageInstance, MessageInstance.EntryState> entry = new StateChangeListenerEntry<MessageInstance, MessageInstance.EntryState>(listener);
        if (!_listenersUpdater.compareAndSet(this, null, entry)) {
            _listenersUpdater.get(this).add(entry);
        }
    }

    @Override
    public boolean removeStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.EntryState> listener) {
        StateChangeListenerEntry entry = _listenersUpdater.get(this);
        return entry != null && entry.remove(listener);
    }

    @Override
    public int compareTo(QueueEntry o) {
        QueueEntryImpl other = (QueueEntryImpl)o;
        return this.getEntryId() > other.getEntryId() ? 1 : (this.getEntryId() < other.getEntryId() ? -1 : 0);
    }

    protected void onDelete() {
    }

    public QueueEntryList getQueueEntryList() {
        return this._queueEntryList;
    }

    @Override
    public boolean isDeleted() {
        return this._state.isDispensed();
    }

    @Override
    public boolean isHeld() {
        return this.checkHeld(System.currentTimeMillis());
    }

    @Override
    public int getDeliveryCount() {
        return this._deliveryCount == -1 ? 0 : this._deliveryCount;
    }

    @Override
    public int getMaximumDeliveryCount() {
        return this.getQueue().getMaximumDeliveryAttempts();
    }

    @Override
    public void incrementDeliveryCount() {
        _deliveryCountUpdater.compareAndSet(this, -1, 0);
        _deliveryCountUpdater.incrementAndGet(this);
    }

    @Override
    public void decrementDeliveryCount() {
        _deliveryCountUpdater.decrementAndGet(this);
    }

    @Override
    public Filterable asFilterable() {
        return Filterable.Factory.newInstance(this.getMessage(), this.getInstanceProperties());
    }

    public String toString() {
        return "QueueEntryImpl{_entryId=" + this._entryId + ", _state=" + this._state + '}';
    }

    @Override
    public TransactionLogResource getOwningResource() {
        return this.getQueue();
    }

    @Override
    public void setRedelivered() {
        this._flags |= 1;
    }

    private void setPersistent() {
        this._flags |= 2;
    }

    @Override
    public boolean isRedelivered() {
        return (this._flags & 1) != 0;
    }

    @Override
    public boolean isPersistent() {
        return (this._flags & 2) != 0;
    }

    @Override
    public MessageReference newMessageReference() {
        try {
            return this.getMessage().newReference();
        }
        catch (MessageDeletedException mde) {
            return null;
        }
    }

    @Override
    public MessageEnqueueRecord getEnqueueRecord() {
        return this._enqueueRecord;
    }

    private class EntryInstanceProperties
    implements InstanceProperties {
        private EntryInstanceProperties() {
        }

        @Override
        public Object getProperty(InstanceProperties.Property prop) {
            switch (prop) {
                case REDELIVERED: {
                    return (QueueEntryImpl.this._flags & 1) != 0;
                }
                case PERSISTENT: {
                    return (QueueEntryImpl.this._flags & 2) != 0;
                }
                case MANDATORY: {
                    return (QueueEntryImpl.this._flags & 4) != 0;
                }
                case IMMEDIATE: {
                    return (QueueEntryImpl.this._flags & 8) != 0;
                }
                case EXPIRATION: {
                    return QueueEntryImpl.this._expiration;
                }
            }
            throw new IllegalArgumentException("Unknown property " + (Object)((Object)prop));
        }
    }

    private class DelayedAcquisitionStateListener
    implements StateChangeListener<MessageInstance, MessageInstance.EntryState> {
        private final Runnable _task;
        private final AtomicBoolean _run = new AtomicBoolean();

        private DelayedAcquisitionStateListener(Runnable task) {
            this._task = task;
        }

        @Override
        public void stateChanged(MessageInstance object, MessageInstance.EntryState oldState, MessageInstance.EntryState newState) {
            if (newState.equals(MessageInstance.DELETED_STATE) || newState.equals(MessageInstance.DEQUEUED_STATE)) {
                QueueEntryImpl.this.removeStateChangeListener(this);
            } else if (QueueEntryImpl.this.acquireOrSteal(null)) {
                this.runTask();
            }
        }

        void runTask() {
            QueueEntryImpl.this.removeStateChangeListener(this);
            if (this._run.compareAndSet(false, true)) {
                this._task.run();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DelayedAcquisitionStateListener that = (DelayedAcquisitionStateListener)o;
            return Objects.equals(this._task, that._task);
        }

        public int hashCode() {
            return Objects.hash(this._task);
        }
    }
}

