/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Named;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.protocol.LinkModel;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.virtualhost.ConnectionEstablishmentPolicy;
import org.apache.qpid.server.virtualhost.LinkRegistryModel;

public interface NamedAddressSpace
extends Named {
    public UUID getId();

    public MessageSource getAttainedMessageSource(String var1);

    public MessageDestination getAttainedMessageDestination(String var1);

    public MessageDestination getAttainedMessageDestination(String var1, boolean var2);

    public boolean registerConnection(AMQPConnection<?> var1, ConnectionEstablishmentPolicy var2);

    public void deregisterConnection(AMQPConnection<?> var1);

    public String getRedirectHost(AmqpPort<?> var1);

    public Principal getPrincipal();

    public boolean isActive();

    public MessageDestination getDefaultDestination();

    public <T extends LinkModel> T getSendingLink(String var1, String var2);

    public <T extends LinkModel> T getReceivingLink(String var1, String var2);

    @Deprecated
    public <T extends LinkModel> Collection<T> findSendingLinks(Pattern var1, Pattern var2);

    public <T extends LinkModel> void visitSendingLinks(LinkRegistryModel.LinkVisitor<T> var1);

    public boolean authoriseCreateConnection(AMQPConnection<?> var1);

    public DtxRegistry getDtxRegistry();

    public MessageStore getMessageStore();

    public <T extends MessageSource> T createMessageSource(Class<T> var1, Map<String, Object> var2);

    public <T extends MessageDestination> T createMessageDestination(Class<T> var1, Map<String, Object> var2);

    public boolean hasMessageSources();

    public Collection<? extends Connection<?>> getConnections();

    public List<String> getGlobalAddressDomains();

    public String getLocalAddress(String var1);
}

