/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.util.Strings;

public class AncestorAttributeResolver
implements Strings.Resolver {
    public static final String PREFIX = "ancestor:";
    private final ThreadLocal<Set<String>> _stack = new ThreadLocal();
    private final ConfiguredObject<?> _object;
    private final ObjectMapper _objectMapper;

    public AncestorAttributeResolver(ConfiguredObject<?> object) {
        this._object = object;
        this._objectMapper = ConfiguredObjectJacksonModule.newObjectMapper(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolve(String variable, Strings.Resolver resolver) {
        boolean clearStack = false;
        Set<String> currentStack = this._stack.get();
        if (currentStack == null) {
            currentStack = new HashSet<String>();
            this._stack.set(currentStack);
            clearStack = true;
        }
        try {
            if (variable.startsWith(PREFIX)) {
                String returnString;
                String classQualifiedAttrName = variable.substring(PREFIX.length());
                if (currentStack.contains(classQualifiedAttrName)) {
                    throw new IllegalArgumentException("The value of attribute " + classQualifiedAttrName + " is defined recursively");
                }
                currentStack.add(classQualifiedAttrName);
                int colonIndex = classQualifiedAttrName.indexOf(":");
                if (colonIndex == -1) {
                    String string = null;
                    return string;
                }
                String categorySimpleClassName = classQualifiedAttrName.substring(0, colonIndex);
                String attributeName = classQualifiedAttrName.substring(colonIndex + 1);
                Class<? extends ConfiguredObject> ancestorCategory = this.findAncestorCategoryBySimpleClassName(categorySimpleClassName, this._object.getCategoryClass());
                if (ancestorCategory == null) {
                    String string = null;
                    return string;
                }
                ConfiguredObject ancestorOrSelf = this._object.getModel().getAncestor(ancestorCategory, this._object);
                if (ancestorOrSelf == null) {
                    String string = null;
                    return string;
                }
                Object returnVal = ancestorOrSelf.getAttribute(attributeName);
                if (returnVal == null) {
                    returnString = null;
                } else if (returnVal instanceof Map || returnVal instanceof Collection) {
                    try {
                        StringWriter writer = new StringWriter();
                        this._objectMapper.writeValue((Writer)writer, returnVal);
                        returnString = writer.toString();
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else {
                    returnString = returnVal instanceof ConfiguredObject ? ((ConfiguredObject)returnVal).getId().toString() : returnVal.toString();
                }
                String string = returnString;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (clearStack) {
                this._stack.remove();
            }
        }
    }

    private Class<? extends ConfiguredObject> findAncestorCategoryBySimpleClassName(String targetCategorySimpleClassName, Class<? extends ConfiguredObject> objectCategory) {
        Class<? extends ConfiguredObject> targetCategoryClass;
        if (targetCategorySimpleClassName.equals(objectCategory.getSimpleName().toLowerCase())) {
            return objectCategory;
        }
        Class<? extends ConfiguredObject> parentCategory = this._object.getModel().getParentType(objectCategory);
        if (parentCategory != null && (targetCategoryClass = this.findAncestorCategoryBySimpleClassName(targetCategorySimpleClassName, parentCategory)) != null) {
            return targetCategoryClass;
        }
        return null;
    }
}

