/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.security.AccessControlException;
import java.util.Map;
import org.apache.qpid.server.exchange.DestinationReferrer;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageSender;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DestinationAddress;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.PermissionedObject;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

public class DefaultDestination
implements MessageDestination,
PermissionedObject {
    private static final Operation PUBLISH_ACTION = Operation.PERFORM_ACTION("publish");
    private final AccessControl _accessControl;
    private QueueManagingVirtualHost<?> _virtualHost;

    public DefaultDestination(QueueManagingVirtualHost<?> virtualHost, AccessControl accessControl) {
        this._virtualHost = virtualHost;
        this._accessControl = accessControl;
    }

    @Override
    public Class<? extends ConfiguredObject> getCategoryClass() {
        return Exchange.class;
    }

    @Override
    public NamedAddressSpace getAddressSpace() {
        return this._virtualHost;
    }

    @Override
    public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
        if (this._accessControl != null) {
            Result result = this._accessControl.authorise(token, PUBLISH_ACTION, this, arguments);
            if (result == Result.DEFER) {
                result = this._accessControl.getDefault();
            }
            if (result == Result.DENIED) {
                throw new AccessControlException("Access denied to publish to default exchange with arguments: " + arguments);
            }
        }
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public <M extends ServerMessage<? extends StorableMessageMetaData>> RoutingResult<M> route(M message, String routingAddress, InstanceProperties instanceProperties) {
        RoutingResult<M> result = new RoutingResult<M>(message);
        DestinationAddress destinationAddress = new DestinationAddress(this._virtualHost, routingAddress);
        MessageDestination messageDestination = destinationAddress.getMessageDestination();
        if (messageDestination != null) {
            result.add(messageDestination.route(message, destinationAddress.getRoutingKey(), instanceProperties));
        }
        return result;
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void linkAdded(MessageSender sender, PublishingLink link) {
    }

    @Override
    public void linkRemoved(MessageSender sender, PublishingLink link) {
    }

    @Override
    public MessageDestination getAlternateBindingDestination() {
        return null;
    }

    @Override
    public void removeReference(DestinationReferrer destinationReferrer) {
    }

    @Override
    public void addReference(DestinationReferrer destinationReferrer) {
    }
}

