/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.messaging.codec;

import org.apache.qpid.server.protocol.v1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.server.protocol.v1_0.codec.AbstractListWriter;
import org.apache.qpid.server.protocol.v1_0.codec.UnsignedLongWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Header;

public class HeaderWriter
extends AbstractDescribedTypeWriter<Header> {
    private static final ValueWriter<UnsignedLong> DESCRIPTOR_WRITER = UnsignedLongWriter.getWriter((byte)112);
    private static final ValueWriter.Factory<Header> FACTORY = new ValueWriter.Factory<Header>(){

        @Override
        public ValueWriter<Header> newInstance(ValueWriter.Registry registry, Header object) {
            return new HeaderWriter(registry, object);
        }
    };

    public HeaderWriter(ValueWriter.Registry registry, Header object) {
        super(DESCRIPTOR_WRITER, new Writer(registry, object));
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Header.class, FACTORY);
    }

    private static class Writer
    extends AbstractListWriter<Header> {
        private final int _count;
        private final Header _value;
        private int _field;

        public Writer(ValueWriter.Registry registry, Header value) {
            super(registry);
            this._value = value;
            this._count = this.calculateCount();
        }

        private int calculateCount() {
            if (this._value.getDeliveryCount() != null) {
                return 5;
            }
            if (this._value.getFirstAcquirer() != null) {
                return 4;
            }
            if (this._value.getTtl() != null) {
                return 3;
            }
            if (this._value.getPriority() != null) {
                return 2;
            }
            if (this._value.getDurable() != null) {
                return 1;
            }
            return 0;
        }

        @Override
        protected int getCount() {
            return this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return this._value.getDurable();
                }
                case 1: {
                    return this._value.getPriority();
                }
                case 2: {
                    return this._value.getTtl();
                }
                case 3: {
                    return this._value.getFirstAcquirer();
                }
                case 4: {
                    return this._value.getDeliveryCount();
                }
            }
            return null;
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

