/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.extensions.soleconn;

import org.apache.qpid.server.protocol.v1_0.type.RestrictedType;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;

public class SoleConnectionDetectionPolicy
implements RestrictedType<UnsignedInteger> {
    public static final SoleConnectionDetectionPolicy STRONG = new SoleConnectionDetectionPolicy(UnsignedInteger.valueOf(0));
    public static final SoleConnectionDetectionPolicy WEAK = new SoleConnectionDetectionPolicy(UnsignedInteger.valueOf(1));
    private final UnsignedInteger _val;

    private SoleConnectionDetectionPolicy(UnsignedInteger val) {
        this._val = val;
    }

    @Override
    public UnsignedInteger getValue() {
        return this._val;
    }

    public static SoleConnectionDetectionPolicy valueOf(Object obj) {
        if (obj instanceof UnsignedInteger) {
            UnsignedInteger val = (UnsignedInteger)obj;
            if (SoleConnectionDetectionPolicy.STRONG._val.equals(val)) {
                return STRONG;
            }
            if (SoleConnectionDetectionPolicy.WEAK._val.equals(val)) {
                return WEAK;
            }
        }
        String message = String.format("Cannot convert '%s' into 'sole-connection-detection-policy'", obj);
        throw new IllegalArgumentException(message);
    }

    public String toString() {
        if (this == STRONG) {
            return "strong";
        }
        if (this == WEAK) {
            return "weak";
        }
        return String.valueOf(this._val);
    }
}

