/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.nio.charset.Charset;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.codec.VariableWidthWriter;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;

public class SymbolWriter
extends VariableWidthWriter<Symbol> {
    private static final Charset ENCODING_CHARSET = Charset.forName("US-ASCII");
    public static final byte LARGE_ENCODING_CODE = -77;
    public static final byte SMALL_ENCODING_CODE = -93;
    private final Symbol _value;
    private static final ValueWriter.Factory<Symbol> FACTORY = new ValueWriter.Factory<Symbol>(){

        @Override
        public ValueWriter<Symbol> newInstance(ValueWriter.Registry registry, Symbol object) {
            return new SymbolWriter(object);
        }
    };

    public SymbolWriter(Symbol object) {
        super(object.length());
        this._value = object;
    }

    @Override
    protected byte getFourOctetEncodingCode() {
        return -77;
    }

    @Override
    protected byte getSingleOctetEncodingCode() {
        return -93;
    }

    @Override
    protected void writeBytes(QpidByteBuffer buf, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            buf.put((byte)this._value.charAt(i));
        }
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Symbol.class, FACTORY);
    }
}

