/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.framing.AMQFrame;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedShort;
import org.apache.qpid.server.transport.ByteBufferSender;

public class FrameWriter {
    private final ByteBufferSender _sender;
    private final ValueWriter.Registry _registry;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public FrameWriter(ValueWriter.Registry registry, ByteBufferSender sender) {
        this._registry = registry;
        this._sender = sender;
    }

    public <T> int send(AMQFrame<T> frame) {
        int totalSize;
        QpidByteBuffer payload = frame.getPayload();
        int payloadLength = payload == null ? 0 : payload.remaining();
        T frameBody = frame.getFrameBody();
        ValueWriter<T> typeWriter = frameBody == null ? null : this._registry.getValueWriter(frameBody);
        int bodySize = typeWriter == null ? 8 : 8 + typeWriter.getEncodedSize();
        try (QpidByteBuffer body = QpidByteBuffer.allocate((boolean)this._sender.isDirectBufferPreferred(), (int)bodySize);){
            totalSize = bodySize + payloadLength;
            body.putInt(totalSize);
            body.put((byte)2);
            body.put(frame.getFrameType());
            body.putShort(UnsignedShort.valueOf(frame.getChannel()).shortValue());
            if (typeWriter != null) {
                typeWriter.writeToBuffer(body);
            }
            body.flip();
            this._sender.send(body);
        }
        if (payload != null) {
            this._sender.send(payload);
        }
        return totalSize;
    }
}

