/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class CharTypeConstructor
implements TypeConstructor<String> {
    private static final CharTypeConstructor INSTANCE = new CharTypeConstructor();

    public static CharTypeConstructor getInstance() {
        return INSTANCE;
    }

    private CharTypeConstructor() {
    }

    @Override
    public String construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.hasRemaining(4)) {
            int codePoint = in.getInt();
            char[] chars = Character.toChars(codePoint);
            return new String(chars);
        }
        throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct char: insufficient input data", new Object[0]);
    }
}

