/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.AlternateBinding;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.BrokerLogInclusionRule;
import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.PermissionedObject;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.RemoteReplicationNode;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAccessControlProvider;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.VirtualHostLogInclusionRule;
import org.apache.qpid.server.model.VirtualHostLogger;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.config.LegacyAccessControl;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.OperationLoggingDetails;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

class LegacyAccessControlAdapter {
    private static final Set<String> LOG_ACCESS_METHOD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("getFile", "getFiles", "getAllFiles", "getLogEntries")));
    private static final Set<String> QUEUE_UPDATE_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("moveMessages", "copyMessages", "deleteMessages")));
    private final LegacyAccessControl _accessControl;
    private final Model _model;

    LegacyAccessControlAdapter(LegacyAccessControl accessControl, Model model) {
        this._accessControl = accessControl;
        this._model = model;
    }

    private Model getModel() {
        return this._model;
    }

    Result authorise(LegacyOperation operation, PermissionedObject configuredObject, Map<String, Object> arguments) {
        if (this.isAllowedOperation(operation, configuredObject)) {
            return Result.ALLOWED;
        }
        Class categoryClass = configuredObject.getCategoryClass();
        ObjectType objectType = this.getACLObjectTypeManagingConfiguredObjectOfCategory(categoryClass);
        if (objectType == null) {
            throw new IllegalArgumentException("Cannot identify object type for category " + categoryClass);
        }
        ObjectProperties properties = this.getACLObjectProperties(configuredObject, operation);
        if (operation == LegacyOperation.UPDATE) {
            properties.setAttributeNames(arguments.keySet());
        }
        LegacyOperation authoriseOperation = this.validateAuthoriseOperation(operation, categoryClass);
        return this._accessControl.authorise(authoriseOperation, objectType, properties);
    }

    private boolean isAllowedOperation(LegacyOperation operation, PermissionedObject configuredObject) {
        if (configuredObject instanceof Session && (operation == LegacyOperation.CREATE || operation == LegacyOperation.UPDATE || operation == LegacyOperation.DELETE)) {
            return true;
        }
        if (configuredObject instanceof Consumer && (operation == LegacyOperation.UPDATE || operation == LegacyOperation.DELETE)) {
            return true;
        }
        return configuredObject instanceof Connection && (operation == LegacyOperation.UPDATE || operation == LegacyOperation.DELETE);
    }

    private ObjectType getACLObjectTypeManagingConfiguredObjectOfCategory(Class<? extends ConfiguredObject> category) {
        if (Binding.class.isAssignableFrom(category)) {
            return ObjectType.EXCHANGE;
        }
        if (VirtualHostNode.class.isAssignableFrom(category)) {
            return ObjectType.VIRTUALHOSTNODE;
        }
        if (this.isBrokerType(category)) {
            return ObjectType.BROKER;
        }
        if (this.isVirtualHostType(category)) {
            return ObjectType.VIRTUALHOST;
        }
        if (Group.class.isAssignableFrom(category)) {
            return ObjectType.GROUP;
        }
        if (GroupMember.class.isAssignableFrom(category)) {
            return ObjectType.GROUP;
        }
        if (User.class.isAssignableFrom(category)) {
            return ObjectType.USER;
        }
        if (Queue.class.isAssignableFrom(category)) {
            return ObjectType.QUEUE;
        }
        if (Exchange.class.isAssignableFrom(category)) {
            return ObjectType.EXCHANGE;
        }
        if (Session.class.isAssignableFrom(category)) {
            return ObjectType.EXCHANGE;
        }
        if (Consumer.class.isAssignableFrom(category)) {
            return ObjectType.QUEUE;
        }
        if (RemoteReplicationNode.class.isAssignableFrom(category)) {
            return ObjectType.VIRTUALHOSTNODE;
        }
        return null;
    }

    private boolean isVirtualHostType(Class<? extends ConfiguredObject> category) {
        return VirtualHost.class.isAssignableFrom(category) || VirtualHostLogger.class.isAssignableFrom(category) || VirtualHostLogInclusionRule.class.isAssignableFrom(category) || VirtualHostAccessControlProvider.class.isAssignableFrom(category) || Connection.class.isAssignableFrom(category);
    }

    private boolean isBrokerType(Class<? extends ConfiguredObject> category) {
        return Broker.class.isAssignableFrom(category) || BrokerLogInclusionRule.class.isAssignableFrom(category) || VirtualHostAlias.class.isAssignableFrom(category) || !VirtualHostNode.class.isAssignableFrom(category) && this.getModel().getChildTypes(Broker.class).contains(category);
    }

    private ObjectProperties getACLObjectProperties(PermissionedObject configuredObject, LegacyOperation configuredObjectOperation) {
        String objectName = configuredObject.getName();
        Class configuredObjectType = configuredObject.getCategoryClass();
        ObjectProperties properties = new ObjectProperties(objectName);
        if (configuredObject instanceof Queue) {
            this.setQueueProperties((ConfiguredObject<?>)((Queue)configuredObject), properties);
        } else if (configuredObject instanceof Exchange) {
            Exchange exchange = (Exchange)configuredObject;
            Object lifeTimePolicy = exchange.getAttribute("lifetimePolicy");
            properties.put(ObjectProperties.Property.AUTO_DELETE, lifeTimePolicy != LifetimePolicy.PERMANENT);
            properties.put(ObjectProperties.Property.TEMPORARY, lifeTimePolicy != LifetimePolicy.PERMANENT);
            properties.put(ObjectProperties.Property.DURABLE, (Boolean)exchange.getAttribute("durable"));
            properties.put(ObjectProperties.Property.TYPE, (String)exchange.getAttribute("type"));
            if (exchange.getAttribute("createdBy") != null) {
                properties.put(ObjectProperties.Property.CREATED_BY, (String)exchange.getAttribute("createdBy"));
            }
            VirtualHost virtualHost = (VirtualHost)exchange.getParent();
            properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, (String)virtualHost.getAttribute("name"));
        } else if (configuredObject instanceof QueueConsumer) {
            Queue queue = (Queue)((QueueConsumer)configuredObject).getParent();
            this.setQueueProperties((ConfiguredObject<?>)queue, properties);
        } else {
            ConfiguredObject object = (ConfiguredObject)configuredObject;
            if (this.isBrokerType(configuredObjectType)) {
                String description = String.format("%s %s '%s'", configuredObjectOperation == null ? null : configuredObjectOperation.name().toLowerCase(), configuredObjectType == null ? null : configuredObjectType.getSimpleName().toLowerCase(), objectName);
                properties = new OperationLoggingDetails(description);
            } else if (this.isVirtualHostType(configuredObjectType)) {
                ConfiguredObject virtualHost = (ConfiguredObject)this.getModel().getAncestor(VirtualHost.class, object);
                properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, (String)virtualHost.getAttribute("name"));
            }
            if (object.getAttribute("createdBy") != null) {
                properties.put(ObjectProperties.Property.CREATED_BY, (String)object.getAttribute("createdBy"));
            }
        }
        return properties;
    }

    private void setQueueProperties(ConfiguredObject<?> queue, ObjectProperties properties) {
        String owner;
        String name;
        Object alternateBinding;
        properties.setName((String)queue.getAttribute("name"));
        Object lifeTimePolicy = queue.getAttribute("lifetimePolicy");
        properties.put(ObjectProperties.Property.AUTO_DELETE, lifeTimePolicy != LifetimePolicy.PERMANENT);
        properties.put(ObjectProperties.Property.TEMPORARY, lifeTimePolicy != LifetimePolicy.PERMANENT);
        properties.put(ObjectProperties.Property.DURABLE, (Boolean)queue.getAttribute("durable"));
        properties.put(ObjectProperties.Property.EXCLUSIVE, queue.getAttribute("exclusive") != ExclusivityPolicy.NONE);
        if (queue.getAttribute("createdBy") != null) {
            properties.put(ObjectProperties.Property.CREATED_BY, (String)queue.getAttribute("createdBy"));
        }
        if ((alternateBinding = queue.getAttribute("alternateBinding")) instanceof AlternateBinding && (name = ((AlternateBinding)alternateBinding).getDestination()) != null && !"".equals(name)) {
            properties.put(ObjectProperties.Property.ALTERNATE, name);
        }
        if ((owner = (String)queue.getAttribute("owner")) != null) {
            properties.put(ObjectProperties.Property.OWNER, owner);
        }
        VirtualHost virtualHost = (VirtualHost)queue.getParent();
        properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, (String)virtualHost.getAttribute("name"));
    }

    private LegacyOperation validateAuthoriseOperation(LegacyOperation operation, Class<? extends ConfiguredObject> category) {
        if (operation == LegacyOperation.CREATE || operation == LegacyOperation.UPDATE) {
            if (Consumer.class.isAssignableFrom(category)) {
                return LegacyOperation.CONSUME;
            }
            if (GroupMember.class.isAssignableFrom(category)) {
                return LegacyOperation.UPDATE;
            }
            if (this.isBrokerType(category)) {
                return LegacyOperation.CONFIGURE;
            }
        } else if (operation == LegacyOperation.DELETE) {
            if (this.isBrokerType(category)) {
                return LegacyOperation.CONFIGURE;
            }
            if (GroupMember.class.isAssignableFrom(category)) {
                return LegacyOperation.UPDATE;
            }
        }
        return operation;
    }

    Result authoriseAction(PermissionedObject configuredObject, String actionName, Map<String, Object> arguments) {
        String createdBy;
        Class categoryClass = configuredObject.getCategoryClass();
        String string = createdBy = configuredObject instanceof ConfiguredObject ? (String)((ConfiguredObject)configuredObject).getAttribute("createdBy") : null;
        if (categoryClass == Exchange.class) {
            MessageDestination exchange = (MessageDestination)configuredObject;
            if ("publish".equals(actionName)) {
                ObjectProperties props = new ObjectProperties(exchange.getAddressSpace().getName(), exchange.getName(), (String)arguments.get("routingKey"));
                props.put(ObjectProperties.Property.DURABLE, exchange.isDurable());
                if (exchange instanceof Exchange) {
                    LifetimePolicy lifetimePolicy = ((Exchange)exchange).getLifetimePolicy();
                    props.put(ObjectProperties.Property.AUTO_DELETE, lifetimePolicy != LifetimePolicy.PERMANENT);
                    props.put(ObjectProperties.Property.TEMPORARY, lifetimePolicy != LifetimePolicy.PERMANENT);
                }
                if (createdBy != null) {
                    props.put(ObjectProperties.Property.CREATED_BY, createdBy);
                }
                return this._accessControl.authorise(LegacyOperation.PUBLISH, ObjectType.EXCHANGE, props);
            }
        } else if (categoryClass == VirtualHost.class) {
            if ("connect".equals(actionName)) {
                String virtualHostName = configuredObject.getName();
                ObjectProperties properties = new ObjectProperties(virtualHostName);
                properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, virtualHostName);
                if (createdBy != null) {
                    properties.put(ObjectProperties.Property.CREATED_BY, createdBy);
                }
                return this._accessControl.authorise(LegacyOperation.ACCESS, ObjectType.VIRTUALHOST, properties);
            }
        } else if (categoryClass == Broker.class) {
            if ("manage".equals(actionName)) {
                ObjectProperties props = ObjectProperties.EMPTY;
                if (createdBy != null) {
                    props = new ObjectProperties();
                    props.put(ObjectProperties.Property.CREATED_BY, createdBy);
                }
                return this._accessControl.authorise(LegacyOperation.ACCESS, ObjectType.MANAGEMENT, props);
            }
        } else if (categoryClass == Queue.class) {
            Queue queue = (Queue)configuredObject;
            if ("publish".equals(actionName)) {
                ObjectProperties props = new ObjectProperties(queue.getParent().getName(), "", queue.getName());
                if (createdBy != null) {
                    props.put(ObjectProperties.Property.CREATED_BY, createdBy);
                }
                return this._accessControl.authorise(LegacyOperation.PUBLISH, ObjectType.EXCHANGE, props);
            }
        }
        return Result.DEFER;
    }

    Result authoriseMethod(PermissionedObject configuredObject, String methodName, Map<String, Object> arguments) {
        Class categoryClass = configuredObject.getCategoryClass();
        Result invokeResult = this._accessControl.authorise(LegacyOperation.INVOKE, this.getACLObjectTypeManagingConfiguredObjectOfCategory(categoryClass), this.createObjectPropertiesForMethod(configuredObject, methodName));
        if (invokeResult == Result.ALLOWED) {
            return invokeResult;
        }
        String createdBy = configuredObject instanceof ConfiguredObject ? (String)((ConfiguredObject)configuredObject).getAttribute("createdBy") : null;
        ObjectProperties properties = new ObjectProperties();
        if (createdBy != null) {
            properties.put(ObjectProperties.Property.CREATED_BY, createdBy);
        }
        if (categoryClass == Queue.class) {
            Queue queue = (Queue)configuredObject;
            if ("clearQueue".equals(methodName)) {
                this.setQueueProperties((ConfiguredObject<?>)queue, properties);
                return this._accessControl.authorise(LegacyOperation.PURGE, ObjectType.QUEUE, properties);
            }
            if (QUEUE_UPDATE_METHODS.contains(methodName)) {
                QueueManagingVirtualHost virtualHost = queue.getVirtualHost();
                String virtualHostName = virtualHost.getName();
                properties.setName(methodName);
                properties.put(ObjectProperties.Property.COMPONENT, this.buildHierarchicalCategoryName((ConfiguredObject<?>)queue, (ConfiguredObject<?>)virtualHost));
                properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, virtualHostName);
                return this._accessControl.authorise(LegacyOperation.UPDATE, ObjectType.METHOD, properties);
            }
        } else {
            if ((categoryClass == BrokerLogger.class || categoryClass == VirtualHostLogger.class) && LOG_ACCESS_METHOD_NAMES.contains(methodName)) {
                if (categoryClass != BrokerLogger.class) {
                    properties.setName(((ConfiguredObject)configuredObject).getParent().getName());
                }
                return this._accessControl.authorise(LegacyOperation.ACCESS_LOGS, categoryClass == BrokerLogger.class ? ObjectType.BROKER : ObjectType.VIRTUALHOST, properties);
            }
            if (categoryClass == Broker.class && "initiateShutdown".equals(methodName)) {
                this._accessControl.authorise(LegacyOperation.SHUTDOWN, ObjectType.BROKER, properties);
            } else if (categoryClass == Exchange.class) {
                ObjectProperties props = this.createObjectPropertiesForExchangeBind(arguments, configuredObject);
                if (createdBy != null) {
                    props.put(ObjectProperties.Property.CREATED_BY, createdBy);
                }
                if ("bind".equals(methodName)) {
                    return this._accessControl.authorise(LegacyOperation.BIND, ObjectType.EXCHANGE, props);
                }
                if ("unbind".equals(methodName)) {
                    return this._accessControl.authorise(LegacyOperation.UNBIND, ObjectType.EXCHANGE, props);
                }
            }
        }
        return invokeResult;
    }

    private ObjectProperties createObjectPropertiesForMethod(PermissionedObject permissionedObject, String methodName) {
        ObjectProperties properties = new ObjectProperties(permissionedObject.getName());
        properties.put(ObjectProperties.Property.METHOD_NAME, methodName);
        if (permissionedObject instanceof ConfiguredObject) {
            String componentName;
            ConfiguredObject configuredObject = (ConfiguredObject)permissionedObject;
            Model model = configuredObject.getModel();
            VirtualHost virtualHost = (VirtualHost)model.getAncestor(VirtualHost.class, configuredObject);
            if (virtualHost != null) {
                properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, virtualHost.getName());
                componentName = this.buildHierarchicalCategoryName((ConfiguredObject<?>)configuredObject, (ConfiguredObject<?>)virtualHost);
            } else {
                componentName = this.buildHierarchicalCategoryName(configuredObject, (ConfiguredObject)model.getAncestor(Broker.class, configuredObject));
            }
            properties.put(ObjectProperties.Property.COMPONENT, componentName);
            String createdBy = (String)configuredObject.getAttribute("createdBy");
            if (createdBy != null) {
                properties.put(ObjectProperties.Property.CREATED_BY, createdBy);
            }
        }
        return properties;
    }

    private String buildHierarchicalCategoryName(ConfiguredObject<?> configuredObject, ConfiguredObject<?> significantAncestor) {
        LinkedList<String> hierarchicalName = new LinkedList<String>();
        ConfiguredObject current = configuredObject;
        hierarchicalName.add(configuredObject.getCategoryClass().getSimpleName());
        while (current != null && significantAncestor != current) {
            ConfiguredObject parent = configuredObject.getParent();
            hierarchicalName.add(0, parent.getCategoryClass().getSimpleName());
            current = parent;
        }
        return hierarchicalName.stream().collect(Collectors.joining("."));
    }

    private ObjectProperties createObjectPropertiesForExchangeBind(Map<String, Object> arguments, PermissionedObject configuredObject) {
        ObjectProperties properties = new ObjectProperties();
        Exchange exchange = (Exchange)configuredObject;
        QueueManagingVirtualHost virtualhost = exchange.getVirtualHost();
        properties.setName(exchange.getName());
        String destination = (String)arguments.get("destination");
        properties.put(ObjectProperties.Property.QUEUE_NAME, destination);
        properties.put(ObjectProperties.Property.ROUTING_KEY, (String)arguments.get("bindingKey"));
        properties.put(ObjectProperties.Property.VIRTUALHOST_NAME, virtualhost.getName());
        MessageDestination dest = virtualhost.getAttainedMessageDestination(destination);
        if (dest != null) {
            if (dest instanceof ConfiguredObject) {
                ConfiguredObject queue = (ConfiguredObject)dest;
                properties.put(ObjectProperties.Property.TEMPORARY, queue.getLifetimePolicy() != LifetimePolicy.PERMANENT);
            }
            properties.put(ObjectProperties.Property.DURABLE, dest.isDurable());
        }
        return properties;
    }

    Result authorise(Operation operation, PermissionedObject configuredObject, Map<String, Object> arguments) {
        switch (operation.getType()) {
            case CREATE: {
                return this.authorise(LegacyOperation.CREATE, configuredObject, Collections.emptyMap());
            }
            case UPDATE: {
                return this.authorise(LegacyOperation.UPDATE, configuredObject, arguments);
            }
            case DELETE: {
                return this.authorise(LegacyOperation.DELETE, configuredObject, Collections.emptyMap());
            }
            case INVOKE_METHOD: {
                return this.authoriseMethod(configuredObject, operation.getName(), arguments);
            }
            case PERFORM_ACTION: {
                return this.authoriseAction(configuredObject, operation.getName(), arguments);
            }
            case DISCOVER: 
            case READ: {
                return Result.DEFER;
            }
        }
        return null;
    }
}

