/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.TestHook;
import java.util.Calendar;

public class CronScheduleParser {
    private static String errorMess = "The style of je.env.verifySchedule is not right. ";
    private static int spaceNum = 4;
    private static int fieldNum = 5;
    public static String nullCons = "The argument should not be null.";
    public static String cons1 = "The standard string should be '* * * * *', i.e. there are " + fieldNum + "fields and " + spaceNum + "blank space.";
    public static String cons2 = "Each filed can only be a int value or *.";
    public static String cons3 = "Can not specify dayOfWeek and dayOfMonth simultaneously.";
    public static String cons4 = "Can not specify dayOfMonth or month.";
    public static String cons5 = "Range Error: ";
    public static String cons6 = "If the day of the week is a concrete day, then the minute and thehour should also be concrete.";
    public static String cons7 = "If the hour is a concrete day, then minute should also be concrete";
    private static long millsOneDay = 86400000L;
    private static long millsOneHour = 3600000L;
    private static long millsOneMinute = 60000L;
    private long delay;
    private long interval;
    public static Calendar curCal;
    public static TestHook<Void> setCurCalHook;

    public CronScheduleParser(String cronSchedule) {
        this.validate(cronSchedule);
        this.parser(cronSchedule);
    }

    public static boolean checkSame(String cronvSchedule1, String cronSchedule2) {
        if (cronvSchedule1 == null && cronSchedule2 == null) {
            return true;
        }
        if (cronvSchedule1 == null || cronSchedule2 == null) {
            return false;
        }
        return cronvSchedule1.equals(cronSchedule2);
    }

    public long getDelayTime() {
        return this.delay;
    }

    public long getInterval() {
        return this.interval;
    }

    private void assertDelay() {
        assert (this.delay >= 0L) : "Delay is: " + this.delay + "; interval is: " + this.interval;
    }

    private void parser(String cronSchedule) {
        curCal = Calendar.getInstance();
        curCal.set(13, 0);
        curCal.set(14, 0);
        if (setCurCalHook != null) {
            setCurCalHook.doHook();
        }
        int curDayOfWeek = curCal.get(7);
        int curHour = curCal.get(11);
        int curMinute = curCal.get(12);
        Calendar scheduleCal = Calendar.getInstance();
        scheduleCal.set(13, 0);
        scheduleCal.set(14, 0);
        String[] timeArray = cronSchedule.split(" ");
        if (!timeArray[4].equals("*")) {
            this.interval = 7L * millsOneDay;
            int tmpDayOfWeek = Integer.valueOf(timeArray[4]) + 1;
            int tmpHour = Integer.valueOf(timeArray[1]);
            int tmpMinute = Integer.valueOf(timeArray[0]);
            scheduleCal.set(7, tmpDayOfWeek);
            scheduleCal.set(11, tmpHour);
            scheduleCal.set(12, tmpMinute);
            if (tmpDayOfWeek < curDayOfWeek || tmpDayOfWeek == curDayOfWeek && tmpHour < curHour || tmpDayOfWeek == curDayOfWeek && tmpHour == curHour && tmpMinute < curMinute) {
                scheduleCal.add(5, 7);
            }
            this.delay = scheduleCal.getTimeInMillis() - curCal.getTimeInMillis();
            this.assertDelay();
            return;
        }
        if (!timeArray[1].equals("*")) {
            this.interval = millsOneDay;
            int tmpHour = Integer.valueOf(timeArray[1]);
            int tmpMinute = Integer.valueOf(timeArray[0]);
            scheduleCal.set(7, curDayOfWeek);
            scheduleCal.set(11, tmpHour);
            scheduleCal.set(12, tmpMinute);
            if (tmpHour < curHour || tmpHour == curHour && tmpMinute < curMinute) {
                scheduleCal.add(5, 1);
            }
            this.delay = scheduleCal.getTimeInMillis() - curCal.getTimeInMillis();
            this.assertDelay();
            return;
        }
        if (!timeArray[0].equals("*")) {
            this.interval = millsOneHour;
            int tmpMinute = Integer.valueOf(timeArray[0]);
            scheduleCal.set(7, curDayOfWeek);
            scheduleCal.set(11, curHour);
            scheduleCal.set(12, tmpMinute);
            if (tmpMinute < curMinute) {
                scheduleCal.add(10, 1);
            }
            this.delay = scheduleCal.getTimeInMillis() - curCal.getTimeInMillis();
            this.assertDelay();
            return;
        }
        if (timeArray[0].equals("*")) {
            this.interval = millsOneMinute;
            this.delay = 0L;
            this.assertDelay();
            return;
        }
    }

    private void validate(String cronSchedule) {
        int dayOfWeek;
        int hour;
        int min;
        String[] timeArray;
        if (cronSchedule == null) {
            throw new IllegalArgumentException(errorMess + nullCons);
        }
        int spaceCount = 0;
        for (int i = 0; i < cronSchedule.length(); ++i) {
            char c = cronSchedule.charAt(i);
            if (c != ' ') continue;
            ++spaceCount;
        }
        if (spaceCount != spaceNum || cronSchedule.split(" ").length != fieldNum) {
            throw new IllegalArgumentException(errorMess + cons1);
        }
        for (String str : timeArray = cronSchedule.split(" ")) {
            try {
                Integer.valueOf(str);
            }
            catch (NumberFormatException e) {
                if (str.equals("*")) continue;
                throw new IllegalArgumentException(errorMess + cons2);
            }
        }
        if (!timeArray[2].equals("*") && !timeArray[4].equals("*")) {
            throw new IllegalArgumentException(errorMess + cons3);
        }
        if (!timeArray[2].equals("*") || !timeArray[3].equals("*")) {
            throw new IllegalArgumentException(errorMess + cons4);
        }
        if (!(timeArray[0].equals("*") || (min = Integer.valueOf(timeArray[0]).intValue()) >= 0 && min <= 59)) {
            throw new IllegalArgumentException(errorMess + cons5 + "The minute should be (0-59).");
        }
        if (!(timeArray[1].equals("*") || (hour = Integer.valueOf(timeArray[1]).intValue()) >= 0 && hour <= 23)) {
            throw new IllegalArgumentException(errorMess + cons5 + "The hour should be (0-23).");
        }
        if (!(timeArray[4].equals("*") || (dayOfWeek = Integer.valueOf(timeArray[4]).intValue()) >= 0 && dayOfWeek <= 6)) {
            throw new IllegalArgumentException(errorMess + cons5 + "The day of the week should" + "be (0-6).");
        }
        if (!timeArray[4].equals("*") && (timeArray[0].equals("*") || timeArray[1].equals("*"))) {
            throw new IllegalArgumentException(errorMess + cons6);
        }
        if (!timeArray[1].equals("*") && timeArray[0].equals("*")) {
            throw new IllegalArgumentException(errorMess + cons7);
        }
    }
}

