/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.prometheus;

import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.plugin.ContentFactory;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.prometheus.IncludeDisabledStatisticPredicate;
import org.apache.qpid.server.prometheus.IncludeMetricPredicate;
import org.apache.qpid.server.prometheus.QpidCollector;

@PluggableService
public class PrometheusContentFactory
implements ContentFactory {
    static final String INCLUDE_DISABLED = "includeDisabled";
    static final String INCLUDE_METRIC = "name[]";
    static final String INCLUDE_DISABLED_CONTEXT_VARIABLE = "qpid.metrics.includeDisabled";

    public Content createContent(ConfiguredObject<?> object, Map<String, String[]> filter) {
        String[] includedMetricNames;
        Boolean val;
        boolean includeDisabled;
        String[] includeDisabledValues = filter.get(INCLUDE_DISABLED);
        boolean bl = includeDisabled = includeDisabledValues != null && includeDisabledValues.length == 1 && Boolean.parseBoolean(includeDisabledValues[0]);
        if (!includeDisabled && (val = (Boolean)object.getContextValue(Boolean.class, INCLUDE_DISABLED_CONTEXT_VARIABLE)) != null) {
            includeDisabled = val;
        }
        IncludeMetricPredicate metricIncludeFilter = new IncludeMetricPredicate((includedMetricNames = filter.get(INCLUDE_METRIC)) == null || includedMetricNames.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(includedMetricNames)));
        final QpidCollector qpidCollector = new QpidCollector(object, new IncludeDisabledStatisticPredicate(includeDisabled), metricIncludeFilter);
        return new Content(){

            public void write(OutputStream outputStream) throws IOException {
                try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
                    TextFormat.write004((Writer)writer, Collections.enumeration(qpidCollector.collect()));
                    ((Writer)writer).flush();
                }
            }

            public void release() {
            }

            @RestContentHeader(value="Content-Type")
            public String getContentType() {
                return "text/plain; version=0.0.4; charset=utf-8";
            }
        };
    }

    public String getType() {
        return "metrics";
    }
}

