/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.util;

import java.util.Collection;
import java.util.Map;
import org.apache.qpid.server.security.access.util.Any;
import org.apache.qpid.server.security.access.util.Empty;
import org.apache.qpid.server.security.access.util.FinalBranch;
import org.apache.qpid.server.security.access.util.WildCardBranch;

public interface PrefixTree
extends Iterable<String> {
    public String prefix();

    public char firstPrefixCharacter();

    public Map<Character, PrefixTree> branches();

    public int size();

    public boolean match(String var1);

    default public PrefixTree mergeWith(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("Prefix tree can not be merged with an empty value");
        }
        if ("*".equals(str)) {
            return Any.INSTANCE;
        }
        if (str.endsWith("*")) {
            return this.mergeWithPrefix(str.substring(0, str.length() - 1));
        }
        return this.mergeWithFinalValue(str);
    }

    default public PrefixTree mergeWith(Collection<String> collection) {
        PrefixTree tree = this;
        for (String str : collection) {
            tree = tree.mergeWith(str);
        }
        return tree;
    }

    public PrefixTree mergeWithFinalValue(String var1);

    public PrefixTree mergeWithPrefix(String var1);

    public static PrefixTree empty() {
        return Empty.INSTANCE;
    }

    public static PrefixTree from(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("A non null string is required");
        }
        if ("*".equals(str)) {
            return Any.INSTANCE;
        }
        if (str.endsWith("*")) {
            return PrefixTree.fromPrefixWithWildCard(str.substring(0, str.length() - 1));
        }
        return PrefixTree.fromFinalValue(str);
    }

    public static PrefixTree from(Collection<String> collection) {
        return PrefixTree.empty().mergeWith(collection);
    }

    public static PrefixTree fromFinalValue(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("A non empty value is required");
        }
        return new FinalBranch(value);
    }

    public static PrefixTree fromPrefixWithWildCard(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            throw new IllegalArgumentException("A non empty prefix is required");
        }
        return new WildCardBranch(prefix);
    }
}

