/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.StdScalarSerializer;

public class InetSocketAddressSerializer
extends StdScalarSerializer<InetSocketAddress> {
    public InetSocketAddressSerializer() {
        super(InetSocketAddress.class);
    }

    @Override
    public void serialize(InetSocketAddress value, JsonGenerator jgen, SerializationContext provider) throws JacksonException {
        InetAddress addr = value.getAddress();
        Object str = addr == null ? value.getHostName() : addr.toString().trim();
        int ix = ((String)str).indexOf(47);
        if (ix >= 0) {
            str = ix == 0 ? (addr instanceof Inet6Address ? "[" + ((String)str).substring(1) + "]" : ((String)str).substring(1)) : ((String)str).substring(0, ix);
        }
        jgen.writeString((String)str + ":" + value.getPort());
    }

    @Override
    public void serializeWithType(InetSocketAddress value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId((Object)value, InetSocketAddress.class, JsonToken.VALUE_STRING));
        this.serialize(value, g, ctxt);
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }
}

