/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.store.berkeleydb.BDBPreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreFactoryService;

@PluggableService
public class BDBPreferenceStoreFactoryService
implements PreferenceStoreFactoryService {
    private static final String TYPE = "BDB";
    private static final String PATH = "path";

    public PreferenceStore createInstance(ConfiguredObject<?> parent, Map<String, Object> preferenceStoreAttributes) {
        Object path = preferenceStoreAttributes.get(PATH);
        if (path == null || !(path instanceof String)) {
            throw new IllegalConfigurationException("BDBPreferenceStore requires path");
        }
        String storePath = (String)path;
        return new BDBPreferenceStore(parent, storePath);
    }

    public String getType() {
        return TYPE;
    }
}

