/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.plugins;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.user.connection.limits.config.FileParser;
import org.apache.qpid.server.user.connection.limits.config.Rule;
import org.apache.qpid.server.user.connection.limits.config.RulePredicates;
import org.apache.qpid.server.user.connection.limits.config.RuleSetCreator;
import org.apache.qpid.server.user.connection.limits.plugins.AbstractConnectionLimitProvider;
import org.apache.qpid.server.user.connection.limits.plugins.ConnectionLimitRule;
import org.apache.qpid.server.user.connection.limits.plugins.ConnectionLimitRuleImpl;
import org.apache.qpid.server.user.connection.limits.plugins.RuleBasedConnectionLimitProvider;

public abstract class AbstractRuleBasedConnectionLimitProvider<C extends AbstractRuleBasedConnectionLimitProvider<C>>
extends AbstractConnectionLimitProvider<C>
implements RuleBasedConnectionLimitProvider<C> {
    private static final String RULES = "rules";
    static final String RULE_BASED_TYPE = "RuleBased";
    @ManagedAttributeField
    private Long _defaultFrequencyPeriod;
    @ManagedAttributeField
    private List<ConnectionLimitRule> _rules = new ArrayList<ConnectionLimitRule>();

    public AbstractRuleBasedConnectionLimitProvider(ConfiguredObject<?> parent, Map<String, Object> attributes) {
        super(parent, attributes);
    }

    @Override
    public List<ConnectionLimitRule> getRules() {
        return Collections.unmodifiableList(this._rules);
    }

    @Override
    public Long getDefaultFrequencyPeriod() {
        return Optional.ofNullable(this._defaultFrequencyPeriod).orElseGet(() -> (Long)this.getContextValue(Long.class, "qpid.broker.connectionLimiter.frequencyPeriodInMillis"));
    }

    @Override
    public Content extractRules() {
        return new StringContent(this.getName(), this.getDefaultFrequencyPeriod(), this.getRules());
    }

    @Override
    public void loadFromFile(String path) {
        this.authorise(Operation.UPDATE);
        ArrayList<ConnectionLimitRule> connectionLimitRules = new ArrayList<ConnectionLimitRule>(this.getRules());
        for (Rule rule : FileParser.parse(path).updateRulesWithDefaultFrequencyPeriod()) {
            connectionLimitRules.add(new ConnectionLimitRuleImpl(rule));
        }
        this.changeAttributes(Collections.singletonMap(RULES, connectionLimitRules));
    }

    @Override
    public void clearRules() {
        this.authorise(Operation.UPDATE);
        this.changeAttributes(Collections.singletonMap(RULES, new ArrayList()));
    }

    @Override
    public void resetCounters() {
        this.changeAttributes(Collections.emptyMap());
    }

    protected void postSetAttributes(Set<String> actualUpdatedAttributes) {
        super.postSetAttributes(actualUpdatedAttributes);
        this.forceNewRuleSetCreator();
    }

    @Override
    protected RuleSetCreator newRuleSetCreator() {
        RuleSetCreator creator = new RuleSetCreator();
        creator.setDefaultFrequencyPeriod(this.getDefaultFrequencyPeriod());
        for (ConnectionLimitRule rule : this.getRules()) {
            creator.add(Rule.newInstance(rule));
        }
        return creator;
    }

    private static final class StringContent
    implements Content,
    CustomRestHeaders {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HHmmss");
        private final String _name;
        private final long _defaultFrequencyPeriod;
        private final List<ConnectionLimitRule> _rules;

        StringContent(String name, long defaultFrequencyPeriod, List<? extends ConnectionLimitRule> rules) {
            this._name = Objects.requireNonNull(name);
            this._defaultFrequencyPeriod = defaultFrequencyPeriod;
            this._rules = new ArrayList<ConnectionLimitRule>(rules);
        }

        public void write(OutputStream outputStream) throws IOException {
            byte[] lineSeparator = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
            outputStream.write(String.format("CONFIG %s=%d", "default_frequency_period", this._defaultFrequencyPeriod).getBytes(StandardCharsets.UTF_8));
            outputStream.write(lineSeparator);
            for (ConnectionLimitRule rule : this._rules) {
                outputStream.write(this.convertToString(rule).getBytes(StandardCharsets.UTF_8));
                outputStream.write(lineSeparator);
            }
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "text/plain";
        }

        @RestContentHeader(value="Content-Disposition")
        public String getContentDisposition() {
            return String.format("attachment; filename=\"%s-%s.clt\"", this._name, FORMATTER.format(LocalDateTime.now()));
        }

        public void release() {
        }

        private String convertToString(ConnectionLimitRule rule) {
            String prefix = "clt".toUpperCase(Locale.ENGLISH);
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("%s %s", prefix, rule.getIdentity()));
            if (Boolean.TRUE.equals(rule.getBlocked())) {
                builder.append(String.format(" %s", "BLOCK"));
            } else {
                this.appendCountLimit(builder, rule);
                this.appendFrequencyLimit(builder, rule);
            }
            this.appendPort(builder, rule);
            return builder.toString();
        }

        private void appendPort(StringBuilder builder, ConnectionLimitRule rule) {
            if (rule.getPort() != null) {
                builder.append(String.format(" %s=%s", new Object[]{RulePredicates.Property.PORT, rule.getPort()}));
            }
        }

        private void appendFrequencyLimit(StringBuilder builder, ConnectionLimitRule rule) {
            if (rule.getFrequencyLimit() != null) {
                if (rule.getFrequencyPeriod() == null) {
                    builder.append(String.format(" %s=%d", new Object[]{RulePredicates.Property.CONNECTION_FREQUENCY_LIMIT, rule.getFrequencyLimit()}));
                } else {
                    builder.append(String.format(" %s=%d/%s", new Object[]{RulePredicates.Property.CONNECTION_FREQUENCY_LIMIT, rule.getFrequencyLimit(), Duration.ofMillis(rule.getFrequencyPeriod())}));
                }
            }
        }

        private void appendCountLimit(StringBuilder builder, ConnectionLimitRule rule) {
            if (rule.getCountLimit() != null) {
                builder.append(String.format(" %s=%d", new Object[]{RulePredicates.Property.CONNECTION_LIMIT, rule.getCountLimit()}));
            }
        }
    }
}

