/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;
import org.apache.qpid.server.protocol.v0_10.transport.Xid;

public final class DtxEnd
extends Method {
    public static final int TYPE = 1539;
    private short packing_flags = 0;
    private Xid xid;

    @Override
    public final int getStructType() {
        return 1539;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public DtxEnd() {
    }

    public DtxEnd(Xid xid, Option ... _options) {
        if (xid != null) {
            this.setXid(xid);
        }
        block8: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case FAIL: {
                    this.packing_flags = (short)(this.packing_flags | 0x200);
                    continue block8;
                }
                case SUSPEND: {
                    this.packing_flags = (short)(this.packing_flags | 0x400);
                    continue block8;
                }
                case SYNC: {
                    this.setSync(true);
                    continue block8;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block8;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block8;
                }
                case NONE: {
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + String.valueOf((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.dtxEnd(context, this);
    }

    public final boolean hasXid() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final DtxEnd clearXid() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.xid = null;
        this.setDirty(true);
        return this;
    }

    public final Xid getXid() {
        return this.xid;
    }

    public final DtxEnd setXid(Xid value) {
        this.xid = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final DtxEnd xid(Xid value) {
        return this.setXid(value);
    }

    public final boolean hasFail() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final DtxEnd clearFail() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getFail() {
        return this.hasFail();
    }

    public final DtxEnd setFail(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x200) : (short)(this.packing_flags & 0xFFFFFDFF);
        this.setDirty(true);
        return this;
    }

    public final DtxEnd fail(boolean value) {
        return this.setFail(value);
    }

    public final boolean hasSuspend() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final DtxEnd clearSuspend() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getSuspend() {
        return this.hasSuspend();
    }

    public final DtxEnd setSuspend(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x400) : (short)(this.packing_flags & 0xFFFFFBFF);
        this.setDirty(true);
        return this;
    }

    public final DtxEnd suspend(boolean value) {
        return this.setSuspend(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStruct(1540, this.xid);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.xid = (Xid)dec.readStruct(1540);
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("xid", this.getXid());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("fail", this.getFail());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("suspend", this.getSuspend());
        }
        return result;
    }
}

