/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.utilint.LoggerUtils;

public class OffsetList {
    static final int SEGMENT_CAPACITY = 100;
    static final int TOO_BIG_FOR_SELF_CHECK = 100;
    private Segment head;
    private Segment tail;
    private int size;

    public OffsetList() {
        this.tail = this.head = new Segment();
    }

    public boolean add(long value, boolean checkDupOffsets) {
        assert (!checkDupOffsets || this.size > 100 || !this.contains(value)) : LoggerUtils.getStackTrace(new Exception("Dup Offset " + Long.toHexString(value)));
        Segment oldTail = this.tail;
        this.tail = this.tail.add(value);
        ++this.size;
        return this.tail != oldTail;
    }

    public int size() {
        return this.size;
    }

    boolean merge(OffsetList other) {
        Segment next;
        boolean oneSegFreed = true;
        Segment seg = other.head;
        while ((next = seg.next()) != null) {
            seg.setNext(this.head);
            this.head = seg;
            seg = next;
        }
        for (int i = 0; i < seg.size(); ++i) {
            if (!this.add(seg.get(i), false)) continue;
            oneSegFreed = false;
        }
        return oneSegFreed;
    }

    public long[] toArray() {
        long[] a = new long[this.size];
        int next = 0;
        block0: for (Segment seg = this.head; seg != null; seg = seg.next()) {
            for (int i = 0; i < seg.size(); ++i) {
                if (next >= a.length) break block0;
                a[next] = seg.get(i);
                ++next;
            }
        }
        return a;
    }

    boolean contains(long offset) {
        for (Segment seg = this.head; seg != null; seg = seg.next()) {
            for (int i = 0; i < seg.size(); ++i) {
                if (seg.get(i) != offset) continue;
                return true;
            }
        }
        return false;
    }

    public static class Segment {
        private int index;
        private Segment next;
        private final int[] values = new int[100];

        Segment add(long value) {
            if (this.index < this.values.length) {
                this.values[this.index] = (int)value;
                ++this.index;
                return this;
            }
            Segment seg = new Segment();
            seg.values[0] = (int)value;
            seg.index = 1;
            this.next = seg;
            return seg;
        }

        long get(int i) {
            return (long)this.values[i] & 0xFFFFFFFFFFFFFFFFL;
        }

        Segment next() {
            return this.next;
        }

        void setNext(Segment next) {
            this.next = next;
        }

        int size() {
            return this.index;
        }
    }
}

