/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.pulsar.manager.profiles;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class SqliteDBTestProfile {

    private static final Logger logger = LoggerFactory.getLogger(SqliteDBTestProfile.class);

    @Bean
    @Profile("test")
    public DataSource dataSource() throws IOException {
        Path tempFile = Files.createTempFile("test-pulsar-manager-db", "sqlite");
        tempFile.toFile().deleteOnExit();
        String sqliteDb = "jdbc:sqlite:" + tempFile.toFile().getAbsolutePath();
        logger.info("Created a temp sqlite db for testing : {}", sqliteDb);

        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName("org.sqlite.JDBC");
        dataSource.setUrl(sqliteDb);

        return dataSource;
    }

}
