@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  pulsar-manager startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and PULSAR_MANAGER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\pulsar-manager.jar;%APP_HOME%\lib\spring-cloud-starter-netflix-zuul-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-web-2.0.2.RELEASE.jar;%APP_HOME%\lib\pagehelper-spring-boot-starter-1.2.4.jar;%APP_HOME%\lib\mybatis-spring-boot-starter-2.1.2.jar;%APP_HOME%\lib\spring-boot-starter-thymeleaf-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-security-2.0.2.RELEASE.jar;%APP_HOME%\lib\casdoor-spring-boot-starter-1.2.0.jar;%APP_HOME%\lib\spring-boot-starter-json-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-cloud-netflix-zuul-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-cloud-starter-netflix-hystrix-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-cloud-starter-netflix-ribbon-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-cloud-starter-netflix-archaius-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-cloud-starter-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-actuator-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-jdbc-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-cloud-netflix-core-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-aop-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-2.0.2.RELEASE.jar;%APP_HOME%\lib\pagehelper-5.1.11.jar;%APP_HOME%\lib\postgresql-42.2.5.jar;%APP_HOME%\lib\herddb-jdbc-0.24.0.jar;%APP_HOME%\lib\hibernate-validator-6.0.9.Final.jar;%APP_HOME%\lib\pulsar-broker-2.7.0.jar;%APP_HOME%\lib\bkvm-3.1.1-war-no-libs.war;%APP_HOME%\lib\bkvm-3.1.1-classes.jar;%APP_HOME%\lib\pulsar-websocket-2.7.0.jar;%APP_HOME%\lib\pulsar-functions-worker-2.7.0.jar;%APP_HOME%\lib\jersey-container-servlet-2.26.jar;%APP_HOME%\lib\jersey-container-servlet-core-2.26.jar;%APP_HOME%\lib\jersey-server-2.26.jar;%APP_HOME%\lib\pulsar-client-admin-original-2.7.0.jar;%APP_HOME%\lib\pulsar-functions-runtime-2.7.0.jar;%APP_HOME%\lib\pulsar-functions-instance-2.7.0.jar;%APP_HOME%\lib\pulsar-functions-utils-2.7.0.jar;%APP_HOME%\lib\pulsar-client-original-2.7.0.jar;%APP_HOME%\lib\jackson-module-jsonSchema-2.9.5.jar;%APP_HOME%\lib\swagger-core-1.5.21.jar;%APP_HOME%\lib\validation-api-2.0.0.Final.jar;%APP_HOME%\lib\pulsar-client-auth-athenz-2.7.0.jar;%APP_HOME%\lib\athenz-zts-java-client-1.10.9.jar;%APP_HOME%\lib\athenz-client-common-1.10.9.jar;%APP_HOME%\lib\athenz-auth-core-1.10.9.jar;%APP_HOME%\lib\pulsar-broker-common-2.7.0.jar;%APP_HOME%\lib\jjwt-impl-0.10.5.jar;%APP_HOME%\lib\jjwt-jackson-0.10.5.jar;%APP_HOME%\lib\jjwt-api-0.10.5.jar;%APP_HOME%\lib\pulsar-transaction-coordinator-2.7.0.jar;%APP_HOME%\lib\managed-ledger-2.7.0.jar;%APP_HOME%\lib\pulsar-zookeeper-utils-2.7.0.jar;%APP_HOME%\lib\pulsar-common-2.7.0.jar;%APP_HOME%\lib\pulsar-client-auth-sasl-2.7.0.jar;%APP_HOME%\lib\springfox-swagger2-2.9.2.jar;%APP_HOME%\lib\herddb-core-0.24.0.jar;%APP_HOME%\lib\springfox-swagger-common-2.9.2.jar;%APP_HOME%\lib\springfox-swagger-ui-2.9.2.jar;%APP_HOME%\lib\springfox-spring-web-2.9.2.jar;%APP_HOME%\lib\hystrix-javanica-1.5.12.jar;%APP_HOME%\lib\ribbon-2.2.5.jar;%APP_HOME%\lib\ribbon-httpclient-2.2.5.jar;%APP_HOME%\lib\ribbon-transport-2.2.5.jar;%APP_HOME%\lib\ribbon-loadbalancer-2.2.5.jar;%APP_HOME%\lib\ribbon-core-2.2.5.jar;%APP_HOME%\lib\zuul-core-1.3.1.jar;%APP_HOME%\lib\hystrix-metrics-event-stream-1.5.12.jar;%APP_HOME%\lib\hystrix-serialization-1.5.12.jar;%APP_HOME%\lib\hystrix-core-1.5.12.jar;%APP_HOME%\lib\archaius-core-0.7.6.jar;%APP_HOME%\lib\rxnetty-servo-0.4.9.jar;%APP_HOME%\lib\servo-core-0.12.21.jar;%APP_HOME%\lib\calcite-core-1.28.0.jar;%APP_HOME%\lib\calcite-linq4j-1.28.0.jar;%APP_HOME%\lib\springfox-schema-2.9.2.jar;%APP_HOME%\lib\springfox-spi-2.9.2.jar;%APP_HOME%\lib\springfox-core-2.9.2.jar;%APP_HOME%\lib\prometheus-metrics-provider-4.12.0.jar;%APP_HOME%\lib\codahale-metrics-provider-4.12.0.jar;%APP_HOME%\lib\pulsar-transaction-common-2.7.0.jar;%APP_HOME%\lib\pulsar-functions-secrets-2.7.0.jar;%APP_HOME%\lib\pulsar-functions-proto-2.7.0.jar;%APP_HOME%\lib\protobuf-java-util-3.11.4.jar;%APP_HOME%\lib\pulsar-metadata-2.7.0.jar;%APP_HOME%\lib\stream-storage-server-4.12.0.jar;%APP_HOME%\lib\stream-storage-service-impl-4.12.0.jar;%APP_HOME%\lib\statelib-4.12.0.jar;%APP_HOME%\lib\distributedlog-core-4.12.0.jar;%APP_HOME%\lib\distributedlog-core-4.12.0-tests.jar;%APP_HOME%\lib\bookkeeper-server-4.14.4.jar;%APP_HOME%\lib\circe-checksum-4.14.4.nar;%APP_HOME%\lib\uzaygezen-core-0.2.jar;%APP_HOME%\lib\stream-storage-java-client-4.12.0.jar;%APP_HOME%\lib\grpc-all-1.18.0.jar;%APP_HOME%\lib\grpc-auth-1.18.0.jar;%APP_HOME%\lib\grpc-netty-1.18.0.jar;%APP_HOME%\lib\grpc-okhttp-1.18.0.jar;%APP_HOME%\lib\grpc-protobuf-1.18.0.jar;%APP_HOME%\lib\grpc-protobuf-nano-1.18.0.jar;%APP_HOME%\lib\grpc-testing-1.18.0.jar;%APP_HOME%\lib\grpc-stub-1.18.0.jar;%APP_HOME%\lib\grpc-protobuf-lite-1.18.0.jar;%APP_HOME%\lib\grpc-core-1.18.0.jar;%APP_HOME%\lib\client-java-9.0.2.jar;%APP_HOME%\lib\bookkeeper-tools-framework-4.14.4.jar;%APP_HOME%\lib\stream-storage-service-api-4.12.0.jar;%APP_HOME%\lib\stream-storage-java-client-base-4.12.0.jar;%APP_HOME%\lib\stream-storage-api-4.12.0.jar;%APP_HOME%\lib\distributedlog-protocol-4.12.0.jar;%APP_HOME%\lib\distributedlog-common-4.12.0.jar;%APP_HOME%\lib\stream-storage-proto-4.12.0.jar;%APP_HOME%\lib\stream-storage-common-4.12.0.jar;%APP_HOME%\lib\bookkeeper-common-4.14.4.jar;%APP_HOME%\lib\cpu-affinity-4.14.4.nar;%APP_HOME%\lib\opencensus-contrib-grpc-metrics-0.18.0.jar;%APP_HOME%\lib\curator-recipes-4.0.1.jar;%APP_HOME%\lib\curator-framework-4.0.1.jar;%APP_HOME%\lib\curator-client-4.0.1.jar;%APP_HOME%\lib\guava-21.0.jar;%APP_HOME%\lib\client-java-api-9.0.2.jar;%APP_HOME%\lib\gson-fire-1.8.4.jar;%APP_HOME%\lib\gson-2.8.2.jar;%APP_HOME%\lib\commons-validator-1.6.jar;%APP_HOME%\lib\tomcat-embed-jasper-8.5.31.jar;%APP_HOME%\lib\jersey-client-2.26.jar;%APP_HOME%\lib\jersey-hk2-2.26.jar;%APP_HOME%\lib\jersey-media-json-jackson-2.26.jar;%APP_HOME%\lib\spring-security-config-5.0.5.RELEASE.jar;%APP_HOME%\lib\mybatis-spring-boot-autoconfigure-2.1.2.jar;%APP_HOME%\lib\pagehelper-spring-boot-autoconfigure-1.2.4.jar;%APP_HOME%\lib\spring-boot-actuator-autoconfigure-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-autoconfigure-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-actuator-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-logging-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-tomcat-2.0.2.RELEASE.jar;%APP_HOME%\lib\jersey-media-multipart-2.26.jar;%APP_HOME%\lib\jersey-media-jaxb-2.26.jar;%APP_HOME%\lib\jersey-common-2.26.jar;%APP_HOME%\lib\hk2-locator-2.5.0-b42.jar;%APP_HOME%\lib\hk2-api-2.5.0-b42.jar;%APP_HOME%\lib\hk2-utils-2.5.0-b42.jar;%APP_HOME%\lib\javax.annotation-api-1.3.2.jar;%APP_HOME%\lib\spring-webmvc-5.0.6.RELEASE.jar;%APP_HOME%\lib\spring-security-web-5.0.5.RELEASE.jar;%APP_HOME%\lib\spring-web-5.0.6.RELEASE.jar;%APP_HOME%\lib\spring-plugin-metadata-1.2.0.RELEASE.jar;%APP_HOME%\lib\spring-plugin-core-1.2.0.RELEASE.jar;%APP_HOME%\lib\spring-security-core-5.0.5.RELEASE.jar;%APP_HOME%\lib\spring-context-5.0.6.RELEASE.jar;%APP_HOME%\lib\spring-aop-5.0.6.RELEASE.jar;%APP_HOME%\lib\spring-jdbc-5.0.6.RELEASE.jar;%APP_HOME%\lib\spring-tx-5.0.6.RELEASE.jar;%APP_HOME%\lib\spring-beans-5.0.6.RELEASE.jar;%APP_HOME%\lib\spring-test-5.0.6.RELEASE.jar;%APP_HOME%\lib\spring-expression-5.0.6.RELEASE.jar;%APP_HOME%\lib\spring-core-5.0.6.RELEASE.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.9.5.jar;%APP_HOME%\lib\collector-0.14.0.jar;%APP_HOME%\lib\snakeyaml-1.19.jar;%APP_HOME%\lib\mybatis-3.5.4.jar;%APP_HOME%\lib\mybatis-spring-2.0.4.jar;%APP_HOME%\lib\jsqlparser-3.2.jar;%APP_HOME%\lib\thymeleaf-spring5-3.0.9.RELEASE.jar;%APP_HOME%\lib\thymeleaf-extras-java8time-3.0.1.RELEASE.jar;%APP_HOME%\lib\aws-java-sdk-sts-1.11.415.jar;%APP_HOME%\lib\aws-java-sdk-core-1.11.415.jar;%APP_HOME%\lib\jersey-apache-client4-1.19.1.jar;%APP_HOME%\lib\avatica-core-1.19.0.jar;%APP_HOME%\lib\libthrift-0.12.0.jar;%APP_HOME%\lib\httpclient-4.5.5.jar;%APP_HOME%\lib\bookkeeper-common-allocator-4.14.4.jar;%APP_HOME%\lib\http-server-4.14.4.jar;%APP_HOME%\lib\bookkeeper-proto-4.14.4.jar;%APP_HOME%\lib\herddb-net-0.24.0.jar;%APP_HOME%\lib\bookkeeper-stats-api-4.14.4.jar;%APP_HOME%\lib\stream-storage-tests-common-4.12.0.jar;%APP_HOME%\lib\commons-configuration-1.10.jar;%APP_HOME%\lib\casdoor-java-sdk-1.5.1.jar;%APP_HOME%\lib\commons-beanutils-1.9.4.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\commons-pool2-2.5.0.jar;%APP_HOME%\lib\athenz-zts-core-1.10.9.jar;%APP_HOME%\lib\avro-protobuf-1.9.1.jar;%APP_HOME%\lib\avro-1.9.1.jar;%APP_HOME%\lib\jackson-jaxrs-json-provider-2.9.5.jar;%APP_HOME%\lib\jackson-module-jaxb-annotations-2.9.5.jar;%APP_HOME%\lib\jackson-datatype-jdk8-2.9.5.jar;%APP_HOME%\lib\jackson-datatype-jsr310-2.9.5.jar;%APP_HOME%\lib\jackson-module-parameter-names-2.9.5.jar;%APP_HOME%\lib\jackson-jaxrs-base-2.9.5.jar;%APP_HOME%\lib\athenz-zms-core-1.10.9.jar;%APP_HOME%\lib\jmespath-java-1.11.415.jar;%APP_HOME%\lib\jackson-module-afterburner-2.9.5.jar;%APP_HOME%\lib\jackson-databind-2.9.5.jar;%APP_HOME%\lib\pulsar-io-core-2.7.0.jar;%APP_HOME%\lib\pulsar-functions-api-2.7.0.jar;%APP_HOME%\lib\pulsar-client-api-2.7.0.jar;%APP_HOME%\lib\swagger-models-1.5.21.jar;%APP_HOME%\lib\swagger-annotations-1.6.2.jar;%APP_HOME%\lib\jul-to-slf4j-1.7.25.jar;%APP_HOME%\lib\athenz-cert-refresher-1.10.9.jar;%APP_HOME%\lib\jcl-over-slf4j-1.7.25.jar;%APP_HOME%\lib\logback-classic-1.2.3.jar;%APP_HOME%\lib\log4j-to-slf4j-2.17.1.jar;%APP_HOME%\lib\netflix-commons-util-0.3.0.jar;%APP_HOME%\lib\HikariCP-2.7.9.jar;%APP_HOME%\lib\thymeleaf-3.0.9.RELEASE.jar;%APP_HOME%\lib\async-http-client-2.12.1.jar;%APP_HOME%\lib\zookeeper-3.6.2.jar;%APP_HOME%\lib\org.apache.oltu.oauth2.client-1.0.2.jar;%APP_HOME%\lib\rxnetty-contexts-0.4.9.jar;%APP_HOME%\lib\rxnetty-0.4.9.jar;%APP_HOME%\lib\async-http-client-netty-utils-2.12.1.jar;%APP_HOME%\lib\metrics-jvm-3.2.6.jar;%APP_HOME%\lib\metrics-graphite-3.2.6.jar;%APP_HOME%\lib\metrics-core-3.2.6.jar;%APP_HOME%\lib\org.apache.oltu.oauth2.common-1.0.2.jar;%APP_HOME%\lib\netflix-statistics-0.1.1.jar;%APP_HOME%\lib\avatica-metrics-1.19.0.jar;%APP_HOME%\lib\slf4j-log4j12-1.7.25.jar;%APP_HOME%\lib\log4j-slf4j-impl-2.17.1.jar;%APP_HOME%\lib\jose4j-0.7.2.jar;%APP_HOME%\lib\pulsar-config-validation-2.7.0.jar;%APP_HOME%\lib\slf4j-api-1.7.25.jar;%APP_HOME%\lib\protobuf-shaded-2.1.0-incubating.jar;%APP_HOME%\lib\netty-codec-http2-4.1.24.Final.jar;%APP_HOME%\lib\netty-handler-4.1.24.Final.jar;%APP_HOME%\lib\netty-transport-native-epoll-4.1.24.Final-linux-x86_64.jar;%APP_HOME%\lib\netty-transport-native-epoll-4.1.24.Final.jar;%APP_HOME%\lib\netty-transport-native-unix-common-4.1.24.Final-linux-x86_64.jar;%APP_HOME%\lib\netty-transport-native-unix-common-4.1.24.Final.jar;%APP_HOME%\lib\aircompressor-0.16.jar;%APP_HOME%\lib\netty-tcnative-boringssl-static-2.0.46.Final.jar;%APP_HOME%\lib\jetty-servlets-9.4.10.v20180503.jar;%APP_HOME%\lib\simpleclient_jetty-0.5.0.jar;%APP_HOME%\lib\websocket-server-9.4.10.v20180503.jar;%APP_HOME%\lib\jetty-servlet-9.4.10.v20180503.jar;%APP_HOME%\lib\jetty-security-9.4.10.v20180503.jar;%APP_HOME%\lib\jetty-server-9.4.10.v20180503.jar;%APP_HOME%\lib\javax-websocket-client-impl-9.4.10.v20180503.jar;%APP_HOME%\lib\websocket-client-9.4.10.v20180503.jar;%APP_HOME%\lib\jetty-client-9.4.10.v20180503.jar;%APP_HOME%\lib\jetty-http-9.4.10.v20180503.jar;%APP_HOME%\lib\websocket-common-9.4.10.v20180503.jar;%APP_HOME%\lib\jetty-io-9.4.10.v20180503.jar;%APP_HOME%\lib\jetty-xml-9.4.10.v20180503.jar;%APP_HOME%\lib\jetty-util-9.4.10.v20180503.jar;%APP_HOME%\lib\commons-lang3-3.7.jar;%APP_HOME%\lib\jersey-entity-filtering-2.26.jar;%APP_HOME%\lib\javax.ws.rs-api-2.1.jar;%APP_HOME%\lib\commons-io-2.7.jar;%APP_HOME%\lib\jaxb-api-2.3.0.jar;%APP_HOME%\lib\javax.activation-1.2.0.jar;%APP_HOME%\lib\lombok-1.16.20.jar;%APP_HOME%\lib\rdl-java-1.5.4.jar;%APP_HOME%\lib\jaxb-runtime-2.3.3.jar;%APP_HOME%\lib\jakarta.xml.bind-api-2.3.3.jar;%APP_HOME%\lib\javax.activation-api-1.2.0.jar;%APP_HOME%\lib\classmate-1.3.4.jar;%APP_HOME%\lib\mapstruct-1.2.0.Final.jar;%APP_HOME%\lib\commons-codec-1.11.jar;%APP_HOME%\lib\commons-collections-3.2.2.jar;%APP_HOME%\lib\netty-handler-proxy-4.1.24.Final.jar;%APP_HOME%\lib\netty-codec-http-4.1.24.Final.jar;%APP_HOME%\lib\netty-resolver-dns-4.1.24.Final.jar;%APP_HOME%\lib\netty-codec-dns-4.1.24.Final.jar;%APP_HOME%\lib\netty-codec-socks-4.1.24.Final.jar;%APP_HOME%\lib\netty-codec-4.1.24.Final.jar;%APP_HOME%\lib\netty-transport-4.1.24.Final.jar;%APP_HOME%\lib\proto-google-common-protos-1.12.0.jar;%APP_HOME%\lib\client-java-proto-9.0.2.jar;%APP_HOME%\lib\protobuf-java-3.17.1.jar;%APP_HOME%\lib\jcommander-1.78.jar;%APP_HOME%\lib\simpleclient_caffeine-0.5.0.jar;%APP_HOME%\lib\simpleclient_hotspot-0.8.1.jar;%APP_HOME%\lib\simpleclient_servlet-0.8.1.jar;%APP_HOME%\lib\simpleclient_httpserver-0.5.0.jar;%APP_HOME%\lib\simpleclient_common-0.8.1.jar;%APP_HOME%\lib\simpleclient-0.9.0.jar;%APP_HOME%\lib\micrometer-core-1.0.4.jar;%APP_HOME%\lib\HdrHistogram-2.1.10.jar;%APP_HOME%\lib\java-semver-0.9.0.jar;%APP_HOME%\lib\hppc-0.7.3.jar;%APP_HOME%\lib\commons-digester-1.8.1.jar;%APP_HOME%\lib\org.eclipse.persistence.jpa-2.7.5.jar;%APP_HOME%\lib\org.eclipse.persistence.core-2.7.5.jar;%APP_HOME%\lib\org.eclipse.persistence.asm-2.7.5.jar;%APP_HOME%\lib\org.eclipse.persistence.antlr-2.7.5.jar;%APP_HOME%\lib\org.eclipse.persistence.jpa.jpql-2.7.5.jar;%APP_HOME%\lib\netty-all-4.1.24.Final.jar;%APP_HOME%\lib\tomcat-embed-websocket-8.5.31.jar;%APP_HOME%\lib\tomcat-embed-core-8.5.31.jar;%APP_HOME%\lib\tomcat-embed-el-8.5.31.jar;%APP_HOME%\lib\ecj-3.12.3.jar;%APP_HOME%\lib\javax.inject-2.5.0-b42.jar;%APP_HOME%\lib\jackson-annotations-2.9.0.jar;%APP_HOME%\lib\jackson-dataformat-cbor-2.9.5.jar;%APP_HOME%\lib\jackson-core-2.9.5.jar;%APP_HOME%\lib\spring-jcl-5.0.6.RELEASE.jar;%APP_HOME%\lib\jboss-logging-3.3.2.Final.jar;%APP_HOME%\lib\spring-cloud-context-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-cloud-commons-2.0.2.RELEASE.jar;%APP_HOME%\lib\spring-security-rsa-1.0.7.RELEASE.jar;%APP_HOME%\lib\spring-cloud-netflix-ribbon-2.0.2.RELEASE.jar;%APP_HOME%\lib\rxjava-reactive-streams-1.2.1.jar;%APP_HOME%\lib\rxjava-1.2.0.jar;%APP_HOME%\lib\spring-cloud-netflix-archaius-2.0.2.RELEASE.jar;%APP_HOME%\lib\herddb-utils-0.24.0.jar;%APP_HOME%\lib\herddb-mock-0.24.0.jar;%APP_HOME%\lib\zookeeper-jute-3.6.2.jar;%APP_HOME%\lib\netty-buffer-4.1.24.Final.jar;%APP_HOME%\lib\netty-resolver-4.1.24.Final.jar;%APP_HOME%\lib\netty-common-4.1.24.Final.jar;%APP_HOME%\lib\bouncy-castle-bc-2.7.0-pkg.jar;%APP_HOME%\lib\sketches-core-0.8.3.jar;%APP_HOME%\lib\jcip-annotations-1.0.jar;%APP_HOME%\lib\mimepull-1.9.6.jar;%APP_HOME%\lib\bcpkix-jdk15on-1.68.jar;%APP_HOME%\lib\libpam4j-1.11.jar;%APP_HOME%\lib\jakarta.activation-api-1.2.2.jar;%APP_HOME%\lib\txw2-2.3.3.jar;%APP_HOME%\lib\istack-commons-runtime-3.0.11.jar;%APP_HOME%\lib\jakarta.activation-1.2.2.jar;%APP_HOME%\lib\websocket-servlet-9.4.10.v20180503.jar;%APP_HOME%\lib\websocket-api-9.4.10.v20180503.jar;%APP_HOME%\lib\javax.servlet-api-3.1.0.jar;%APP_HOME%\lib\caffeine-2.6.2.jar;%APP_HOME%\lib\aspectjrt-1.8.13.jar;%APP_HOME%\lib\aspectjweaver-1.8.13.jar;%APP_HOME%\lib\jetty-continuation-9.4.10.v20180503.jar;%APP_HOME%\lib\commons-compress-1.20.jar;%APP_HOME%\lib\netty-tcnative-classes-2.0.46.Final.jar;%APP_HOME%\lib\jakarta.persistence-2.2.3.jar;%APP_HOME%\lib\commons-lang-2.6.jar;%APP_HOME%\lib\audience-annotations-0.5.0.jar;%APP_HOME%\lib\rocksdbjni-6.16.4.jar;%APP_HOME%\lib\commons-cli-1.2.jar;%APP_HOME%\lib\commons-collections4-4.4.jar;%APP_HOME%\lib\bc-fips-1.0.2.jar;%APP_HOME%\lib\jna-4.5.1.jar;%APP_HOME%\lib\tomcat-annotations-api-8.5.31.jar;%APP_HOME%\lib\osgi-resource-locator-1.0.1.jar;%APP_HOME%\lib\aopalliance-repackaged-2.5.0-b42.jar;%APP_HOME%\lib\ognl-3.1.12.jar;%APP_HOME%\lib\javassist-3.22.0-CR2.jar;%APP_HOME%\lib\logging-interceptor-3.8.1.jar;%APP_HOME%\lib\okhttp-3.8.1.jar;%APP_HOME%\lib\nimbus-jose-jwt-9.10.jar;%APP_HOME%\lib\logback-core-1.2.3.jar;%APP_HOME%\lib\log4j-core-2.17.1.jar;%APP_HOME%\lib\log4j-api-2.17.1.jar;%APP_HOME%\lib\httpcore-4.4.9.jar;%APP_HOME%\lib\javax.inject-1.jar;%APP_HOME%\lib\spring-security-crypto-5.0.5.RELEASE.jar;%APP_HOME%\lib\LatencyUtils-2.0.3.jar;%APP_HOME%\lib\asm-5.0.4.jar;%APP_HOME%\lib\netty-reactive-streams-2.0.4.jar;%APP_HOME%\lib\reactive-streams-1.0.2.jar;%APP_HOME%\lib\annotations-2.0.0.jar;%APP_HOME%\lib\jersey-client-1.19.1.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\attoparser-2.0.4.RELEASE.jar;%APP_HOME%\lib\unbescape-1.1.5.RELEASE.jar;%APP_HOME%\lib\lz4-1.3.0.jar;%APP_HOME%\lib\apiguardian-api-1.1.0.jar;%APP_HOME%\lib\checker-qual-3.10.0.jar;%APP_HOME%\lib\error_prone_annotations-2.5.1.jar;%APP_HOME%\lib\kotlin-stdlib-jdk8-1.2.41.jar;%APP_HOME%\lib\janino-3.0.8.jar;%APP_HOME%\lib\commons-compiler-3.1.6.jar;%APP_HOME%\lib\bcprov-ext-jdk15on-1.66.jar;%APP_HOME%\lib\memory-0.8.3.jar;%APP_HOME%\lib\bcprov-jdk15on-1.68.jar;%APP_HOME%\lib\ion-java-1.0.2.jar;%APP_HOME%\lib\joda-time-2.9.9.jar;%APP_HOME%\lib\mockito-core-2.15.0.jar;%APP_HOME%\lib\byte-buddy-1.7.11.jar;%APP_HOME%\lib\javax.websocket-client-api-1.0.jar;%APP_HOME%\lib\opencensus-api-0.18.0.jar;%APP_HOME%\lib\grpc-context-1.18.0.jar;%APP_HOME%\lib\jctools-core-2.1.2.jar;%APP_HOME%\lib\okhttp-2.5.0.jar;%APP_HOME%\lib\okio-1.13.0.jar;%APP_HOME%\lib\jcip-annotations-1.0-1.jar;%APP_HOME%\lib\jersey-core-1.19.1.jar;%APP_HOME%\lib\kotlin-stdlib-jdk7-1.2.41.jar;%APP_HOME%\lib\kotlin-stdlib-1.2.41.jar;%APP_HOME%\lib\log4j-1.2.17.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\j2objc-annotations-1.3.jar;%APP_HOME%\lib\google-auth-library-credentials-0.9.0.jar;%APP_HOME%\lib\animal-sniffer-annotations-1.17.jar;%APP_HOME%\lib\checker-compat-qual-2.5.2.jar;%APP_HOME%\lib\protobuf-javanano-3.0.0-alpha-5.jar;%APP_HOME%\lib\freebuilder-1.14.9.jar;%APP_HOME%\lib\pulsar-client-messagecrypto-bc-2.7.0.jar;%APP_HOME%\lib\typetools-0.5.0.jar;%APP_HOME%\lib\json-20140107.jar;%APP_HOME%\lib\jsr311-api-1.1.1.jar;%APP_HOME%\lib\annotations-13.0.jar;%APP_HOME%\lib\junit-4.12.jar;%APP_HOME%\lib\builder-annotations-0.21.0.jar;%APP_HOME%\lib\joda-convert-2.2.1.jar;%APP_HOME%\lib\hamcrest-core-1.3.jar;%APP_HOME%\lib\byte-buddy-agent-1.7.11.jar;%APP_HOME%\lib\objenesis-2.6.jar;%APP_HOME%\lib\sundr-core-0.21.0.jar;%APP_HOME%\lib\sundr-codegen-0.21.0.jar;%APP_HOME%\lib\resourcecify-annotations-0.21.0.jar

@rem Execute pulsar-manager
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %PULSAR_MANAGER_OPTS%  -classpath "%CLASSPATH%" org.apache.pulsar.manager.PulsarManagerApplication %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable PULSAR_MANAGER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%PULSAR_MANAGER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
