// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/apache/pulsar-client-go@v0.3.0/pulsar/internal/pulsar_proto/PulsarApi.proto

package pulsar_proto

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type CompressionType int32

const (
	CompressionType_NONE   CompressionType = 0
	CompressionType_LZ4    CompressionType = 1
	CompressionType_ZLIB   CompressionType = 2
	CompressionType_ZSTD   CompressionType = 3
	CompressionType_SNAPPY CompressionType = 4
)

var CompressionType_name = map[int32]string{
	0: "NONE",
	1: "LZ4",
	2: "ZLIB",
	3: "ZSTD",
	4: "SNAPPY",
}

var CompressionType_value = map[string]int32{
	"NONE":   0,
	"LZ4":    1,
	"ZLIB":   2,
	"ZSTD":   3,
	"SNAPPY": 4,
}

func (x CompressionType) Enum() *CompressionType {
	p := new(CompressionType)
	*p = x
	return p
}

func (x CompressionType) String() string {
	return proto.EnumName(CompressionType_name, int32(x))
}

func (x *CompressionType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CompressionType_value, data, "CompressionType")
	if err != nil {
		return err
	}
	*x = CompressionType(value)
	return nil
}

func (CompressionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{0}
}

type ServerError int32

const (
	ServerError_UnknownError        ServerError = 0
	ServerError_MetadataError       ServerError = 1
	ServerError_PersistenceError    ServerError = 2
	ServerError_AuthenticationError ServerError = 3
	ServerError_AuthorizationError  ServerError = 4
	ServerError_ConsumerBusy        ServerError = 5
	// other consumers are connected
	ServerError_ServiceNotReady                       ServerError = 6
	ServerError_ProducerBlockedQuotaExceededError     ServerError = 7
	ServerError_ProducerBlockedQuotaExceededException ServerError = 8
	ServerError_ChecksumError                         ServerError = 9
	ServerError_UnsupportedVersionError               ServerError = 10
	ServerError_TopicNotFound                         ServerError = 11
	ServerError_SubscriptionNotFound                  ServerError = 12
	ServerError_ConsumerNotFound                      ServerError = 13
	ServerError_TooManyRequests                       ServerError = 14
	ServerError_TopicTerminatedError                  ServerError = 15
	ServerError_ProducerBusy                          ServerError = 16
	ServerError_InvalidTopicName                      ServerError = 17
	ServerError_IncompatibleSchema                    ServerError = 18
	ServerError_ConsumerAssignError                   ServerError = 19
	ServerError_TransactionCoordinatorNotFound        ServerError = 20
	ServerError_InvalidTxnStatus                      ServerError = 21
)

var ServerError_name = map[int32]string{
	0:  "UnknownError",
	1:  "MetadataError",
	2:  "PersistenceError",
	3:  "AuthenticationError",
	4:  "AuthorizationError",
	5:  "ConsumerBusy",
	6:  "ServiceNotReady",
	7:  "ProducerBlockedQuotaExceededError",
	8:  "ProducerBlockedQuotaExceededException",
	9:  "ChecksumError",
	10: "UnsupportedVersionError",
	11: "TopicNotFound",
	12: "SubscriptionNotFound",
	13: "ConsumerNotFound",
	14: "TooManyRequests",
	15: "TopicTerminatedError",
	16: "ProducerBusy",
	17: "InvalidTopicName",
	18: "IncompatibleSchema",
	19: "ConsumerAssignError",
	20: "TransactionCoordinatorNotFound",
	21: "InvalidTxnStatus",
}

var ServerError_value = map[string]int32{
	"UnknownError":                          0,
	"MetadataError":                         1,
	"PersistenceError":                      2,
	"AuthenticationError":                   3,
	"AuthorizationError":                    4,
	"ConsumerBusy":                          5,
	"ServiceNotReady":                       6,
	"ProducerBlockedQuotaExceededError":     7,
	"ProducerBlockedQuotaExceededException": 8,
	"ChecksumError":                         9,
	"UnsupportedVersionError":               10,
	"TopicNotFound":                         11,
	"SubscriptionNotFound":                  12,
	"ConsumerNotFound":                      13,
	"TooManyRequests":                       14,
	"TopicTerminatedError":                  15,
	"ProducerBusy":                          16,
	"InvalidTopicName":                      17,
	"IncompatibleSchema":                    18,
	"ConsumerAssignError":                   19,
	"TransactionCoordinatorNotFound":        20,
	"InvalidTxnStatus":                      21,
}

func (x ServerError) Enum() *ServerError {
	p := new(ServerError)
	*p = x
	return p
}

func (x ServerError) String() string {
	return proto.EnumName(ServerError_name, int32(x))
}

func (x *ServerError) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ServerError_value, data, "ServerError")
	if err != nil {
		return err
	}
	*x = ServerError(value)
	return nil
}

func (ServerError) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{1}
}

type AuthMethod int32

const (
	AuthMethod_AuthMethodNone   AuthMethod = 0
	AuthMethod_AuthMethodYcaV1  AuthMethod = 1
	AuthMethod_AuthMethodAthens AuthMethod = 2
)

var AuthMethod_name = map[int32]string{
	0: "AuthMethodNone",
	1: "AuthMethodYcaV1",
	2: "AuthMethodAthens",
}

var AuthMethod_value = map[string]int32{
	"AuthMethodNone":   0,
	"AuthMethodYcaV1":  1,
	"AuthMethodAthens": 2,
}

func (x AuthMethod) Enum() *AuthMethod {
	p := new(AuthMethod)
	*p = x
	return p
}

func (x AuthMethod) String() string {
	return proto.EnumName(AuthMethod_name, int32(x))
}

func (x *AuthMethod) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(AuthMethod_value, data, "AuthMethod")
	if err != nil {
		return err
	}
	*x = AuthMethod(value)
	return nil
}

func (AuthMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{2}
}

// Each protocol version identify new features that are
// incrementally added to the protocol
type ProtocolVersion int32

const (
	ProtocolVersion_v0  ProtocolVersion = 0
	ProtocolVersion_v1  ProtocolVersion = 1
	ProtocolVersion_v2  ProtocolVersion = 2
	ProtocolVersion_v3  ProtocolVersion = 3
	ProtocolVersion_v4  ProtocolVersion = 4
	ProtocolVersion_v5  ProtocolVersion = 5
	ProtocolVersion_v6  ProtocolVersion = 6
	ProtocolVersion_v7  ProtocolVersion = 7
	ProtocolVersion_v8  ProtocolVersion = 8
	ProtocolVersion_v9  ProtocolVersion = 9
	ProtocolVersion_v10 ProtocolVersion = 10
	ProtocolVersion_v11 ProtocolVersion = 11
	ProtocolVersion_v12 ProtocolVersion = 12
	// Added CommandActiveConsumerChange
	// Added CommandGetTopicsOfNamespace
	ProtocolVersion_v13 ProtocolVersion = 13
	ProtocolVersion_v14 ProtocolVersion = 14
	// Added Key_Shared subscription
	ProtocolVersion_v15 ProtocolVersion = 15
)

var ProtocolVersion_name = map[int32]string{
	0:  "v0",
	1:  "v1",
	2:  "v2",
	3:  "v3",
	4:  "v4",
	5:  "v5",
	6:  "v6",
	7:  "v7",
	8:  "v8",
	9:  "v9",
	10: "v10",
	11: "v11",
	12: "v12",
	13: "v13",
	14: "v14",
	15: "v15",
}

var ProtocolVersion_value = map[string]int32{
	"v0":  0,
	"v1":  1,
	"v2":  2,
	"v3":  3,
	"v4":  4,
	"v5":  5,
	"v6":  6,
	"v7":  7,
	"v8":  8,
	"v9":  9,
	"v10": 10,
	"v11": 11,
	"v12": 12,
	"v13": 13,
	"v14": 14,
	"v15": 15,
}

func (x ProtocolVersion) Enum() *ProtocolVersion {
	p := new(ProtocolVersion)
	*p = x
	return p
}

func (x ProtocolVersion) String() string {
	return proto.EnumName(ProtocolVersion_name, int32(x))
}

func (x *ProtocolVersion) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ProtocolVersion_value, data, "ProtocolVersion")
	if err != nil {
		return err
	}
	*x = ProtocolVersion(value)
	return nil
}

func (ProtocolVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{3}
}

type KeySharedMode int32

const (
	KeySharedMode_AUTO_SPLIT KeySharedMode = 0
	KeySharedMode_STICKY     KeySharedMode = 1
)

var KeySharedMode_name = map[int32]string{
	0: "AUTO_SPLIT",
	1: "STICKY",
}

var KeySharedMode_value = map[string]int32{
	"AUTO_SPLIT": 0,
	"STICKY":     1,
}

func (x KeySharedMode) Enum() *KeySharedMode {
	p := new(KeySharedMode)
	*p = x
	return p
}

func (x KeySharedMode) String() string {
	return proto.EnumName(KeySharedMode_name, int32(x))
}

func (x *KeySharedMode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(KeySharedMode_value, data, "KeySharedMode")
	if err != nil {
		return err
	}
	*x = KeySharedMode(value)
	return nil
}

func (KeySharedMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{4}
}

type TxnAction int32

const (
	TxnAction_COMMIT TxnAction = 0
	TxnAction_ABORT  TxnAction = 1
)

var TxnAction_name = map[int32]string{
	0: "COMMIT",
	1: "ABORT",
}

var TxnAction_value = map[string]int32{
	"COMMIT": 0,
	"ABORT":  1,
}

func (x TxnAction) Enum() *TxnAction {
	p := new(TxnAction)
	*p = x
	return p
}

func (x TxnAction) String() string {
	return proto.EnumName(TxnAction_name, int32(x))
}

func (x *TxnAction) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TxnAction_value, data, "TxnAction")
	if err != nil {
		return err
	}
	*x = TxnAction(value)
	return nil
}

func (TxnAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{5}
}

type Schema_Type int32

const (
	Schema_None      Schema_Type = 0
	Schema_String    Schema_Type = 1
	Schema_Json      Schema_Type = 2
	Schema_Protobuf  Schema_Type = 3
	Schema_Avro      Schema_Type = 4
	Schema_Bool      Schema_Type = 5
	Schema_Int8      Schema_Type = 6
	Schema_Int16     Schema_Type = 7
	Schema_Int32     Schema_Type = 8
	Schema_Int64     Schema_Type = 9
	Schema_Float     Schema_Type = 10
	Schema_Double    Schema_Type = 11
	Schema_Date      Schema_Type = 12
	Schema_Time      Schema_Type = 13
	Schema_Timestamp Schema_Type = 14
	Schema_KeyValue  Schema_Type = 15
)

var Schema_Type_name = map[int32]string{
	0:  "None",
	1:  "String",
	2:  "Json",
	3:  "Protobuf",
	4:  "Avro",
	5:  "Bool",
	6:  "Int8",
	7:  "Int16",
	8:  "Int32",
	9:  "Int64",
	10: "Float",
	11: "Double",
	12: "Date",
	13: "Time",
	14: "Timestamp",
	15: "KeyValue",
}

var Schema_Type_value = map[string]int32{
	"None":      0,
	"String":    1,
	"Json":      2,
	"Protobuf":  3,
	"Avro":      4,
	"Bool":      5,
	"Int8":      6,
	"Int16":     7,
	"Int32":     8,
	"Int64":     9,
	"Float":     10,
	"Double":    11,
	"Date":      12,
	"Time":      13,
	"Timestamp": 14,
	"KeyValue":  15,
}

func (x Schema_Type) Enum() *Schema_Type {
	p := new(Schema_Type)
	*p = x
	return p
}

func (x Schema_Type) String() string {
	return proto.EnumName(Schema_Type_name, int32(x))
}

func (x *Schema_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Schema_Type_value, data, "Schema_Type")
	if err != nil {
		return err
	}
	*x = Schema_Type(value)
	return nil
}

func (Schema_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{0, 0}
}

type CommandSubscribe_SubType int32

const (
	CommandSubscribe_Exclusive  CommandSubscribe_SubType = 0
	CommandSubscribe_Shared     CommandSubscribe_SubType = 1
	CommandSubscribe_Failover   CommandSubscribe_SubType = 2
	CommandSubscribe_Key_Shared CommandSubscribe_SubType = 3
)

var CommandSubscribe_SubType_name = map[int32]string{
	0: "Exclusive",
	1: "Shared",
	2: "Failover",
	3: "Key_Shared",
}

var CommandSubscribe_SubType_value = map[string]int32{
	"Exclusive":  0,
	"Shared":     1,
	"Failover":   2,
	"Key_Shared": 3,
}

func (x CommandSubscribe_SubType) Enum() *CommandSubscribe_SubType {
	p := new(CommandSubscribe_SubType)
	*p = x
	return p
}

func (x CommandSubscribe_SubType) String() string {
	return proto.EnumName(CommandSubscribe_SubType_name, int32(x))
}

func (x *CommandSubscribe_SubType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CommandSubscribe_SubType_value, data, "CommandSubscribe_SubType")
	if err != nil {
		return err
	}
	*x = CommandSubscribe_SubType(value)
	return nil
}

func (CommandSubscribe_SubType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{15, 0}
}

type CommandSubscribe_InitialPosition int32

const (
	CommandSubscribe_Latest   CommandSubscribe_InitialPosition = 0
	CommandSubscribe_Earliest CommandSubscribe_InitialPosition = 1
)

var CommandSubscribe_InitialPosition_name = map[int32]string{
	0: "Latest",
	1: "Earliest",
}

var CommandSubscribe_InitialPosition_value = map[string]int32{
	"Latest":   0,
	"Earliest": 1,
}

func (x CommandSubscribe_InitialPosition) Enum() *CommandSubscribe_InitialPosition {
	p := new(CommandSubscribe_InitialPosition)
	*p = x
	return p
}

func (x CommandSubscribe_InitialPosition) String() string {
	return proto.EnumName(CommandSubscribe_InitialPosition_name, int32(x))
}

func (x *CommandSubscribe_InitialPosition) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CommandSubscribe_InitialPosition_value, data, "CommandSubscribe_InitialPosition")
	if err != nil {
		return err
	}
	*x = CommandSubscribe_InitialPosition(value)
	return nil
}

func (CommandSubscribe_InitialPosition) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{15, 1}
}

type CommandPartitionedTopicMetadataResponse_LookupType int32

const (
	CommandPartitionedTopicMetadataResponse_Success CommandPartitionedTopicMetadataResponse_LookupType = 0
	CommandPartitionedTopicMetadataResponse_Failed  CommandPartitionedTopicMetadataResponse_LookupType = 1
)

var CommandPartitionedTopicMetadataResponse_LookupType_name = map[int32]string{
	0: "Success",
	1: "Failed",
}

var CommandPartitionedTopicMetadataResponse_LookupType_value = map[string]int32{
	"Success": 0,
	"Failed":  1,
}

func (x CommandPartitionedTopicMetadataResponse_LookupType) Enum() *CommandPartitionedTopicMetadataResponse_LookupType {
	p := new(CommandPartitionedTopicMetadataResponse_LookupType)
	*p = x
	return p
}

func (x CommandPartitionedTopicMetadataResponse_LookupType) String() string {
	return proto.EnumName(CommandPartitionedTopicMetadataResponse_LookupType_name, int32(x))
}

func (x *CommandPartitionedTopicMetadataResponse_LookupType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CommandPartitionedTopicMetadataResponse_LookupType_value, data, "CommandPartitionedTopicMetadataResponse_LookupType")
	if err != nil {
		return err
	}
	*x = CommandPartitionedTopicMetadataResponse_LookupType(value)
	return nil
}

func (CommandPartitionedTopicMetadataResponse_LookupType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{17, 0}
}

type CommandLookupTopicResponse_LookupType int32

const (
	CommandLookupTopicResponse_Redirect CommandLookupTopicResponse_LookupType = 0
	CommandLookupTopicResponse_Connect  CommandLookupTopicResponse_LookupType = 1
	CommandLookupTopicResponse_Failed   CommandLookupTopicResponse_LookupType = 2
)

var CommandLookupTopicResponse_LookupType_name = map[int32]string{
	0: "Redirect",
	1: "Connect",
	2: "Failed",
}

var CommandLookupTopicResponse_LookupType_value = map[string]int32{
	"Redirect": 0,
	"Connect":  1,
	"Failed":   2,
}

func (x CommandLookupTopicResponse_LookupType) Enum() *CommandLookupTopicResponse_LookupType {
	p := new(CommandLookupTopicResponse_LookupType)
	*p = x
	return p
}

func (x CommandLookupTopicResponse_LookupType) String() string {
	return proto.EnumName(CommandLookupTopicResponse_LookupType_name, int32(x))
}

func (x *CommandLookupTopicResponse_LookupType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CommandLookupTopicResponse_LookupType_value, data, "CommandLookupTopicResponse_LookupType")
	if err != nil {
		return err
	}
	*x = CommandLookupTopicResponse_LookupType(value)
	return nil
}

func (CommandLookupTopicResponse_LookupType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{19, 0}
}

type CommandAck_AckType int32

const (
	CommandAck_Individual CommandAck_AckType = 0
	CommandAck_Cumulative CommandAck_AckType = 1
)

var CommandAck_AckType_name = map[int32]string{
	0: "Individual",
	1: "Cumulative",
}

var CommandAck_AckType_value = map[string]int32{
	"Individual": 0,
	"Cumulative": 1,
}

func (x CommandAck_AckType) Enum() *CommandAck_AckType {
	p := new(CommandAck_AckType)
	*p = x
	return p
}

func (x CommandAck_AckType) String() string {
	return proto.EnumName(CommandAck_AckType_name, int32(x))
}

func (x *CommandAck_AckType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CommandAck_AckType_value, data, "CommandAck_AckType")
	if err != nil {
		return err
	}
	*x = CommandAck_AckType(value)
	return nil
}

func (CommandAck_AckType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{25, 0}
}

// Acks can contain a flag to indicate the consumer
// received an invalid message that got discarded
// before being passed on to the application.
type CommandAck_ValidationError int32

const (
	CommandAck_UncompressedSizeCorruption CommandAck_ValidationError = 0
	CommandAck_DecompressionError         CommandAck_ValidationError = 1
	CommandAck_ChecksumMismatch           CommandAck_ValidationError = 2
	CommandAck_BatchDeSerializeError      CommandAck_ValidationError = 3
	CommandAck_DecryptionError            CommandAck_ValidationError = 4
)

var CommandAck_ValidationError_name = map[int32]string{
	0: "UncompressedSizeCorruption",
	1: "DecompressionError",
	2: "ChecksumMismatch",
	3: "BatchDeSerializeError",
	4: "DecryptionError",
}

var CommandAck_ValidationError_value = map[string]int32{
	"UncompressedSizeCorruption": 0,
	"DecompressionError":         1,
	"ChecksumMismatch":           2,
	"BatchDeSerializeError":      3,
	"DecryptionError":            4,
}

func (x CommandAck_ValidationError) Enum() *CommandAck_ValidationError {
	p := new(CommandAck_ValidationError)
	*p = x
	return p
}

func (x CommandAck_ValidationError) String() string {
	return proto.EnumName(CommandAck_ValidationError_name, int32(x))
}

func (x *CommandAck_ValidationError) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CommandAck_ValidationError_value, data, "CommandAck_ValidationError")
	if err != nil {
		return err
	}
	*x = CommandAck_ValidationError(value)
	return nil
}

func (CommandAck_ValidationError) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{25, 1}
}

type CommandGetTopicsOfNamespace_Mode int32

const (
	CommandGetTopicsOfNamespace_PERSISTENT     CommandGetTopicsOfNamespace_Mode = 0
	CommandGetTopicsOfNamespace_NON_PERSISTENT CommandGetTopicsOfNamespace_Mode = 1
	CommandGetTopicsOfNamespace_ALL            CommandGetTopicsOfNamespace_Mode = 2
)

var CommandGetTopicsOfNamespace_Mode_name = map[int32]string{
	0: "PERSISTENT",
	1: "NON_PERSISTENT",
	2: "ALL",
}

var CommandGetTopicsOfNamespace_Mode_value = map[string]int32{
	"PERSISTENT":     0,
	"NON_PERSISTENT": 1,
	"ALL":            2,
}

func (x CommandGetTopicsOfNamespace_Mode) Enum() *CommandGetTopicsOfNamespace_Mode {
	p := new(CommandGetTopicsOfNamespace_Mode)
	*p = x
	return p
}

func (x CommandGetTopicsOfNamespace_Mode) String() string {
	return proto.EnumName(CommandGetTopicsOfNamespace_Mode_name, int32(x))
}

func (x *CommandGetTopicsOfNamespace_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CommandGetTopicsOfNamespace_Mode_value, data, "CommandGetTopicsOfNamespace_Mode")
	if err != nil {
		return err
	}
	*x = CommandGetTopicsOfNamespace_Mode(value)
	return nil
}

func (CommandGetTopicsOfNamespace_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{44, 0}
}

type BaseCommand_Type int32

const (
	BaseCommand_CONNECT                           BaseCommand_Type = 2
	BaseCommand_CONNECTED                         BaseCommand_Type = 3
	BaseCommand_SUBSCRIBE                         BaseCommand_Type = 4
	BaseCommand_PRODUCER                          BaseCommand_Type = 5
	BaseCommand_SEND                              BaseCommand_Type = 6
	BaseCommand_SEND_RECEIPT                      BaseCommand_Type = 7
	BaseCommand_SEND_ERROR                        BaseCommand_Type = 8
	BaseCommand_MESSAGE                           BaseCommand_Type = 9
	BaseCommand_ACK                               BaseCommand_Type = 10
	BaseCommand_FLOW                              BaseCommand_Type = 11
	BaseCommand_UNSUBSCRIBE                       BaseCommand_Type = 12
	BaseCommand_SUCCESS                           BaseCommand_Type = 13
	BaseCommand_ERROR                             BaseCommand_Type = 14
	BaseCommand_CLOSE_PRODUCER                    BaseCommand_Type = 15
	BaseCommand_CLOSE_CONSUMER                    BaseCommand_Type = 16
	BaseCommand_PRODUCER_SUCCESS                  BaseCommand_Type = 17
	BaseCommand_PING                              BaseCommand_Type = 18
	BaseCommand_PONG                              BaseCommand_Type = 19
	BaseCommand_REDELIVER_UNACKNOWLEDGED_MESSAGES BaseCommand_Type = 20
	BaseCommand_PARTITIONED_METADATA              BaseCommand_Type = 21
	BaseCommand_PARTITIONED_METADATA_RESPONSE     BaseCommand_Type = 22
	BaseCommand_LOOKUP                            BaseCommand_Type = 23
	BaseCommand_LOOKUP_RESPONSE                   BaseCommand_Type = 24
	BaseCommand_CONSUMER_STATS                    BaseCommand_Type = 25
	BaseCommand_CONSUMER_STATS_RESPONSE           BaseCommand_Type = 26
	BaseCommand_REACHED_END_OF_TOPIC              BaseCommand_Type = 27
	BaseCommand_SEEK                              BaseCommand_Type = 28
	BaseCommand_GET_LAST_MESSAGE_ID               BaseCommand_Type = 29
	BaseCommand_GET_LAST_MESSAGE_ID_RESPONSE      BaseCommand_Type = 30
	BaseCommand_ACTIVE_CONSUMER_CHANGE            BaseCommand_Type = 31
	BaseCommand_GET_TOPICS_OF_NAMESPACE           BaseCommand_Type = 32
	BaseCommand_GET_TOPICS_OF_NAMESPACE_RESPONSE  BaseCommand_Type = 33
	BaseCommand_GET_SCHEMA                        BaseCommand_Type = 34
	BaseCommand_GET_SCHEMA_RESPONSE               BaseCommand_Type = 35
	BaseCommand_AUTH_CHALLENGE                    BaseCommand_Type = 36
	BaseCommand_AUTH_RESPONSE                     BaseCommand_Type = 37
	BaseCommand_ACK_RESPONSE                      BaseCommand_Type = 38
	BaseCommand_GET_OR_CREATE_SCHEMA              BaseCommand_Type = 39
	BaseCommand_GET_OR_CREATE_SCHEMA_RESPONSE     BaseCommand_Type = 40
	// transaction related
	BaseCommand_NEW_TXN                          BaseCommand_Type = 50
	BaseCommand_NEW_TXN_RESPONSE                 BaseCommand_Type = 51
	BaseCommand_ADD_PARTITION_TO_TXN             BaseCommand_Type = 52
	BaseCommand_ADD_PARTITION_TO_TXN_RESPONSE    BaseCommand_Type = 53
	BaseCommand_ADD_SUBSCRIPTION_TO_TXN          BaseCommand_Type = 54
	BaseCommand_ADD_SUBSCRIPTION_TO_TXN_RESPONSE BaseCommand_Type = 55
	BaseCommand_END_TXN                          BaseCommand_Type = 56
	BaseCommand_END_TXN_RESPONSE                 BaseCommand_Type = 57
	BaseCommand_END_TXN_ON_PARTITION             BaseCommand_Type = 58
	BaseCommand_END_TXN_ON_PARTITION_RESPONSE    BaseCommand_Type = 59
	BaseCommand_END_TXN_ON_SUBSCRIPTION          BaseCommand_Type = 60
	BaseCommand_END_TXN_ON_SUBSCRIPTION_RESPONSE BaseCommand_Type = 61
)

var BaseCommand_Type_name = map[int32]string{
	2:  "CONNECT",
	3:  "CONNECTED",
	4:  "SUBSCRIBE",
	5:  "PRODUCER",
	6:  "SEND",
	7:  "SEND_RECEIPT",
	8:  "SEND_ERROR",
	9:  "MESSAGE",
	10: "ACK",
	11: "FLOW",
	12: "UNSUBSCRIBE",
	13: "SUCCESS",
	14: "ERROR",
	15: "CLOSE_PRODUCER",
	16: "CLOSE_CONSUMER",
	17: "PRODUCER_SUCCESS",
	18: "PING",
	19: "PONG",
	20: "REDELIVER_UNACKNOWLEDGED_MESSAGES",
	21: "PARTITIONED_METADATA",
	22: "PARTITIONED_METADATA_RESPONSE",
	23: "LOOKUP",
	24: "LOOKUP_RESPONSE",
	25: "CONSUMER_STATS",
	26: "CONSUMER_STATS_RESPONSE",
	27: "REACHED_END_OF_TOPIC",
	28: "SEEK",
	29: "GET_LAST_MESSAGE_ID",
	30: "GET_LAST_MESSAGE_ID_RESPONSE",
	31: "ACTIVE_CONSUMER_CHANGE",
	32: "GET_TOPICS_OF_NAMESPACE",
	33: "GET_TOPICS_OF_NAMESPACE_RESPONSE",
	34: "GET_SCHEMA",
	35: "GET_SCHEMA_RESPONSE",
	36: "AUTH_CHALLENGE",
	37: "AUTH_RESPONSE",
	38: "ACK_RESPONSE",
	39: "GET_OR_CREATE_SCHEMA",
	40: "GET_OR_CREATE_SCHEMA_RESPONSE",
	50: "NEW_TXN",
	51: "NEW_TXN_RESPONSE",
	52: "ADD_PARTITION_TO_TXN",
	53: "ADD_PARTITION_TO_TXN_RESPONSE",
	54: "ADD_SUBSCRIPTION_TO_TXN",
	55: "ADD_SUBSCRIPTION_TO_TXN_RESPONSE",
	56: "END_TXN",
	57: "END_TXN_RESPONSE",
	58: "END_TXN_ON_PARTITION",
	59: "END_TXN_ON_PARTITION_RESPONSE",
	60: "END_TXN_ON_SUBSCRIPTION",
	61: "END_TXN_ON_SUBSCRIPTION_RESPONSE",
}

var BaseCommand_Type_value = map[string]int32{
	"CONNECT":                           2,
	"CONNECTED":                         3,
	"SUBSCRIBE":                         4,
	"PRODUCER":                          5,
	"SEND":                              6,
	"SEND_RECEIPT":                      7,
	"SEND_ERROR":                        8,
	"MESSAGE":                           9,
	"ACK":                               10,
	"FLOW":                              11,
	"UNSUBSCRIBE":                       12,
	"SUCCESS":                           13,
	"ERROR":                             14,
	"CLOSE_PRODUCER":                    15,
	"CLOSE_CONSUMER":                    16,
	"PRODUCER_SUCCESS":                  17,
	"PING":                              18,
	"PONG":                              19,
	"REDELIVER_UNACKNOWLEDGED_MESSAGES": 20,
	"PARTITIONED_METADATA":              21,
	"PARTITIONED_METADATA_RESPONSE":     22,
	"LOOKUP":                            23,
	"LOOKUP_RESPONSE":                   24,
	"CONSUMER_STATS":                    25,
	"CONSUMER_STATS_RESPONSE":           26,
	"REACHED_END_OF_TOPIC":              27,
	"SEEK":                              28,
	"GET_LAST_MESSAGE_ID":               29,
	"GET_LAST_MESSAGE_ID_RESPONSE":      30,
	"ACTIVE_CONSUMER_CHANGE":            31,
	"GET_TOPICS_OF_NAMESPACE":           32,
	"GET_TOPICS_OF_NAMESPACE_RESPONSE":  33,
	"GET_SCHEMA":                        34,
	"GET_SCHEMA_RESPONSE":               35,
	"AUTH_CHALLENGE":                    36,
	"AUTH_RESPONSE":                     37,
	"ACK_RESPONSE":                      38,
	"GET_OR_CREATE_SCHEMA":              39,
	"GET_OR_CREATE_SCHEMA_RESPONSE":     40,
	"NEW_TXN":                           50,
	"NEW_TXN_RESPONSE":                  51,
	"ADD_PARTITION_TO_TXN":              52,
	"ADD_PARTITION_TO_TXN_RESPONSE":     53,
	"ADD_SUBSCRIPTION_TO_TXN":           54,
	"ADD_SUBSCRIPTION_TO_TXN_RESPONSE":  55,
	"END_TXN":                           56,
	"END_TXN_RESPONSE":                  57,
	"END_TXN_ON_PARTITION":              58,
	"END_TXN_ON_PARTITION_RESPONSE":     59,
	"END_TXN_ON_SUBSCRIPTION":           60,
	"END_TXN_ON_SUBSCRIPTION_RESPONSE":  61,
}

func (x BaseCommand_Type) Enum() *BaseCommand_Type {
	p := new(BaseCommand_Type)
	*p = x
	return p
}

func (x BaseCommand_Type) String() string {
	return proto.EnumName(BaseCommand_Type_name, int32(x))
}

func (x *BaseCommand_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(BaseCommand_Type_value, data, "BaseCommand_Type")
	if err != nil {
		return err
	}
	*x = BaseCommand_Type(value)
	return nil
}

func (BaseCommand_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{63, 0}
}

type Schema struct {
	Name                 *string      `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	SchemaData           []byte       `protobuf:"bytes,3,req,name=schema_data" json:"schema_data,omitempty"`
	Type                 *Schema_Type `protobuf:"varint,4,req,name=type,enum=pulsar.proto.Schema_Type" json:"type,omitempty"`
	Properties           []*KeyValue  `protobuf:"bytes,5,rep,name=properties" json:"properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Schema) Reset()         { *m = Schema{} }
func (m *Schema) String() string { return proto.CompactTextString(m) }
func (*Schema) ProtoMessage()    {}
func (*Schema) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{0}
}
func (m *Schema) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Schema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Schema.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Schema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Schema.Merge(m, src)
}
func (m *Schema) XXX_Size() int {
	return m.Size()
}
func (m *Schema) XXX_DiscardUnknown() {
	xxx_messageInfo_Schema.DiscardUnknown(m)
}

var xxx_messageInfo_Schema proto.InternalMessageInfo

func (m *Schema) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Schema) GetSchemaData() []byte {
	if m != nil {
		return m.SchemaData
	}
	return nil
}

func (m *Schema) GetType() Schema_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Schema_None
}

func (m *Schema) GetProperties() []*KeyValue {
	if m != nil {
		return m.Properties
	}
	return nil
}

type MessageIdData struct {
	LedgerId             *uint64  `protobuf:"varint,1,req,name=ledgerId" json:"ledgerId,omitempty"`
	EntryId              *uint64  `protobuf:"varint,2,req,name=entryId" json:"entryId,omitempty"`
	Partition            *int32   `protobuf:"varint,3,opt,name=partition,def=-1" json:"partition,omitempty"`
	BatchIndex           *int32   `protobuf:"varint,4,opt,name=batch_index,def=-1" json:"batch_index,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MessageIdData) Reset()         { *m = MessageIdData{} }
func (m *MessageIdData) String() string { return proto.CompactTextString(m) }
func (*MessageIdData) ProtoMessage()    {}
func (*MessageIdData) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{1}
}
func (m *MessageIdData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MessageIdData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MessageIdData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MessageIdData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageIdData.Merge(m, src)
}
func (m *MessageIdData) XXX_Size() int {
	return m.Size()
}
func (m *MessageIdData) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageIdData.DiscardUnknown(m)
}

var xxx_messageInfo_MessageIdData proto.InternalMessageInfo

const Default_MessageIdData_Partition int32 = -1
const Default_MessageIdData_BatchIndex int32 = -1

func (m *MessageIdData) GetLedgerId() uint64 {
	if m != nil && m.LedgerId != nil {
		return *m.LedgerId
	}
	return 0
}

func (m *MessageIdData) GetEntryId() uint64 {
	if m != nil && m.EntryId != nil {
		return *m.EntryId
	}
	return 0
}

func (m *MessageIdData) GetPartition() int32 {
	if m != nil && m.Partition != nil {
		return *m.Partition
	}
	return Default_MessageIdData_Partition
}

func (m *MessageIdData) GetBatchIndex() int32 {
	if m != nil && m.BatchIndex != nil {
		return *m.BatchIndex
	}
	return Default_MessageIdData_BatchIndex
}

type KeyValue struct {
	Key                  *string  `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value                *string  `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyValue) Reset()         { *m = KeyValue{} }
func (m *KeyValue) String() string { return proto.CompactTextString(m) }
func (*KeyValue) ProtoMessage()    {}
func (*KeyValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{2}
}
func (m *KeyValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KeyValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyValue.Merge(m, src)
}
func (m *KeyValue) XXX_Size() int {
	return m.Size()
}
func (m *KeyValue) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyValue.DiscardUnknown(m)
}

var xxx_messageInfo_KeyValue proto.InternalMessageInfo

func (m *KeyValue) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *KeyValue) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type KeyLongValue struct {
	Key                  *string  `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value                *uint64  `protobuf:"varint,2,req,name=value" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyLongValue) Reset()         { *m = KeyLongValue{} }
func (m *KeyLongValue) String() string { return proto.CompactTextString(m) }
func (*KeyLongValue) ProtoMessage()    {}
func (*KeyLongValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{3}
}
func (m *KeyLongValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyLongValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyLongValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KeyLongValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyLongValue.Merge(m, src)
}
func (m *KeyLongValue) XXX_Size() int {
	return m.Size()
}
func (m *KeyLongValue) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyLongValue.DiscardUnknown(m)
}

var xxx_messageInfo_KeyLongValue proto.InternalMessageInfo

func (m *KeyLongValue) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *KeyLongValue) GetValue() uint64 {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return 0
}

type IntRange struct {
	Start                *int32   `protobuf:"varint,1,req,name=start" json:"start,omitempty"`
	End                  *int32   `protobuf:"varint,2,req,name=end" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IntRange) Reset()         { *m = IntRange{} }
func (m *IntRange) String() string { return proto.CompactTextString(m) }
func (*IntRange) ProtoMessage()    {}
func (*IntRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{4}
}
func (m *IntRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IntRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IntRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IntRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntRange.Merge(m, src)
}
func (m *IntRange) XXX_Size() int {
	return m.Size()
}
func (m *IntRange) XXX_DiscardUnknown() {
	xxx_messageInfo_IntRange.DiscardUnknown(m)
}

var xxx_messageInfo_IntRange proto.InternalMessageInfo

func (m *IntRange) GetStart() int32 {
	if m != nil && m.Start != nil {
		return *m.Start
	}
	return 0
}

func (m *IntRange) GetEnd() int32 {
	if m != nil && m.End != nil {
		return *m.End
	}
	return 0
}

type EncryptionKeys struct {
	Key                  *string     `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value                []byte      `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	Metadata             []*KeyValue `protobuf:"bytes,3,rep,name=metadata" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *EncryptionKeys) Reset()         { *m = EncryptionKeys{} }
func (m *EncryptionKeys) String() string { return proto.CompactTextString(m) }
func (*EncryptionKeys) ProtoMessage()    {}
func (*EncryptionKeys) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{5}
}
func (m *EncryptionKeys) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EncryptionKeys) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EncryptionKeys.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EncryptionKeys) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptionKeys.Merge(m, src)
}
func (m *EncryptionKeys) XXX_Size() int {
	return m.Size()
}
func (m *EncryptionKeys) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptionKeys.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptionKeys proto.InternalMessageInfo

func (m *EncryptionKeys) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *EncryptionKeys) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *EncryptionKeys) GetMetadata() []*KeyValue {
	if m != nil {
		return m.Metadata
	}
	return nil
}

type MessageMetadata struct {
	ProducerName *string     `protobuf:"bytes,1,req,name=producer_name" json:"producer_name,omitempty"`
	SequenceId   *uint64     `protobuf:"varint,2,req,name=sequence_id" json:"sequence_id,omitempty"`
	PublishTime  *uint64     `protobuf:"varint,3,req,name=publish_time" json:"publish_time,omitempty"`
	Properties   []*KeyValue `protobuf:"bytes,4,rep,name=properties" json:"properties,omitempty"`
	// Property set on replicated message,
	// includes the source cluster name
	ReplicatedFrom *string `protobuf:"bytes,5,opt,name=replicated_from" json:"replicated_from,omitempty"`
	//key to decide partition for the msg
	PartitionKey *string `protobuf:"bytes,6,opt,name=partition_key" json:"partition_key,omitempty"`
	// Override namespace's replication
	ReplicateTo      []string         `protobuf:"bytes,7,rep,name=replicate_to" json:"replicate_to,omitempty"`
	Compression      *CompressionType `protobuf:"varint,8,opt,name=compression,enum=pulsar.proto.CompressionType,def=0" json:"compression,omitempty"`
	UncompressedSize *uint32          `protobuf:"varint,9,opt,name=uncompressed_size,def=0" json:"uncompressed_size,omitempty"`
	// Removed below checksum field from Metadata as
	// it should be part of send-command which keeps checksum of header + payload
	//optional sfixed64 checksum = 10;
	// differentiate single and batch message metadata
	NumMessagesInBatch *int32 `protobuf:"varint,11,opt,name=num_messages_in_batch,def=1" json:"num_messages_in_batch,omitempty"`
	// the timestamp that this event occurs. it is typically set by applications.
	// if this field is omitted, `publish_time` can be used for the purpose of `event_time`.
	EventTime *uint64 `protobuf:"varint,12,opt,name=event_time,def=0" json:"event_time,omitempty"`
	// Contains encryption key name, encrypted key and metadata to describe the key
	EncryptionKeys []*EncryptionKeys `protobuf:"bytes,13,rep,name=encryption_keys" json:"encryption_keys,omitempty"`
	// Algorithm used to encrypt data key
	EncryptionAlgo *string `protobuf:"bytes,14,opt,name=encryption_algo" json:"encryption_algo,omitempty"`
	// Additional parameters required by encryption
	EncryptionParam        []byte `protobuf:"bytes,15,opt,name=encryption_param" json:"encryption_param,omitempty"`
	SchemaVersion          []byte `protobuf:"bytes,16,opt,name=schema_version" json:"schema_version,omitempty"`
	PartitionKeyB64Encoded *bool  `protobuf:"varint,17,opt,name=partition_key_b64_encoded,def=0" json:"partition_key_b64_encoded,omitempty"`
	// Specific a key to overwrite the message key which used for ordering dispatch in Key_Shared mode.
	OrderingKey []byte `protobuf:"bytes,18,opt,name=ordering_key" json:"ordering_key,omitempty"`
	// Mark the message to be delivered at or after the specified timestamp
	DeliverAtTime *int64 `protobuf:"varint,19,opt,name=deliver_at_time" json:"deliver_at_time,omitempty"`
	// Identify whether a message is a "marker" message used for
	// internal metadata instead of application published data.
	// Markers will generally not be propagated back to clients
	MarkerType *int32 `protobuf:"varint,20,opt,name=marker_type" json:"marker_type,omitempty"`
	// transaction related message info
	TxnidLeastBits *uint64 `protobuf:"varint,22,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64 `protobuf:"varint,23,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	/// Add highest sequence id to support batch message with external sequence id
	HighestSequenceId    *uint64  `protobuf:"varint,24,opt,name=highest_sequence_id,def=0" json:"highest_sequence_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MessageMetadata) Reset()         { *m = MessageMetadata{} }
func (m *MessageMetadata) String() string { return proto.CompactTextString(m) }
func (*MessageMetadata) ProtoMessage()    {}
func (*MessageMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{6}
}
func (m *MessageMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MessageMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MessageMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MessageMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageMetadata.Merge(m, src)
}
func (m *MessageMetadata) XXX_Size() int {
	return m.Size()
}
func (m *MessageMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_MessageMetadata proto.InternalMessageInfo

const Default_MessageMetadata_Compression CompressionType = CompressionType_NONE
const Default_MessageMetadata_UncompressedSize uint32 = 0
const Default_MessageMetadata_NumMessagesInBatch int32 = 1
const Default_MessageMetadata_EventTime uint64 = 0
const Default_MessageMetadata_PartitionKeyB64Encoded bool = false
const Default_MessageMetadata_TxnidLeastBits uint64 = 0
const Default_MessageMetadata_TxnidMostBits uint64 = 0
const Default_MessageMetadata_HighestSequenceId uint64 = 0

func (m *MessageMetadata) GetProducerName() string {
	if m != nil && m.ProducerName != nil {
		return *m.ProducerName
	}
	return ""
}

func (m *MessageMetadata) GetSequenceId() uint64 {
	if m != nil && m.SequenceId != nil {
		return *m.SequenceId
	}
	return 0
}

func (m *MessageMetadata) GetPublishTime() uint64 {
	if m != nil && m.PublishTime != nil {
		return *m.PublishTime
	}
	return 0
}

func (m *MessageMetadata) GetProperties() []*KeyValue {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *MessageMetadata) GetReplicatedFrom() string {
	if m != nil && m.ReplicatedFrom != nil {
		return *m.ReplicatedFrom
	}
	return ""
}

func (m *MessageMetadata) GetPartitionKey() string {
	if m != nil && m.PartitionKey != nil {
		return *m.PartitionKey
	}
	return ""
}

func (m *MessageMetadata) GetReplicateTo() []string {
	if m != nil {
		return m.ReplicateTo
	}
	return nil
}

func (m *MessageMetadata) GetCompression() CompressionType {
	if m != nil && m.Compression != nil {
		return *m.Compression
	}
	return Default_MessageMetadata_Compression
}

func (m *MessageMetadata) GetUncompressedSize() uint32 {
	if m != nil && m.UncompressedSize != nil {
		return *m.UncompressedSize
	}
	return Default_MessageMetadata_UncompressedSize
}

func (m *MessageMetadata) GetNumMessagesInBatch() int32 {
	if m != nil && m.NumMessagesInBatch != nil {
		return *m.NumMessagesInBatch
	}
	return Default_MessageMetadata_NumMessagesInBatch
}

func (m *MessageMetadata) GetEventTime() uint64 {
	if m != nil && m.EventTime != nil {
		return *m.EventTime
	}
	return Default_MessageMetadata_EventTime
}

func (m *MessageMetadata) GetEncryptionKeys() []*EncryptionKeys {
	if m != nil {
		return m.EncryptionKeys
	}
	return nil
}

func (m *MessageMetadata) GetEncryptionAlgo() string {
	if m != nil && m.EncryptionAlgo != nil {
		return *m.EncryptionAlgo
	}
	return ""
}

func (m *MessageMetadata) GetEncryptionParam() []byte {
	if m != nil {
		return m.EncryptionParam
	}
	return nil
}

func (m *MessageMetadata) GetSchemaVersion() []byte {
	if m != nil {
		return m.SchemaVersion
	}
	return nil
}

func (m *MessageMetadata) GetPartitionKeyB64Encoded() bool {
	if m != nil && m.PartitionKeyB64Encoded != nil {
		return *m.PartitionKeyB64Encoded
	}
	return Default_MessageMetadata_PartitionKeyB64Encoded
}

func (m *MessageMetadata) GetOrderingKey() []byte {
	if m != nil {
		return m.OrderingKey
	}
	return nil
}

func (m *MessageMetadata) GetDeliverAtTime() int64 {
	if m != nil && m.DeliverAtTime != nil {
		return *m.DeliverAtTime
	}
	return 0
}

func (m *MessageMetadata) GetMarkerType() int32 {
	if m != nil && m.MarkerType != nil {
		return *m.MarkerType
	}
	return 0
}

func (m *MessageMetadata) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_MessageMetadata_TxnidLeastBits
}

func (m *MessageMetadata) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_MessageMetadata_TxnidMostBits
}

func (m *MessageMetadata) GetHighestSequenceId() uint64 {
	if m != nil && m.HighestSequenceId != nil {
		return *m.HighestSequenceId
	}
	return Default_MessageMetadata_HighestSequenceId
}

type SingleMessageMetadata struct {
	Properties   []*KeyValue `protobuf:"bytes,1,rep,name=properties" json:"properties,omitempty"`
	PartitionKey *string     `protobuf:"bytes,2,opt,name=partition_key" json:"partition_key,omitempty"`
	PayloadSize  *int32      `protobuf:"varint,3,req,name=payload_size" json:"payload_size,omitempty"`
	CompactedOut *bool       `protobuf:"varint,4,opt,name=compacted_out,def=0" json:"compacted_out,omitempty"`
	// the timestamp that this event occurs. it is typically set by applications.
	// if this field is omitted, `publish_time` can be used for the purpose of `event_time`.
	EventTime              *uint64 `protobuf:"varint,5,opt,name=event_time,def=0" json:"event_time,omitempty"`
	PartitionKeyB64Encoded *bool   `protobuf:"varint,6,opt,name=partition_key_b64_encoded,def=0" json:"partition_key_b64_encoded,omitempty"`
	// Specific a key to overwrite the message key which used for ordering dispatch in Key_Shared mode.
	OrderingKey []byte `protobuf:"bytes,7,opt,name=ordering_key" json:"ordering_key,omitempty"`
	// Allows consumer retrieve the sequence id that the producer set.
	SequenceId           *uint64  `protobuf:"varint,8,opt,name=sequence_id" json:"sequence_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SingleMessageMetadata) Reset()         { *m = SingleMessageMetadata{} }
func (m *SingleMessageMetadata) String() string { return proto.CompactTextString(m) }
func (*SingleMessageMetadata) ProtoMessage()    {}
func (*SingleMessageMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{7}
}
func (m *SingleMessageMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SingleMessageMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SingleMessageMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SingleMessageMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SingleMessageMetadata.Merge(m, src)
}
func (m *SingleMessageMetadata) XXX_Size() int {
	return m.Size()
}
func (m *SingleMessageMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_SingleMessageMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_SingleMessageMetadata proto.InternalMessageInfo

const Default_SingleMessageMetadata_CompactedOut bool = false
const Default_SingleMessageMetadata_EventTime uint64 = 0
const Default_SingleMessageMetadata_PartitionKeyB64Encoded bool = false

func (m *SingleMessageMetadata) GetProperties() []*KeyValue {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *SingleMessageMetadata) GetPartitionKey() string {
	if m != nil && m.PartitionKey != nil {
		return *m.PartitionKey
	}
	return ""
}

func (m *SingleMessageMetadata) GetPayloadSize() int32 {
	if m != nil && m.PayloadSize != nil {
		return *m.PayloadSize
	}
	return 0
}

func (m *SingleMessageMetadata) GetCompactedOut() bool {
	if m != nil && m.CompactedOut != nil {
		return *m.CompactedOut
	}
	return Default_SingleMessageMetadata_CompactedOut
}

func (m *SingleMessageMetadata) GetEventTime() uint64 {
	if m != nil && m.EventTime != nil {
		return *m.EventTime
	}
	return Default_SingleMessageMetadata_EventTime
}

func (m *SingleMessageMetadata) GetPartitionKeyB64Encoded() bool {
	if m != nil && m.PartitionKeyB64Encoded != nil {
		return *m.PartitionKeyB64Encoded
	}
	return Default_SingleMessageMetadata_PartitionKeyB64Encoded
}

func (m *SingleMessageMetadata) GetOrderingKey() []byte {
	if m != nil {
		return m.OrderingKey
	}
	return nil
}

func (m *SingleMessageMetadata) GetSequenceId() uint64 {
	if m != nil && m.SequenceId != nil {
		return *m.SequenceId
	}
	return 0
}

type CommandConnect struct {
	ClientVersion   *string     `protobuf:"bytes,1,req,name=client_version" json:"client_version,omitempty"`
	AuthMethod      *AuthMethod `protobuf:"varint,2,opt,name=auth_method,enum=pulsar.proto.AuthMethod" json:"auth_method,omitempty"`
	AuthMethodName  *string     `protobuf:"bytes,5,opt,name=auth_method_name" json:"auth_method_name,omitempty"`
	AuthData        []byte      `protobuf:"bytes,3,opt,name=auth_data" json:"auth_data,omitempty"`
	ProtocolVersion *int32      `protobuf:"varint,4,opt,name=protocol_version,def=0" json:"protocol_version,omitempty"`
	// Client can ask to be proxyied to a specific broker
	// This is only honored by a Pulsar proxy
	ProxyToBrokerUrl *string `protobuf:"bytes,6,opt,name=proxy_to_broker_url" json:"proxy_to_broker_url,omitempty"`
	// Original principal that was verified by
	// a Pulsar proxy. In this case the auth info above
	// will be the auth of the proxy itself
	OriginalPrincipal *string `protobuf:"bytes,7,opt,name=original_principal" json:"original_principal,omitempty"`
	// Original auth role and auth Method that was passed
	// to the proxy. In this case the auth info above
	// will be the auth of the proxy itself
	OriginalAuthData   *string `protobuf:"bytes,8,opt,name=original_auth_data" json:"original_auth_data,omitempty"`
	OriginalAuthMethod *string `protobuf:"bytes,9,opt,name=original_auth_method" json:"original_auth_method,omitempty"`
	// Feature flags
	FeatureFlags         *FeatureFlags `protobuf:"bytes,10,opt,name=feature_flags" json:"feature_flags,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CommandConnect) Reset()         { *m = CommandConnect{} }
func (m *CommandConnect) String() string { return proto.CompactTextString(m) }
func (*CommandConnect) ProtoMessage()    {}
func (*CommandConnect) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{8}
}
func (m *CommandConnect) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandConnect) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandConnect.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandConnect) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandConnect.Merge(m, src)
}
func (m *CommandConnect) XXX_Size() int {
	return m.Size()
}
func (m *CommandConnect) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandConnect.DiscardUnknown(m)
}

var xxx_messageInfo_CommandConnect proto.InternalMessageInfo

const Default_CommandConnect_ProtocolVersion int32 = 0

func (m *CommandConnect) GetClientVersion() string {
	if m != nil && m.ClientVersion != nil {
		return *m.ClientVersion
	}
	return ""
}

func (m *CommandConnect) GetAuthMethod() AuthMethod {
	if m != nil && m.AuthMethod != nil {
		return *m.AuthMethod
	}
	return AuthMethod_AuthMethodNone
}

func (m *CommandConnect) GetAuthMethodName() string {
	if m != nil && m.AuthMethodName != nil {
		return *m.AuthMethodName
	}
	return ""
}

func (m *CommandConnect) GetAuthData() []byte {
	if m != nil {
		return m.AuthData
	}
	return nil
}

func (m *CommandConnect) GetProtocolVersion() int32 {
	if m != nil && m.ProtocolVersion != nil {
		return *m.ProtocolVersion
	}
	return Default_CommandConnect_ProtocolVersion
}

func (m *CommandConnect) GetProxyToBrokerUrl() string {
	if m != nil && m.ProxyToBrokerUrl != nil {
		return *m.ProxyToBrokerUrl
	}
	return ""
}

func (m *CommandConnect) GetOriginalPrincipal() string {
	if m != nil && m.OriginalPrincipal != nil {
		return *m.OriginalPrincipal
	}
	return ""
}

func (m *CommandConnect) GetOriginalAuthData() string {
	if m != nil && m.OriginalAuthData != nil {
		return *m.OriginalAuthData
	}
	return ""
}

func (m *CommandConnect) GetOriginalAuthMethod() string {
	if m != nil && m.OriginalAuthMethod != nil {
		return *m.OriginalAuthMethod
	}
	return ""
}

func (m *CommandConnect) GetFeatureFlags() *FeatureFlags {
	if m != nil {
		return m.FeatureFlags
	}
	return nil
}

type FeatureFlags struct {
	SupportsAuthRefresh  *bool    `protobuf:"varint,1,opt,name=supports_auth_refresh,def=0" json:"supports_auth_refresh,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FeatureFlags) Reset()         { *m = FeatureFlags{} }
func (m *FeatureFlags) String() string { return proto.CompactTextString(m) }
func (*FeatureFlags) ProtoMessage()    {}
func (*FeatureFlags) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{9}
}
func (m *FeatureFlags) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FeatureFlags) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FeatureFlags.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FeatureFlags) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeatureFlags.Merge(m, src)
}
func (m *FeatureFlags) XXX_Size() int {
	return m.Size()
}
func (m *FeatureFlags) XXX_DiscardUnknown() {
	xxx_messageInfo_FeatureFlags.DiscardUnknown(m)
}

var xxx_messageInfo_FeatureFlags proto.InternalMessageInfo

const Default_FeatureFlags_SupportsAuthRefresh bool = false

func (m *FeatureFlags) GetSupportsAuthRefresh() bool {
	if m != nil && m.SupportsAuthRefresh != nil {
		return *m.SupportsAuthRefresh
	}
	return Default_FeatureFlags_SupportsAuthRefresh
}

type CommandConnected struct {
	ServerVersion        *string  `protobuf:"bytes,1,req,name=server_version" json:"server_version,omitempty"`
	ProtocolVersion      *int32   `protobuf:"varint,2,opt,name=protocol_version,def=0" json:"protocol_version,omitempty"`
	MaxMessageSize       *int32   `protobuf:"varint,3,opt,name=max_message_size" json:"max_message_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandConnected) Reset()         { *m = CommandConnected{} }
func (m *CommandConnected) String() string { return proto.CompactTextString(m) }
func (*CommandConnected) ProtoMessage()    {}
func (*CommandConnected) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{10}
}
func (m *CommandConnected) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandConnected) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandConnected.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandConnected) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandConnected.Merge(m, src)
}
func (m *CommandConnected) XXX_Size() int {
	return m.Size()
}
func (m *CommandConnected) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandConnected.DiscardUnknown(m)
}

var xxx_messageInfo_CommandConnected proto.InternalMessageInfo

const Default_CommandConnected_ProtocolVersion int32 = 0

func (m *CommandConnected) GetServerVersion() string {
	if m != nil && m.ServerVersion != nil {
		return *m.ServerVersion
	}
	return ""
}

func (m *CommandConnected) GetProtocolVersion() int32 {
	if m != nil && m.ProtocolVersion != nil {
		return *m.ProtocolVersion
	}
	return Default_CommandConnected_ProtocolVersion
}

func (m *CommandConnected) GetMaxMessageSize() int32 {
	if m != nil && m.MaxMessageSize != nil {
		return *m.MaxMessageSize
	}
	return 0
}

type CommandAuthResponse struct {
	ClientVersion        *string   `protobuf:"bytes,1,opt,name=client_version" json:"client_version,omitempty"`
	Response             *AuthData `protobuf:"bytes,2,opt,name=response" json:"response,omitempty"`
	ProtocolVersion      *int32    `protobuf:"varint,3,opt,name=protocol_version,def=0" json:"protocol_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CommandAuthResponse) Reset()         { *m = CommandAuthResponse{} }
func (m *CommandAuthResponse) String() string { return proto.CompactTextString(m) }
func (*CommandAuthResponse) ProtoMessage()    {}
func (*CommandAuthResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{11}
}
func (m *CommandAuthResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandAuthResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandAuthResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandAuthResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandAuthResponse.Merge(m, src)
}
func (m *CommandAuthResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandAuthResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandAuthResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandAuthResponse proto.InternalMessageInfo

const Default_CommandAuthResponse_ProtocolVersion int32 = 0

func (m *CommandAuthResponse) GetClientVersion() string {
	if m != nil && m.ClientVersion != nil {
		return *m.ClientVersion
	}
	return ""
}

func (m *CommandAuthResponse) GetResponse() *AuthData {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *CommandAuthResponse) GetProtocolVersion() int32 {
	if m != nil && m.ProtocolVersion != nil {
		return *m.ProtocolVersion
	}
	return Default_CommandAuthResponse_ProtocolVersion
}

type CommandAuthChallenge struct {
	ServerVersion        *string   `protobuf:"bytes,1,opt,name=server_version" json:"server_version,omitempty"`
	Challenge            *AuthData `protobuf:"bytes,2,opt,name=challenge" json:"challenge,omitempty"`
	ProtocolVersion      *int32    `protobuf:"varint,3,opt,name=protocol_version,def=0" json:"protocol_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CommandAuthChallenge) Reset()         { *m = CommandAuthChallenge{} }
func (m *CommandAuthChallenge) String() string { return proto.CompactTextString(m) }
func (*CommandAuthChallenge) ProtoMessage()    {}
func (*CommandAuthChallenge) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{12}
}
func (m *CommandAuthChallenge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandAuthChallenge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandAuthChallenge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandAuthChallenge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandAuthChallenge.Merge(m, src)
}
func (m *CommandAuthChallenge) XXX_Size() int {
	return m.Size()
}
func (m *CommandAuthChallenge) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandAuthChallenge.DiscardUnknown(m)
}

var xxx_messageInfo_CommandAuthChallenge proto.InternalMessageInfo

const Default_CommandAuthChallenge_ProtocolVersion int32 = 0

func (m *CommandAuthChallenge) GetServerVersion() string {
	if m != nil && m.ServerVersion != nil {
		return *m.ServerVersion
	}
	return ""
}

func (m *CommandAuthChallenge) GetChallenge() *AuthData {
	if m != nil {
		return m.Challenge
	}
	return nil
}

func (m *CommandAuthChallenge) GetProtocolVersion() int32 {
	if m != nil && m.ProtocolVersion != nil {
		return *m.ProtocolVersion
	}
	return Default_CommandAuthChallenge_ProtocolVersion
}

// To support mutual authentication type, such as Sasl, reuse this command to mutual auth.
type AuthData struct {
	AuthMethodName       *string  `protobuf:"bytes,1,opt,name=auth_method_name" json:"auth_method_name,omitempty"`
	AuthData             []byte   `protobuf:"bytes,2,opt,name=auth_data" json:"auth_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuthData) Reset()         { *m = AuthData{} }
func (m *AuthData) String() string { return proto.CompactTextString(m) }
func (*AuthData) ProtoMessage()    {}
func (*AuthData) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{13}
}
func (m *AuthData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuthData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuthData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthData.Merge(m, src)
}
func (m *AuthData) XXX_Size() int {
	return m.Size()
}
func (m *AuthData) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthData.DiscardUnknown(m)
}

var xxx_messageInfo_AuthData proto.InternalMessageInfo

func (m *AuthData) GetAuthMethodName() string {
	if m != nil && m.AuthMethodName != nil {
		return *m.AuthMethodName
	}
	return ""
}

func (m *AuthData) GetAuthData() []byte {
	if m != nil {
		return m.AuthData
	}
	return nil
}

type KeySharedMeta struct {
	KeySharedMode           *KeySharedMode `protobuf:"varint,1,req,name=keySharedMode,enum=pulsar.proto.KeySharedMode" json:"keySharedMode,omitempty"`
	HashRanges              []*IntRange    `protobuf:"bytes,3,rep,name=hashRanges" json:"hashRanges,omitempty"`
	AllowOutOfOrderDelivery *bool          `protobuf:"varint,4,opt,name=allowOutOfOrderDelivery,def=0" json:"allowOutOfOrderDelivery,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}       `json:"-"`
	XXX_unrecognized        []byte         `json:"-"`
	XXX_sizecache           int32          `json:"-"`
}

func (m *KeySharedMeta) Reset()         { *m = KeySharedMeta{} }
func (m *KeySharedMeta) String() string { return proto.CompactTextString(m) }
func (*KeySharedMeta) ProtoMessage()    {}
func (*KeySharedMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{14}
}
func (m *KeySharedMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeySharedMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeySharedMeta.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KeySharedMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeySharedMeta.Merge(m, src)
}
func (m *KeySharedMeta) XXX_Size() int {
	return m.Size()
}
func (m *KeySharedMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_KeySharedMeta.DiscardUnknown(m)
}

var xxx_messageInfo_KeySharedMeta proto.InternalMessageInfo

const Default_KeySharedMeta_AllowOutOfOrderDelivery bool = false

func (m *KeySharedMeta) GetKeySharedMode() KeySharedMode {
	if m != nil && m.KeySharedMode != nil {
		return *m.KeySharedMode
	}
	return KeySharedMode_AUTO_SPLIT
}

func (m *KeySharedMeta) GetHashRanges() []*IntRange {
	if m != nil {
		return m.HashRanges
	}
	return nil
}

func (m *KeySharedMeta) GetAllowOutOfOrderDelivery() bool {
	if m != nil && m.AllowOutOfOrderDelivery != nil {
		return *m.AllowOutOfOrderDelivery
	}
	return Default_KeySharedMeta_AllowOutOfOrderDelivery
}

type CommandSubscribe struct {
	Topic         *string                   `protobuf:"bytes,1,req,name=topic" json:"topic,omitempty"`
	Subscription  *string                   `protobuf:"bytes,2,req,name=subscription" json:"subscription,omitempty"`
	SubType       *CommandSubscribe_SubType `protobuf:"varint,3,req,name=subType,enum=pulsar.proto.CommandSubscribe_SubType" json:"subType,omitempty"`
	ConsumerId    *uint64                   `protobuf:"varint,4,req,name=consumer_id" json:"consumer_id,omitempty"`
	RequestId     *uint64                   `protobuf:"varint,5,req,name=request_id" json:"request_id,omitempty"`
	ConsumerName  *string                   `protobuf:"bytes,6,opt,name=consumer_name" json:"consumer_name,omitempty"`
	PriorityLevel *int32                    `protobuf:"varint,7,opt,name=priority_level" json:"priority_level,omitempty"`
	// Signal wether the subscription should be backed by a
	// durable cursor or not
	Durable *bool `protobuf:"varint,8,opt,name=durable,def=1" json:"durable,omitempty"`
	// If specified, the subscription will position the cursor
	// markd-delete position  on the particular message id and
	// will send messages from that point
	StartMessageId *MessageIdData `protobuf:"bytes,9,opt,name=start_message_id" json:"start_message_id,omitempty"`
	/// Add optional metadata key=value to this consumer
	Metadata      []*KeyValue `protobuf:"bytes,10,rep,name=metadata" json:"metadata,omitempty"`
	ReadCompacted *bool       `protobuf:"varint,11,opt,name=read_compacted" json:"read_compacted,omitempty"`
	Schema        *Schema     `protobuf:"bytes,12,opt,name=schema" json:"schema,omitempty"`
	// Signal whether the subscription will initialize on latest
	// or not -- earliest
	InitialPosition *CommandSubscribe_InitialPosition `protobuf:"varint,13,opt,name=initialPosition,enum=pulsar.proto.CommandSubscribe_InitialPosition,def=0" json:"initialPosition,omitempty"`
	// Mark the subscription as "replicated". Pulsar will make sure
	// to periodically sync the state of replicated subscriptions
	// across different clusters (when using geo-replication).
	ReplicateSubscriptionState *bool `protobuf:"varint,14,opt,name=replicate_subscription_state" json:"replicate_subscription_state,omitempty"`
	// If true, the subscribe operation will cause a topic to be
	// created if it does not exist already (and if topic auto-creation
	// is allowed by broker.
	// If false, the subscribe operation will fail if the topic
	// does not exist.
	ForceTopicCreation *bool `protobuf:"varint,15,opt,name=force_topic_creation,def=1" json:"force_topic_creation,omitempty"`
	// If specified, the subscription will reset cursor's position back
	// to specified seconds and  will send messages from that point
	StartMessageRollbackDurationSec *uint64        `protobuf:"varint,16,opt,name=start_message_rollback_duration_sec,def=0" json:"start_message_rollback_duration_sec,omitempty"`
	KeySharedMeta                   *KeySharedMeta `protobuf:"bytes,17,opt,name=keySharedMeta" json:"keySharedMeta,omitempty"`
	XXX_NoUnkeyedLiteral            struct{}       `json:"-"`
	XXX_unrecognized                []byte         `json:"-"`
	XXX_sizecache                   int32          `json:"-"`
}

func (m *CommandSubscribe) Reset()         { *m = CommandSubscribe{} }
func (m *CommandSubscribe) String() string { return proto.CompactTextString(m) }
func (*CommandSubscribe) ProtoMessage()    {}
func (*CommandSubscribe) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{15}
}
func (m *CommandSubscribe) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandSubscribe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandSubscribe.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandSubscribe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandSubscribe.Merge(m, src)
}
func (m *CommandSubscribe) XXX_Size() int {
	return m.Size()
}
func (m *CommandSubscribe) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandSubscribe.DiscardUnknown(m)
}

var xxx_messageInfo_CommandSubscribe proto.InternalMessageInfo

const Default_CommandSubscribe_Durable bool = true
const Default_CommandSubscribe_InitialPosition CommandSubscribe_InitialPosition = CommandSubscribe_Latest
const Default_CommandSubscribe_ForceTopicCreation bool = true
const Default_CommandSubscribe_StartMessageRollbackDurationSec uint64 = 0

func (m *CommandSubscribe) GetTopic() string {
	if m != nil && m.Topic != nil {
		return *m.Topic
	}
	return ""
}

func (m *CommandSubscribe) GetSubscription() string {
	if m != nil && m.Subscription != nil {
		return *m.Subscription
	}
	return ""
}

func (m *CommandSubscribe) GetSubType() CommandSubscribe_SubType {
	if m != nil && m.SubType != nil {
		return *m.SubType
	}
	return CommandSubscribe_Exclusive
}

func (m *CommandSubscribe) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

func (m *CommandSubscribe) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandSubscribe) GetConsumerName() string {
	if m != nil && m.ConsumerName != nil {
		return *m.ConsumerName
	}
	return ""
}

func (m *CommandSubscribe) GetPriorityLevel() int32 {
	if m != nil && m.PriorityLevel != nil {
		return *m.PriorityLevel
	}
	return 0
}

func (m *CommandSubscribe) GetDurable() bool {
	if m != nil && m.Durable != nil {
		return *m.Durable
	}
	return Default_CommandSubscribe_Durable
}

func (m *CommandSubscribe) GetStartMessageId() *MessageIdData {
	if m != nil {
		return m.StartMessageId
	}
	return nil
}

func (m *CommandSubscribe) GetMetadata() []*KeyValue {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *CommandSubscribe) GetReadCompacted() bool {
	if m != nil && m.ReadCompacted != nil {
		return *m.ReadCompacted
	}
	return false
}

func (m *CommandSubscribe) GetSchema() *Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *CommandSubscribe) GetInitialPosition() CommandSubscribe_InitialPosition {
	if m != nil && m.InitialPosition != nil {
		return *m.InitialPosition
	}
	return Default_CommandSubscribe_InitialPosition
}

func (m *CommandSubscribe) GetReplicateSubscriptionState() bool {
	if m != nil && m.ReplicateSubscriptionState != nil {
		return *m.ReplicateSubscriptionState
	}
	return false
}

func (m *CommandSubscribe) GetForceTopicCreation() bool {
	if m != nil && m.ForceTopicCreation != nil {
		return *m.ForceTopicCreation
	}
	return Default_CommandSubscribe_ForceTopicCreation
}

func (m *CommandSubscribe) GetStartMessageRollbackDurationSec() uint64 {
	if m != nil && m.StartMessageRollbackDurationSec != nil {
		return *m.StartMessageRollbackDurationSec
	}
	return Default_CommandSubscribe_StartMessageRollbackDurationSec
}

func (m *CommandSubscribe) GetKeySharedMeta() *KeySharedMeta {
	if m != nil {
		return m.KeySharedMeta
	}
	return nil
}

type CommandPartitionedTopicMetadata struct {
	Topic     *string `protobuf:"bytes,1,req,name=topic" json:"topic,omitempty"`
	RequestId *uint64 `protobuf:"varint,2,req,name=request_id" json:"request_id,omitempty"`
	// TODO - Remove original_principal, original_auth_data, original_auth_method
	// Original principal that was verified by
	// a Pulsar proxy.
	OriginalPrincipal *string `protobuf:"bytes,3,opt,name=original_principal" json:"original_principal,omitempty"`
	// Original auth role and auth Method that was passed
	// to the proxy.
	OriginalAuthData     *string  `protobuf:"bytes,4,opt,name=original_auth_data" json:"original_auth_data,omitempty"`
	OriginalAuthMethod   *string  `protobuf:"bytes,5,opt,name=original_auth_method" json:"original_auth_method,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandPartitionedTopicMetadata) Reset()         { *m = CommandPartitionedTopicMetadata{} }
func (m *CommandPartitionedTopicMetadata) String() string { return proto.CompactTextString(m) }
func (*CommandPartitionedTopicMetadata) ProtoMessage()    {}
func (*CommandPartitionedTopicMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{16}
}
func (m *CommandPartitionedTopicMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandPartitionedTopicMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandPartitionedTopicMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandPartitionedTopicMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandPartitionedTopicMetadata.Merge(m, src)
}
func (m *CommandPartitionedTopicMetadata) XXX_Size() int {
	return m.Size()
}
func (m *CommandPartitionedTopicMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandPartitionedTopicMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CommandPartitionedTopicMetadata proto.InternalMessageInfo

func (m *CommandPartitionedTopicMetadata) GetTopic() string {
	if m != nil && m.Topic != nil {
		return *m.Topic
	}
	return ""
}

func (m *CommandPartitionedTopicMetadata) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandPartitionedTopicMetadata) GetOriginalPrincipal() string {
	if m != nil && m.OriginalPrincipal != nil {
		return *m.OriginalPrincipal
	}
	return ""
}

func (m *CommandPartitionedTopicMetadata) GetOriginalAuthData() string {
	if m != nil && m.OriginalAuthData != nil {
		return *m.OriginalAuthData
	}
	return ""
}

func (m *CommandPartitionedTopicMetadata) GetOriginalAuthMethod() string {
	if m != nil && m.OriginalAuthMethod != nil {
		return *m.OriginalAuthMethod
	}
	return ""
}

type CommandPartitionedTopicMetadataResponse struct {
	Partitions           *uint32                                             `protobuf:"varint,1,opt,name=partitions" json:"partitions,omitempty"`
	RequestId            *uint64                                             `protobuf:"varint,2,req,name=request_id" json:"request_id,omitempty"`
	Response             *CommandPartitionedTopicMetadataResponse_LookupType `protobuf:"varint,3,opt,name=response,enum=pulsar.proto.CommandPartitionedTopicMetadataResponse_LookupType" json:"response,omitempty"`
	Error                *ServerError                                        `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message              *string                                             `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_unrecognized     []byte                                              `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *CommandPartitionedTopicMetadataResponse) Reset() {
	*m = CommandPartitionedTopicMetadataResponse{}
}
func (m *CommandPartitionedTopicMetadataResponse) String() string { return proto.CompactTextString(m) }
func (*CommandPartitionedTopicMetadataResponse) ProtoMessage()    {}
func (*CommandPartitionedTopicMetadataResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{17}
}
func (m *CommandPartitionedTopicMetadataResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandPartitionedTopicMetadataResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandPartitionedTopicMetadataResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandPartitionedTopicMetadataResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandPartitionedTopicMetadataResponse.Merge(m, src)
}
func (m *CommandPartitionedTopicMetadataResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandPartitionedTopicMetadataResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandPartitionedTopicMetadataResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandPartitionedTopicMetadataResponse proto.InternalMessageInfo

func (m *CommandPartitionedTopicMetadataResponse) GetPartitions() uint32 {
	if m != nil && m.Partitions != nil {
		return *m.Partitions
	}
	return 0
}

func (m *CommandPartitionedTopicMetadataResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandPartitionedTopicMetadataResponse) GetResponse() CommandPartitionedTopicMetadataResponse_LookupType {
	if m != nil && m.Response != nil {
		return *m.Response
	}
	return CommandPartitionedTopicMetadataResponse_Success
}

func (m *CommandPartitionedTopicMetadataResponse) GetError() ServerError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ServerError_UnknownError
}

func (m *CommandPartitionedTopicMetadataResponse) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

type CommandLookupTopic struct {
	Topic         *string `protobuf:"bytes,1,req,name=topic" json:"topic,omitempty"`
	RequestId     *uint64 `protobuf:"varint,2,req,name=request_id" json:"request_id,omitempty"`
	Authoritative *bool   `protobuf:"varint,3,opt,name=authoritative,def=0" json:"authoritative,omitempty"`
	// TODO - Remove original_principal, original_auth_data, original_auth_method
	// Original principal that was verified by
	// a Pulsar proxy.
	OriginalPrincipal *string `protobuf:"bytes,4,opt,name=original_principal" json:"original_principal,omitempty"`
	// Original auth role and auth Method that was passed
	// to the proxy.
	OriginalAuthData   *string `protobuf:"bytes,5,opt,name=original_auth_data" json:"original_auth_data,omitempty"`
	OriginalAuthMethod *string `protobuf:"bytes,6,opt,name=original_auth_method" json:"original_auth_method,omitempty"`
	// net mode setting
	AdvertisedListenerName *string  `protobuf:"bytes,7,opt,name=advertised_listener_name" json:"advertised_listener_name,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *CommandLookupTopic) Reset()         { *m = CommandLookupTopic{} }
func (m *CommandLookupTopic) String() string { return proto.CompactTextString(m) }
func (*CommandLookupTopic) ProtoMessage()    {}
func (*CommandLookupTopic) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{18}
}
func (m *CommandLookupTopic) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandLookupTopic) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandLookupTopic.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandLookupTopic) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandLookupTopic.Merge(m, src)
}
func (m *CommandLookupTopic) XXX_Size() int {
	return m.Size()
}
func (m *CommandLookupTopic) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandLookupTopic.DiscardUnknown(m)
}

var xxx_messageInfo_CommandLookupTopic proto.InternalMessageInfo

const Default_CommandLookupTopic_Authoritative bool = false

func (m *CommandLookupTopic) GetTopic() string {
	if m != nil && m.Topic != nil {
		return *m.Topic
	}
	return ""
}

func (m *CommandLookupTopic) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandLookupTopic) GetAuthoritative() bool {
	if m != nil && m.Authoritative != nil {
		return *m.Authoritative
	}
	return Default_CommandLookupTopic_Authoritative
}

func (m *CommandLookupTopic) GetOriginalPrincipal() string {
	if m != nil && m.OriginalPrincipal != nil {
		return *m.OriginalPrincipal
	}
	return ""
}

func (m *CommandLookupTopic) GetOriginalAuthData() string {
	if m != nil && m.OriginalAuthData != nil {
		return *m.OriginalAuthData
	}
	return ""
}

func (m *CommandLookupTopic) GetOriginalAuthMethod() string {
	if m != nil && m.OriginalAuthMethod != nil {
		return *m.OriginalAuthMethod
	}
	return ""
}

func (m *CommandLookupTopic) GetAdvertisedListenerName() string {
	if m != nil && m.AdvertisedListenerName != nil {
		return *m.AdvertisedListenerName
	}
	return ""
}

type CommandLookupTopicResponse struct {
	BrokerServiceUrl    *string                                `protobuf:"bytes,1,opt,name=brokerServiceUrl" json:"brokerServiceUrl,omitempty"`
	BrokerServiceUrlTls *string                                `protobuf:"bytes,2,opt,name=brokerServiceUrlTls" json:"brokerServiceUrlTls,omitempty"`
	Response            *CommandLookupTopicResponse_LookupType `protobuf:"varint,3,opt,name=response,enum=pulsar.proto.CommandLookupTopicResponse_LookupType" json:"response,omitempty"`
	RequestId           *uint64                                `protobuf:"varint,4,req,name=request_id" json:"request_id,omitempty"`
	Authoritative       *bool                                  `protobuf:"varint,5,opt,name=authoritative,def=0" json:"authoritative,omitempty"`
	Error               *ServerError                           `protobuf:"varint,6,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message             *string                                `protobuf:"bytes,7,opt,name=message" json:"message,omitempty"`
	// If it's true, indicates to the client that it must
	// always connect through the service url after the
	// lookup has been completed.
	ProxyThroughServiceUrl *bool    `protobuf:"varint,8,opt,name=proxy_through_service_url,def=0" json:"proxy_through_service_url,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *CommandLookupTopicResponse) Reset()         { *m = CommandLookupTopicResponse{} }
func (m *CommandLookupTopicResponse) String() string { return proto.CompactTextString(m) }
func (*CommandLookupTopicResponse) ProtoMessage()    {}
func (*CommandLookupTopicResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{19}
}
func (m *CommandLookupTopicResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandLookupTopicResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandLookupTopicResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandLookupTopicResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandLookupTopicResponse.Merge(m, src)
}
func (m *CommandLookupTopicResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandLookupTopicResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandLookupTopicResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandLookupTopicResponse proto.InternalMessageInfo

const Default_CommandLookupTopicResponse_Authoritative bool = false
const Default_CommandLookupTopicResponse_ProxyThroughServiceUrl bool = false

func (m *CommandLookupTopicResponse) GetBrokerServiceUrl() string {
	if m != nil && m.BrokerServiceUrl != nil {
		return *m.BrokerServiceUrl
	}
	return ""
}

func (m *CommandLookupTopicResponse) GetBrokerServiceUrlTls() string {
	if m != nil && m.BrokerServiceUrlTls != nil {
		return *m.BrokerServiceUrlTls
	}
	return ""
}

func (m *CommandLookupTopicResponse) GetResponse() CommandLookupTopicResponse_LookupType {
	if m != nil && m.Response != nil {
		return *m.Response
	}
	return CommandLookupTopicResponse_Redirect
}

func (m *CommandLookupTopicResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandLookupTopicResponse) GetAuthoritative() bool {
	if m != nil && m.Authoritative != nil {
		return *m.Authoritative
	}
	return Default_CommandLookupTopicResponse_Authoritative
}

func (m *CommandLookupTopicResponse) GetError() ServerError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ServerError_UnknownError
}

func (m *CommandLookupTopicResponse) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *CommandLookupTopicResponse) GetProxyThroughServiceUrl() bool {
	if m != nil && m.ProxyThroughServiceUrl != nil {
		return *m.ProxyThroughServiceUrl
	}
	return Default_CommandLookupTopicResponse_ProxyThroughServiceUrl
}

/// Create a new Producer on a topic, assigning the given producer_id,
/// all messages sent with this producer_id will be persisted on the topic
type CommandProducer struct {
	Topic      *string `protobuf:"bytes,1,req,name=topic" json:"topic,omitempty"`
	ProducerId *uint64 `protobuf:"varint,2,req,name=producer_id" json:"producer_id,omitempty"`
	RequestId  *uint64 `protobuf:"varint,3,req,name=request_id" json:"request_id,omitempty"`
	/// If a producer name is specified, the name will be used,
	/// otherwise the broker will generate a unique name
	ProducerName *string `protobuf:"bytes,4,opt,name=producer_name" json:"producer_name,omitempty"`
	Encrypted    *bool   `protobuf:"varint,5,opt,name=encrypted,def=0" json:"encrypted,omitempty"`
	/// Add optional metadata key=value to this producer
	Metadata []*KeyValue `protobuf:"bytes,6,rep,name=metadata" json:"metadata,omitempty"`
	Schema   *Schema     `protobuf:"bytes,7,opt,name=schema" json:"schema,omitempty"`
	// If producer reconnect to broker, the epoch of this producer will +1
	Epoch *uint64 `protobuf:"varint,8,opt,name=epoch,def=0" json:"epoch,omitempty"`
	// Indicate the name of the producer is generated or user provided
	// Use default true here is in order to be forward compatible with the client
	UserProvidedProducerName *bool    `protobuf:"varint,9,opt,name=user_provided_producer_name,def=1" json:"user_provided_producer_name,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *CommandProducer) Reset()         { *m = CommandProducer{} }
func (m *CommandProducer) String() string { return proto.CompactTextString(m) }
func (*CommandProducer) ProtoMessage()    {}
func (*CommandProducer) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{20}
}
func (m *CommandProducer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandProducer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandProducer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandProducer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandProducer.Merge(m, src)
}
func (m *CommandProducer) XXX_Size() int {
	return m.Size()
}
func (m *CommandProducer) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandProducer.DiscardUnknown(m)
}

var xxx_messageInfo_CommandProducer proto.InternalMessageInfo

const Default_CommandProducer_Encrypted bool = false
const Default_CommandProducer_Epoch uint64 = 0
const Default_CommandProducer_UserProvidedProducerName bool = true

func (m *CommandProducer) GetTopic() string {
	if m != nil && m.Topic != nil {
		return *m.Topic
	}
	return ""
}

func (m *CommandProducer) GetProducerId() uint64 {
	if m != nil && m.ProducerId != nil {
		return *m.ProducerId
	}
	return 0
}

func (m *CommandProducer) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandProducer) GetProducerName() string {
	if m != nil && m.ProducerName != nil {
		return *m.ProducerName
	}
	return ""
}

func (m *CommandProducer) GetEncrypted() bool {
	if m != nil && m.Encrypted != nil {
		return *m.Encrypted
	}
	return Default_CommandProducer_Encrypted
}

func (m *CommandProducer) GetMetadata() []*KeyValue {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *CommandProducer) GetSchema() *Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *CommandProducer) GetEpoch() uint64 {
	if m != nil && m.Epoch != nil {
		return *m.Epoch
	}
	return Default_CommandProducer_Epoch
}

func (m *CommandProducer) GetUserProvidedProducerName() bool {
	if m != nil && m.UserProvidedProducerName != nil {
		return *m.UserProvidedProducerName
	}
	return Default_CommandProducer_UserProvidedProducerName
}

type CommandSend struct {
	ProducerId     *uint64 `protobuf:"varint,1,req,name=producer_id" json:"producer_id,omitempty"`
	SequenceId     *uint64 `protobuf:"varint,2,req,name=sequence_id" json:"sequence_id,omitempty"`
	NumMessages    *int32  `protobuf:"varint,3,opt,name=num_messages,def=1" json:"num_messages,omitempty"`
	TxnidLeastBits *uint64 `protobuf:"varint,4,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits  *uint64 `protobuf:"varint,5,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	/// Add highest sequence id to support batch message with external sequence id
	HighestSequenceId    *uint64  `protobuf:"varint,6,opt,name=highest_sequence_id,def=0" json:"highest_sequence_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandSend) Reset()         { *m = CommandSend{} }
func (m *CommandSend) String() string { return proto.CompactTextString(m) }
func (*CommandSend) ProtoMessage()    {}
func (*CommandSend) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{21}
}
func (m *CommandSend) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandSend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandSend.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandSend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandSend.Merge(m, src)
}
func (m *CommandSend) XXX_Size() int {
	return m.Size()
}
func (m *CommandSend) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandSend.DiscardUnknown(m)
}

var xxx_messageInfo_CommandSend proto.InternalMessageInfo

const Default_CommandSend_NumMessages int32 = 1
const Default_CommandSend_TxnidLeastBits uint64 = 0
const Default_CommandSend_TxnidMostBits uint64 = 0
const Default_CommandSend_HighestSequenceId uint64 = 0

func (m *CommandSend) GetProducerId() uint64 {
	if m != nil && m.ProducerId != nil {
		return *m.ProducerId
	}
	return 0
}

func (m *CommandSend) GetSequenceId() uint64 {
	if m != nil && m.SequenceId != nil {
		return *m.SequenceId
	}
	return 0
}

func (m *CommandSend) GetNumMessages() int32 {
	if m != nil && m.NumMessages != nil {
		return *m.NumMessages
	}
	return Default_CommandSend_NumMessages
}

func (m *CommandSend) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandSend_TxnidLeastBits
}

func (m *CommandSend) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandSend_TxnidMostBits
}

func (m *CommandSend) GetHighestSequenceId() uint64 {
	if m != nil && m.HighestSequenceId != nil {
		return *m.HighestSequenceId
	}
	return Default_CommandSend_HighestSequenceId
}

type CommandSendReceipt struct {
	ProducerId           *uint64        `protobuf:"varint,1,req,name=producer_id" json:"producer_id,omitempty"`
	SequenceId           *uint64        `protobuf:"varint,2,req,name=sequence_id" json:"sequence_id,omitempty"`
	MessageId            *MessageIdData `protobuf:"bytes,3,opt,name=message_id" json:"message_id,omitempty"`
	HighestSequenceId    *uint64        `protobuf:"varint,4,opt,name=highest_sequence_id,def=0" json:"highest_sequence_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CommandSendReceipt) Reset()         { *m = CommandSendReceipt{} }
func (m *CommandSendReceipt) String() string { return proto.CompactTextString(m) }
func (*CommandSendReceipt) ProtoMessage()    {}
func (*CommandSendReceipt) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{22}
}
func (m *CommandSendReceipt) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandSendReceipt) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandSendReceipt.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandSendReceipt) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandSendReceipt.Merge(m, src)
}
func (m *CommandSendReceipt) XXX_Size() int {
	return m.Size()
}
func (m *CommandSendReceipt) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandSendReceipt.DiscardUnknown(m)
}

var xxx_messageInfo_CommandSendReceipt proto.InternalMessageInfo

const Default_CommandSendReceipt_HighestSequenceId uint64 = 0

func (m *CommandSendReceipt) GetProducerId() uint64 {
	if m != nil && m.ProducerId != nil {
		return *m.ProducerId
	}
	return 0
}

func (m *CommandSendReceipt) GetSequenceId() uint64 {
	if m != nil && m.SequenceId != nil {
		return *m.SequenceId
	}
	return 0
}

func (m *CommandSendReceipt) GetMessageId() *MessageIdData {
	if m != nil {
		return m.MessageId
	}
	return nil
}

func (m *CommandSendReceipt) GetHighestSequenceId() uint64 {
	if m != nil && m.HighestSequenceId != nil {
		return *m.HighestSequenceId
	}
	return Default_CommandSendReceipt_HighestSequenceId
}

type CommandSendError struct {
	ProducerId           *uint64      `protobuf:"varint,1,req,name=producer_id" json:"producer_id,omitempty"`
	SequenceId           *uint64      `protobuf:"varint,2,req,name=sequence_id" json:"sequence_id,omitempty"`
	Error                *ServerError `protobuf:"varint,3,req,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message              *string      `protobuf:"bytes,4,req,name=message" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommandSendError) Reset()         { *m = CommandSendError{} }
func (m *CommandSendError) String() string { return proto.CompactTextString(m) }
func (*CommandSendError) ProtoMessage()    {}
func (*CommandSendError) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{23}
}
func (m *CommandSendError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandSendError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandSendError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandSendError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandSendError.Merge(m, src)
}
func (m *CommandSendError) XXX_Size() int {
	return m.Size()
}
func (m *CommandSendError) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandSendError.DiscardUnknown(m)
}

var xxx_messageInfo_CommandSendError proto.InternalMessageInfo

func (m *CommandSendError) GetProducerId() uint64 {
	if m != nil && m.ProducerId != nil {
		return *m.ProducerId
	}
	return 0
}

func (m *CommandSendError) GetSequenceId() uint64 {
	if m != nil && m.SequenceId != nil {
		return *m.SequenceId
	}
	return 0
}

func (m *CommandSendError) GetError() ServerError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ServerError_UnknownError
}

func (m *CommandSendError) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

type CommandMessage struct {
	ConsumerId           *uint64        `protobuf:"varint,1,req,name=consumer_id" json:"consumer_id,omitempty"`
	MessageId            *MessageIdData `protobuf:"bytes,2,req,name=message_id" json:"message_id,omitempty"`
	RedeliveryCount      *uint32        `protobuf:"varint,3,opt,name=redelivery_count,def=0" json:"redelivery_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CommandMessage) Reset()         { *m = CommandMessage{} }
func (m *CommandMessage) String() string { return proto.CompactTextString(m) }
func (*CommandMessage) ProtoMessage()    {}
func (*CommandMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{24}
}
func (m *CommandMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandMessage.Merge(m, src)
}
func (m *CommandMessage) XXX_Size() int {
	return m.Size()
}
func (m *CommandMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandMessage.DiscardUnknown(m)
}

var xxx_messageInfo_CommandMessage proto.InternalMessageInfo

const Default_CommandMessage_RedeliveryCount uint32 = 0

func (m *CommandMessage) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

func (m *CommandMessage) GetMessageId() *MessageIdData {
	if m != nil {
		return m.MessageId
	}
	return nil
}

func (m *CommandMessage) GetRedeliveryCount() uint32 {
	if m != nil && m.RedeliveryCount != nil {
		return *m.RedeliveryCount
	}
	return Default_CommandMessage_RedeliveryCount
}

type CommandAck struct {
	ConsumerId *uint64             `protobuf:"varint,1,req,name=consumer_id" json:"consumer_id,omitempty"`
	AckType    *CommandAck_AckType `protobuf:"varint,2,req,name=ack_type,enum=pulsar.proto.CommandAck_AckType" json:"ack_type,omitempty"`
	// In case of individual acks, the client can pass a list of message ids
	MessageId            []*MessageIdData            `protobuf:"bytes,3,rep,name=message_id" json:"message_id,omitempty"`
	ValidationError      *CommandAck_ValidationError `protobuf:"varint,4,opt,name=validation_error,enum=pulsar.proto.CommandAck_ValidationError" json:"validation_error,omitempty"`
	Properties           []*KeyLongValue             `protobuf:"bytes,5,rep,name=properties" json:"properties,omitempty"`
	TxnidLeastBits       *uint64                     `protobuf:"varint,6,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64                     `protobuf:"varint,7,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *CommandAck) Reset()         { *m = CommandAck{} }
func (m *CommandAck) String() string { return proto.CompactTextString(m) }
func (*CommandAck) ProtoMessage()    {}
func (*CommandAck) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{25}
}
func (m *CommandAck) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandAck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandAck.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandAck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandAck.Merge(m, src)
}
func (m *CommandAck) XXX_Size() int {
	return m.Size()
}
func (m *CommandAck) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandAck.DiscardUnknown(m)
}

var xxx_messageInfo_CommandAck proto.InternalMessageInfo

const Default_CommandAck_TxnidLeastBits uint64 = 0
const Default_CommandAck_TxnidMostBits uint64 = 0

func (m *CommandAck) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

func (m *CommandAck) GetAckType() CommandAck_AckType {
	if m != nil && m.AckType != nil {
		return *m.AckType
	}
	return CommandAck_Individual
}

func (m *CommandAck) GetMessageId() []*MessageIdData {
	if m != nil {
		return m.MessageId
	}
	return nil
}

func (m *CommandAck) GetValidationError() CommandAck_ValidationError {
	if m != nil && m.ValidationError != nil {
		return *m.ValidationError
	}
	return CommandAck_UncompressedSizeCorruption
}

func (m *CommandAck) GetProperties() []*KeyLongValue {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *CommandAck) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandAck_TxnidLeastBits
}

func (m *CommandAck) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandAck_TxnidMostBits
}

type CommandAckResponse struct {
	ConsumerId           *uint64      `protobuf:"varint,1,req,name=consumer_id" json:"consumer_id,omitempty"`
	TxnidLeastBits       *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	Error                *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message              *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommandAckResponse) Reset()         { *m = CommandAckResponse{} }
func (m *CommandAckResponse) String() string { return proto.CompactTextString(m) }
func (*CommandAckResponse) ProtoMessage()    {}
func (*CommandAckResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{26}
}
func (m *CommandAckResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandAckResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandAckResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandAckResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandAckResponse.Merge(m, src)
}
func (m *CommandAckResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandAckResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandAckResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandAckResponse proto.InternalMessageInfo

const Default_CommandAckResponse_TxnidLeastBits uint64 = 0
const Default_CommandAckResponse_TxnidMostBits uint64 = 0

func (m *CommandAckResponse) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

func (m *CommandAckResponse) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandAckResponse_TxnidLeastBits
}

func (m *CommandAckResponse) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandAckResponse_TxnidMostBits
}

func (m *CommandAckResponse) GetError() ServerError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ServerError_UnknownError
}

func (m *CommandAckResponse) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// changes on active consumer
type CommandActiveConsumerChange struct {
	ConsumerId           *uint64  `protobuf:"varint,1,req,name=consumer_id" json:"consumer_id,omitempty"`
	IsActive             *bool    `protobuf:"varint,2,opt,name=is_active,def=0" json:"is_active,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandActiveConsumerChange) Reset()         { *m = CommandActiveConsumerChange{} }
func (m *CommandActiveConsumerChange) String() string { return proto.CompactTextString(m) }
func (*CommandActiveConsumerChange) ProtoMessage()    {}
func (*CommandActiveConsumerChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{27}
}
func (m *CommandActiveConsumerChange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandActiveConsumerChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandActiveConsumerChange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandActiveConsumerChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandActiveConsumerChange.Merge(m, src)
}
func (m *CommandActiveConsumerChange) XXX_Size() int {
	return m.Size()
}
func (m *CommandActiveConsumerChange) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandActiveConsumerChange.DiscardUnknown(m)
}

var xxx_messageInfo_CommandActiveConsumerChange proto.InternalMessageInfo

const Default_CommandActiveConsumerChange_IsActive bool = false

func (m *CommandActiveConsumerChange) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

func (m *CommandActiveConsumerChange) GetIsActive() bool {
	if m != nil && m.IsActive != nil {
		return *m.IsActive
	}
	return Default_CommandActiveConsumerChange_IsActive
}

type CommandFlow struct {
	ConsumerId *uint64 `protobuf:"varint,1,req,name=consumer_id" json:"consumer_id,omitempty"`
	// Max number of messages to prefetch, in addition
	// of any number previously specified
	MessagePermits       *uint32  `protobuf:"varint,2,req,name=messagePermits" json:"messagePermits,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandFlow) Reset()         { *m = CommandFlow{} }
func (m *CommandFlow) String() string { return proto.CompactTextString(m) }
func (*CommandFlow) ProtoMessage()    {}
func (*CommandFlow) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{28}
}
func (m *CommandFlow) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandFlow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandFlow.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandFlow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandFlow.Merge(m, src)
}
func (m *CommandFlow) XXX_Size() int {
	return m.Size()
}
func (m *CommandFlow) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandFlow.DiscardUnknown(m)
}

var xxx_messageInfo_CommandFlow proto.InternalMessageInfo

func (m *CommandFlow) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

func (m *CommandFlow) GetMessagePermits() uint32 {
	if m != nil && m.MessagePermits != nil {
		return *m.MessagePermits
	}
	return 0
}

type CommandUnsubscribe struct {
	ConsumerId           *uint64  `protobuf:"varint,1,req,name=consumer_id" json:"consumer_id,omitempty"`
	RequestId            *uint64  `protobuf:"varint,2,req,name=request_id" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandUnsubscribe) Reset()         { *m = CommandUnsubscribe{} }
func (m *CommandUnsubscribe) String() string { return proto.CompactTextString(m) }
func (*CommandUnsubscribe) ProtoMessage()    {}
func (*CommandUnsubscribe) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{29}
}
func (m *CommandUnsubscribe) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandUnsubscribe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandUnsubscribe.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandUnsubscribe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandUnsubscribe.Merge(m, src)
}
func (m *CommandUnsubscribe) XXX_Size() int {
	return m.Size()
}
func (m *CommandUnsubscribe) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandUnsubscribe.DiscardUnknown(m)
}

var xxx_messageInfo_CommandUnsubscribe proto.InternalMessageInfo

func (m *CommandUnsubscribe) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

func (m *CommandUnsubscribe) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

// Reset an existing consumer to a particular message id
type CommandSeek struct {
	ConsumerId           *uint64        `protobuf:"varint,1,req,name=consumer_id" json:"consumer_id,omitempty"`
	RequestId            *uint64        `protobuf:"varint,2,req,name=request_id" json:"request_id,omitempty"`
	MessageId            *MessageIdData `protobuf:"bytes,3,opt,name=message_id" json:"message_id,omitempty"`
	MessagePublishTime   *uint64        `protobuf:"varint,4,opt,name=message_publish_time" json:"message_publish_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CommandSeek) Reset()         { *m = CommandSeek{} }
func (m *CommandSeek) String() string { return proto.CompactTextString(m) }
func (*CommandSeek) ProtoMessage()    {}
func (*CommandSeek) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{30}
}
func (m *CommandSeek) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandSeek) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandSeek.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandSeek) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandSeek.Merge(m, src)
}
func (m *CommandSeek) XXX_Size() int {
	return m.Size()
}
func (m *CommandSeek) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandSeek.DiscardUnknown(m)
}

var xxx_messageInfo_CommandSeek proto.InternalMessageInfo

func (m *CommandSeek) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

func (m *CommandSeek) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandSeek) GetMessageId() *MessageIdData {
	if m != nil {
		return m.MessageId
	}
	return nil
}

func (m *CommandSeek) GetMessagePublishTime() uint64 {
	if m != nil && m.MessagePublishTime != nil {
		return *m.MessagePublishTime
	}
	return 0
}

// Message sent by broker to client when a topic
// has been forcefully terminated and there are no more
// messages left to consume
type CommandReachedEndOfTopic struct {
	ConsumerId           *uint64  `protobuf:"varint,1,req,name=consumer_id" json:"consumer_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandReachedEndOfTopic) Reset()         { *m = CommandReachedEndOfTopic{} }
func (m *CommandReachedEndOfTopic) String() string { return proto.CompactTextString(m) }
func (*CommandReachedEndOfTopic) ProtoMessage()    {}
func (*CommandReachedEndOfTopic) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{31}
}
func (m *CommandReachedEndOfTopic) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandReachedEndOfTopic) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandReachedEndOfTopic.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandReachedEndOfTopic) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandReachedEndOfTopic.Merge(m, src)
}
func (m *CommandReachedEndOfTopic) XXX_Size() int {
	return m.Size()
}
func (m *CommandReachedEndOfTopic) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandReachedEndOfTopic.DiscardUnknown(m)
}

var xxx_messageInfo_CommandReachedEndOfTopic proto.InternalMessageInfo

func (m *CommandReachedEndOfTopic) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

type CommandCloseProducer struct {
	ProducerId           *uint64  `protobuf:"varint,1,req,name=producer_id" json:"producer_id,omitempty"`
	RequestId            *uint64  `protobuf:"varint,2,req,name=request_id" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandCloseProducer) Reset()         { *m = CommandCloseProducer{} }
func (m *CommandCloseProducer) String() string { return proto.CompactTextString(m) }
func (*CommandCloseProducer) ProtoMessage()    {}
func (*CommandCloseProducer) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{32}
}
func (m *CommandCloseProducer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandCloseProducer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandCloseProducer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandCloseProducer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandCloseProducer.Merge(m, src)
}
func (m *CommandCloseProducer) XXX_Size() int {
	return m.Size()
}
func (m *CommandCloseProducer) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandCloseProducer.DiscardUnknown(m)
}

var xxx_messageInfo_CommandCloseProducer proto.InternalMessageInfo

func (m *CommandCloseProducer) GetProducerId() uint64 {
	if m != nil && m.ProducerId != nil {
		return *m.ProducerId
	}
	return 0
}

func (m *CommandCloseProducer) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

type CommandCloseConsumer struct {
	ConsumerId           *uint64  `protobuf:"varint,1,req,name=consumer_id" json:"consumer_id,omitempty"`
	RequestId            *uint64  `protobuf:"varint,2,req,name=request_id" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandCloseConsumer) Reset()         { *m = CommandCloseConsumer{} }
func (m *CommandCloseConsumer) String() string { return proto.CompactTextString(m) }
func (*CommandCloseConsumer) ProtoMessage()    {}
func (*CommandCloseConsumer) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{33}
}
func (m *CommandCloseConsumer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandCloseConsumer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandCloseConsumer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandCloseConsumer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandCloseConsumer.Merge(m, src)
}
func (m *CommandCloseConsumer) XXX_Size() int {
	return m.Size()
}
func (m *CommandCloseConsumer) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandCloseConsumer.DiscardUnknown(m)
}

var xxx_messageInfo_CommandCloseConsumer proto.InternalMessageInfo

func (m *CommandCloseConsumer) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

func (m *CommandCloseConsumer) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

type CommandRedeliverUnacknowledgedMessages struct {
	ConsumerId           *uint64          `protobuf:"varint,1,req,name=consumer_id" json:"consumer_id,omitempty"`
	MessageIds           []*MessageIdData `protobuf:"bytes,2,rep,name=message_ids" json:"message_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *CommandRedeliverUnacknowledgedMessages) Reset() {
	*m = CommandRedeliverUnacknowledgedMessages{}
}
func (m *CommandRedeliverUnacknowledgedMessages) String() string { return proto.CompactTextString(m) }
func (*CommandRedeliverUnacknowledgedMessages) ProtoMessage()    {}
func (*CommandRedeliverUnacknowledgedMessages) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{34}
}
func (m *CommandRedeliverUnacknowledgedMessages) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandRedeliverUnacknowledgedMessages) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandRedeliverUnacknowledgedMessages.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandRedeliverUnacknowledgedMessages) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandRedeliverUnacknowledgedMessages.Merge(m, src)
}
func (m *CommandRedeliverUnacknowledgedMessages) XXX_Size() int {
	return m.Size()
}
func (m *CommandRedeliverUnacknowledgedMessages) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandRedeliverUnacknowledgedMessages.DiscardUnknown(m)
}

var xxx_messageInfo_CommandRedeliverUnacknowledgedMessages proto.InternalMessageInfo

func (m *CommandRedeliverUnacknowledgedMessages) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

func (m *CommandRedeliverUnacknowledgedMessages) GetMessageIds() []*MessageIdData {
	if m != nil {
		return m.MessageIds
	}
	return nil
}

type CommandSuccess struct {
	RequestId            *uint64  `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	Schema               *Schema  `protobuf:"bytes,2,opt,name=schema" json:"schema,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandSuccess) Reset()         { *m = CommandSuccess{} }
func (m *CommandSuccess) String() string { return proto.CompactTextString(m) }
func (*CommandSuccess) ProtoMessage()    {}
func (*CommandSuccess) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{35}
}
func (m *CommandSuccess) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandSuccess) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandSuccess.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandSuccess) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandSuccess.Merge(m, src)
}
func (m *CommandSuccess) XXX_Size() int {
	return m.Size()
}
func (m *CommandSuccess) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandSuccess.DiscardUnknown(m)
}

var xxx_messageInfo_CommandSuccess proto.InternalMessageInfo

func (m *CommandSuccess) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandSuccess) GetSchema() *Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

/// Response from CommandProducer
type CommandProducerSuccess struct {
	RequestId    *uint64 `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	ProducerName *string `protobuf:"bytes,2,req,name=producer_name" json:"producer_name,omitempty"`
	// The last sequence id that was stored by this producer in the previous session
	// This will only be meaningful if deduplication has been enabled.
	LastSequenceId       *int64   `protobuf:"varint,3,opt,name=last_sequence_id,def=-1" json:"last_sequence_id,omitempty"`
	SchemaVersion        []byte   `protobuf:"bytes,4,opt,name=schema_version" json:"schema_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandProducerSuccess) Reset()         { *m = CommandProducerSuccess{} }
func (m *CommandProducerSuccess) String() string { return proto.CompactTextString(m) }
func (*CommandProducerSuccess) ProtoMessage()    {}
func (*CommandProducerSuccess) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{36}
}
func (m *CommandProducerSuccess) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandProducerSuccess) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandProducerSuccess.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandProducerSuccess) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandProducerSuccess.Merge(m, src)
}
func (m *CommandProducerSuccess) XXX_Size() int {
	return m.Size()
}
func (m *CommandProducerSuccess) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandProducerSuccess.DiscardUnknown(m)
}

var xxx_messageInfo_CommandProducerSuccess proto.InternalMessageInfo

const Default_CommandProducerSuccess_LastSequenceId int64 = -1

func (m *CommandProducerSuccess) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandProducerSuccess) GetProducerName() string {
	if m != nil && m.ProducerName != nil {
		return *m.ProducerName
	}
	return ""
}

func (m *CommandProducerSuccess) GetLastSequenceId() int64 {
	if m != nil && m.LastSequenceId != nil {
		return *m.LastSequenceId
	}
	return Default_CommandProducerSuccess_LastSequenceId
}

func (m *CommandProducerSuccess) GetSchemaVersion() []byte {
	if m != nil {
		return m.SchemaVersion
	}
	return nil
}

type CommandError struct {
	RequestId            *uint64      `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	Error                *ServerError `protobuf:"varint,2,req,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message              *string      `protobuf:"bytes,3,req,name=message" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommandError) Reset()         { *m = CommandError{} }
func (m *CommandError) String() string { return proto.CompactTextString(m) }
func (*CommandError) ProtoMessage()    {}
func (*CommandError) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{37}
}
func (m *CommandError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandError.Merge(m, src)
}
func (m *CommandError) XXX_Size() int {
	return m.Size()
}
func (m *CommandError) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandError.DiscardUnknown(m)
}

var xxx_messageInfo_CommandError proto.InternalMessageInfo

func (m *CommandError) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandError) GetError() ServerError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ServerError_UnknownError
}

func (m *CommandError) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// Commands to probe the state of connection.
// When either client or broker doesn't receive commands for certain
// amount of time, they will send a Ping probe.
type CommandPing struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandPing) Reset()         { *m = CommandPing{} }
func (m *CommandPing) String() string { return proto.CompactTextString(m) }
func (*CommandPing) ProtoMessage()    {}
func (*CommandPing) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{38}
}
func (m *CommandPing) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandPing) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandPing.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandPing) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandPing.Merge(m, src)
}
func (m *CommandPing) XXX_Size() int {
	return m.Size()
}
func (m *CommandPing) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandPing.DiscardUnknown(m)
}

var xxx_messageInfo_CommandPing proto.InternalMessageInfo

type CommandPong struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandPong) Reset()         { *m = CommandPong{} }
func (m *CommandPong) String() string { return proto.CompactTextString(m) }
func (*CommandPong) ProtoMessage()    {}
func (*CommandPong) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{39}
}
func (m *CommandPong) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandPong) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandPong.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandPong) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandPong.Merge(m, src)
}
func (m *CommandPong) XXX_Size() int {
	return m.Size()
}
func (m *CommandPong) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandPong.DiscardUnknown(m)
}

var xxx_messageInfo_CommandPong proto.InternalMessageInfo

type CommandConsumerStats struct {
	RequestId *uint64 `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	// required string topic_name         = 2;
	// required string subscription_name  = 3;
	ConsumerId           *uint64  `protobuf:"varint,4,req,name=consumer_id" json:"consumer_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandConsumerStats) Reset()         { *m = CommandConsumerStats{} }
func (m *CommandConsumerStats) String() string { return proto.CompactTextString(m) }
func (*CommandConsumerStats) ProtoMessage()    {}
func (*CommandConsumerStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{40}
}
func (m *CommandConsumerStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandConsumerStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandConsumerStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandConsumerStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandConsumerStats.Merge(m, src)
}
func (m *CommandConsumerStats) XXX_Size() int {
	return m.Size()
}
func (m *CommandConsumerStats) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandConsumerStats.DiscardUnknown(m)
}

var xxx_messageInfo_CommandConsumerStats proto.InternalMessageInfo

func (m *CommandConsumerStats) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandConsumerStats) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

type CommandConsumerStatsResponse struct {
	RequestId    *uint64      `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	ErrorCode    *ServerError `protobuf:"varint,2,opt,name=error_code,enum=pulsar.proto.ServerError" json:"error_code,omitempty"`
	ErrorMessage *string      `protobuf:"bytes,3,opt,name=error_message" json:"error_message,omitempty"`
	/// Total rate of messages delivered to the consumer. msg/s
	MsgRateOut *float64 `protobuf:"fixed64,4,opt,name=msgRateOut" json:"msgRateOut,omitempty"`
	/// Total throughput delivered to the consumer. bytes/s
	MsgThroughputOut *float64 `protobuf:"fixed64,5,opt,name=msgThroughputOut" json:"msgThroughputOut,omitempty"`
	/// Total rate of messages redelivered by this consumer. msg/s
	MsgRateRedeliver *float64 `protobuf:"fixed64,6,opt,name=msgRateRedeliver" json:"msgRateRedeliver,omitempty"`
	/// Name of the consumer
	ConsumerName *string `protobuf:"bytes,7,opt,name=consumerName" json:"consumerName,omitempty"`
	/// Number of available message permits for the consumer
	AvailablePermits *uint64 `protobuf:"varint,8,opt,name=availablePermits" json:"availablePermits,omitempty"`
	/// Number of unacknowledged messages for the consumer
	UnackedMessages *uint64 `protobuf:"varint,9,opt,name=unackedMessages" json:"unackedMessages,omitempty"`
	/// Flag to verify if consumer is blocked due to reaching threshold of unacked messages
	BlockedConsumerOnUnackedMsgs *bool `protobuf:"varint,10,opt,name=blockedConsumerOnUnackedMsgs" json:"blockedConsumerOnUnackedMsgs,omitempty"`
	/// Address of this consumer
	Address *string `protobuf:"bytes,11,opt,name=address" json:"address,omitempty"`
	/// Timestamp of connection
	ConnectedSince *string `protobuf:"bytes,12,opt,name=connectedSince" json:"connectedSince,omitempty"`
	/// Whether this subscription is Exclusive or Shared or Failover
	Type *string `protobuf:"bytes,13,opt,name=type" json:"type,omitempty"`
	/// Total rate of messages expired on this subscription. msg/s
	MsgRateExpired *float64 `protobuf:"fixed64,14,opt,name=msgRateExpired" json:"msgRateExpired,omitempty"`
	/// Number of messages in the subscription backlog
	MsgBacklog           *uint64  `protobuf:"varint,15,opt,name=msgBacklog" json:"msgBacklog,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandConsumerStatsResponse) Reset()         { *m = CommandConsumerStatsResponse{} }
func (m *CommandConsumerStatsResponse) String() string { return proto.CompactTextString(m) }
func (*CommandConsumerStatsResponse) ProtoMessage()    {}
func (*CommandConsumerStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{41}
}
func (m *CommandConsumerStatsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandConsumerStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandConsumerStatsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandConsumerStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandConsumerStatsResponse.Merge(m, src)
}
func (m *CommandConsumerStatsResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandConsumerStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandConsumerStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandConsumerStatsResponse proto.InternalMessageInfo

func (m *CommandConsumerStatsResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandConsumerStatsResponse) GetErrorCode() ServerError {
	if m != nil && m.ErrorCode != nil {
		return *m.ErrorCode
	}
	return ServerError_UnknownError
}

func (m *CommandConsumerStatsResponse) GetErrorMessage() string {
	if m != nil && m.ErrorMessage != nil {
		return *m.ErrorMessage
	}
	return ""
}

func (m *CommandConsumerStatsResponse) GetMsgRateOut() float64 {
	if m != nil && m.MsgRateOut != nil {
		return *m.MsgRateOut
	}
	return 0
}

func (m *CommandConsumerStatsResponse) GetMsgThroughputOut() float64 {
	if m != nil && m.MsgThroughputOut != nil {
		return *m.MsgThroughputOut
	}
	return 0
}

func (m *CommandConsumerStatsResponse) GetMsgRateRedeliver() float64 {
	if m != nil && m.MsgRateRedeliver != nil {
		return *m.MsgRateRedeliver
	}
	return 0
}

func (m *CommandConsumerStatsResponse) GetConsumerName() string {
	if m != nil && m.ConsumerName != nil {
		return *m.ConsumerName
	}
	return ""
}

func (m *CommandConsumerStatsResponse) GetAvailablePermits() uint64 {
	if m != nil && m.AvailablePermits != nil {
		return *m.AvailablePermits
	}
	return 0
}

func (m *CommandConsumerStatsResponse) GetUnackedMessages() uint64 {
	if m != nil && m.UnackedMessages != nil {
		return *m.UnackedMessages
	}
	return 0
}

func (m *CommandConsumerStatsResponse) GetBlockedConsumerOnUnackedMsgs() bool {
	if m != nil && m.BlockedConsumerOnUnackedMsgs != nil {
		return *m.BlockedConsumerOnUnackedMsgs
	}
	return false
}

func (m *CommandConsumerStatsResponse) GetAddress() string {
	if m != nil && m.Address != nil {
		return *m.Address
	}
	return ""
}

func (m *CommandConsumerStatsResponse) GetConnectedSince() string {
	if m != nil && m.ConnectedSince != nil {
		return *m.ConnectedSince
	}
	return ""
}

func (m *CommandConsumerStatsResponse) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *CommandConsumerStatsResponse) GetMsgRateExpired() float64 {
	if m != nil && m.MsgRateExpired != nil {
		return *m.MsgRateExpired
	}
	return 0
}

func (m *CommandConsumerStatsResponse) GetMsgBacklog() uint64 {
	if m != nil && m.MsgBacklog != nil {
		return *m.MsgBacklog
	}
	return 0
}

type CommandGetLastMessageId struct {
	ConsumerId           *uint64  `protobuf:"varint,1,req,name=consumer_id" json:"consumer_id,omitempty"`
	RequestId            *uint64  `protobuf:"varint,2,req,name=request_id" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandGetLastMessageId) Reset()         { *m = CommandGetLastMessageId{} }
func (m *CommandGetLastMessageId) String() string { return proto.CompactTextString(m) }
func (*CommandGetLastMessageId) ProtoMessage()    {}
func (*CommandGetLastMessageId) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{42}
}
func (m *CommandGetLastMessageId) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandGetLastMessageId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandGetLastMessageId.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandGetLastMessageId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandGetLastMessageId.Merge(m, src)
}
func (m *CommandGetLastMessageId) XXX_Size() int {
	return m.Size()
}
func (m *CommandGetLastMessageId) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandGetLastMessageId.DiscardUnknown(m)
}

var xxx_messageInfo_CommandGetLastMessageId proto.InternalMessageInfo

func (m *CommandGetLastMessageId) GetConsumerId() uint64 {
	if m != nil && m.ConsumerId != nil {
		return *m.ConsumerId
	}
	return 0
}

func (m *CommandGetLastMessageId) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

type CommandGetLastMessageIdResponse struct {
	LastMessageId        *MessageIdData `protobuf:"bytes,1,req,name=last_message_id" json:"last_message_id,omitempty"`
	RequestId            *uint64        `protobuf:"varint,2,req,name=request_id" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CommandGetLastMessageIdResponse) Reset()         { *m = CommandGetLastMessageIdResponse{} }
func (m *CommandGetLastMessageIdResponse) String() string { return proto.CompactTextString(m) }
func (*CommandGetLastMessageIdResponse) ProtoMessage()    {}
func (*CommandGetLastMessageIdResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{43}
}
func (m *CommandGetLastMessageIdResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandGetLastMessageIdResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandGetLastMessageIdResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandGetLastMessageIdResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandGetLastMessageIdResponse.Merge(m, src)
}
func (m *CommandGetLastMessageIdResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandGetLastMessageIdResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandGetLastMessageIdResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandGetLastMessageIdResponse proto.InternalMessageInfo

func (m *CommandGetLastMessageIdResponse) GetLastMessageId() *MessageIdData {
	if m != nil {
		return m.LastMessageId
	}
	return nil
}

func (m *CommandGetLastMessageIdResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

type CommandGetTopicsOfNamespace struct {
	RequestId            *uint64                           `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	Namespace            *string                           `protobuf:"bytes,2,req,name=namespace" json:"namespace,omitempty"`
	Mode                 *CommandGetTopicsOfNamespace_Mode `protobuf:"varint,3,opt,name=mode,enum=pulsar.proto.CommandGetTopicsOfNamespace_Mode,def=0" json:"mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *CommandGetTopicsOfNamespace) Reset()         { *m = CommandGetTopicsOfNamespace{} }
func (m *CommandGetTopicsOfNamespace) String() string { return proto.CompactTextString(m) }
func (*CommandGetTopicsOfNamespace) ProtoMessage()    {}
func (*CommandGetTopicsOfNamespace) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{44}
}
func (m *CommandGetTopicsOfNamespace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandGetTopicsOfNamespace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandGetTopicsOfNamespace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandGetTopicsOfNamespace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandGetTopicsOfNamespace.Merge(m, src)
}
func (m *CommandGetTopicsOfNamespace) XXX_Size() int {
	return m.Size()
}
func (m *CommandGetTopicsOfNamespace) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandGetTopicsOfNamespace.DiscardUnknown(m)
}

var xxx_messageInfo_CommandGetTopicsOfNamespace proto.InternalMessageInfo

const Default_CommandGetTopicsOfNamespace_Mode CommandGetTopicsOfNamespace_Mode = CommandGetTopicsOfNamespace_PERSISTENT

func (m *CommandGetTopicsOfNamespace) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandGetTopicsOfNamespace) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *CommandGetTopicsOfNamespace) GetMode() CommandGetTopicsOfNamespace_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return Default_CommandGetTopicsOfNamespace_Mode
}

type CommandGetTopicsOfNamespaceResponse struct {
	RequestId            *uint64  `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	Topics               []string `protobuf:"bytes,2,rep,name=topics" json:"topics,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandGetTopicsOfNamespaceResponse) Reset()         { *m = CommandGetTopicsOfNamespaceResponse{} }
func (m *CommandGetTopicsOfNamespaceResponse) String() string { return proto.CompactTextString(m) }
func (*CommandGetTopicsOfNamespaceResponse) ProtoMessage()    {}
func (*CommandGetTopicsOfNamespaceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{45}
}
func (m *CommandGetTopicsOfNamespaceResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandGetTopicsOfNamespaceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandGetTopicsOfNamespaceResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandGetTopicsOfNamespaceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandGetTopicsOfNamespaceResponse.Merge(m, src)
}
func (m *CommandGetTopicsOfNamespaceResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandGetTopicsOfNamespaceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandGetTopicsOfNamespaceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandGetTopicsOfNamespaceResponse proto.InternalMessageInfo

func (m *CommandGetTopicsOfNamespaceResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandGetTopicsOfNamespaceResponse) GetTopics() []string {
	if m != nil {
		return m.Topics
	}
	return nil
}

type CommandGetSchema struct {
	RequestId            *uint64  `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	Topic                *string  `protobuf:"bytes,2,req,name=topic" json:"topic,omitempty"`
	SchemaVersion        []byte   `protobuf:"bytes,3,opt,name=schema_version" json:"schema_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandGetSchema) Reset()         { *m = CommandGetSchema{} }
func (m *CommandGetSchema) String() string { return proto.CompactTextString(m) }
func (*CommandGetSchema) ProtoMessage()    {}
func (*CommandGetSchema) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{46}
}
func (m *CommandGetSchema) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandGetSchema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandGetSchema.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandGetSchema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandGetSchema.Merge(m, src)
}
func (m *CommandGetSchema) XXX_Size() int {
	return m.Size()
}
func (m *CommandGetSchema) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandGetSchema.DiscardUnknown(m)
}

var xxx_messageInfo_CommandGetSchema proto.InternalMessageInfo

func (m *CommandGetSchema) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandGetSchema) GetTopic() string {
	if m != nil && m.Topic != nil {
		return *m.Topic
	}
	return ""
}

func (m *CommandGetSchema) GetSchemaVersion() []byte {
	if m != nil {
		return m.SchemaVersion
	}
	return nil
}

type CommandGetSchemaResponse struct {
	RequestId            *uint64      `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	ErrorCode            *ServerError `protobuf:"varint,2,opt,name=error_code,enum=pulsar.proto.ServerError" json:"error_code,omitempty"`
	ErrorMessage         *string      `protobuf:"bytes,3,opt,name=error_message" json:"error_message,omitempty"`
	Schema               *Schema      `protobuf:"bytes,4,opt,name=schema" json:"schema,omitempty"`
	SchemaVersion        []byte       `protobuf:"bytes,5,opt,name=schema_version" json:"schema_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommandGetSchemaResponse) Reset()         { *m = CommandGetSchemaResponse{} }
func (m *CommandGetSchemaResponse) String() string { return proto.CompactTextString(m) }
func (*CommandGetSchemaResponse) ProtoMessage()    {}
func (*CommandGetSchemaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{47}
}
func (m *CommandGetSchemaResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandGetSchemaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandGetSchemaResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandGetSchemaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandGetSchemaResponse.Merge(m, src)
}
func (m *CommandGetSchemaResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandGetSchemaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandGetSchemaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandGetSchemaResponse proto.InternalMessageInfo

func (m *CommandGetSchemaResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandGetSchemaResponse) GetErrorCode() ServerError {
	if m != nil && m.ErrorCode != nil {
		return *m.ErrorCode
	}
	return ServerError_UnknownError
}

func (m *CommandGetSchemaResponse) GetErrorMessage() string {
	if m != nil && m.ErrorMessage != nil {
		return *m.ErrorMessage
	}
	return ""
}

func (m *CommandGetSchemaResponse) GetSchema() *Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *CommandGetSchemaResponse) GetSchemaVersion() []byte {
	if m != nil {
		return m.SchemaVersion
	}
	return nil
}

type CommandGetOrCreateSchema struct {
	RequestId            *uint64  `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	Topic                *string  `protobuf:"bytes,2,req,name=topic" json:"topic,omitempty"`
	Schema               *Schema  `protobuf:"bytes,3,req,name=schema" json:"schema,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandGetOrCreateSchema) Reset()         { *m = CommandGetOrCreateSchema{} }
func (m *CommandGetOrCreateSchema) String() string { return proto.CompactTextString(m) }
func (*CommandGetOrCreateSchema) ProtoMessage()    {}
func (*CommandGetOrCreateSchema) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{48}
}
func (m *CommandGetOrCreateSchema) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandGetOrCreateSchema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandGetOrCreateSchema.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandGetOrCreateSchema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandGetOrCreateSchema.Merge(m, src)
}
func (m *CommandGetOrCreateSchema) XXX_Size() int {
	return m.Size()
}
func (m *CommandGetOrCreateSchema) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandGetOrCreateSchema.DiscardUnknown(m)
}

var xxx_messageInfo_CommandGetOrCreateSchema proto.InternalMessageInfo

func (m *CommandGetOrCreateSchema) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandGetOrCreateSchema) GetTopic() string {
	if m != nil && m.Topic != nil {
		return *m.Topic
	}
	return ""
}

func (m *CommandGetOrCreateSchema) GetSchema() *Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

type CommandGetOrCreateSchemaResponse struct {
	RequestId            *uint64      `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	ErrorCode            *ServerError `protobuf:"varint,2,opt,name=error_code,enum=pulsar.proto.ServerError" json:"error_code,omitempty"`
	ErrorMessage         *string      `protobuf:"bytes,3,opt,name=error_message" json:"error_message,omitempty"`
	SchemaVersion        []byte       `protobuf:"bytes,4,opt,name=schema_version" json:"schema_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommandGetOrCreateSchemaResponse) Reset()         { *m = CommandGetOrCreateSchemaResponse{} }
func (m *CommandGetOrCreateSchemaResponse) String() string { return proto.CompactTextString(m) }
func (*CommandGetOrCreateSchemaResponse) ProtoMessage()    {}
func (*CommandGetOrCreateSchemaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{49}
}
func (m *CommandGetOrCreateSchemaResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandGetOrCreateSchemaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandGetOrCreateSchemaResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandGetOrCreateSchemaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandGetOrCreateSchemaResponse.Merge(m, src)
}
func (m *CommandGetOrCreateSchemaResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandGetOrCreateSchemaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandGetOrCreateSchemaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandGetOrCreateSchemaResponse proto.InternalMessageInfo

func (m *CommandGetOrCreateSchemaResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandGetOrCreateSchemaResponse) GetErrorCode() ServerError {
	if m != nil && m.ErrorCode != nil {
		return *m.ErrorCode
	}
	return ServerError_UnknownError
}

func (m *CommandGetOrCreateSchemaResponse) GetErrorMessage() string {
	if m != nil && m.ErrorMessage != nil {
		return *m.ErrorMessage
	}
	return ""
}

func (m *CommandGetOrCreateSchemaResponse) GetSchemaVersion() []byte {
	if m != nil {
		return m.SchemaVersion
	}
	return nil
}

type CommandNewTxn struct {
	RequestId            *uint64  `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnTtlSeconds        *uint64  `protobuf:"varint,2,opt,name=txn_ttl_seconds,def=0" json:"txn_ttl_seconds,omitempty"`
	TcId                 *uint64  `protobuf:"varint,3,opt,name=tc_id,def=0" json:"tc_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandNewTxn) Reset()         { *m = CommandNewTxn{} }
func (m *CommandNewTxn) String() string { return proto.CompactTextString(m) }
func (*CommandNewTxn) ProtoMessage()    {}
func (*CommandNewTxn) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{50}
}
func (m *CommandNewTxn) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandNewTxn) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandNewTxn.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandNewTxn) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandNewTxn.Merge(m, src)
}
func (m *CommandNewTxn) XXX_Size() int {
	return m.Size()
}
func (m *CommandNewTxn) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandNewTxn.DiscardUnknown(m)
}

var xxx_messageInfo_CommandNewTxn proto.InternalMessageInfo

const Default_CommandNewTxn_TxnTtlSeconds uint64 = 0
const Default_CommandNewTxn_TcId uint64 = 0

func (m *CommandNewTxn) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandNewTxn) GetTxnTtlSeconds() uint64 {
	if m != nil && m.TxnTtlSeconds != nil {
		return *m.TxnTtlSeconds
	}
	return Default_CommandNewTxn_TxnTtlSeconds
}

func (m *CommandNewTxn) GetTcId() uint64 {
	if m != nil && m.TcId != nil {
		return *m.TcId
	}
	return Default_CommandNewTxn_TcId
}

type CommandNewTxnResponse struct {
	RequestId            *uint64      `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnidLeastBits       *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	Error                *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message              *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommandNewTxnResponse) Reset()         { *m = CommandNewTxnResponse{} }
func (m *CommandNewTxnResponse) String() string { return proto.CompactTextString(m) }
func (*CommandNewTxnResponse) ProtoMessage()    {}
func (*CommandNewTxnResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{51}
}
func (m *CommandNewTxnResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandNewTxnResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandNewTxnResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandNewTxnResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandNewTxnResponse.Merge(m, src)
}
func (m *CommandNewTxnResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandNewTxnResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandNewTxnResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandNewTxnResponse proto.InternalMessageInfo

const Default_CommandNewTxnResponse_TxnidLeastBits uint64 = 0
const Default_CommandNewTxnResponse_TxnidMostBits uint64 = 0

func (m *CommandNewTxnResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandNewTxnResponse) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandNewTxnResponse_TxnidLeastBits
}

func (m *CommandNewTxnResponse) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandNewTxnResponse_TxnidMostBits
}

func (m *CommandNewTxnResponse) GetError() ServerError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ServerError_UnknownError
}

func (m *CommandNewTxnResponse) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

type CommandAddPartitionToTxn struct {
	RequestId            *uint64  `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnidLeastBits       *uint64  `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64  `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	Partitions           []string `protobuf:"bytes,4,rep,name=partitions" json:"partitions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandAddPartitionToTxn) Reset()         { *m = CommandAddPartitionToTxn{} }
func (m *CommandAddPartitionToTxn) String() string { return proto.CompactTextString(m) }
func (*CommandAddPartitionToTxn) ProtoMessage()    {}
func (*CommandAddPartitionToTxn) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{52}
}
func (m *CommandAddPartitionToTxn) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandAddPartitionToTxn) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandAddPartitionToTxn.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandAddPartitionToTxn) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandAddPartitionToTxn.Merge(m, src)
}
func (m *CommandAddPartitionToTxn) XXX_Size() int {
	return m.Size()
}
func (m *CommandAddPartitionToTxn) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandAddPartitionToTxn.DiscardUnknown(m)
}

var xxx_messageInfo_CommandAddPartitionToTxn proto.InternalMessageInfo

const Default_CommandAddPartitionToTxn_TxnidLeastBits uint64 = 0
const Default_CommandAddPartitionToTxn_TxnidMostBits uint64 = 0

func (m *CommandAddPartitionToTxn) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandAddPartitionToTxn) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandAddPartitionToTxn_TxnidLeastBits
}

func (m *CommandAddPartitionToTxn) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandAddPartitionToTxn_TxnidMostBits
}

func (m *CommandAddPartitionToTxn) GetPartitions() []string {
	if m != nil {
		return m.Partitions
	}
	return nil
}

type CommandAddPartitionToTxnResponse struct {
	RequestId            *uint64      `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnidLeastBits       *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	Error                *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message              *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommandAddPartitionToTxnResponse) Reset()         { *m = CommandAddPartitionToTxnResponse{} }
func (m *CommandAddPartitionToTxnResponse) String() string { return proto.CompactTextString(m) }
func (*CommandAddPartitionToTxnResponse) ProtoMessage()    {}
func (*CommandAddPartitionToTxnResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{53}
}
func (m *CommandAddPartitionToTxnResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandAddPartitionToTxnResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandAddPartitionToTxnResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandAddPartitionToTxnResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandAddPartitionToTxnResponse.Merge(m, src)
}
func (m *CommandAddPartitionToTxnResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandAddPartitionToTxnResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandAddPartitionToTxnResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandAddPartitionToTxnResponse proto.InternalMessageInfo

const Default_CommandAddPartitionToTxnResponse_TxnidLeastBits uint64 = 0
const Default_CommandAddPartitionToTxnResponse_TxnidMostBits uint64 = 0

func (m *CommandAddPartitionToTxnResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandAddPartitionToTxnResponse) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandAddPartitionToTxnResponse_TxnidLeastBits
}

func (m *CommandAddPartitionToTxnResponse) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandAddPartitionToTxnResponse_TxnidMostBits
}

func (m *CommandAddPartitionToTxnResponse) GetError() ServerError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ServerError_UnknownError
}

func (m *CommandAddPartitionToTxnResponse) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

type Subscription struct {
	Topic                *string  `protobuf:"bytes,1,req,name=topic" json:"topic,omitempty"`
	Subscription         *string  `protobuf:"bytes,2,req,name=subscription" json:"subscription,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Subscription) Reset()         { *m = Subscription{} }
func (m *Subscription) String() string { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()    {}
func (*Subscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{54}
}
func (m *Subscription) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Subscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Subscription.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Subscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subscription.Merge(m, src)
}
func (m *Subscription) XXX_Size() int {
	return m.Size()
}
func (m *Subscription) XXX_DiscardUnknown() {
	xxx_messageInfo_Subscription.DiscardUnknown(m)
}

var xxx_messageInfo_Subscription proto.InternalMessageInfo

func (m *Subscription) GetTopic() string {
	if m != nil && m.Topic != nil {
		return *m.Topic
	}
	return ""
}

func (m *Subscription) GetSubscription() string {
	if m != nil && m.Subscription != nil {
		return *m.Subscription
	}
	return ""
}

type CommandAddSubscriptionToTxn struct {
	RequestId            *uint64         `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnidLeastBits       *uint64         `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64         `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	Subscription         []*Subscription `protobuf:"bytes,4,rep,name=subscription" json:"subscription,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CommandAddSubscriptionToTxn) Reset()         { *m = CommandAddSubscriptionToTxn{} }
func (m *CommandAddSubscriptionToTxn) String() string { return proto.CompactTextString(m) }
func (*CommandAddSubscriptionToTxn) ProtoMessage()    {}
func (*CommandAddSubscriptionToTxn) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{55}
}
func (m *CommandAddSubscriptionToTxn) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandAddSubscriptionToTxn) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandAddSubscriptionToTxn.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandAddSubscriptionToTxn) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandAddSubscriptionToTxn.Merge(m, src)
}
func (m *CommandAddSubscriptionToTxn) XXX_Size() int {
	return m.Size()
}
func (m *CommandAddSubscriptionToTxn) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandAddSubscriptionToTxn.DiscardUnknown(m)
}

var xxx_messageInfo_CommandAddSubscriptionToTxn proto.InternalMessageInfo

const Default_CommandAddSubscriptionToTxn_TxnidLeastBits uint64 = 0
const Default_CommandAddSubscriptionToTxn_TxnidMostBits uint64 = 0

func (m *CommandAddSubscriptionToTxn) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandAddSubscriptionToTxn) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandAddSubscriptionToTxn_TxnidLeastBits
}

func (m *CommandAddSubscriptionToTxn) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandAddSubscriptionToTxn_TxnidMostBits
}

func (m *CommandAddSubscriptionToTxn) GetSubscription() []*Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

type CommandAddSubscriptionToTxnResponse struct {
	RequestId            *uint64      `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnidLeastBits       *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	Error                *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message              *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommandAddSubscriptionToTxnResponse) Reset()         { *m = CommandAddSubscriptionToTxnResponse{} }
func (m *CommandAddSubscriptionToTxnResponse) String() string { return proto.CompactTextString(m) }
func (*CommandAddSubscriptionToTxnResponse) ProtoMessage()    {}
func (*CommandAddSubscriptionToTxnResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{56}
}
func (m *CommandAddSubscriptionToTxnResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandAddSubscriptionToTxnResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandAddSubscriptionToTxnResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandAddSubscriptionToTxnResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandAddSubscriptionToTxnResponse.Merge(m, src)
}
func (m *CommandAddSubscriptionToTxnResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandAddSubscriptionToTxnResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandAddSubscriptionToTxnResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandAddSubscriptionToTxnResponse proto.InternalMessageInfo

const Default_CommandAddSubscriptionToTxnResponse_TxnidLeastBits uint64 = 0
const Default_CommandAddSubscriptionToTxnResponse_TxnidMostBits uint64 = 0

func (m *CommandAddSubscriptionToTxnResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandAddSubscriptionToTxnResponse) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandAddSubscriptionToTxnResponse_TxnidLeastBits
}

func (m *CommandAddSubscriptionToTxnResponse) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandAddSubscriptionToTxnResponse_TxnidMostBits
}

func (m *CommandAddSubscriptionToTxnResponse) GetError() ServerError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ServerError_UnknownError
}

func (m *CommandAddSubscriptionToTxnResponse) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

type CommandEndTxn struct {
	RequestId            *uint64    `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnidLeastBits       *uint64    `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64    `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	TxnAction            *TxnAction `protobuf:"varint,4,opt,name=txn_action,enum=pulsar.proto.TxnAction" json:"txn_action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CommandEndTxn) Reset()         { *m = CommandEndTxn{} }
func (m *CommandEndTxn) String() string { return proto.CompactTextString(m) }
func (*CommandEndTxn) ProtoMessage()    {}
func (*CommandEndTxn) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{57}
}
func (m *CommandEndTxn) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandEndTxn) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandEndTxn.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandEndTxn) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandEndTxn.Merge(m, src)
}
func (m *CommandEndTxn) XXX_Size() int {
	return m.Size()
}
func (m *CommandEndTxn) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandEndTxn.DiscardUnknown(m)
}

var xxx_messageInfo_CommandEndTxn proto.InternalMessageInfo

const Default_CommandEndTxn_TxnidLeastBits uint64 = 0
const Default_CommandEndTxn_TxnidMostBits uint64 = 0

func (m *CommandEndTxn) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandEndTxn) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandEndTxn_TxnidLeastBits
}

func (m *CommandEndTxn) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandEndTxn_TxnidMostBits
}

func (m *CommandEndTxn) GetTxnAction() TxnAction {
	if m != nil && m.TxnAction != nil {
		return *m.TxnAction
	}
	return TxnAction_COMMIT
}

type CommandEndTxnResponse struct {
	RequestId            *uint64      `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnidLeastBits       *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	Error                *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message              *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommandEndTxnResponse) Reset()         { *m = CommandEndTxnResponse{} }
func (m *CommandEndTxnResponse) String() string { return proto.CompactTextString(m) }
func (*CommandEndTxnResponse) ProtoMessage()    {}
func (*CommandEndTxnResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{58}
}
func (m *CommandEndTxnResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandEndTxnResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandEndTxnResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandEndTxnResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandEndTxnResponse.Merge(m, src)
}
func (m *CommandEndTxnResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandEndTxnResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandEndTxnResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandEndTxnResponse proto.InternalMessageInfo

const Default_CommandEndTxnResponse_TxnidLeastBits uint64 = 0
const Default_CommandEndTxnResponse_TxnidMostBits uint64 = 0

func (m *CommandEndTxnResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandEndTxnResponse) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandEndTxnResponse_TxnidLeastBits
}

func (m *CommandEndTxnResponse) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandEndTxnResponse_TxnidMostBits
}

func (m *CommandEndTxnResponse) GetError() ServerError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ServerError_UnknownError
}

func (m *CommandEndTxnResponse) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

type CommandEndTxnOnPartition struct {
	RequestId            *uint64    `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnidLeastBits       *uint64    `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64    `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	Topic                *string    `protobuf:"bytes,4,opt,name=topic" json:"topic,omitempty"`
	TxnAction            *TxnAction `protobuf:"varint,5,opt,name=txn_action,enum=pulsar.proto.TxnAction" json:"txn_action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CommandEndTxnOnPartition) Reset()         { *m = CommandEndTxnOnPartition{} }
func (m *CommandEndTxnOnPartition) String() string { return proto.CompactTextString(m) }
func (*CommandEndTxnOnPartition) ProtoMessage()    {}
func (*CommandEndTxnOnPartition) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{59}
}
func (m *CommandEndTxnOnPartition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandEndTxnOnPartition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandEndTxnOnPartition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandEndTxnOnPartition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandEndTxnOnPartition.Merge(m, src)
}
func (m *CommandEndTxnOnPartition) XXX_Size() int {
	return m.Size()
}
func (m *CommandEndTxnOnPartition) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandEndTxnOnPartition.DiscardUnknown(m)
}

var xxx_messageInfo_CommandEndTxnOnPartition proto.InternalMessageInfo

const Default_CommandEndTxnOnPartition_TxnidLeastBits uint64 = 0
const Default_CommandEndTxnOnPartition_TxnidMostBits uint64 = 0

func (m *CommandEndTxnOnPartition) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandEndTxnOnPartition) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandEndTxnOnPartition_TxnidLeastBits
}

func (m *CommandEndTxnOnPartition) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandEndTxnOnPartition_TxnidMostBits
}

func (m *CommandEndTxnOnPartition) GetTopic() string {
	if m != nil && m.Topic != nil {
		return *m.Topic
	}
	return ""
}

func (m *CommandEndTxnOnPartition) GetTxnAction() TxnAction {
	if m != nil && m.TxnAction != nil {
		return *m.TxnAction
	}
	return TxnAction_COMMIT
}

type CommandEndTxnOnPartitionResponse struct {
	RequestId            *uint64      `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnidLeastBits       *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	Error                *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message              *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommandEndTxnOnPartitionResponse) Reset()         { *m = CommandEndTxnOnPartitionResponse{} }
func (m *CommandEndTxnOnPartitionResponse) String() string { return proto.CompactTextString(m) }
func (*CommandEndTxnOnPartitionResponse) ProtoMessage()    {}
func (*CommandEndTxnOnPartitionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{60}
}
func (m *CommandEndTxnOnPartitionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandEndTxnOnPartitionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandEndTxnOnPartitionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandEndTxnOnPartitionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandEndTxnOnPartitionResponse.Merge(m, src)
}
func (m *CommandEndTxnOnPartitionResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandEndTxnOnPartitionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandEndTxnOnPartitionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandEndTxnOnPartitionResponse proto.InternalMessageInfo

const Default_CommandEndTxnOnPartitionResponse_TxnidLeastBits uint64 = 0
const Default_CommandEndTxnOnPartitionResponse_TxnidMostBits uint64 = 0

func (m *CommandEndTxnOnPartitionResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandEndTxnOnPartitionResponse) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandEndTxnOnPartitionResponse_TxnidLeastBits
}

func (m *CommandEndTxnOnPartitionResponse) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandEndTxnOnPartitionResponse_TxnidMostBits
}

func (m *CommandEndTxnOnPartitionResponse) GetError() ServerError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ServerError_UnknownError
}

func (m *CommandEndTxnOnPartitionResponse) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

type CommandEndTxnOnSubscription struct {
	RequestId            *uint64       `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnidLeastBits       *uint64       `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64       `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	Subscription         *Subscription `protobuf:"bytes,4,opt,name=subscription" json:"subscription,omitempty"`
	TxnAction            *TxnAction    `protobuf:"varint,5,opt,name=txn_action,enum=pulsar.proto.TxnAction" json:"txn_action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CommandEndTxnOnSubscription) Reset()         { *m = CommandEndTxnOnSubscription{} }
func (m *CommandEndTxnOnSubscription) String() string { return proto.CompactTextString(m) }
func (*CommandEndTxnOnSubscription) ProtoMessage()    {}
func (*CommandEndTxnOnSubscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{61}
}
func (m *CommandEndTxnOnSubscription) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandEndTxnOnSubscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandEndTxnOnSubscription.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandEndTxnOnSubscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandEndTxnOnSubscription.Merge(m, src)
}
func (m *CommandEndTxnOnSubscription) XXX_Size() int {
	return m.Size()
}
func (m *CommandEndTxnOnSubscription) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandEndTxnOnSubscription.DiscardUnknown(m)
}

var xxx_messageInfo_CommandEndTxnOnSubscription proto.InternalMessageInfo

const Default_CommandEndTxnOnSubscription_TxnidLeastBits uint64 = 0
const Default_CommandEndTxnOnSubscription_TxnidMostBits uint64 = 0

func (m *CommandEndTxnOnSubscription) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandEndTxnOnSubscription) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandEndTxnOnSubscription_TxnidLeastBits
}

func (m *CommandEndTxnOnSubscription) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandEndTxnOnSubscription_TxnidMostBits
}

func (m *CommandEndTxnOnSubscription) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

func (m *CommandEndTxnOnSubscription) GetTxnAction() TxnAction {
	if m != nil && m.TxnAction != nil {
		return *m.TxnAction
	}
	return TxnAction_COMMIT
}

type CommandEndTxnOnSubscriptionResponse struct {
	RequestId            *uint64      `protobuf:"varint,1,req,name=request_id" json:"request_id,omitempty"`
	TxnidLeastBits       *uint64      `protobuf:"varint,2,opt,name=txnid_least_bits,def=0" json:"txnid_least_bits,omitempty"`
	TxnidMostBits        *uint64      `protobuf:"varint,3,opt,name=txnid_most_bits,def=0" json:"txnid_most_bits,omitempty"`
	Error                *ServerError `protobuf:"varint,4,opt,name=error,enum=pulsar.proto.ServerError" json:"error,omitempty"`
	Message              *string      `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CommandEndTxnOnSubscriptionResponse) Reset()         { *m = CommandEndTxnOnSubscriptionResponse{} }
func (m *CommandEndTxnOnSubscriptionResponse) String() string { return proto.CompactTextString(m) }
func (*CommandEndTxnOnSubscriptionResponse) ProtoMessage()    {}
func (*CommandEndTxnOnSubscriptionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{62}
}
func (m *CommandEndTxnOnSubscriptionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandEndTxnOnSubscriptionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandEndTxnOnSubscriptionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommandEndTxnOnSubscriptionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandEndTxnOnSubscriptionResponse.Merge(m, src)
}
func (m *CommandEndTxnOnSubscriptionResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommandEndTxnOnSubscriptionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandEndTxnOnSubscriptionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommandEndTxnOnSubscriptionResponse proto.InternalMessageInfo

const Default_CommandEndTxnOnSubscriptionResponse_TxnidLeastBits uint64 = 0
const Default_CommandEndTxnOnSubscriptionResponse_TxnidMostBits uint64 = 0

func (m *CommandEndTxnOnSubscriptionResponse) GetRequestId() uint64 {
	if m != nil && m.RequestId != nil {
		return *m.RequestId
	}
	return 0
}

func (m *CommandEndTxnOnSubscriptionResponse) GetTxnidLeastBits() uint64 {
	if m != nil && m.TxnidLeastBits != nil {
		return *m.TxnidLeastBits
	}
	return Default_CommandEndTxnOnSubscriptionResponse_TxnidLeastBits
}

func (m *CommandEndTxnOnSubscriptionResponse) GetTxnidMostBits() uint64 {
	if m != nil && m.TxnidMostBits != nil {
		return *m.TxnidMostBits
	}
	return Default_CommandEndTxnOnSubscriptionResponse_TxnidMostBits
}

func (m *CommandEndTxnOnSubscriptionResponse) GetError() ServerError {
	if m != nil && m.Error != nil {
		return *m.Error
	}
	return ServerError_UnknownError
}

func (m *CommandEndTxnOnSubscriptionResponse) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

type BaseCommand struct {
	Type                            *BaseCommand_Type                        `protobuf:"varint,1,req,name=type,enum=pulsar.proto.BaseCommand_Type" json:"type,omitempty"`
	Connect                         *CommandConnect                          `protobuf:"bytes,2,opt,name=connect" json:"connect,omitempty"`
	Connected                       *CommandConnected                        `protobuf:"bytes,3,opt,name=connected" json:"connected,omitempty"`
	Subscribe                       *CommandSubscribe                        `protobuf:"bytes,4,opt,name=subscribe" json:"subscribe,omitempty"`
	Producer                        *CommandProducer                         `protobuf:"bytes,5,opt,name=producer" json:"producer,omitempty"`
	Send                            *CommandSend                             `protobuf:"bytes,6,opt,name=send" json:"send,omitempty"`
	SendReceipt                     *CommandSendReceipt                      `protobuf:"bytes,7,opt,name=send_receipt" json:"send_receipt,omitempty"`
	SendError                       *CommandSendError                        `protobuf:"bytes,8,opt,name=send_error" json:"send_error,omitempty"`
	Message                         *CommandMessage                          `protobuf:"bytes,9,opt,name=message" json:"message,omitempty"`
	Ack                             *CommandAck                              `protobuf:"bytes,10,opt,name=ack" json:"ack,omitempty"`
	Flow                            *CommandFlow                             `protobuf:"bytes,11,opt,name=flow" json:"flow,omitempty"`
	Unsubscribe                     *CommandUnsubscribe                      `protobuf:"bytes,12,opt,name=unsubscribe" json:"unsubscribe,omitempty"`
	Success                         *CommandSuccess                          `protobuf:"bytes,13,opt,name=success" json:"success,omitempty"`
	Error                           *CommandError                            `protobuf:"bytes,14,opt,name=error" json:"error,omitempty"`
	CloseProducer                   *CommandCloseProducer                    `protobuf:"bytes,15,opt,name=close_producer" json:"close_producer,omitempty"`
	CloseConsumer                   *CommandCloseConsumer                    `protobuf:"bytes,16,opt,name=close_consumer" json:"close_consumer,omitempty"`
	ProducerSuccess                 *CommandProducerSuccess                  `protobuf:"bytes,17,opt,name=producer_success" json:"producer_success,omitempty"`
	Ping                            *CommandPing                             `protobuf:"bytes,18,opt,name=ping" json:"ping,omitempty"`
	Pong                            *CommandPong                             `protobuf:"bytes,19,opt,name=pong" json:"pong,omitempty"`
	RedeliverUnacknowledgedMessages *CommandRedeliverUnacknowledgedMessages  `protobuf:"bytes,20,opt,name=redeliverUnacknowledgedMessages" json:"redeliverUnacknowledgedMessages,omitempty"`
	PartitionMetadata               *CommandPartitionedTopicMetadata         `protobuf:"bytes,21,opt,name=partitionMetadata" json:"partitionMetadata,omitempty"`
	PartitionMetadataResponse       *CommandPartitionedTopicMetadataResponse `protobuf:"bytes,22,opt,name=partitionMetadataResponse" json:"partitionMetadataResponse,omitempty"`
	LookupTopic                     *CommandLookupTopic                      `protobuf:"bytes,23,opt,name=lookupTopic" json:"lookupTopic,omitempty"`
	LookupTopicResponse             *CommandLookupTopicResponse              `protobuf:"bytes,24,opt,name=lookupTopicResponse" json:"lookupTopicResponse,omitempty"`
	ConsumerStats                   *CommandConsumerStats                    `protobuf:"bytes,25,opt,name=consumerStats" json:"consumerStats,omitempty"`
	ConsumerStatsResponse           *CommandConsumerStatsResponse            `protobuf:"bytes,26,opt,name=consumerStatsResponse" json:"consumerStatsResponse,omitempty"`
	ReachedEndOfTopic               *CommandReachedEndOfTopic                `protobuf:"bytes,27,opt,name=reachedEndOfTopic" json:"reachedEndOfTopic,omitempty"`
	Seek                            *CommandSeek                             `protobuf:"bytes,28,opt,name=seek" json:"seek,omitempty"`
	GetLastMessageId                *CommandGetLastMessageId                 `protobuf:"bytes,29,opt,name=getLastMessageId" json:"getLastMessageId,omitempty"`
	GetLastMessageIdResponse        *CommandGetLastMessageIdResponse         `protobuf:"bytes,30,opt,name=getLastMessageIdResponse" json:"getLastMessageIdResponse,omitempty"`
	ActiveConsumerChange            *CommandActiveConsumerChange             `protobuf:"bytes,31,opt,name=active_consumer_change" json:"active_consumer_change,omitempty"`
	GetTopicsOfNamespace            *CommandGetTopicsOfNamespace             `protobuf:"bytes,32,opt,name=getTopicsOfNamespace" json:"getTopicsOfNamespace,omitempty"`
	GetTopicsOfNamespaceResponse    *CommandGetTopicsOfNamespaceResponse     `protobuf:"bytes,33,opt,name=getTopicsOfNamespaceResponse" json:"getTopicsOfNamespaceResponse,omitempty"`
	GetSchema                       *CommandGetSchema                        `protobuf:"bytes,34,opt,name=getSchema" json:"getSchema,omitempty"`
	GetSchemaResponse               *CommandGetSchemaResponse                `protobuf:"bytes,35,opt,name=getSchemaResponse" json:"getSchemaResponse,omitempty"`
	AuthChallenge                   *CommandAuthChallenge                    `protobuf:"bytes,36,opt,name=authChallenge" json:"authChallenge,omitempty"`
	AuthResponse                    *CommandAuthResponse                     `protobuf:"bytes,37,opt,name=authResponse" json:"authResponse,omitempty"`
	AckResponse                     *CommandAckResponse                      `protobuf:"bytes,38,opt,name=ackResponse" json:"ackResponse,omitempty"`
	GetOrCreateSchema               *CommandGetOrCreateSchema                `protobuf:"bytes,39,opt,name=getOrCreateSchema" json:"getOrCreateSchema,omitempty"`
	GetOrCreateSchemaResponse       *CommandGetOrCreateSchemaResponse        `protobuf:"bytes,40,opt,name=getOrCreateSchemaResponse" json:"getOrCreateSchemaResponse,omitempty"`
	// transaction related
	NewTxn                       *CommandNewTxn                       `protobuf:"bytes,50,opt,name=newTxn" json:"newTxn,omitempty"`
	NewTxnResponse               *CommandNewTxnResponse               `protobuf:"bytes,51,opt,name=newTxnResponse" json:"newTxnResponse,omitempty"`
	AddPartitionToTxn            *CommandAddPartitionToTxn            `protobuf:"bytes,52,opt,name=addPartitionToTxn" json:"addPartitionToTxn,omitempty"`
	AddPartitionToTxnResponse    *CommandAddPartitionToTxnResponse    `protobuf:"bytes,53,opt,name=addPartitionToTxnResponse" json:"addPartitionToTxnResponse,omitempty"`
	AddSubscriptionToTxn         *CommandAddSubscriptionToTxn         `protobuf:"bytes,54,opt,name=addSubscriptionToTxn" json:"addSubscriptionToTxn,omitempty"`
	AddSubscriptionToTxnResponse *CommandAddSubscriptionToTxnResponse `protobuf:"bytes,55,opt,name=addSubscriptionToTxnResponse" json:"addSubscriptionToTxnResponse,omitempty"`
	EndTxn                       *CommandEndTxn                       `protobuf:"bytes,56,opt,name=endTxn" json:"endTxn,omitempty"`
	EndTxnResponse               *CommandEndTxnResponse               `protobuf:"bytes,57,opt,name=endTxnResponse" json:"endTxnResponse,omitempty"`
	EndTxnOnPartition            *CommandEndTxnOnPartition            `protobuf:"bytes,58,opt,name=endTxnOnPartition" json:"endTxnOnPartition,omitempty"`
	EndTxnOnPartitionResponse    *CommandEndTxnOnPartitionResponse    `protobuf:"bytes,59,opt,name=endTxnOnPartitionResponse" json:"endTxnOnPartitionResponse,omitempty"`
	EndTxnOnSubscription         *CommandEndTxnOnSubscription         `protobuf:"bytes,60,opt,name=endTxnOnSubscription" json:"endTxnOnSubscription,omitempty"`
	EndTxnOnSubscriptionResponse *CommandEndTxnOnSubscriptionResponse `protobuf:"bytes,61,opt,name=endTxnOnSubscriptionResponse" json:"endTxnOnSubscriptionResponse,omitempty"`
	XXX_NoUnkeyedLiteral         struct{}                             `json:"-"`
	XXX_unrecognized             []byte                               `json:"-"`
	XXX_sizecache                int32                                `json:"-"`
}

func (m *BaseCommand) Reset()         { *m = BaseCommand{} }
func (m *BaseCommand) String() string { return proto.CompactTextString(m) }
func (*BaseCommand) ProtoMessage()    {}
func (*BaseCommand) Descriptor() ([]byte, []int) {
	return fileDescriptor_1370d448d7fffc03, []int{63}
}
func (m *BaseCommand) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BaseCommand) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BaseCommand.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BaseCommand) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BaseCommand.Merge(m, src)
}
func (m *BaseCommand) XXX_Size() int {
	return m.Size()
}
func (m *BaseCommand) XXX_DiscardUnknown() {
	xxx_messageInfo_BaseCommand.DiscardUnknown(m)
}

var xxx_messageInfo_BaseCommand proto.InternalMessageInfo

func (m *BaseCommand) GetType() BaseCommand_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return BaseCommand_CONNECT
}

func (m *BaseCommand) GetConnect() *CommandConnect {
	if m != nil {
		return m.Connect
	}
	return nil
}

func (m *BaseCommand) GetConnected() *CommandConnected {
	if m != nil {
		return m.Connected
	}
	return nil
}

func (m *BaseCommand) GetSubscribe() *CommandSubscribe {
	if m != nil {
		return m.Subscribe
	}
	return nil
}

func (m *BaseCommand) GetProducer() *CommandProducer {
	if m != nil {
		return m.Producer
	}
	return nil
}

func (m *BaseCommand) GetSend() *CommandSend {
	if m != nil {
		return m.Send
	}
	return nil
}

func (m *BaseCommand) GetSendReceipt() *CommandSendReceipt {
	if m != nil {
		return m.SendReceipt
	}
	return nil
}

func (m *BaseCommand) GetSendError() *CommandSendError {
	if m != nil {
		return m.SendError
	}
	return nil
}

func (m *BaseCommand) GetMessage() *CommandMessage {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *BaseCommand) GetAck() *CommandAck {
	if m != nil {
		return m.Ack
	}
	return nil
}

func (m *BaseCommand) GetFlow() *CommandFlow {
	if m != nil {
		return m.Flow
	}
	return nil
}

func (m *BaseCommand) GetUnsubscribe() *CommandUnsubscribe {
	if m != nil {
		return m.Unsubscribe
	}
	return nil
}

func (m *BaseCommand) GetSuccess() *CommandSuccess {
	if m != nil {
		return m.Success
	}
	return nil
}

func (m *BaseCommand) GetError() *CommandError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *BaseCommand) GetCloseProducer() *CommandCloseProducer {
	if m != nil {
		return m.CloseProducer
	}
	return nil
}

func (m *BaseCommand) GetCloseConsumer() *CommandCloseConsumer {
	if m != nil {
		return m.CloseConsumer
	}
	return nil
}

func (m *BaseCommand) GetProducerSuccess() *CommandProducerSuccess {
	if m != nil {
		return m.ProducerSuccess
	}
	return nil
}

func (m *BaseCommand) GetPing() *CommandPing {
	if m != nil {
		return m.Ping
	}
	return nil
}

func (m *BaseCommand) GetPong() *CommandPong {
	if m != nil {
		return m.Pong
	}
	return nil
}

func (m *BaseCommand) GetRedeliverUnacknowledgedMessages() *CommandRedeliverUnacknowledgedMessages {
	if m != nil {
		return m.RedeliverUnacknowledgedMessages
	}
	return nil
}

func (m *BaseCommand) GetPartitionMetadata() *CommandPartitionedTopicMetadata {
	if m != nil {
		return m.PartitionMetadata
	}
	return nil
}

func (m *BaseCommand) GetPartitionMetadataResponse() *CommandPartitionedTopicMetadataResponse {
	if m != nil {
		return m.PartitionMetadataResponse
	}
	return nil
}

func (m *BaseCommand) GetLookupTopic() *CommandLookupTopic {
	if m != nil {
		return m.LookupTopic
	}
	return nil
}

func (m *BaseCommand) GetLookupTopicResponse() *CommandLookupTopicResponse {
	if m != nil {
		return m.LookupTopicResponse
	}
	return nil
}

func (m *BaseCommand) GetConsumerStats() *CommandConsumerStats {
	if m != nil {
		return m.ConsumerStats
	}
	return nil
}

func (m *BaseCommand) GetConsumerStatsResponse() *CommandConsumerStatsResponse {
	if m != nil {
		return m.ConsumerStatsResponse
	}
	return nil
}

func (m *BaseCommand) GetReachedEndOfTopic() *CommandReachedEndOfTopic {
	if m != nil {
		return m.ReachedEndOfTopic
	}
	return nil
}

func (m *BaseCommand) GetSeek() *CommandSeek {
	if m != nil {
		return m.Seek
	}
	return nil
}

func (m *BaseCommand) GetGetLastMessageId() *CommandGetLastMessageId {
	if m != nil {
		return m.GetLastMessageId
	}
	return nil
}

func (m *BaseCommand) GetGetLastMessageIdResponse() *CommandGetLastMessageIdResponse {
	if m != nil {
		return m.GetLastMessageIdResponse
	}
	return nil
}

func (m *BaseCommand) GetActiveConsumerChange() *CommandActiveConsumerChange {
	if m != nil {
		return m.ActiveConsumerChange
	}
	return nil
}

func (m *BaseCommand) GetGetTopicsOfNamespace() *CommandGetTopicsOfNamespace {
	if m != nil {
		return m.GetTopicsOfNamespace
	}
	return nil
}

func (m *BaseCommand) GetGetTopicsOfNamespaceResponse() *CommandGetTopicsOfNamespaceResponse {
	if m != nil {
		return m.GetTopicsOfNamespaceResponse
	}
	return nil
}

func (m *BaseCommand) GetGetSchema() *CommandGetSchema {
	if m != nil {
		return m.GetSchema
	}
	return nil
}

func (m *BaseCommand) GetGetSchemaResponse() *CommandGetSchemaResponse {
	if m != nil {
		return m.GetSchemaResponse
	}
	return nil
}

func (m *BaseCommand) GetAuthChallenge() *CommandAuthChallenge {
	if m != nil {
		return m.AuthChallenge
	}
	return nil
}

func (m *BaseCommand) GetAuthResponse() *CommandAuthResponse {
	if m != nil {
		return m.AuthResponse
	}
	return nil
}

func (m *BaseCommand) GetAckResponse() *CommandAckResponse {
	if m != nil {
		return m.AckResponse
	}
	return nil
}

func (m *BaseCommand) GetGetOrCreateSchema() *CommandGetOrCreateSchema {
	if m != nil {
		return m.GetOrCreateSchema
	}
	return nil
}

func (m *BaseCommand) GetGetOrCreateSchemaResponse() *CommandGetOrCreateSchemaResponse {
	if m != nil {
		return m.GetOrCreateSchemaResponse
	}
	return nil
}

func (m *BaseCommand) GetNewTxn() *CommandNewTxn {
	if m != nil {
		return m.NewTxn
	}
	return nil
}

func (m *BaseCommand) GetNewTxnResponse() *CommandNewTxnResponse {
	if m != nil {
		return m.NewTxnResponse
	}
	return nil
}

func (m *BaseCommand) GetAddPartitionToTxn() *CommandAddPartitionToTxn {
	if m != nil {
		return m.AddPartitionToTxn
	}
	return nil
}

func (m *BaseCommand) GetAddPartitionToTxnResponse() *CommandAddPartitionToTxnResponse {
	if m != nil {
		return m.AddPartitionToTxnResponse
	}
	return nil
}

func (m *BaseCommand) GetAddSubscriptionToTxn() *CommandAddSubscriptionToTxn {
	if m != nil {
		return m.AddSubscriptionToTxn
	}
	return nil
}

func (m *BaseCommand) GetAddSubscriptionToTxnResponse() *CommandAddSubscriptionToTxnResponse {
	if m != nil {
		return m.AddSubscriptionToTxnResponse
	}
	return nil
}

func (m *BaseCommand) GetEndTxn() *CommandEndTxn {
	if m != nil {
		return m.EndTxn
	}
	return nil
}

func (m *BaseCommand) GetEndTxnResponse() *CommandEndTxnResponse {
	if m != nil {
		return m.EndTxnResponse
	}
	return nil
}

func (m *BaseCommand) GetEndTxnOnPartition() *CommandEndTxnOnPartition {
	if m != nil {
		return m.EndTxnOnPartition
	}
	return nil
}

func (m *BaseCommand) GetEndTxnOnPartitionResponse() *CommandEndTxnOnPartitionResponse {
	if m != nil {
		return m.EndTxnOnPartitionResponse
	}
	return nil
}

func (m *BaseCommand) GetEndTxnOnSubscription() *CommandEndTxnOnSubscription {
	if m != nil {
		return m.EndTxnOnSubscription
	}
	return nil
}

func (m *BaseCommand) GetEndTxnOnSubscriptionResponse() *CommandEndTxnOnSubscriptionResponse {
	if m != nil {
		return m.EndTxnOnSubscriptionResponse
	}
	return nil
}

func init() {
	proto.RegisterEnum("pulsar.proto.CompressionType", CompressionType_name, CompressionType_value)
	proto.RegisterEnum("pulsar.proto.ServerError", ServerError_name, ServerError_value)
	proto.RegisterEnum("pulsar.proto.AuthMethod", AuthMethod_name, AuthMethod_value)
	proto.RegisterEnum("pulsar.proto.ProtocolVersion", ProtocolVersion_name, ProtocolVersion_value)
	proto.RegisterEnum("pulsar.proto.KeySharedMode", KeySharedMode_name, KeySharedMode_value)
	proto.RegisterEnum("pulsar.proto.TxnAction", TxnAction_name, TxnAction_value)
	proto.RegisterEnum("pulsar.proto.Schema_Type", Schema_Type_name, Schema_Type_value)
	proto.RegisterEnum("pulsar.proto.CommandSubscribe_SubType", CommandSubscribe_SubType_name, CommandSubscribe_SubType_value)
	proto.RegisterEnum("pulsar.proto.CommandSubscribe_InitialPosition", CommandSubscribe_InitialPosition_name, CommandSubscribe_InitialPosition_value)
	proto.RegisterEnum("pulsar.proto.CommandPartitionedTopicMetadataResponse_LookupType", CommandPartitionedTopicMetadataResponse_LookupType_name, CommandPartitionedTopicMetadataResponse_LookupType_value)
	proto.RegisterEnum("pulsar.proto.CommandLookupTopicResponse_LookupType", CommandLookupTopicResponse_LookupType_name, CommandLookupTopicResponse_LookupType_value)
	proto.RegisterEnum("pulsar.proto.CommandAck_AckType", CommandAck_AckType_name, CommandAck_AckType_value)
	proto.RegisterEnum("pulsar.proto.CommandAck_ValidationError", CommandAck_ValidationError_name, CommandAck_ValidationError_value)
	proto.RegisterEnum("pulsar.proto.CommandGetTopicsOfNamespace_Mode", CommandGetTopicsOfNamespace_Mode_name, CommandGetTopicsOfNamespace_Mode_value)
	proto.RegisterEnum("pulsar.proto.BaseCommand_Type", BaseCommand_Type_name, BaseCommand_Type_value)
	proto.RegisterType((*Schema)(nil), "pulsar.proto.Schema")
	proto.RegisterType((*MessageIdData)(nil), "pulsar.proto.MessageIdData")
	proto.RegisterType((*KeyValue)(nil), "pulsar.proto.KeyValue")
	proto.RegisterType((*KeyLongValue)(nil), "pulsar.proto.KeyLongValue")
	proto.RegisterType((*IntRange)(nil), "pulsar.proto.IntRange")
	proto.RegisterType((*EncryptionKeys)(nil), "pulsar.proto.EncryptionKeys")
	proto.RegisterType((*MessageMetadata)(nil), "pulsar.proto.MessageMetadata")
	proto.RegisterType((*SingleMessageMetadata)(nil), "pulsar.proto.SingleMessageMetadata")
	proto.RegisterType((*CommandConnect)(nil), "pulsar.proto.CommandConnect")
	proto.RegisterType((*FeatureFlags)(nil), "pulsar.proto.FeatureFlags")
	proto.RegisterType((*CommandConnected)(nil), "pulsar.proto.CommandConnected")
	proto.RegisterType((*CommandAuthResponse)(nil), "pulsar.proto.CommandAuthResponse")
	proto.RegisterType((*CommandAuthChallenge)(nil), "pulsar.proto.CommandAuthChallenge")
	proto.RegisterType((*AuthData)(nil), "pulsar.proto.AuthData")
	proto.RegisterType((*KeySharedMeta)(nil), "pulsar.proto.KeySharedMeta")
	proto.RegisterType((*CommandSubscribe)(nil), "pulsar.proto.CommandSubscribe")
	proto.RegisterType((*CommandPartitionedTopicMetadata)(nil), "pulsar.proto.CommandPartitionedTopicMetadata")
	proto.RegisterType((*CommandPartitionedTopicMetadataResponse)(nil), "pulsar.proto.CommandPartitionedTopicMetadataResponse")
	proto.RegisterType((*CommandLookupTopic)(nil), "pulsar.proto.CommandLookupTopic")
	proto.RegisterType((*CommandLookupTopicResponse)(nil), "pulsar.proto.CommandLookupTopicResponse")
	proto.RegisterType((*CommandProducer)(nil), "pulsar.proto.CommandProducer")
	proto.RegisterType((*CommandSend)(nil), "pulsar.proto.CommandSend")
	proto.RegisterType((*CommandSendReceipt)(nil), "pulsar.proto.CommandSendReceipt")
	proto.RegisterType((*CommandSendError)(nil), "pulsar.proto.CommandSendError")
	proto.RegisterType((*CommandMessage)(nil), "pulsar.proto.CommandMessage")
	proto.RegisterType((*CommandAck)(nil), "pulsar.proto.CommandAck")
	proto.RegisterType((*CommandAckResponse)(nil), "pulsar.proto.CommandAckResponse")
	proto.RegisterType((*CommandActiveConsumerChange)(nil), "pulsar.proto.CommandActiveConsumerChange")
	proto.RegisterType((*CommandFlow)(nil), "pulsar.proto.CommandFlow")
	proto.RegisterType((*CommandUnsubscribe)(nil), "pulsar.proto.CommandUnsubscribe")
	proto.RegisterType((*CommandSeek)(nil), "pulsar.proto.CommandSeek")
	proto.RegisterType((*CommandReachedEndOfTopic)(nil), "pulsar.proto.CommandReachedEndOfTopic")
	proto.RegisterType((*CommandCloseProducer)(nil), "pulsar.proto.CommandCloseProducer")
	proto.RegisterType((*CommandCloseConsumer)(nil), "pulsar.proto.CommandCloseConsumer")
	proto.RegisterType((*CommandRedeliverUnacknowledgedMessages)(nil), "pulsar.proto.CommandRedeliverUnacknowledgedMessages")
	proto.RegisterType((*CommandSuccess)(nil), "pulsar.proto.CommandSuccess")
	proto.RegisterType((*CommandProducerSuccess)(nil), "pulsar.proto.CommandProducerSuccess")
	proto.RegisterType((*CommandError)(nil), "pulsar.proto.CommandError")
	proto.RegisterType((*CommandPing)(nil), "pulsar.proto.CommandPing")
	proto.RegisterType((*CommandPong)(nil), "pulsar.proto.CommandPong")
	proto.RegisterType((*CommandConsumerStats)(nil), "pulsar.proto.CommandConsumerStats")
	proto.RegisterType((*CommandConsumerStatsResponse)(nil), "pulsar.proto.CommandConsumerStatsResponse")
	proto.RegisterType((*CommandGetLastMessageId)(nil), "pulsar.proto.CommandGetLastMessageId")
	proto.RegisterType((*CommandGetLastMessageIdResponse)(nil), "pulsar.proto.CommandGetLastMessageIdResponse")
	proto.RegisterType((*CommandGetTopicsOfNamespace)(nil), "pulsar.proto.CommandGetTopicsOfNamespace")
	proto.RegisterType((*CommandGetTopicsOfNamespaceResponse)(nil), "pulsar.proto.CommandGetTopicsOfNamespaceResponse")
	proto.RegisterType((*CommandGetSchema)(nil), "pulsar.proto.CommandGetSchema")
	proto.RegisterType((*CommandGetSchemaResponse)(nil), "pulsar.proto.CommandGetSchemaResponse")
	proto.RegisterType((*CommandGetOrCreateSchema)(nil), "pulsar.proto.CommandGetOrCreateSchema")
	proto.RegisterType((*CommandGetOrCreateSchemaResponse)(nil), "pulsar.proto.CommandGetOrCreateSchemaResponse")
	proto.RegisterType((*CommandNewTxn)(nil), "pulsar.proto.CommandNewTxn")
	proto.RegisterType((*CommandNewTxnResponse)(nil), "pulsar.proto.CommandNewTxnResponse")
	proto.RegisterType((*CommandAddPartitionToTxn)(nil), "pulsar.proto.CommandAddPartitionToTxn")
	proto.RegisterType((*CommandAddPartitionToTxnResponse)(nil), "pulsar.proto.CommandAddPartitionToTxnResponse")
	proto.RegisterType((*Subscription)(nil), "pulsar.proto.Subscription")
	proto.RegisterType((*CommandAddSubscriptionToTxn)(nil), "pulsar.proto.CommandAddSubscriptionToTxn")
	proto.RegisterType((*CommandAddSubscriptionToTxnResponse)(nil), "pulsar.proto.CommandAddSubscriptionToTxnResponse")
	proto.RegisterType((*CommandEndTxn)(nil), "pulsar.proto.CommandEndTxn")
	proto.RegisterType((*CommandEndTxnResponse)(nil), "pulsar.proto.CommandEndTxnResponse")
	proto.RegisterType((*CommandEndTxnOnPartition)(nil), "pulsar.proto.CommandEndTxnOnPartition")
	proto.RegisterType((*CommandEndTxnOnPartitionResponse)(nil), "pulsar.proto.CommandEndTxnOnPartitionResponse")
	proto.RegisterType((*CommandEndTxnOnSubscription)(nil), "pulsar.proto.CommandEndTxnOnSubscription")
	proto.RegisterType((*CommandEndTxnOnSubscriptionResponse)(nil), "pulsar.proto.CommandEndTxnOnSubscriptionResponse")
	proto.RegisterType((*BaseCommand)(nil), "pulsar.proto.BaseCommand")
}

func init() {
	proto.RegisterFile("github.com/apache/pulsar-client-go@v0.3.0/pulsar/internal/pulsar_proto/PulsarApi.proto", fileDescriptor_1370d448d7fffc03)
}

var fileDescriptor_1370d448d7fffc03 = []byte{
	// 4908 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x7b, 0xcb, 0x6f, 0x1b, 0x49,
	0x7a, 0xb8, 0x9b, 0x0f, 0x89, 0xfc, 0xf8, 0x2a, 0xb7, 0x5e, 0x6d, 0x5b, 0xe3, 0xa1, 0x7b, 0xfc,
	0xa0, 0x3d, 0x3f, 0xcb, 0xb6, 0xfc, 0x9a, 0xf1, 0xec, 0xfe, 0x76, 0x29, 0xaa, 0x2d, 0x73, 0x25,
	0x91, 0x1a, 0x92, 0xb2, 0x77, 0x17, 0x58, 0x34, 0x4a, 0xdd, 0x65, 0xaa, 0xa1, 0x66, 0x37, 0xd3,
	0xdd, 0x94, 0xad, 0xc9, 0x39, 0x08, 0x72, 0x0a, 0x10, 0x04, 0x58, 0x20, 0x48, 0xb0, 0x87, 0x1c,
	0x82, 0x04, 0xc8, 0x25, 0xd7, 0x00, 0xb9, 0xe4, 0x90, 0xe4, 0x10, 0x20, 0xff, 0x41, 0x82, 0x39,
	0xe4, 0x18, 0xe4, 0x9c, 0x4b, 0x82, 0xaa, 0xea, 0x17, 0xa9, 0x66, 0xcb, 0x9e, 0xec, 0x6e, 0xe6,
	0xc4, 0xee, 0xae, 0xaa, 0xaf, 0xbe, 0xf7, 0xab, 0x8a, 0xf0, 0x7a, 0x68, 0x78, 0xc7, 0x93, 0xa3,
	0x0d, 0xcd, 0x1e, 0x3d, 0xc0, 0x63, 0xac, 0x1d, 0x93, 0x07, 0xe3, 0x89, 0xe9, 0x62, 0xe7, 0xbe,
	0x66, 0x1a, 0xc4, 0xf2, 0xee, 0x0f, 0xed, 0x1f, 0x9f, 0x3e, 0xdc, 0x78, 0xbc, 0xf1, 0xd0, 0xff,
	0xfe, 0xc0, 0xb0, 0x3c, 0xe2, 0x58, 0xd8, 0xf4, 0xdf, 0xd5, 0xb1, 0x63, 0x7b, 0xf6, 0x83, 0x03,
	0xf6, 0xd2, 0x1c, 0x1b, 0x1b, 0xec, 0x5d, 0x2c, 0xf3, 0x51, 0xfe, 0x26, 0xff, 0x5d, 0x06, 0x16,
	0xfa, 0xda, 0x31, 0x19, 0x61, 0xb1, 0x0c, 0x39, 0x0b, 0x8f, 0x88, 0x24, 0xd4, 0x33, 0x8d, 0xa2,
	0xb8, 0x04, 0x25, 0x97, 0x7d, 0x57, 0x75, 0xec, 0x61, 0x29, 0x5b, 0xcf, 0x34, 0xca, 0xe2, 0x1d,
	0xc8, 0x79, 0x67, 0x63, 0x22, 0xe5, 0xea, 0x99, 0x46, 0x75, 0xf3, 0xca, 0x46, 0x1c, 0xd4, 0x06,
	0x07, 0xb3, 0x31, 0x38, 0x1b, 0x13, 0xf1, 0x1e, 0xc0, 0xd8, 0xb1, 0xc7, 0xc4, 0xf1, 0x0c, 0xe2,
	0x4a, 0xf9, 0x7a, 0xb6, 0x51, 0xda, 0x5c, 0x9d, 0x9e, 0xbe, 0x4b, 0xce, 0x5e, 0x63, 0x73, 0x42,
	0xe4, 0xbf, 0x15, 0x20, 0xc7, 0x16, 0x15, 0x20, 0xd7, 0xb1, 0x2d, 0x82, 0x2e, 0x89, 0x00, 0x0b,
	0x7d, 0xcf, 0x31, 0xac, 0x21, 0x12, 0xe8, 0xd7, 0x9f, 0xb8, 0xb6, 0x85, 0x32, 0x62, 0x19, 0x0a,
	0x07, 0x74, 0xe9, 0xd1, 0xe4, 0x2d, 0xca, 0xd2, 0xef, 0xcd, 0x53, 0xc7, 0x46, 0x39, 0xfa, 0xb4,
	0x65, 0xdb, 0x26, 0xca, 0xd3, 0xa7, 0xb6, 0xe5, 0x7d, 0x81, 0x16, 0xc4, 0x22, 0xe4, 0xdb, 0x96,
	0xf7, 0xe8, 0x19, 0x5a, 0xf4, 0x1f, 0x1f, 0x6f, 0xa2, 0x82, 0xff, 0xf8, 0xec, 0x09, 0x2a, 0xd2,
	0xc7, 0x97, 0xa6, 0x8d, 0x3d, 0x04, 0x74, 0xb7, 0x6d, 0x7b, 0x72, 0x64, 0x12, 0x54, 0xa2, 0x10,
	0xb6, 0xb1, 0x47, 0x50, 0x99, 0x3e, 0x0d, 0x8c, 0x11, 0x41, 0x15, 0xb1, 0x02, 0x45, 0xfa, 0xe4,
	0x7a, 0x78, 0x34, 0x46, 0x55, 0x8a, 0x46, 0x80, 0x3b, 0xaa, 0xc9, 0x47, 0x50, 0xd9, 0x27, 0xae,
	0x8b, 0x87, 0xa4, 0xad, 0x6f, 0x63, 0x0f, 0x8b, 0x08, 0x0a, 0x26, 0xd1, 0x87, 0xc4, 0x69, 0xeb,
	0x8c, 0x95, 0x39, 0xb1, 0x06, 0x8b, 0xc4, 0xf2, 0x9c, 0xb3, 0xb6, 0x2e, 0x65, 0xd8, 0x87, 0x15,
	0x28, 0x8e, 0xb1, 0xe3, 0x19, 0x9e, 0x61, 0x5b, 0x52, 0xb6, 0x2e, 0x34, 0xf2, 0x2f, 0x32, 0xf7,
	0x1f, 0x89, 0x6b, 0x50, 0x3a, 0xc2, 0x9e, 0x76, 0xac, 0x1a, 0x96, 0x4e, 0xde, 0x4b, 0xb9, 0x60,
	0x40, 0xbe, 0x1d, 0xed, 0x28, 0x96, 0x20, 0x7b, 0x42, 0xce, 0x7c, 0x21, 0x55, 0x20, 0x7f, 0x4a,
	0xbf, 0x32, 0xb8, 0x45, 0xf9, 0x1e, 0x94, 0x77, 0xc9, 0xd9, 0x9e, 0x6d, 0x0d, 0x2f, 0x9a, 0x9b,
	0xa3, 0x30, 0xdb, 0x96, 0xd7, 0xc3, 0xd6, 0x90, 0xd0, 0x21, 0xd7, 0xc3, 0x8e, 0xc7, 0x66, 0xe6,
	0xe9, 0x32, 0x62, 0x71, 0x5c, 0xf3, 0xf2, 0x6b, 0xa8, 0x2a, 0x96, 0xe6, 0x9c, 0x8d, 0x29, 0xb2,
	0xbb, 0xe4, 0xcc, 0x4d, 0x81, 0x5a, 0x16, 0x1b, 0x50, 0x18, 0x11, 0x0f, 0xfb, 0x2a, 0x93, 0x26,
	0xf5, 0x5f, 0xe5, 0xa1, 0xe6, 0x33, 0x6e, 0xdf, 0x5f, 0x21, 0xae, 0x40, 0x65, 0xec, 0xd8, 0xfa,
	0x44, 0x23, 0x8e, 0x3a, 0xa3, 0x8a, 0xe4, 0x77, 0x26, 0xc4, 0xd2, 0x88, 0x6a, 0x04, 0x3c, 0x5c,
	0x86, 0xf2, 0x78, 0x72, 0x64, 0x1a, 0xee, 0xb1, 0xea, 0x19, 0x23, 0xc2, 0x14, 0x34, 0x37, 0xa3,
	0x77, 0xb9, 0x34, 0x0c, 0xc4, 0x35, 0xa8, 0x39, 0x64, 0x6c, 0x1a, 0x1a, 0xf6, 0x88, 0xae, 0xbe,
	0x75, 0xec, 0x91, 0x94, 0xaf, 0x0b, 0x8d, 0x22, 0x43, 0x23, 0x10, 0x8f, 0x4a, 0x49, 0x5d, 0x60,
	0x9f, 0x97, 0xa1, 0x1c, 0xce, 0x57, 0x3d, 0x5b, 0x5a, 0xac, 0x67, 0x1b, 0x45, 0xf1, 0x0b, 0x28,
	0x69, 0xf6, 0x68, 0xec, 0x10, 0xd7, 0xa5, 0xd2, 0x2c, 0xd4, 0x85, 0x46, 0x75, 0xf3, 0x93, 0xe9,
	0x2d, 0x5b, 0xd1, 0x04, 0xaa, 0xe8, 0x2f, 0x72, 0x9d, 0x6e, 0x47, 0x11, 0xd7, 0xe1, 0xf2, 0xc4,
	0x0a, 0xd6, 0x12, 0x5d, 0x75, 0x8d, 0x6f, 0x88, 0x54, 0xac, 0x0b, 0x8d, 0xca, 0x0b, 0xe1, 0xa1,
	0x58, 0x87, 0x15, 0x6b, 0x32, 0x52, 0x47, 0x9c, 0x45, 0xae, 0x6a, 0x58, 0x2a, 0x53, 0x0e, 0xa9,
	0xc4, 0xd4, 0x42, 0x78, 0x24, 0xae, 0x00, 0x90, 0x53, 0x62, 0x79, 0x9c, 0xfe, 0x72, 0x5d, 0x68,
	0xe4, 0xe8, 0xc2, 0xa7, 0x50, 0x23, 0xa1, 0xc0, 0x28, 0xfa, 0xae, 0x54, 0x61, 0x7c, 0x58, 0x9f,
	0x46, 0x6a, 0x46, 0xaa, 0x6b, 0x53, 0xcb, 0xb0, 0x39, 0xb4, 0xa5, 0x2a, 0x23, 0x5b, 0x02, 0x14,
	0x1b, 0x18, 0x63, 0x07, 0x8f, 0xa4, 0x5a, 0x5d, 0x68, 0x94, 0xc5, 0x55, 0xa8, 0xfa, 0x2e, 0xe2,
	0x94, 0x38, 0x8c, 0x7a, 0xc4, 0xbe, 0x37, 0xe0, 0xca, 0x14, 0xff, 0xd4, 0xa3, 0x67, 0x4f, 0x54,
	0x62, 0x69, 0xb6, 0x4e, 0x74, 0xe9, 0x72, 0x5d, 0x68, 0x14, 0x5e, 0xe4, 0xdf, 0x62, 0xd3, 0x25,
	0x94, 0xa5, 0xb6, 0xa3, 0x13, 0x6a, 0xe9, 0x8c, 0xd1, 0x22, 0x5b, 0xbf, 0x06, 0x35, 0x9d, 0x98,
	0xc6, 0x29, 0x71, 0x54, 0xec, 0x53, 0xb7, 0x54, 0x17, 0x1a, 0x59, 0xaa, 0x08, 0x23, 0xec, 0x9c,
	0x10, 0x47, 0x65, 0x5e, 0x68, 0x99, 0x72, 0x42, 0xbc, 0x06, 0xc8, 0x7b, 0x6f, 0x19, 0xba, 0x6a,
	0x12, 0xec, 0x7a, 0xea, 0x91, 0xe1, 0xb9, 0xd2, 0x6a, 0xc0, 0x8c, 0xab, 0x50, 0xe3, 0x83, 0x23,
	0x3b, 0x18, 0x5b, 0x0b, 0xc6, 0xae, 0xc3, 0xd2, 0xb1, 0x31, 0x3c, 0x26, 0xae, 0xa7, 0xc6, 0xd5,
	0x4b, 0xf2, 0xc7, 0xe5, 0xff, 0x12, 0x60, 0xa5, 0x6f, 0x58, 0x43, 0x93, 0xcc, 0xea, 0xe9, 0xb4,
	0x96, 0x09, 0xa9, 0x5a, 0x76, 0x4e, 0x99, 0x32, 0x81, 0x32, 0x8d, 0xf1, 0x99, 0x69, 0x63, 0x5f,
	0xee, 0x59, 0x66, 0x79, 0xeb, 0x50, 0xa1, 0x0a, 0x81, 0x35, 0xaa, 0x91, 0xf6, 0xc4, 0x63, 0x3e,
	0x20, 0xe4, 0xd6, 0xb4, 0xc0, 0xf3, 0x01, 0x1d, 0xa9, 0xec, 0x5e, 0x48, 0x63, 0xf7, 0x22, 0x63,
	0xf7, 0x8c, 0x79, 0x51, 0x0d, 0xce, 0xc9, 0xff, 0x90, 0x81, 0x6a, 0xcb, 0x1e, 0x8d, 0xb0, 0xa5,
	0xb7, 0x6c, 0xcb, 0x22, 0x9a, 0x47, 0xc5, 0xcd, 0x23, 0x4f, 0x28, 0x6e, 0x6e, 0x9e, 0xf7, 0xa1,
	0x84, 0x27, 0xde, 0xb1, 0x3a, 0x22, 0xde, 0xb1, 0xad, 0x33, 0xfa, 0xaa, 0x9b, 0xd2, 0x34, 0x3b,
	0x9a, 0x13, 0xef, 0x78, 0x9f, 0x8d, 0x53, 0x7d, 0x8a, 0x4d, 0xe7, 0x76, 0xce, 0xed, 0xee, 0x32,
	0x14, 0xd9, 0x88, 0xef, 0x3d, 0x28, 0x6e, 0xd7, 0x00, 0x31, 0x00, 0x9a, 0x6d, 0x86, 0xbb, 0x72,
	0xbf, 0x28, 0x3c, 0x14, 0xaf, 0xc1, 0xd2, 0xd8, 0xb1, 0xdf, 0x9f, 0xa9, 0x9e, 0xad, 0x1e, 0x39,
	0x36, 0xd5, 0x8b, 0x89, 0x63, 0xfa, 0xd6, 0x7a, 0x15, 0x44, 0xdb, 0x31, 0x86, 0x86, 0x85, 0x4d,
	0x75, 0xec, 0x18, 0x96, 0x66, 0x8c, 0xb1, 0xc9, 0x28, 0x9e, 0x1e, 0x8b, 0x76, 0x2c, 0xb0, 0xb1,
	0x75, 0x58, 0x9e, 0x1e, 0xf3, 0xc9, 0x2a, 0xb2, 0xd1, 0x47, 0x50, 0x79, 0x4b, 0xb0, 0x37, 0x71,
	0x88, 0xfa, 0xd6, 0xc4, 0x43, 0x57, 0x82, 0xba, 0xd0, 0x28, 0x6d, 0x5e, 0x9d, 0xa6, 0xf6, 0x25,
	0x9f, 0xf2, 0x92, 0xce, 0x90, 0x9f, 0x40, 0x39, 0xfe, 0x2e, 0xde, 0x84, 0x15, 0x77, 0x32, 0x1e,
	0xdb, 0x8e, 0xe7, 0xf2, 0x0d, 0x1c, 0xf2, 0xd6, 0x21, 0xee, 0xb1, 0x24, 0xc4, 0x44, 0x25, 0x63,
	0x40, 0xd3, 0xec, 0x27, 0x3a, 0xb3, 0x37, 0xe2, 0x50, 0xb3, 0x98, 0x16, 0x40, 0x12, 0x93, 0x32,
	0x01, 0x93, 0x24, 0x40, 0x23, 0xfc, 0x3e, 0xf0, 0x23, 0x81, 0xb2, 0x09, 0x8d, 0xbc, 0xec, 0xc1,
	0x92, 0xbf, 0x05, 0x95, 0x4e, 0x8f, 0xb8, 0x63, 0xdb, 0x72, 0x49, 0xa2, 0x98, 0x29, 0xe9, 0x0d,
	0x28, 0x38, 0xfe, 0x1c, 0x06, 0xfd, 0x9c, 0xca, 0x53, 0x28, 0x2c, 0x02, 0x26, 0xe1, 0x93, 0xf5,
	0xf1, 0x91, 0x4f, 0x61, 0x39, 0xb6, 0x6b, 0xeb, 0x18, 0x9b, 0x26, 0xa1, 0x31, 0x28, 0x89, 0x38,
	0xba, 0xed, 0x5d, 0x28, 0x6a, 0xc1, 0xa4, 0xff, 0xcd, 0xbe, 0xcf, 0xa1, 0x10, 0x4e, 0x4c, 0x52,
	0x41, 0xe1, 0xbc, 0x0a, 0xd2, 0xdd, 0xca, 0xf2, 0x2f, 0x05, 0xa8, 0xec, 0x92, 0xb3, 0xfe, 0x31,
	0x76, 0x88, 0x4e, 0x5d, 0x80, 0xb8, 0x09, 0x95, 0x93, 0xf0, 0x83, 0xad, 0xf3, 0x30, 0x55, 0xdd,
	0xbc, 0x76, 0xce, 0x03, 0x44, 0x53, 0xa8, 0xcb, 0x38, 0xc6, 0xee, 0x31, 0x8b, 0xb7, 0x6e, 0x72,
	0x68, 0x0c, 0xc3, 0xf1, 0x6d, 0x58, 0xc3, 0xa6, 0x69, 0xbf, 0xeb, 0x4e, 0xbc, 0xee, 0xdb, 0x2e,
	0x35, 0xd8, 0x6d, 0xee, 0x0e, 0xcf, 0xa6, 0xfc, 0x81, 0xfc, 0x1f, 0xf9, 0x50, 0x49, 0xfa, 0x93,
	0x23, 0x57, 0x73, 0x8c, 0x23, 0x16, 0xcb, 0x3d, 0x7b, 0x6c, 0x68, 0xbe, 0x6e, 0x2c, 0x43, 0xd9,
	0xe5, 0x63, 0xcc, 0x7f, 0xf3, 0x44, 0x41, 0x7c, 0x0e, 0x8b, 0xee, 0xe4, 0x88, 0xc6, 0x22, 0xe6,
	0x78, 0xaa, 0x9b, 0xb7, 0xcf, 0x05, 0xac, 0x29, 0xa8, 0x1b, 0x7d, 0x3e, 0x9b, 0xfa, 0x0a, 0xcd,
	0xb6, 0xdc, 0xc9, 0x88, 0x38, 0xd4, 0x57, 0xe4, 0x58, 0xd0, 0x15, 0x01, 0x1c, 0xea, 0x40, 0x5c,
	0x8f, 0x7e, 0xcb, 0xfb, 0x29, 0x4e, 0x25, 0x9c, 0xc8, 0xf8, 0xcb, 0xad, 0x72, 0x15, 0xaa, 0x63,
	0xc7, 0xb0, 0x1d, 0xc3, 0x3b, 0x53, 0x4d, 0x72, 0x4a, 0xb8, 0x45, 0xe6, 0xc5, 0x15, 0x58, 0xd4,
	0x27, 0x0e, 0x3e, 0x32, 0x09, 0x33, 0xc3, 0xc2, 0x8b, 0x9c, 0xe7, 0x4c, 0x88, 0xf8, 0x14, 0x10,
	0x4b, 0x4c, 0x42, 0xf5, 0x35, 0xb8, 0x21, 0x96, 0x66, 0x99, 0x3d, 0x9d, 0x82, 0xc5, 0xb3, 0x10,
	0x48, 0xf5, 0xce, 0xab, 0x50, 0x75, 0x08, 0xd6, 0xd5, 0xd0, 0xeb, 0xb2, 0xf0, 0x5a, 0x10, 0x6f,
	0xc2, 0x02, 0x0f, 0x6d, 0x2c, 0xae, 0x96, 0x36, 0x97, 0x93, 0x52, 0x5d, 0xb1, 0x0b, 0x35, 0xc3,
	0x32, 0x3c, 0x03, 0x9b, 0x07, 0xb6, 0xcb, 0xb3, 0xb9, 0x0a, 0xf3, 0x7e, 0x1b, 0x17, 0xb0, 0xb3,
	0x3d, 0xbd, 0xea, 0xc5, 0xc2, 0x1e, 0xf6, 0x88, 0xeb, 0x89, 0x37, 0x61, 0x3d, 0x4a, 0x31, 0xe2,
	0x72, 0x53, 0x5d, 0x0f, 0x7b, 0x84, 0x45, 0xe4, 0x82, 0x28, 0xc3, 0xf2, 0x5b, 0xdb, 0xd1, 0x68,
	0x12, 0x32, 0x36, 0x34, 0x55, 0x73, 0x08, 0x66, 0x7b, 0xd7, 0x62, 0x9c, 0xdb, 0x80, 0xcf, 0xa6,
	0x39, 0xe7, 0xd8, 0xa6, 0x79, 0x84, 0xb5, 0x13, 0x95, 0xf2, 0x99, 0x83, 0x24, 0x1a, 0x0b, 0xd8,
	0x2c, 0x88, 0x4c, 0xe9, 0x34, 0xf1, 0x30, 0x8b, 0xd3, 0xa5, 0xf9, 0x3a, 0x4d, 0x3c, 0x2c, 0x6f,
	0xc1, 0x62, 0xa0, 0x17, 0x15, 0x28, 0x2a, 0xef, 0x35, 0x73, 0xe2, 0x1a, 0xa7, 0x41, 0xfe, 0xce,
	0xe6, 0x21, 0x81, 0xa6, 0xcb, 0x2f, 0xb1, 0x61, 0xda, 0xa7, 0xc4, 0x41, 0x19, 0xb1, 0x0a, 0xb0,
	0x4b, 0xce, 0x54, 0x7f, 0x34, 0x2b, 0x7f, 0x0e, 0xb5, 0x19, 0x66, 0xd0, 0xc5, 0x9c, 0x1d, 0xe8,
	0x12, 0x5d, 0xac, 0x60, 0xc7, 0x34, 0xe8, 0x9b, 0x20, 0xff, 0x89, 0x00, 0x9f, 0xfa, 0xbc, 0x3c,
	0x08, 0x22, 0x1e, 0xd1, 0x07, 0x94, 0x0b, 0x61, 0x6c, 0x9e, 0xd1, 0xff, 0x69, 0xdd, 0xe4, 0xa9,
	0x63, 0x72, 0x68, 0xc8, 0xa6, 0x84, 0x86, 0x5c, 0x6a, 0x68, 0x60, 0xd1, 0x4b, 0xfe, 0xfd, 0x0c,
	0xdc, 0xb9, 0x00, 0xb9, 0xd0, 0xc7, 0x8a, 0x00, 0x61, 0xc8, 0x76, 0x99, 0xeb, 0xa9, 0x24, 0x62,
	0xda, 0x8b, 0xf9, 0xdc, 0x2c, 0xd3, 0xac, 0x1f, 0x27, 0x6a, 0xd6, 0x45, 0x1b, 0x6e, 0xec, 0xd9,
	0xf6, 0xc9, 0x64, 0xcc, 0x44, 0xd5, 0x80, 0x3c, 0x71, 0x1c, 0xdb, 0x61, 0x44, 0x9d, 0x2f, 0xe2,
	0x98, 0x0f, 0x56, 0xe8, 0x04, 0x5a, 0xb7, 0xf8, 0xda, 0xe3, 0x93, 0x78, 0x0b, 0x20, 0x06, 0xa8,
	0x44, 0xc5, 0xaf, 0x69, 0xc4, 0x75, 0xb9, 0xc4, 0xa9, 0x94, 0xa9, 0xc4, 0xe5, 0x7f, 0x16, 0x40,
	0xf4, 0x11, 0xf3, 0xa7, 0x53, 0x9c, 0x3e, 0x44, 0x32, 0xeb, 0x50, 0xa1, 0x8c, 0xa5, 0xfe, 0x01,
	0x7b, 0xc6, 0x29, 0x27, 0x3a, 0x4c, 0x5f, 0x92, 0xe5, 0x96, 0x4b, 0x91, 0x5b, 0x3e, 0x55, 0x6e,
	0xdc, 0x25, 0xd5, 0x41, 0xc2, 0xfa, 0x29, 0xcd, 0xe5, 0x68, 0x12, 0x6e, 0x1a, 0xae, 0x47, 0xac,
	0xc0, 0x69, 0xb1, 0x74, 0x41, 0xfe, 0xf7, 0x0c, 0x5c, 0x3d, 0x4f, 0x4f, 0x28, 0x4c, 0x09, 0x10,
	0xcf, 0x3e, 0x28, 0xef, 0x0c, 0x8d, 0x1c, 0x3a, 0xa6, 0x1f, 0x4d, 0xae, 0xc1, 0xd2, 0xec, 0xc8,
	0xc0, 0x74, 0xfd, 0x0c, 0x50, 0x39, 0x27, 0xdb, 0xc7, 0x89, 0xb2, 0x4d, 0xd8, 0x32, 0x2e, 0xce,
	0x69, 0x36, 0xe6, 0x92, 0xd9, 0x98, 0x8f, 0xb3, 0x31, 0x54, 0x80, 0x85, 0x8f, 0x50, 0x80, 0x45,
	0x3f, 0x07, 0xb8, 0xe2, 0x67, 0x5c, 0xc7, 0x8e, 0x3d, 0x19, 0x1e, 0xab, 0x2e, 0x27, 0x8c, 0xe5,
	0x5d, 0x85, 0x78, 0x6c, 0x7a, 0x3c, 0xa5, 0x2a, 0x65, 0x28, 0xf4, 0x88, 0x6e, 0x38, 0x44, 0xa3,
	0x46, 0x5d, 0x82, 0x45, 0x3f, 0xa9, 0x41, 0x42, 0x4c, 0x71, 0x32, 0xd4, 0x84, 0x6a, 0x81, 0x46,
	0xfb, 0x75, 0xe0, 0xac, 0xd6, 0x2c, 0x41, 0x29, 0x2c, 0x11, 0x43, 0xb5, 0x99, 0xe6, 0x41, 0x36,
	0x08, 0x40, 0xd3, 0xb5, 0x64, 0xce, 0xaf, 0x66, 0x8a, 0x7e, 0x35, 0x43, 0xf4, 0x59, 0xb6, 0x44,
	0x41, 0x63, 0x21, 0x35, 0x68, 0x44, 0xc1, 0x61, 0x31, 0x25, 0x38, 0x20, 0xc8, 0x93, 0xb1, 0xad,
	0x1d, 0xf3, 0x84, 0x9a, 0xfa, 0xd8, 0xbb, 0x70, 0x6d, 0xe2, 0x12, 0xd6, 0x97, 0x39, 0x35, 0x74,
	0xa2, 0xab, 0xd3, 0x08, 0x16, 0x23, 0xf7, 0x2d, 0xff, 0xa5, 0x00, 0xa5, 0x20, 0x6a, 0x10, 0x4b,
	0x9f, 0x25, 0x9b, 0xf7, 0x15, 0x12, 0xeb, 0xe2, 0x35, 0x28, 0xc7, 0xeb, 0xc6, 0x20, 0x01, 0x7a,
	0x94, 0x58, 0x27, 0xe5, 0x52, 0xea, 0xa4, 0xfc, 0x05, 0x75, 0xd2, 0x42, 0x50, 0x27, 0xfd, 0x61,
	0x64, 0xee, 0x14, 0xd7, 0x1e, 0xd1, 0x88, 0x31, 0xf6, 0x3e, 0x02, 0xe5, 0x07, 0x00, 0xb1, 0xf8,
	0x9e, 0xbd, 0x38, 0xbe, 0xcf, 0xc1, 0x28, 0xa0, 0x46, 0x7e, 0x17, 0xe5, 0x45, 0xc4, 0xd2, 0xb9,
	0x2e, 0x7f, 0x38, 0x3a, 0xa1, 0x7d, 0x64, 0x13, 0xbb, 0x5c, 0xc9, 0xf6, 0x91, 0x63, 0x0d, 0x18,
	0x37, 0x2c, 0x9a, 0x7c, 0x84, 0x67, 0x13, 0x26, 0x21, 0x81, 0x60, 0xba, 0xeb, 0x05, 0x04, 0x5f,
	0x03, 0xe4, 0x10, 0xbf, 0x26, 0x3e, 0x53, 0x35, 0x7b, 0x62, 0x79, 0x8c, 0x4f, 0x15, 0x4a, 0xed,
	0x7f, 0x66, 0x01, 0x82, 0x94, 0x5a, 0x3b, 0x49, 0xde, 0x71, 0x13, 0x0a, 0x34, 0xf6, 0xb3, 0xb2,
	0x39, 0xc3, 0xc8, 0xaa, 0x27, 0x3a, 0x9b, 0xa6, 0x76, 0xb2, 0xd1, 0xd4, 0x4e, 0x98, 0xd1, 0xce,
	0x8a, 0x25, 0x7b, 0x11, 0x96, 0x5b, 0x80, 0x4e, 0xb1, 0x69, 0xe8, 0x3c, 0xbd, 0x88, 0x07, 0x99,
	0xc6, 0xdc, 0xcd, 0x5e, 0x87, 0x0b, 0x38, 0x4b, 0x37, 0x12, 0x1a, 0x87, 0x57, 0xcf, 0xd9, 0x61,
	0xd4, 0xe2, 0x4a, 0xd2, 0xea, 0x85, 0x14, 0xad, 0x5e, 0x0c, 0x74, 0xe4, 0x2e, 0x2c, 0x06, 0x84,
	0x56, 0x01, 0xda, 0x96, 0x6e, 0x9c, 0x1a, 0xfa, 0x04, 0x9b, 0xe8, 0x12, 0x7d, 0x6f, 0x4d, 0x46,
	0x13, 0x93, 0xf9, 0x4e, 0x24, 0x50, 0x05, 0xaf, 0xcd, 0xe2, 0x79, 0x1d, 0xae, 0x1e, 0xc6, 0x9a,
	0x37, 0x7d, 0xe3, 0x1b, 0xd2, 0xb2, 0x1d, 0x67, 0xc2, 0xb2, 0x35, 0x74, 0x49, 0x5c, 0x05, 0x71,
	0x9b, 0xc4, 0x1a, 0x43, 0x6c, 0x15, 0x12, 0xc4, 0x65, 0x40, 0xad, 0x63, 0xa2, 0x9d, 0xb8, 0x93,
	0xd1, 0xbe, 0xe1, 0x8e, 0xb0, 0xa7, 0x1d, 0xa3, 0x8c, 0x78, 0x05, 0x56, 0xb6, 0xe8, 0xe3, 0x36,
	0xe9, 0x13, 0xc7, 0xc0, 0xa6, 0xf1, 0x0d, 0xe1, 0x0b, 0xb2, 0xe2, 0x12, 0xd4, 0xb6, 0x49, 0xd0,
	0x7e, 0xe1, 0x1f, 0x73, 0xf2, 0x9f, 0x45, 0x26, 0xd7, 0xd4, 0x4e, 0xc2, 0x48, 0x94, 0x28, 0xfa,
	0x24, 0x0e, 0x65, 0x52, 0x38, 0x94, 0x8d, 0xfa, 0x0a, 0xdf, 0x39, 0x51, 0xd8, 0x83, 0x6b, 0x21,
	0x7a, 0x94, 0x89, 0x2d, 0x1f, 0xab, 0xd6, 0x31, 0x2b, 0x70, 0x12, 0xf1, 0x94, 0xa0, 0x68, 0xb8,
	0x2a, 0x66, 0xf3, 0x19, 0x82, 0x61, 0x2c, 0x79, 0x11, 0xfa, 0xc2, 0x97, 0xa6, 0xfd, 0x2e, 0x79,
	0xf5, 0x2a, 0x54, 0x7d, 0x14, 0x0e, 0x88, 0x33, 0xe2, 0x34, 0x66, 0x1a, 0x15, 0xf9, 0x87, 0x21,
	0xa3, 0x0e, 0x2d, 0x37, 0x2c, 0x92, 0x12, 0x41, 0x24, 0x24, 0x24, 0xf2, 0xef, 0xc5, 0xfd, 0x30,
	0x39, 0xf9, 0xe0, 0x85, 0x1f, 0xef, 0xd3, 0xd6, 0x61, 0x39, 0x58, 0x30, 0xd5, 0xd7, 0x64, 0x4e,
	0x4d, 0x7e, 0x00, 0x92, 0x8f, 0x46, 0x8f, 0x60, 0xed, 0x98, 0xe8, 0x8a, 0xa5, 0x77, 0xdf, 0xf2,
	0xbc, 0x2a, 0x09, 0x27, 0xf9, 0x47, 0x61, 0x99, 0xdd, 0x32, 0x6d, 0x97, 0x84, 0xe1, 0x34, 0xd1,
	0x0d, 0x26, 0x51, 0x3e, 0x03, 0x20, 0x90, 0xe0, 0x87, 0xb3, 0xce, 0x86, 0xdb, 0x21, 0xca, 0xbe,
	0xeb, 0x3a, 0xb4, 0xb0, 0x76, 0x62, 0xd9, 0xef, 0x58, 0x7f, 0x3c, 0x70, 0x91, 0x6e, 0x32, 0xc8,
	0x87, 0x50, 0x8a, 0x18, 0x48, 0xa5, 0x79, 0x91, 0xfb, 0x91, 0x7f, 0x12, 0x3a, 0x5f, 0x3f, 0x2d,
	0x9d, 0x41, 0x8b, 0xc3, 0x8d, 0x82, 0x77, 0x66, 0x7e, 0xf0, 0x96, 0xcf, 0x60, 0x75, 0x26, 0x11,
	0x49, 0x83, 0x79, 0x2e, 0xd7, 0xe0, 0x55, 0xf6, 0x3a, 0x20, 0x13, 0xcf, 0xc4, 0x28, 0xaa, 0x09,
	0x59, 0xd6, 0xed, 0x3f, 0xdf, 0x3d, 0xcd, 0xb1, 0x7e, 0xc3, 0x2f, 0xa0, 0xec, 0x6f, 0xcd, 0x8d,
	0x2b, 0x69, 0xc3, 0xd0, 0x34, 0x33, 0x1f, 0x11, 0xa2, 0xb2, 0x2c, 0x44, 0x55, 0x42, 0x85, 0x3e,
	0x30, 0xac, 0x61, 0xfc, 0xd5, 0xb6, 0x86, 0x71, 0xa9, 0xfb, 0x12, 0xe9, 0x7b, 0xd8, 0x4b, 0xa6,
	0x3a, 0xa9, 0x17, 0x20, 0xff, 0x51, 0x16, 0xd6, 0x93, 0x20, 0xc4, 0x4b, 0x9f, 0x73, 0x90, 0xee,
	0x03, 0x30, 0x72, 0x54, 0xcd, 0xd6, 0x89, 0xdf, 0x40, 0x4c, 0xa1, 0x69, 0x05, 0x2a, 0x7c, 0x7a,
	0x44, 0x99, 0xc0, 0x0b, 0x8a, 0x91, 0x3b, 0xec, 0x61, 0x8f, 0x74, 0xfd, 0xce, 0xa9, 0xc0, 0xba,
	0x5f, 0xee, 0x70, 0xc0, 0xb3, 0xd5, 0xf1, 0xc4, 0xa3, 0x23, 0xf9, 0xd8, 0x08, 0x9d, 0x1d, 0xaa,
	0x27, 0x0b, 0x1c, 0xd4, 0x45, 0x97, 0x03, 0xba, 0x3a, 0x61, 0x11, 0xc0, 0x7a, 0x46, 0xa7, 0xd8,
	0x30, 0xf1, 0x91, 0x19, 0xba, 0x18, 0x96, 0xd9, 0x89, 0x6b, 0x50, 0x9b, 0x50, 0xc5, 0x8e, 0x34,
	0x9a, 0xa5, 0x72, 0x54, 0xd5, 0xd6, 0x8f, 0x4c, 0x9b, 0x0e, 0x04, 0xac, 0xe8, 0x5a, 0x87, 0xfe,
	0x4c, 0xd7, 0xef, 0x1d, 0x16, 0xa8, 0x84, 0xb0, 0xae, 0xd3, 0x30, 0xc1, 0x7a, 0x0f, 0xac, 0x47,
	0xa2, 0x05, 0x3d, 0xbf, 0xbe, 0x61, 0x69, 0xbc, 0xb7, 0x5f, 0x14, 0xcb, 0xfe, 0xe1, 0x5b, 0x25,
	0x98, 0xe5, 0xe3, 0xaf, 0xbc, 0x1f, 0x1b, 0x0e, 0xd1, 0x59, 0x73, 0x40, 0xf0, 0xb9, 0xb0, 0x85,
	0xb5, 0x13, 0xd3, 0x1e, 0xb2, 0x96, 0x40, 0x4e, 0xde, 0x82, 0x35, 0x5f, 0x26, 0x3b, 0xc4, 0xdb,
	0xc3, 0xae, 0x17, 0x1a, 0xce, 0x87, 0x9b, 0xf3, 0x49, 0x58, 0x7a, 0xcf, 0xc2, 0x08, 0x45, 0xfb,
	0x04, 0x6a, 0x4c, 0xdf, 0x63, 0x8e, 0x4f, 0xb8, 0x38, 0xb7, 0x49, 0xda, 0xec, 0xef, 0x85, 0x30,
	0x80, 0xec, 0x10, 0x8f, 0xb9, 0x39, 0xb7, 0xfb, 0x96, 0x4a, 0xc3, 0x1d, 0x63, 0x2d, 0x59, 0x89,
	0x2e, 0x43, 0xd1, 0x0a, 0x26, 0xf8, 0x06, 0xf8, 0x0a, 0x72, 0x23, 0xaa, 0x51, 0xd9, 0x94, 0xa6,
	0x4c, 0x12, 0xfc, 0x8d, 0x7d, 0x5b, 0x27, 0x2f, 0xe0, 0x40, 0xe9, 0xf5, 0xdb, 0xfd, 0x81, 0xd2,
	0x19, 0xc8, 0x8f, 0x21, 0xc7, 0xda, 0x78, 0x55, 0x88, 0x7d, 0x45, 0x97, 0x44, 0x11, 0xaa, 0x9d,
	0x6e, 0x47, 0x8d, 0x7d, 0x13, 0xc4, 0x45, 0xc8, 0x36, 0xf7, 0xf6, 0x50, 0x46, 0x6e, 0xc3, 0x67,
	0x29, 0x9b, 0xa4, 0x5a, 0x44, 0x15, 0x16, 0x58, 0xd5, 0xc3, 0x1d, 0x5f, 0x51, 0xde, 0x0f, 0x33,
	0xda, 0x1d, 0xe2, 0xf9, 0x05, 0x46, 0xd2, 0xba, 0xb0, 0x5a, 0xe2, 0x0c, 0x38, 0xef, 0x63, 0x58,
	0x5b, 0x5d, 0xfe, 0x1b, 0x21, 0x8c, 0x27, 0x21, 0xbc, 0xdf, 0x82, 0x85, 0x46, 0xbe, 0x37, 0x97,
	0x52, 0x38, 0x9d, 0x47, 0x3a, 0xcf, 0x90, 0xd6, 0xe2, 0x38, 0x77, 0x9d, 0x96, 0x43, 0xb0, 0x47,
	0x3e, 0x9c, 0x17, 0xd1, 0xe6, 0x59, 0xa6, 0x94, 0xc9, 0x8e, 0xff, 0x8f, 0x05, 0xa8, 0xcf, 0xdb,
	0xe5, 0xb7, 0xc0, 0xa1, 0x79, 0x41, 0xe1, 0x6b, 0xa8, 0xf8, 0x58, 0x75, 0xc8, 0xbb, 0xc1, 0x7b,
	0x2b, 0x11, 0x05, 0x9e, 0xcc, 0xa9, 0x9e, 0x67, 0xaa, 0x2e, 0xd1, 0x6c, 0x4b, 0x8f, 0x25, 0x7a,
	0x08, 0xf2, 0x9e, 0x16, 0x04, 0x20, 0x96, 0x00, 0xff, 0x4a, 0x80, 0x95, 0x29, 0x98, 0xa9, 0xe4,
	0xfd, 0x5f, 0x64, 0x91, 0xbf, 0x1b, 0x0a, 0xbc, 0xa9, 0x47, 0x2d, 0xae, 0x81, 0x3d, 0x8f, 0xfe,
	0xef, 0x8c, 0xe3, 0x74, 0x3b, 0x2e, 0xc7, 0x2c, 0xee, 0xaf, 0x22, 0x45, 0x38, 0xb7, 0xfb, 0xf7,
	0x8e, 0x53, 0x8f, 0xa1, 0xdc, 0x8f, 0x75, 0x8b, 0x3f, 0xe8, 0x10, 0x40, 0xfe, 0xd3, 0xc8, 0xc9,
	0x36, 0x75, 0x3d, 0xbe, 0xfe, 0x37, 0xc0, 0xe2, 0x87, 0x33, 0x28, 0xe4, 0x92, 0x2a, 0xbb, 0x38,
	0x0e, 0xf2, 0x5f, 0x0b, 0xa1, 0xfb, 0x4c, 0x42, 0xef, 0x7b, 0x27, 0x83, 0x3f, 0x10, 0x42, 0x1b,
	0x55, 0x2c, 0xfd, 0xd7, 0xce, 0xc0, 0xcf, 0x01, 0xa8, 0x71, 0xd3, 0xfa, 0xc8, 0xf7, 0x0a, 0xd5,
	0xcd, 0xb5, 0x69, 0xf4, 0x06, 0xef, 0xad, 0x26, 0x1b, 0x8e, 0xdb, 0x36, 0xc7, 0xe5, 0x7b, 0xc7,
	0xad, 0x3f, 0x8f, 0x22, 0x10, 0xc7, 0xb0, 0x6b, 0x85, 0x36, 0xf6, 0xeb, 0x45, 0x32, 0xb4, 0x05,
	0xde, 0x00, 0x9c, 0xe6, 0x63, 0x3e, 0x9d, 0x8f, 0x31, 0x27, 0x70, 0x0e, 0xcb, 0xef, 0x1d, 0x4b,
	0xff, 0x29, 0xb2, 0xe7, 0x00, 0xd9, 0x29, 0xa7, 0xf0, 0x1b, 0xb6, 0x67, 0x21, 0xdd, 0x9e, 0x3f,
	0x8e, 0xf1, 0x31, 0xe3, 0x4f, 0xa2, 0xe5, 0x7b, 0xc7, 0xfb, 0xff, 0xbe, 0x01, 0xa5, 0x2d, 0x4c,
	0xcb, 0x64, 0x86, 0xb3, 0xf8, 0xff, 0xfc, 0x5c, 0x9d, 0x9f, 0x0c, 0x5f, 0x9f, 0x86, 0x14, 0x9b,
	0xc8, 0x6f, 0xcb, 0xdd, 0x87, 0x45, 0x3f, 0xe3, 0xf7, 0x8b, 0xd2, 0xf5, 0xc4, 0x54, 0x35, 0xb8,
	0x88, 0xf1, 0x08, 0x8a, 0x61, 0x81, 0xe0, 0xb7, 0x16, 0xae, 0xa7, 0x2d, 0x20, 0x3a, 0x5d, 0x12,
	0x76, 0x3f, 0x7c, 0x59, 0x5d, 0x4f, 0x3f, 0xa3, 0x14, 0x1f, 0x40, 0x21, 0x28, 0x6a, 0x19, 0x91,
	0xa5, 0x84, 0x5b, 0x4d, 0x53, 0x9d, 0xfa, 0x3b, 0x90, 0x73, 0x89, 0xc5, 0x1b, 0xc3, 0xa5, 0x59,
	0xee, 0xc5, 0x9b, 0xd9, 0xcf, 0xa0, 0x4c, 0x27, 0xaa, 0x0e, 0xef, 0x14, 0xfb, 0x5d, 0xf4, 0xfa,
	0xdc, 0x05, 0x41, 0x47, 0x79, 0x13, 0x80, 0xad, 0xe3, 0x42, 0x2a, 0xa4, 0x51, 0x11, 0xb6, 0x7d,
	0xef, 0x47, 0x92, 0x2a, 0xa6, 0xb0, 0x36, 0x68, 0xd7, 0xde, 0x82, 0x2c, 0xd6, 0x4e, 0xfc, 0x5b,
	0x1d, 0xd2, 0xbc, 0xae, 0x25, 0x25, 0xf5, 0xad, 0x69, 0xbf, 0x63, 0x05, 0xdb, 0x3c, 0x52, 0x59,
	0xaf, 0xea, 0x29, 0x94, 0x26, 0x51, 0xdf, 0xc9, 0x3f, 0x4c, 0x4e, 0xa6, 0x34, 0xde, 0x9f, 0xba,
	0x0f, 0x8b, 0x2e, 0xef, 0x37, 0xb0, 0x6a, 0x6f, 0x1e, 0xd6, 0x41, 0x4f, 0xe2, 0x6e, 0xa0, 0xb8,
	0xd5, 0x24, 0x2b, 0x9c, 0xea, 0x26, 0xbc, 0x80, 0xaa, 0x66, 0xda, 0x2e, 0x09, 0xcf, 0x1e, 0x58,
	0x89, 0x58, 0xda, 0x94, 0x93, 0x15, 0x68, 0xaa, 0x77, 0x14, 0xae, 0x0d, 0x2a, 0x46, 0x76, 0x7c,
	0x9c, 0xba, 0x36, 0x6c, 0x1b, 0xfd, 0x7f, 0x76, 0x37, 0x83, 0xb7, 0x48, 0x02, 0xd2, 0xf8, 0x11,
	0xf3, 0xcd, 0x54, 0xad, 0x0a, 0x48, 0xbc, 0x03, 0xb9, 0xb1, 0x61, 0x0d, 0xd9, 0x0d, 0xb1, 0x79,
	0x1c, 0x3f, 0x30, 0xac, 0x21, 0x9b, 0x68, 0x5b, 0x43, 0x76, 0x63, 0x6c, 0xee, 0x44, 0xdb, 0x1a,
	0x8a, 0xbf, 0x80, 0x4f, 0x9d, 0xf4, 0xc6, 0x14, 0xbb, 0x60, 0x56, 0xda, 0x7c, 0x92, 0x08, 0xe3,
	0xa2, 0xa6, 0xd6, 0x2b, 0xb8, 0x1c, 0xe6, 0x94, 0xc1, 0x71, 0xac, 0xb4, 0xc2, 0x00, 0xde, 0xff,
	0xa8, 0x33, 0x5c, 0xf1, 0xa7, 0xb1, 0xfb, 0x5d, 0xb3, 0x07, 0xbb, 0xec, 0xa6, 0x5b, 0x69, 0xf3,
	0xe9, 0x77, 0x3a, 0x15, 0xa6, 0xda, 0x69, 0x46, 0xa7, 0x8b, 0xec, 0x66, 0xdc, 0x3c, 0xed, 0x8c,
	0x1f, 0xe4, 0x2a, 0xb0, 0x64, 0x9e, 0x3f, 0x94, 0x64, 0x17, 0xe7, 0x4a, 0x73, 0x5a, 0xfd, 0x49,
	0xe7, 0xa6, 0x5f, 0x46, 0x57, 0x44, 0x58, 0x8b, 0x48, 0xba, 0x92, 0xa6, 0x4d, 0x53, 0xed, 0xa8,
	0x36, 0xac, 0x68, 0x49, 0xdd, 0x25, 0xe9, 0x2a, 0x03, 0x71, 0xef, 0x62, 0x10, 0x21, 0x16, 0x4d,
	0xb8, 0xec, 0xcc, 0xb6, 0x54, 0xa5, 0x6b, 0x0c, 0xcc, 0xed, 0x39, 0x82, 0x9f, 0x6d, 0xc0, 0x32,
	0xc7, 0x47, 0x4e, 0xa4, 0xf5, 0x54, 0xc7, 0x47, 0x4e, 0xc4, 0x1f, 0x01, 0x1a, 0xce, 0x34, 0x4f,
	0xa4, 0x4f, 0xd8, 0xa2, 0x5b, 0xf3, 0x7a, 0x13, 0xd3, 0xdd, 0x9a, 0x2e, 0x48, 0xc3, 0x39, 0xdd,
	0x17, 0xe9, 0x7a, 0x8a, 0x6e, 0xcd, 0x6d, 0xd9, 0xb4, 0x61, 0x95, 0x77, 0xdc, 0x43, 0x9b, 0x56,
	0x35, 0xd6, 0xa3, 0x97, 0x3e, 0x65, 0xe0, 0xee, 0xce, 0x71, 0x81, 0x09, 0x4d, 0xfd, 0x1d, 0x58,
	0x1e, 0x26, 0xb4, 0x39, 0xa4, 0x7a, 0x0a, 0xa0, 0xc4, 0xe6, 0xce, 0x1b, 0x58, 0x1f, 0xa6, 0xf4,
	0x4b, 0xa4, 0x1b, 0x0c, 0xe0, 0xa3, 0x0f, 0x06, 0x18, 0x12, 0xfb, 0x08, 0x8a, 0xc3, 0xa0, 0xdb,
	0x21, 0xc9, 0x29, 0xe1, 0x23, 0xea, 0xb1, 0x34, 0xe1, 0xf2, 0x70, 0xb6, 0x41, 0x22, 0x7d, 0x96,
	0xa2, 0x1d, 0xe7, 0xdb, 0x29, 0x5f, 0xf2, 0xc3, 0xf8, 0xf0, 0xa6, 0x9b, 0x74, 0x33, 0x45, 0xcd,
	0xa7, 0xef, 0xc4, 0x3d, 0x87, 0x32, 0x8e, 0x5d, 0xcd, 0x93, 0x6e, 0xb1, 0x95, 0x37, 0xe6, 0xae,
	0x8c, 0x1b, 0x36, 0x8e, 0xce, 0x85, 0xa4, 0xdb, 0x29, 0x86, 0x1d, 0x3f, 0x3f, 0xe2, 0xd4, 0x4e,
	0x37, 0x3d, 0xa4, 0x3b, 0xe9, 0xd4, 0xce, 0x34, 0x62, 0xbe, 0x86, 0x2b, 0xc3, 0x79, 0x7d, 0x13,
	0xa9, 0xc1, 0x40, 0x6d, 0x7c, 0x18, 0xa8, 0x10, 0xab, 0xcf, 0x61, 0xc1, 0x62, 0x0d, 0x0a, 0x69,
	0x33, 0xe9, 0x18, 0x65, 0xba, 0x2f, 0xf2, 0x15, 0x54, 0xad, 0xa9, 0x6e, 0x86, 0xf4, 0x98, 0x2d,
	0xfa, 0x2c, 0x65, 0x51, 0x9c, 0x7e, 0x3c, 0x5b, 0xeb, 0x4b, 0x4f, 0x52, 0xe8, 0x3f, 0xdf, 0x97,
	0xf8, 0x1a, 0xae, 0xe0, 0x79, 0xed, 0x02, 0xe9, 0x69, 0x0a, 0xfd, 0xf3, 0x9b, 0x0c, 0x3b, 0xb0,
	0x8c, 0x13, 0x0a, 0x60, 0xe9, 0x59, 0x9a, 0x85, 0x26, 0x15, 0xf4, 0x6f, 0x60, 0x1d, 0xa7, 0x54,
	0xd2, 0xd2, 0xf3, 0x14, 0xc3, 0x4a, 0x2d, 0xc1, 0x3f, 0x87, 0x05, 0xc2, 0xb2, 0x74, 0xe9, 0x8b,
	0x14, 0x09, 0xf9, 0x55, 0xf1, 0x57, 0x50, 0x25, 0x53, 0x35, 0xa9, 0xf4, 0x65, 0x8a, 0x84, 0x66,
	0xca, 0xd7, 0x26, 0x5c, 0x26, 0xb3, 0x85, 0x98, 0xf4, 0x22, 0x45, 0x42, 0xe7, 0x8b, 0xcb, 0xaf,
	0xe1, 0x0a, 0x99, 0x57, 0xcb, 0x49, 0x5f, 0xa5, 0x48, 0x68, 0x7e, 0x05, 0xb8, 0x03, 0xcb, 0x24,
	0xa1, 0x4a, 0x91, 0x7e, 0x90, 0x22, 0xa1, 0xc4, 0x12, 0xed, 0x0d, 0xac, 0x93, 0x94, 0x72, 0x47,
	0xfa, 0x61, 0x8a, 0x84, 0xd2, 0xea, 0x24, 0xf9, 0x5f, 0x0b, 0xfe, 0x7f, 0x6c, 0x4a, 0xb0, 0xd8,
	0xea, 0x76, 0x3a, 0x4a, 0x6b, 0x80, 0x32, 0x62, 0x05, 0x8a, 0xfe, 0x8b, 0xb2, 0x8d, 0xb2, 0xf4,
	0xb5, 0x7f, 0xb8, 0xd5, 0x6f, 0xf5, 0xda, 0x5b, 0x0a, 0xca, 0xb1, 0xbf, 0xdb, 0xf4, 0xba, 0xdb,
	0x87, 0x2d, 0xa5, 0xc7, 0xff, 0x5a, 0xd3, 0x57, 0x3a, 0xdb, 0x68, 0x41, 0x44, 0x50, 0xa6, 0x4f,
	0x6a, 0x4f, 0x69, 0x29, 0xed, 0x83, 0x01, 0x5a, 0x14, 0xab, 0x00, 0xec, 0x8b, 0xd2, 0xeb, 0x75,
	0x7b, 0xa8, 0x40, 0x37, 0xd9, 0x57, 0xfa, 0xfd, 0xe6, 0x8e, 0x82, 0x8a, 0xac, 0x1d, 0xde, 0xda,
	0x45, 0x40, 0x21, 0xbc, 0xdc, 0xeb, 0xbe, 0x41, 0x25, 0xb1, 0x06, 0xa5, 0xc3, 0x4e, 0xb4, 0x55,
	0x99, 0x5d, 0x25, 0x3b, 0x6c, 0xb5, 0x94, 0x7e, 0x1f, 0x55, 0xc4, 0x22, 0xe4, 0x39, 0xa0, 0xaa,
	0x28, 0x42, 0xb5, 0xb5, 0xd7, 0xed, 0x2b, 0x6a, 0x88, 0x48, 0x2d, 0xfa, 0xd6, 0xea, 0x76, 0xfa,
	0x87, 0xfb, 0x4a, 0x0f, 0x21, 0x71, 0x19, 0x50, 0x30, 0x43, 0x0d, 0x00, 0x5d, 0xa6, 0x1b, 0x1e,
	0xb4, 0x3b, 0x3b, 0x48, 0x64, 0x4f, 0xdd, 0xce, 0x0e, 0x5a, 0x12, 0x6f, 0xc1, 0x8d, 0x9e, 0xb2,
	0xad, 0xec, 0xb5, 0x5f, 0x2b, 0x3d, 0xf5, 0xb0, 0xd3, 0x6c, 0xed, 0x76, 0xba, 0x6f, 0xf6, 0x94,
	0xed, 0x1d, 0x65, 0x5b, 0xf5, 0x71, 0xee, 0xa3, 0x65, 0x51, 0x82, 0xe5, 0x83, 0x66, 0x6f, 0xd0,
	0x1e, 0xb4, 0xbb, 0x1d, 0x36, 0x32, 0x68, 0x6e, 0x37, 0x07, 0x4d, 0xb4, 0x22, 0xde, 0x80, 0x4f,
	0x92, 0x46, 0xd4, 0x9e, 0xd2, 0x3f, 0xe8, 0x76, 0xfa, 0x0a, 0x5a, 0x65, 0x17, 0x18, 0xbb, 0xdd,
	0xdd, 0xc3, 0x03, 0xb4, 0x26, 0x2e, 0x41, 0x8d, 0x3f, 0x47, 0x13, 0x24, 0x46, 0x82, 0x8f, 0xbc,
	0xda, 0x1f, 0x34, 0x07, 0x7d, 0x74, 0x45, 0xbc, 0x06, 0x6b, 0xd3, 0xdf, 0xa2, 0x05, 0x57, 0x29,
	0x3a, 0x3d, 0xa5, 0xd9, 0x7a, 0xa5, 0x6c, 0xab, 0x94, 0xcf, 0xdd, 0x97, 0xea, 0xa0, 0x7b, 0xd0,
	0x6e, 0xa1, 0x6b, 0x5c, 0x2c, 0xca, 0x2e, 0x5a, 0x17, 0xd7, 0x60, 0x69, 0x47, 0x19, 0xa8, 0x7b,
	0xcd, 0xfe, 0x20, 0xa0, 0x44, 0x6d, 0x6f, 0xa3, 0x4f, 0xc4, 0x3a, 0xac, 0x27, 0x0c, 0x44, 0xe0,
	0xaf, 0x8b, 0x57, 0x61, 0xb5, 0xd9, 0x1a, 0xb4, 0x5f, 0x47, 0x3c, 0x55, 0x5b, 0xaf, 0x9a, 0x9d,
	0x1d, 0x05, 0x7d, 0x4a, 0xf1, 0xa2, 0xab, 0xd9, 0x7e, 0x7d, 0xba, 0x73, 0xa7, 0xb9, 0xaf, 0xf4,
	0x0f, 0x9a, 0x2d, 0x05, 0xd5, 0xc5, 0x9b, 0x50, 0x9f, 0x33, 0x18, 0x81, 0xbf, 0x41, 0xd5, 0x83,
	0xce, 0xea, 0xb7, 0x5e, 0x29, 0xfb, 0x4d, 0x24, 0x07, 0x98, 0xf2, 0xf7, 0x68, 0xe2, 0x67, 0x94,
	0x2f, 0xcd, 0xc3, 0xc1, 0x2b, 0xba, 0xf9, 0xde, 0x9e, 0x42, 0xf7, 0xbf, 0x29, 0x5e, 0x86, 0x0a,
	0xfb, 0x16, 0x4e, 0xbb, 0x45, 0x15, 0xb0, 0xd9, 0xda, 0x8d, 0xbe, 0xdc, 0xa6, 0xfc, 0xa1, 0x10,
	0xbb, 0x3d, 0xb5, 0xd5, 0x53, 0x9a, 0x03, 0x25, 0xd8, 0xeb, 0x0e, 0x15, 0x57, 0xd2, 0x48, 0xb4,
	0xb8, 0x41, 0x95, 0xaf, 0xa3, 0xbc, 0x51, 0x07, 0x3f, 0xed, 0xa0, 0x4d, 0xaa, 0x49, 0xfe, 0x4b,
	0x34, 0xe5, 0x31, 0x85, 0xdf, 0xdc, 0xde, 0x56, 0x43, 0xc1, 0xab, 0x83, 0x2e, 0x9b, 0xff, 0x84,
	0xc2, 0x4f, 0x1a, 0x89, 0x16, 0x3f, 0xa5, 0x1c, 0xa4, 0x53, 0x7c, 0x7d, 0x3f, 0x88, 0xaf, 0x7f,
	0x46, 0x39, 0x38, 0x67, 0x30, 0x02, 0xf1, 0x9c, 0xa2, 0x48, 0xe5, 0x4e, 0x97, 0x7c, 0x41, 0x51,
	0xf4, 0x5f, 0xa2, 0x29, 0x5f, 0x52, 0x14, 0x83, 0xaf, 0xdd, 0x4e, 0x84, 0x0f, 0x7a, 0x41, 0x51,
	0x4c, 0x1a, 0x89, 0x16, 0x7f, 0x45, 0x51, 0x8c, 0x4d, 0x89, 0x23, 0x83, 0x7e, 0x40, 0x51, 0x9c,
	0x33, 0x18, 0x81, 0xf8, 0xe1, 0xbd, 0x6d, 0x76, 0x75, 0x2f, 0xfe, 0x37, 0x27, 0xf6, 0x7f, 0xbe,
	0x6e, 0x47, 0x41, 0x97, 0xa8, 0x0f, 0xd8, 0xfb, 0xf9, 0x13, 0xfe, 0x67, 0xbe, 0x9f, 0xef, 0xb5,
	0xb7, 0x50, 0x86, 0x3d, 0xf5, 0x07, 0xd4, 0xed, 0x00, 0x2c, 0xf4, 0x3b, 0xcd, 0x83, 0x83, 0x9f,
	0xa1, 0xdc, 0xbd, 0xbf, 0xc8, 0x41, 0x29, 0xde, 0x68, 0x41, 0x50, 0x3e, 0xb4, 0x68, 0x75, 0xe5,
	0x5f, 0x7d, 0xb9, 0x44, 0xf5, 0x21, 0xa8, 0x63, 0x62, 0x77, 0x6a, 0x0e, 0x88, 0xe3, 0xb2, 0x9b,
	0x9b, 0x9a, 0x7f, 0x71, 0x26, 0x43, 0xb5, 0x8c, 0xe6, 0x44, 0xc4, 0xf2, 0x0c, 0x2d, 0xba, 0xb8,
	0x83, 0xb2, 0xe2, 0x2a, 0x88, 0x4d, 0x7e, 0x3b, 0xf2, 0x9b, 0xd8, 0xf7, 0x1c, 0xdd, 0x2b, 0x48,
	0x69, 0xb7, 0x26, 0xee, 0x19, 0xca, 0x53, 0xe3, 0xf5, 0x6f, 0x6e, 0x76, 0x6c, 0xaf, 0x47, 0xb0,
	0x7e, 0x86, 0x16, 0xa8, 0x07, 0x09, 0x8a, 0xd3, 0x2d, 0x7e, 0xba, 0xfb, 0xf5, 0xc4, 0xf6, 0xb0,
	0xf2, 0x5e, 0x23, 0x44, 0x27, 0xbc, 0xcc, 0x46, 0x8b, 0xe2, 0x5d, 0xb8, 0x95, 0x3a, 0xed, 0xbd,
	0x46, 0xf8, 0x5d, 0xa1, 0x02, 0x25, 0x29, 0xb8, 0x13, 0xc4, 0x57, 0x17, 0xa9, 0x40, 0x0e, 0x2d,
	0xff, 0x6f, 0x22, 0x44, 0x7f, 0xcd, 0xcf, 0x82, 0xf8, 0x20, 0xd0, 0xf9, 0x2c, 0xc9, 0xed, 0xd8,
	0xde, 0x4b, 0x7b, 0x62, 0xe9, 0xa8, 0x44, 0xa5, 0x1f, 0xf7, 0xfb, 0xe1, 0x48, 0x99, 0x5d, 0x38,
	0x0a, 0x4e, 0xb3, 0x83, 0xaf, 0x15, 0x4a, 0xd9, 0xc0, 0xb6, 0xf7, 0xb1, 0x75, 0xd6, 0xe3, 0xed,
	0x33, 0x17, 0x55, 0x29, 0x10, 0x06, 0x77, 0x40, 0x9c, 0x91, 0x61, 0x61, 0x2f, 0x20, 0xa6, 0x46,
	0x59, 0x13, 0x12, 0x43, 0x59, 0xc3, 0x3c, 0x6e, 0xdb, 0x62, 0xb7, 0xbd, 0x38, 0x2a, 0x78, 0x44,
	0xd0, 0x65, 0xca, 0xda, 0x36, 0xbb, 0x15, 0x85, 0x3d, 0xe3, 0xc8, 0xf4, 0x13, 0x39, 0x24, 0x52,
	0x59, 0x04, 0x48, 0x34, 0x5d, 0xd7, 0x18, 0xfa, 0xa4, 0x2c, 0x89, 0x32, 0x5c, 0x1f, 0x38, 0xd8,
	0x72, 0x79, 0x57, 0xb0, 0x65, 0xdb, 0x8e, 0x4e, 0x77, 0xb6, 0x23, 0x5c, 0x97, 0xe3, 0x5b, 0xbd,
	0xb7, 0x68, 0xf1, 0x36, 0x71, 0xd1, 0xca, 0xbd, 0x5d, 0x80, 0xd8, 0x9f, 0x8a, 0xa8, 0xe7, 0x08,
	0xdf, 0xfc, 0x3f, 0x91, 0x2e, 0x41, 0x2d, 0xfa, 0xf6, 0x33, 0x0d, 0xbf, 0x7e, 0xc4, 0x75, 0x25,
	0xfa, 0xd8, 0xa4, 0xea, 0xe1, 0xa2, 0xcc, 0xbd, 0x5f, 0x0a, 0x50, 0x3b, 0xf0, 0xff, 0x3a, 0xe2,
	0x33, 0x5b, 0x5c, 0x80, 0xcc, 0xe9, 0x43, 0x74, 0x89, 0xfd, 0xd2, 0x95, 0xf4, 0x77, 0x13, 0x65,
	0xd8, 0xef, 0x63, 0x94, 0x65, 0xbf, 0x4f, 0x50, 0x8e, 0xfd, 0x3e, 0x45, 0x79, 0xf6, 0xfb, 0x0c,
	0x2d, 0xb0, 0xdf, 0xe7, 0x68, 0x91, 0xfd, 0x7e, 0x81, 0x0a, 0xec, 0xf7, 0x4b, 0x1e, 0x07, 0x4f,
	0x1f, 0x3d, 0x44, 0xc0, 0x1f, 0x1e, 0xa1, 0x12, 0x7f, 0xd8, 0x44, 0x65, 0xfe, 0xf0, 0x18, 0x55,
	0xf8, 0xc3, 0x13, 0x54, 0xe5, 0x0f, 0x4f, 0x51, 0xed, 0xde, 0xe7, 0xf1, 0x3f, 0x9f, 0xf8, 0x27,
	0xd0, 0xcd, 0xc3, 0x41, 0x57, 0xed, 0x1f, 0xec, 0xb5, 0x07, 0xfe, 0x55, 0xfb, 0x41, 0xbb, 0xb5,
	0xfb, 0x33, 0x24, 0xdc, 0x93, 0xa1, 0x18, 0xb6, 0x50, 0xe9, 0x40, 0xab, 0xbb, 0xbf, 0xcf, 0x26,
	0x15, 0x21, 0xdf, 0xdc, 0xea, 0xf6, 0x06, 0x48, 0xd8, 0xda, 0xfc, 0xc7, 0x6f, 0xaf, 0x0b, 0xff,
	0xf2, 0xed, 0x75, 0xe1, 0xdf, 0xbe, 0xbd, 0x2e, 0x80, 0x6c, 0x3b, 0xc3, 0x0d, 0xfe, 0xef, 0xe2,
	0x20, 0xa9, 0xd0, 0xec, 0xd1, 0xc8, 0xb6, 0x36, 0x70, 0xf0, 0x87, 0xe1, 0x57, 0xd9, 0xff, 0x09,
	0x00, 0x00, 0xff, 0xff, 0xc5, 0x98, 0x27, 0x47, 0x8b, 0x3c, 0x00, 0x00,
}

func (m *Schema) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Schema) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Schema) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Properties) > 0 {
		for iNdEx := len(m.Properties) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Properties[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Type))
		i--
		dAtA[i] = 0x20
	}
	if m.SchemaData == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("schema_data")
	} else {
		i -= len(m.SchemaData)
		copy(dAtA[i:], m.SchemaData)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.SchemaData)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MessageIdData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MessageIdData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MessageIdData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.BatchIndex != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.BatchIndex))
		i--
		dAtA[i] = 0x20
	}
	if m.Partition != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Partition))
		i--
		dAtA[i] = 0x18
	}
	if m.EntryId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("entryId")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.EntryId))
		i--
		dAtA[i] = 0x10
	}
	if m.LedgerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("ledgerId")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.LedgerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *KeyValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KeyValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		i -= len(*m.Value)
		copy(dAtA[i:], *m.Value)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if m.Key == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("key")
	} else {
		i -= len(*m.Key)
		copy(dAtA[i:], *m.Key)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *KeyLongValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyLongValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KeyLongValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Value))
		i--
		dAtA[i] = 0x10
	}
	if m.Key == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("key")
	} else {
		i -= len(*m.Key)
		copy(dAtA[i:], *m.Key)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IntRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IntRange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IntRange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.End == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("end")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.End))
		i--
		dAtA[i] = 0x10
	}
	if m.Start == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("start")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Start))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *EncryptionKeys) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncryptionKeys) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EncryptionKeys) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Metadata) > 0 {
		for iNdEx := len(m.Metadata) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Metadata[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if m.Key == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("key")
	} else {
		i -= len(*m.Key)
		copy(dAtA[i:], *m.Key)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MessageMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MessageMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MessageMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.HighestSequenceId != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.HighestSequenceId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.MarkerType != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.MarkerType))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if m.DeliverAtTime != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.DeliverAtTime))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if m.OrderingKey != nil {
		i -= len(m.OrderingKey)
		copy(dAtA[i:], m.OrderingKey)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.OrderingKey)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.PartitionKeyB64Encoded != nil {
		i--
		if *m.PartitionKeyB64Encoded {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.SchemaVersion != nil {
		i -= len(m.SchemaVersion)
		copy(dAtA[i:], m.SchemaVersion)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.SchemaVersion)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.EncryptionParam != nil {
		i -= len(m.EncryptionParam)
		copy(dAtA[i:], m.EncryptionParam)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.EncryptionParam)))
		i--
		dAtA[i] = 0x7a
	}
	if m.EncryptionAlgo != nil {
		i -= len(*m.EncryptionAlgo)
		copy(dAtA[i:], *m.EncryptionAlgo)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.EncryptionAlgo)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.EncryptionKeys) > 0 {
		for iNdEx := len(m.EncryptionKeys) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.EncryptionKeys[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x6a
		}
	}
	if m.EventTime != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.EventTime))
		i--
		dAtA[i] = 0x60
	}
	if m.NumMessagesInBatch != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.NumMessagesInBatch))
		i--
		dAtA[i] = 0x58
	}
	if m.UncompressedSize != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.UncompressedSize))
		i--
		dAtA[i] = 0x48
	}
	if m.Compression != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Compression))
		i--
		dAtA[i] = 0x40
	}
	if len(m.ReplicateTo) > 0 {
		for iNdEx := len(m.ReplicateTo) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ReplicateTo[iNdEx])
			copy(dAtA[i:], m.ReplicateTo[iNdEx])
			i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.ReplicateTo[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.PartitionKey != nil {
		i -= len(*m.PartitionKey)
		copy(dAtA[i:], *m.PartitionKey)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.PartitionKey)))
		i--
		dAtA[i] = 0x32
	}
	if m.ReplicatedFrom != nil {
		i -= len(*m.ReplicatedFrom)
		copy(dAtA[i:], *m.ReplicatedFrom)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ReplicatedFrom)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Properties) > 0 {
		for iNdEx := len(m.Properties) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Properties[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.PublishTime == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("publish_time")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.PublishTime))
		i--
		dAtA[i] = 0x18
	}
	if m.SequenceId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("sequence_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.SequenceId))
		i--
		dAtA[i] = 0x10
	}
	if m.ProducerName == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_name")
	} else {
		i -= len(*m.ProducerName)
		copy(dAtA[i:], *m.ProducerName)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ProducerName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SingleMessageMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SingleMessageMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SingleMessageMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SequenceId != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.SequenceId))
		i--
		dAtA[i] = 0x40
	}
	if m.OrderingKey != nil {
		i -= len(m.OrderingKey)
		copy(dAtA[i:], m.OrderingKey)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.OrderingKey)))
		i--
		dAtA[i] = 0x3a
	}
	if m.PartitionKeyB64Encoded != nil {
		i--
		if *m.PartitionKeyB64Encoded {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.EventTime != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.EventTime))
		i--
		dAtA[i] = 0x28
	}
	if m.CompactedOut != nil {
		i--
		if *m.CompactedOut {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.PayloadSize == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("payload_size")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.PayloadSize))
		i--
		dAtA[i] = 0x18
	}
	if m.PartitionKey != nil {
		i -= len(*m.PartitionKey)
		copy(dAtA[i:], *m.PartitionKey)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.PartitionKey)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Properties) > 0 {
		for iNdEx := len(m.Properties) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Properties[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CommandConnect) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandConnect) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandConnect) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.FeatureFlags != nil {
		{
			size, err := m.FeatureFlags.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.OriginalAuthMethod != nil {
		i -= len(*m.OriginalAuthMethod)
		copy(dAtA[i:], *m.OriginalAuthMethod)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.OriginalAuthMethod)))
		i--
		dAtA[i] = 0x4a
	}
	if m.OriginalAuthData != nil {
		i -= len(*m.OriginalAuthData)
		copy(dAtA[i:], *m.OriginalAuthData)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.OriginalAuthData)))
		i--
		dAtA[i] = 0x42
	}
	if m.OriginalPrincipal != nil {
		i -= len(*m.OriginalPrincipal)
		copy(dAtA[i:], *m.OriginalPrincipal)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.OriginalPrincipal)))
		i--
		dAtA[i] = 0x3a
	}
	if m.ProxyToBrokerUrl != nil {
		i -= len(*m.ProxyToBrokerUrl)
		copy(dAtA[i:], *m.ProxyToBrokerUrl)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ProxyToBrokerUrl)))
		i--
		dAtA[i] = 0x32
	}
	if m.AuthMethodName != nil {
		i -= len(*m.AuthMethodName)
		copy(dAtA[i:], *m.AuthMethodName)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.AuthMethodName)))
		i--
		dAtA[i] = 0x2a
	}
	if m.ProtocolVersion != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ProtocolVersion))
		i--
		dAtA[i] = 0x20
	}
	if m.AuthData != nil {
		i -= len(m.AuthData)
		copy(dAtA[i:], m.AuthData)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.AuthData)))
		i--
		dAtA[i] = 0x1a
	}
	if m.AuthMethod != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.AuthMethod))
		i--
		dAtA[i] = 0x10
	}
	if m.ClientVersion == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("client_version")
	} else {
		i -= len(*m.ClientVersion)
		copy(dAtA[i:], *m.ClientVersion)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ClientVersion)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FeatureFlags) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FeatureFlags) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FeatureFlags) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SupportsAuthRefresh != nil {
		i--
		if *m.SupportsAuthRefresh {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandConnected) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandConnected) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandConnected) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MaxMessageSize != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.MaxMessageSize))
		i--
		dAtA[i] = 0x18
	}
	if m.ProtocolVersion != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ProtocolVersion))
		i--
		dAtA[i] = 0x10
	}
	if m.ServerVersion == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("server_version")
	} else {
		i -= len(*m.ServerVersion)
		copy(dAtA[i:], *m.ServerVersion)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ServerVersion)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommandAuthResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandAuthResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandAuthResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ProtocolVersion != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ProtocolVersion))
		i--
		dAtA[i] = 0x18
	}
	if m.Response != nil {
		{
			size, err := m.Response.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ClientVersion != nil {
		i -= len(*m.ClientVersion)
		copy(dAtA[i:], *m.ClientVersion)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ClientVersion)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommandAuthChallenge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandAuthChallenge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandAuthChallenge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ProtocolVersion != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ProtocolVersion))
		i--
		dAtA[i] = 0x18
	}
	if m.Challenge != nil {
		{
			size, err := m.Challenge.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ServerVersion != nil {
		i -= len(*m.ServerVersion)
		copy(dAtA[i:], *m.ServerVersion)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ServerVersion)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuthData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AuthData != nil {
		i -= len(m.AuthData)
		copy(dAtA[i:], m.AuthData)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.AuthData)))
		i--
		dAtA[i] = 0x12
	}
	if m.AuthMethodName != nil {
		i -= len(*m.AuthMethodName)
		copy(dAtA[i:], *m.AuthMethodName)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.AuthMethodName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *KeySharedMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeySharedMeta) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KeySharedMeta) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AllowOutOfOrderDelivery != nil {
		i--
		if *m.AllowOutOfOrderDelivery {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.HashRanges) > 0 {
		for iNdEx := len(m.HashRanges) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HashRanges[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.KeySharedMode == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("keySharedMode")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.KeySharedMode))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandSubscribe) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandSubscribe) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandSubscribe) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.KeySharedMeta != nil {
		{
			size, err := m.KeySharedMeta.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.StartMessageRollbackDurationSec != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.StartMessageRollbackDurationSec))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.ForceTopicCreation != nil {
		i--
		if *m.ForceTopicCreation {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x78
	}
	if m.ReplicateSubscriptionState != nil {
		i--
		if *m.ReplicateSubscriptionState {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x70
	}
	if m.InitialPosition != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.InitialPosition))
		i--
		dAtA[i] = 0x68
	}
	if m.Schema != nil {
		{
			size, err := m.Schema.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.ReadCompacted != nil {
		i--
		if *m.ReadCompacted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.Metadata) > 0 {
		for iNdEx := len(m.Metadata) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Metadata[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x52
		}
	}
	if m.StartMessageId != nil {
		{
			size, err := m.StartMessageId.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.Durable != nil {
		i--
		if *m.Durable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.PriorityLevel != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.PriorityLevel))
		i--
		dAtA[i] = 0x38
	}
	if m.ConsumerName != nil {
		i -= len(*m.ConsumerName)
		copy(dAtA[i:], *m.ConsumerName)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ConsumerName)))
		i--
		dAtA[i] = 0x32
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x28
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x20
	}
	if m.SubType == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("subType")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.SubType))
		i--
		dAtA[i] = 0x18
	}
	if m.Subscription == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("subscription")
	} else {
		i -= len(*m.Subscription)
		copy(dAtA[i:], *m.Subscription)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Subscription)))
		i--
		dAtA[i] = 0x12
	}
	if m.Topic == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	} else {
		i -= len(*m.Topic)
		copy(dAtA[i:], *m.Topic)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Topic)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommandPartitionedTopicMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandPartitionedTopicMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandPartitionedTopicMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.OriginalAuthMethod != nil {
		i -= len(*m.OriginalAuthMethod)
		copy(dAtA[i:], *m.OriginalAuthMethod)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.OriginalAuthMethod)))
		i--
		dAtA[i] = 0x2a
	}
	if m.OriginalAuthData != nil {
		i -= len(*m.OriginalAuthData)
		copy(dAtA[i:], *m.OriginalAuthData)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.OriginalAuthData)))
		i--
		dAtA[i] = 0x22
	}
	if m.OriginalPrincipal != nil {
		i -= len(*m.OriginalPrincipal)
		copy(dAtA[i:], *m.OriginalPrincipal)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.OriginalPrincipal)))
		i--
		dAtA[i] = 0x1a
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x10
	}
	if m.Topic == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	} else {
		i -= len(*m.Topic)
		copy(dAtA[i:], *m.Topic)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Topic)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommandPartitionedTopicMetadataResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandPartitionedTopicMetadataResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandPartitionedTopicMetadataResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Message != nil {
		i -= len(*m.Message)
		copy(dAtA[i:], *m.Message)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Error != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Error))
		i--
		dAtA[i] = 0x20
	}
	if m.Response != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Response))
		i--
		dAtA[i] = 0x18
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x10
	}
	if m.Partitions != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Partitions))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandLookupTopic) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandLookupTopic) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandLookupTopic) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AdvertisedListenerName != nil {
		i -= len(*m.AdvertisedListenerName)
		copy(dAtA[i:], *m.AdvertisedListenerName)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.AdvertisedListenerName)))
		i--
		dAtA[i] = 0x3a
	}
	if m.OriginalAuthMethod != nil {
		i -= len(*m.OriginalAuthMethod)
		copy(dAtA[i:], *m.OriginalAuthMethod)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.OriginalAuthMethod)))
		i--
		dAtA[i] = 0x32
	}
	if m.OriginalAuthData != nil {
		i -= len(*m.OriginalAuthData)
		copy(dAtA[i:], *m.OriginalAuthData)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.OriginalAuthData)))
		i--
		dAtA[i] = 0x2a
	}
	if m.OriginalPrincipal != nil {
		i -= len(*m.OriginalPrincipal)
		copy(dAtA[i:], *m.OriginalPrincipal)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.OriginalPrincipal)))
		i--
		dAtA[i] = 0x22
	}
	if m.Authoritative != nil {
		i--
		if *m.Authoritative {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x10
	}
	if m.Topic == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	} else {
		i -= len(*m.Topic)
		copy(dAtA[i:], *m.Topic)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Topic)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommandLookupTopicResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandLookupTopicResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandLookupTopicResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ProxyThroughServiceUrl != nil {
		i--
		if *m.ProxyThroughServiceUrl {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.Message != nil {
		i -= len(*m.Message)
		copy(dAtA[i:], *m.Message)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Message)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Error != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Error))
		i--
		dAtA[i] = 0x30
	}
	if m.Authoritative != nil {
		i--
		if *m.Authoritative {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x20
	}
	if m.Response != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Response))
		i--
		dAtA[i] = 0x18
	}
	if m.BrokerServiceUrlTls != nil {
		i -= len(*m.BrokerServiceUrlTls)
		copy(dAtA[i:], *m.BrokerServiceUrlTls)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.BrokerServiceUrlTls)))
		i--
		dAtA[i] = 0x12
	}
	if m.BrokerServiceUrl != nil {
		i -= len(*m.BrokerServiceUrl)
		copy(dAtA[i:], *m.BrokerServiceUrl)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.BrokerServiceUrl)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommandProducer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandProducer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandProducer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UserProvidedProducerName != nil {
		i--
		if *m.UserProvidedProducerName {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.Epoch != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Epoch))
		i--
		dAtA[i] = 0x40
	}
	if m.Schema != nil {
		{
			size, err := m.Schema.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Metadata) > 0 {
		for iNdEx := len(m.Metadata) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Metadata[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Encrypted != nil {
		i--
		if *m.Encrypted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.ProducerName != nil {
		i -= len(*m.ProducerName)
		copy(dAtA[i:], *m.ProducerName)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ProducerName)))
		i--
		dAtA[i] = 0x22
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x18
	}
	if m.ProducerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ProducerId))
		i--
		dAtA[i] = 0x10
	}
	if m.Topic == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	} else {
		i -= len(*m.Topic)
		copy(dAtA[i:], *m.Topic)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Topic)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommandSend) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandSend) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandSend) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.HighestSequenceId != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.HighestSequenceId))
		i--
		dAtA[i] = 0x30
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x28
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x20
	}
	if m.NumMessages != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.NumMessages))
		i--
		dAtA[i] = 0x18
	}
	if m.SequenceId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("sequence_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.SequenceId))
		i--
		dAtA[i] = 0x10
	}
	if m.ProducerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ProducerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandSendReceipt) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandSendReceipt) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandSendReceipt) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.HighestSequenceId != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.HighestSequenceId))
		i--
		dAtA[i] = 0x20
	}
	if m.MessageId != nil {
		{
			size, err := m.MessageId.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.SequenceId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("sequence_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.SequenceId))
		i--
		dAtA[i] = 0x10
	}
	if m.ProducerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ProducerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandSendError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandSendError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandSendError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Message == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("message")
	} else {
		i -= len(*m.Message)
		copy(dAtA[i:], *m.Message)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Message)))
		i--
		dAtA[i] = 0x22
	}
	if m.Error == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("error")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Error))
		i--
		dAtA[i] = 0x18
	}
	if m.SequenceId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("sequence_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.SequenceId))
		i--
		dAtA[i] = 0x10
	}
	if m.ProducerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ProducerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RedeliveryCount != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RedeliveryCount))
		i--
		dAtA[i] = 0x18
	}
	if m.MessageId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("message_id")
	} else {
		{
			size, err := m.MessageId.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandAck) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandAck) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandAck) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x38
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x30
	}
	if len(m.Properties) > 0 {
		for iNdEx := len(m.Properties) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Properties[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.ValidationError != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ValidationError))
		i--
		dAtA[i] = 0x20
	}
	if len(m.MessageId) > 0 {
		for iNdEx := len(m.MessageId) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.MessageId[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.AckType == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("ack_type")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.AckType))
		i--
		dAtA[i] = 0x10
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandAckResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandAckResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandAckResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Message != nil {
		i -= len(*m.Message)
		copy(dAtA[i:], *m.Message)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Error != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Error))
		i--
		dAtA[i] = 0x20
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandActiveConsumerChange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandActiveConsumerChange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandActiveConsumerChange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsActive != nil {
		i--
		if *m.IsActive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandFlow) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandFlow) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandFlow) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MessagePermits == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("messagePermits")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.MessagePermits))
		i--
		dAtA[i] = 0x10
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandUnsubscribe) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandUnsubscribe) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandUnsubscribe) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x10
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandSeek) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandSeek) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandSeek) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MessagePublishTime != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.MessagePublishTime))
		i--
		dAtA[i] = 0x20
	}
	if m.MessageId != nil {
		{
			size, err := m.MessageId.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x10
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandReachedEndOfTopic) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandReachedEndOfTopic) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandReachedEndOfTopic) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandCloseProducer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandCloseProducer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandCloseProducer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x10
	}
	if m.ProducerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ProducerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandCloseConsumer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandCloseConsumer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandCloseConsumer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x10
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandRedeliverUnacknowledgedMessages) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandRedeliverUnacknowledgedMessages) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandRedeliverUnacknowledgedMessages) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.MessageIds) > 0 {
		for iNdEx := len(m.MessageIds) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.MessageIds[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandSuccess) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandSuccess) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandSuccess) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Schema != nil {
		{
			size, err := m.Schema.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandProducerSuccess) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandProducerSuccess) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandProducerSuccess) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SchemaVersion != nil {
		i -= len(m.SchemaVersion)
		copy(dAtA[i:], m.SchemaVersion)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.SchemaVersion)))
		i--
		dAtA[i] = 0x22
	}
	if m.LastSequenceId != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.LastSequenceId))
		i--
		dAtA[i] = 0x18
	}
	if m.ProducerName == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_name")
	} else {
		i -= len(*m.ProducerName)
		copy(dAtA[i:], *m.ProducerName)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ProducerName)))
		i--
		dAtA[i] = 0x12
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Message == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("message")
	} else {
		i -= len(*m.Message)
		copy(dAtA[i:], *m.Message)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Message)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Error == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("error")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Error))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandPing) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandPing) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandPing) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *CommandPong) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandPong) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandPong) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *CommandConsumerStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandConsumerStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandConsumerStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x20
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandConsumerStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandConsumerStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandConsumerStatsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MsgBacklog != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.MsgBacklog))
		i--
		dAtA[i] = 0x78
	}
	if m.MsgRateExpired != nil {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(*m.MsgRateExpired))))
		i--
		dAtA[i] = 0x71
	}
	if m.Type != nil {
		i -= len(*m.Type)
		copy(dAtA[i:], *m.Type)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Type)))
		i--
		dAtA[i] = 0x6a
	}
	if m.ConnectedSince != nil {
		i -= len(*m.ConnectedSince)
		copy(dAtA[i:], *m.ConnectedSince)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ConnectedSince)))
		i--
		dAtA[i] = 0x62
	}
	if m.Address != nil {
		i -= len(*m.Address)
		copy(dAtA[i:], *m.Address)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Address)))
		i--
		dAtA[i] = 0x5a
	}
	if m.BlockedConsumerOnUnackedMsgs != nil {
		i--
		if *m.BlockedConsumerOnUnackedMsgs {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.UnackedMessages != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.UnackedMessages))
		i--
		dAtA[i] = 0x48
	}
	if m.AvailablePermits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.AvailablePermits))
		i--
		dAtA[i] = 0x40
	}
	if m.ConsumerName != nil {
		i -= len(*m.ConsumerName)
		copy(dAtA[i:], *m.ConsumerName)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ConsumerName)))
		i--
		dAtA[i] = 0x3a
	}
	if m.MsgRateRedeliver != nil {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(*m.MsgRateRedeliver))))
		i--
		dAtA[i] = 0x31
	}
	if m.MsgThroughputOut != nil {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(*m.MsgThroughputOut))))
		i--
		dAtA[i] = 0x29
	}
	if m.MsgRateOut != nil {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(*m.MsgRateOut))))
		i--
		dAtA[i] = 0x21
	}
	if m.ErrorMessage != nil {
		i -= len(*m.ErrorMessage)
		copy(dAtA[i:], *m.ErrorMessage)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ErrorMessage)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ErrorCode != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ErrorCode))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandGetLastMessageId) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandGetLastMessageId) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandGetLastMessageId) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x10
	}
	if m.ConsumerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ConsumerId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandGetLastMessageIdResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandGetLastMessageIdResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandGetLastMessageIdResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x10
	}
	if m.LastMessageId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("last_message_id")
	} else {
		{
			size, err := m.LastMessageId.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommandGetTopicsOfNamespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandGetTopicsOfNamespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandGetTopicsOfNamespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Mode != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Mode))
		i--
		dAtA[i] = 0x18
	}
	if m.Namespace == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("namespace")
	} else {
		i -= len(*m.Namespace)
		copy(dAtA[i:], *m.Namespace)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandGetTopicsOfNamespaceResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandGetTopicsOfNamespaceResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandGetTopicsOfNamespaceResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Topics) > 0 {
		for iNdEx := len(m.Topics) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Topics[iNdEx])
			copy(dAtA[i:], m.Topics[iNdEx])
			i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.Topics[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandGetSchema) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandGetSchema) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandGetSchema) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SchemaVersion != nil {
		i -= len(m.SchemaVersion)
		copy(dAtA[i:], m.SchemaVersion)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.SchemaVersion)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Topic == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	} else {
		i -= len(*m.Topic)
		copy(dAtA[i:], *m.Topic)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Topic)))
		i--
		dAtA[i] = 0x12
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandGetSchemaResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandGetSchemaResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandGetSchemaResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SchemaVersion != nil {
		i -= len(m.SchemaVersion)
		copy(dAtA[i:], m.SchemaVersion)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.SchemaVersion)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Schema != nil {
		{
			size, err := m.Schema.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.ErrorMessage != nil {
		i -= len(*m.ErrorMessage)
		copy(dAtA[i:], *m.ErrorMessage)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ErrorMessage)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ErrorCode != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ErrorCode))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandGetOrCreateSchema) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandGetOrCreateSchema) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandGetOrCreateSchema) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Schema == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("schema")
	} else {
		{
			size, err := m.Schema.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Topic == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	} else {
		i -= len(*m.Topic)
		copy(dAtA[i:], *m.Topic)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Topic)))
		i--
		dAtA[i] = 0x12
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandGetOrCreateSchemaResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandGetOrCreateSchemaResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandGetOrCreateSchemaResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SchemaVersion != nil {
		i -= len(m.SchemaVersion)
		copy(dAtA[i:], m.SchemaVersion)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.SchemaVersion)))
		i--
		dAtA[i] = 0x22
	}
	if m.ErrorMessage != nil {
		i -= len(*m.ErrorMessage)
		copy(dAtA[i:], *m.ErrorMessage)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.ErrorMessage)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ErrorCode != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.ErrorCode))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandNewTxn) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandNewTxn) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandNewTxn) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TcId != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TcId))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnTtlSeconds != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnTtlSeconds))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandNewTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandNewTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandNewTxnResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Message != nil {
		i -= len(*m.Message)
		copy(dAtA[i:], *m.Message)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Error != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Error))
		i--
		dAtA[i] = 0x20
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandAddPartitionToTxn) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandAddPartitionToTxn) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandAddPartitionToTxn) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Partitions) > 0 {
		for iNdEx := len(m.Partitions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Partitions[iNdEx])
			copy(dAtA[i:], m.Partitions[iNdEx])
			i = encodeVarintPulsarApi(dAtA, i, uint64(len(m.Partitions[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandAddPartitionToTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandAddPartitionToTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandAddPartitionToTxnResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Message != nil {
		i -= len(*m.Message)
		copy(dAtA[i:], *m.Message)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Error != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Error))
		i--
		dAtA[i] = 0x20
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Subscription) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Subscription) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Subscription) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Subscription == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("subscription")
	} else {
		i -= len(*m.Subscription)
		copy(dAtA[i:], *m.Subscription)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Subscription)))
		i--
		dAtA[i] = 0x12
	}
	if m.Topic == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	} else {
		i -= len(*m.Topic)
		copy(dAtA[i:], *m.Topic)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Topic)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommandAddSubscriptionToTxn) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandAddSubscriptionToTxn) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandAddSubscriptionToTxn) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Subscription) > 0 {
		for iNdEx := len(m.Subscription) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Subscription[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPulsarApi(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandAddSubscriptionToTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandAddSubscriptionToTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandAddSubscriptionToTxnResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Message != nil {
		i -= len(*m.Message)
		copy(dAtA[i:], *m.Message)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Error != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Error))
		i--
		dAtA[i] = 0x20
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandEndTxn) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandEndTxn) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandEndTxn) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TxnAction != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnAction))
		i--
		dAtA[i] = 0x20
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandEndTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandEndTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandEndTxnResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Message != nil {
		i -= len(*m.Message)
		copy(dAtA[i:], *m.Message)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Error != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Error))
		i--
		dAtA[i] = 0x20
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandEndTxnOnPartition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandEndTxnOnPartition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandEndTxnOnPartition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TxnAction != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnAction))
		i--
		dAtA[i] = 0x28
	}
	if m.Topic != nil {
		i -= len(*m.Topic)
		copy(dAtA[i:], *m.Topic)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Topic)))
		i--
		dAtA[i] = 0x22
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandEndTxnOnPartitionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandEndTxnOnPartitionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandEndTxnOnPartitionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Message != nil {
		i -= len(*m.Message)
		copy(dAtA[i:], *m.Message)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Error != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Error))
		i--
		dAtA[i] = 0x20
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandEndTxnOnSubscription) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandEndTxnOnSubscription) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandEndTxnOnSubscription) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TxnAction != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnAction))
		i--
		dAtA[i] = 0x28
	}
	if m.Subscription != nil {
		{
			size, err := m.Subscription.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommandEndTxnOnSubscriptionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandEndTxnOnSubscriptionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommandEndTxnOnSubscriptionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Message != nil {
		i -= len(*m.Message)
		copy(dAtA[i:], *m.Message)
		i = encodeVarintPulsarApi(dAtA, i, uint64(len(*m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Error != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Error))
		i--
		dAtA[i] = 0x20
	}
	if m.TxnidMostBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidMostBits))
		i--
		dAtA[i] = 0x18
	}
	if m.TxnidLeastBits != nil {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.TxnidLeastBits))
		i--
		dAtA[i] = 0x10
	}
	if m.RequestId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.RequestId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *BaseCommand) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BaseCommand) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BaseCommand) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.EndTxnOnSubscriptionResponse != nil {
		{
			size, err := m.EndTxnOnSubscriptionResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xea
	}
	if m.EndTxnOnSubscription != nil {
		{
			size, err := m.EndTxnOnSubscription.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xe2
	}
	if m.EndTxnOnPartitionResponse != nil {
		{
			size, err := m.EndTxnOnPartitionResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xda
	}
	if m.EndTxnOnPartition != nil {
		{
			size, err := m.EndTxnOnPartition.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xd2
	}
	if m.EndTxnResponse != nil {
		{
			size, err := m.EndTxnResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xca
	}
	if m.EndTxn != nil {
		{
			size, err := m.EndTxn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xc2
	}
	if m.AddSubscriptionToTxnResponse != nil {
		{
			size, err := m.AddSubscriptionToTxnResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xba
	}
	if m.AddSubscriptionToTxn != nil {
		{
			size, err := m.AddSubscriptionToTxn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xb2
	}
	if m.AddPartitionToTxnResponse != nil {
		{
			size, err := m.AddPartitionToTxnResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xaa
	}
	if m.AddPartitionToTxn != nil {
		{
			size, err := m.AddPartitionToTxn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xa2
	}
	if m.NewTxnResponse != nil {
		{
			size, err := m.NewTxnResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x9a
	}
	if m.NewTxn != nil {
		{
			size, err := m.NewTxn.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x92
	}
	if m.GetOrCreateSchemaResponse != nil {
		{
			size, err := m.GetOrCreateSchemaResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc2
	}
	if m.GetOrCreateSchema != nil {
		{
			size, err := m.GetOrCreateSchema.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xba
	}
	if m.AckResponse != nil {
		{
			size, err := m.AckResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb2
	}
	if m.AuthResponse != nil {
		{
			size, err := m.AuthResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xaa
	}
	if m.AuthChallenge != nil {
		{
			size, err := m.AuthChallenge.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xa2
	}
	if m.GetSchemaResponse != nil {
		{
			size, err := m.GetSchemaResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x9a
	}
	if m.GetSchema != nil {
		{
			size, err := m.GetSchema.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x92
	}
	if m.GetTopicsOfNamespaceResponse != nil {
		{
			size, err := m.GetTopicsOfNamespaceResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x8a
	}
	if m.GetTopicsOfNamespace != nil {
		{
			size, err := m.GetTopicsOfNamespace.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x82
	}
	if m.ActiveConsumerChange != nil {
		{
			size, err := m.ActiveConsumerChange.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfa
	}
	if m.GetLastMessageIdResponse != nil {
		{
			size, err := m.GetLastMessageIdResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf2
	}
	if m.GetLastMessageId != nil {
		{
			size, err := m.GetLastMessageId.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xea
	}
	if m.Seek != nil {
		{
			size, err := m.Seek.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe2
	}
	if m.ReachedEndOfTopic != nil {
		{
			size, err := m.ReachedEndOfTopic.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xda
	}
	if m.ConsumerStatsResponse != nil {
		{
			size, err := m.ConsumerStatsResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd2
	}
	if m.ConsumerStats != nil {
		{
			size, err := m.ConsumerStats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xca
	}
	if m.LookupTopicResponse != nil {
		{
			size, err := m.LookupTopicResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc2
	}
	if m.LookupTopic != nil {
		{
			size, err := m.LookupTopic.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xba
	}
	if m.PartitionMetadataResponse != nil {
		{
			size, err := m.PartitionMetadataResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if m.PartitionMetadata != nil {
		{
			size, err := m.PartitionMetadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.RedeliverUnacknowledgedMessages != nil {
		{
			size, err := m.RedeliverUnacknowledgedMessages.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if m.Pong != nil {
		{
			size, err := m.Pong.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if m.Ping != nil {
		{
			size, err := m.Ping.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.ProducerSuccess != nil {
		{
			size, err := m.ProducerSuccess.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.CloseConsumer != nil {
		{
			size, err := m.CloseConsumer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.CloseProducer != nil {
		{
			size, err := m.CloseProducer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if m.Success != nil {
		{
			size, err := m.Success.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.Unsubscribe != nil {
		{
			size, err := m.Unsubscribe.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.Flow != nil {
		{
			size, err := m.Flow.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.Ack != nil {
		{
			size, err := m.Ack.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.Message != nil {
		{
			size, err := m.Message.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.SendError != nil {
		{
			size, err := m.SendError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.SendReceipt != nil {
		{
			size, err := m.SendReceipt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.Send != nil {
		{
			size, err := m.Send.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Producer != nil {
		{
			size, err := m.Producer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Subscribe != nil {
		{
			size, err := m.Subscribe.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Connected != nil {
		{
			size, err := m.Connected.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Connect != nil {
		{
			size, err := m.Connect.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPulsarApi(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		i = encodeVarintPulsarApi(dAtA, i, uint64(*m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintPulsarApi(dAtA []byte, offset int, v uint64) int {
	offset -= sovPulsarApi(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Schema) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.SchemaData != nil {
		l = len(m.SchemaData)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Type != nil {
		n += 1 + sovPulsarApi(uint64(*m.Type))
	}
	if len(m.Properties) > 0 {
		for _, e := range m.Properties {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MessageIdData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LedgerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.LedgerId))
	}
	if m.EntryId != nil {
		n += 1 + sovPulsarApi(uint64(*m.EntryId))
	}
	if m.Partition != nil {
		n += 1 + sovPulsarApi(uint64(*m.Partition))
	}
	if m.BatchIndex != nil {
		n += 1 + sovPulsarApi(uint64(*m.BatchIndex))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KeyValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KeyLongValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Value != nil {
		n += 1 + sovPulsarApi(uint64(*m.Value))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IntRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Start != nil {
		n += 1 + sovPulsarApi(uint64(*m.Start))
	}
	if m.End != nil {
		n += 1 + sovPulsarApi(uint64(*m.End))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EncryptionKeys) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Value != nil {
		l = len(m.Value)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if len(m.Metadata) > 0 {
		for _, e := range m.Metadata {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MessageMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProducerName != nil {
		l = len(*m.ProducerName)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.SequenceId != nil {
		n += 1 + sovPulsarApi(uint64(*m.SequenceId))
	}
	if m.PublishTime != nil {
		n += 1 + sovPulsarApi(uint64(*m.PublishTime))
	}
	if len(m.Properties) > 0 {
		for _, e := range m.Properties {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.ReplicatedFrom != nil {
		l = len(*m.ReplicatedFrom)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.PartitionKey != nil {
		l = len(*m.PartitionKey)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if len(m.ReplicateTo) > 0 {
		for _, s := range m.ReplicateTo {
			l = len(s)
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.Compression != nil {
		n += 1 + sovPulsarApi(uint64(*m.Compression))
	}
	if m.UncompressedSize != nil {
		n += 1 + sovPulsarApi(uint64(*m.UncompressedSize))
	}
	if m.NumMessagesInBatch != nil {
		n += 1 + sovPulsarApi(uint64(*m.NumMessagesInBatch))
	}
	if m.EventTime != nil {
		n += 1 + sovPulsarApi(uint64(*m.EventTime))
	}
	if len(m.EncryptionKeys) > 0 {
		for _, e := range m.EncryptionKeys {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.EncryptionAlgo != nil {
		l = len(*m.EncryptionAlgo)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.EncryptionParam != nil {
		l = len(m.EncryptionParam)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.SchemaVersion != nil {
		l = len(m.SchemaVersion)
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.PartitionKeyB64Encoded != nil {
		n += 3
	}
	if m.OrderingKey != nil {
		l = len(m.OrderingKey)
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.DeliverAtTime != nil {
		n += 2 + sovPulsarApi(uint64(*m.DeliverAtTime))
	}
	if m.MarkerType != nil {
		n += 2 + sovPulsarApi(uint64(*m.MarkerType))
	}
	if m.TxnidLeastBits != nil {
		n += 2 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 2 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.HighestSequenceId != nil {
		n += 2 + sovPulsarApi(uint64(*m.HighestSequenceId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SingleMessageMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Properties) > 0 {
		for _, e := range m.Properties {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.PartitionKey != nil {
		l = len(*m.PartitionKey)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.PayloadSize != nil {
		n += 1 + sovPulsarApi(uint64(*m.PayloadSize))
	}
	if m.CompactedOut != nil {
		n += 2
	}
	if m.EventTime != nil {
		n += 1 + sovPulsarApi(uint64(*m.EventTime))
	}
	if m.PartitionKeyB64Encoded != nil {
		n += 2
	}
	if m.OrderingKey != nil {
		l = len(m.OrderingKey)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.SequenceId != nil {
		n += 1 + sovPulsarApi(uint64(*m.SequenceId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandConnect) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClientVersion != nil {
		l = len(*m.ClientVersion)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.AuthMethod != nil {
		n += 1 + sovPulsarApi(uint64(*m.AuthMethod))
	}
	if m.AuthData != nil {
		l = len(m.AuthData)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.ProtocolVersion != nil {
		n += 1 + sovPulsarApi(uint64(*m.ProtocolVersion))
	}
	if m.AuthMethodName != nil {
		l = len(*m.AuthMethodName)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.ProxyToBrokerUrl != nil {
		l = len(*m.ProxyToBrokerUrl)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.OriginalPrincipal != nil {
		l = len(*m.OriginalPrincipal)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.OriginalAuthData != nil {
		l = len(*m.OriginalAuthData)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.OriginalAuthMethod != nil {
		l = len(*m.OriginalAuthMethod)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.FeatureFlags != nil {
		l = m.FeatureFlags.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FeatureFlags) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SupportsAuthRefresh != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandConnected) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ServerVersion != nil {
		l = len(*m.ServerVersion)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.ProtocolVersion != nil {
		n += 1 + sovPulsarApi(uint64(*m.ProtocolVersion))
	}
	if m.MaxMessageSize != nil {
		n += 1 + sovPulsarApi(uint64(*m.MaxMessageSize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandAuthResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClientVersion != nil {
		l = len(*m.ClientVersion)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Response != nil {
		l = m.Response.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.ProtocolVersion != nil {
		n += 1 + sovPulsarApi(uint64(*m.ProtocolVersion))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandAuthChallenge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ServerVersion != nil {
		l = len(*m.ServerVersion)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Challenge != nil {
		l = m.Challenge.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.ProtocolVersion != nil {
		n += 1 + sovPulsarApi(uint64(*m.ProtocolVersion))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuthData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AuthMethodName != nil {
		l = len(*m.AuthMethodName)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.AuthData != nil {
		l = len(m.AuthData)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KeySharedMeta) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.KeySharedMode != nil {
		n += 1 + sovPulsarApi(uint64(*m.KeySharedMode))
	}
	if len(m.HashRanges) > 0 {
		for _, e := range m.HashRanges {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.AllowOutOfOrderDelivery != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandSubscribe) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Topic != nil {
		l = len(*m.Topic)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Subscription != nil {
		l = len(*m.Subscription)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.SubType != nil {
		n += 1 + sovPulsarApi(uint64(*m.SubType))
	}
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.ConsumerName != nil {
		l = len(*m.ConsumerName)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.PriorityLevel != nil {
		n += 1 + sovPulsarApi(uint64(*m.PriorityLevel))
	}
	if m.Durable != nil {
		n += 2
	}
	if m.StartMessageId != nil {
		l = m.StartMessageId.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if len(m.Metadata) > 0 {
		for _, e := range m.Metadata {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.ReadCompacted != nil {
		n += 2
	}
	if m.Schema != nil {
		l = m.Schema.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.InitialPosition != nil {
		n += 1 + sovPulsarApi(uint64(*m.InitialPosition))
	}
	if m.ReplicateSubscriptionState != nil {
		n += 2
	}
	if m.ForceTopicCreation != nil {
		n += 2
	}
	if m.StartMessageRollbackDurationSec != nil {
		n += 2 + sovPulsarApi(uint64(*m.StartMessageRollbackDurationSec))
	}
	if m.KeySharedMeta != nil {
		l = m.KeySharedMeta.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandPartitionedTopicMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Topic != nil {
		l = len(*m.Topic)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.OriginalPrincipal != nil {
		l = len(*m.OriginalPrincipal)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.OriginalAuthData != nil {
		l = len(*m.OriginalAuthData)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.OriginalAuthMethod != nil {
		l = len(*m.OriginalAuthMethod)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandPartitionedTopicMetadataResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Partitions != nil {
		n += 1 + sovPulsarApi(uint64(*m.Partitions))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.Response != nil {
		n += 1 + sovPulsarApi(uint64(*m.Response))
	}
	if m.Error != nil {
		n += 1 + sovPulsarApi(uint64(*m.Error))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandLookupTopic) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Topic != nil {
		l = len(*m.Topic)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.Authoritative != nil {
		n += 2
	}
	if m.OriginalPrincipal != nil {
		l = len(*m.OriginalPrincipal)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.OriginalAuthData != nil {
		l = len(*m.OriginalAuthData)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.OriginalAuthMethod != nil {
		l = len(*m.OriginalAuthMethod)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.AdvertisedListenerName != nil {
		l = len(*m.AdvertisedListenerName)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandLookupTopicResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BrokerServiceUrl != nil {
		l = len(*m.BrokerServiceUrl)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.BrokerServiceUrlTls != nil {
		l = len(*m.BrokerServiceUrlTls)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Response != nil {
		n += 1 + sovPulsarApi(uint64(*m.Response))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.Authoritative != nil {
		n += 2
	}
	if m.Error != nil {
		n += 1 + sovPulsarApi(uint64(*m.Error))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.ProxyThroughServiceUrl != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandProducer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Topic != nil {
		l = len(*m.Topic)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.ProducerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ProducerId))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.ProducerName != nil {
		l = len(*m.ProducerName)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Encrypted != nil {
		n += 2
	}
	if len(m.Metadata) > 0 {
		for _, e := range m.Metadata {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.Schema != nil {
		l = m.Schema.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Epoch != nil {
		n += 1 + sovPulsarApi(uint64(*m.Epoch))
	}
	if m.UserProvidedProducerName != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandSend) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProducerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ProducerId))
	}
	if m.SequenceId != nil {
		n += 1 + sovPulsarApi(uint64(*m.SequenceId))
	}
	if m.NumMessages != nil {
		n += 1 + sovPulsarApi(uint64(*m.NumMessages))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.HighestSequenceId != nil {
		n += 1 + sovPulsarApi(uint64(*m.HighestSequenceId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandSendReceipt) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProducerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ProducerId))
	}
	if m.SequenceId != nil {
		n += 1 + sovPulsarApi(uint64(*m.SequenceId))
	}
	if m.MessageId != nil {
		l = m.MessageId.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.HighestSequenceId != nil {
		n += 1 + sovPulsarApi(uint64(*m.HighestSequenceId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandSendError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProducerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ProducerId))
	}
	if m.SequenceId != nil {
		n += 1 + sovPulsarApi(uint64(*m.SequenceId))
	}
	if m.Error != nil {
		n += 1 + sovPulsarApi(uint64(*m.Error))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.MessageId != nil {
		l = m.MessageId.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.RedeliveryCount != nil {
		n += 1 + sovPulsarApi(uint64(*m.RedeliveryCount))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandAck) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.AckType != nil {
		n += 1 + sovPulsarApi(uint64(*m.AckType))
	}
	if len(m.MessageId) > 0 {
		for _, e := range m.MessageId {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.ValidationError != nil {
		n += 1 + sovPulsarApi(uint64(*m.ValidationError))
	}
	if len(m.Properties) > 0 {
		for _, e := range m.Properties {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandAckResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.Error != nil {
		n += 1 + sovPulsarApi(uint64(*m.Error))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandActiveConsumerChange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.IsActive != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandFlow) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.MessagePermits != nil {
		n += 1 + sovPulsarApi(uint64(*m.MessagePermits))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandUnsubscribe) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandSeek) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.MessageId != nil {
		l = m.MessageId.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.MessagePublishTime != nil {
		n += 1 + sovPulsarApi(uint64(*m.MessagePublishTime))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandReachedEndOfTopic) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandCloseProducer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProducerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ProducerId))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandCloseConsumer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandRedeliverUnacknowledgedMessages) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if len(m.MessageIds) > 0 {
		for _, e := range m.MessageIds {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandSuccess) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.Schema != nil {
		l = m.Schema.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandProducerSuccess) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.ProducerName != nil {
		l = len(*m.ProducerName)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.LastSequenceId != nil {
		n += 1 + sovPulsarApi(uint64(*m.LastSequenceId))
	}
	if m.SchemaVersion != nil {
		l = len(m.SchemaVersion)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.Error != nil {
		n += 1 + sovPulsarApi(uint64(*m.Error))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandPing) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandPong) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandConsumerStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandConsumerStatsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.ErrorCode != nil {
		n += 1 + sovPulsarApi(uint64(*m.ErrorCode))
	}
	if m.ErrorMessage != nil {
		l = len(*m.ErrorMessage)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.MsgRateOut != nil {
		n += 9
	}
	if m.MsgThroughputOut != nil {
		n += 9
	}
	if m.MsgRateRedeliver != nil {
		n += 9
	}
	if m.ConsumerName != nil {
		l = len(*m.ConsumerName)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.AvailablePermits != nil {
		n += 1 + sovPulsarApi(uint64(*m.AvailablePermits))
	}
	if m.UnackedMessages != nil {
		n += 1 + sovPulsarApi(uint64(*m.UnackedMessages))
	}
	if m.BlockedConsumerOnUnackedMsgs != nil {
		n += 2
	}
	if m.Address != nil {
		l = len(*m.Address)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.ConnectedSince != nil {
		l = len(*m.ConnectedSince)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.MsgRateExpired != nil {
		n += 9
	}
	if m.MsgBacklog != nil {
		n += 1 + sovPulsarApi(uint64(*m.MsgBacklog))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandGetLastMessageId) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsumerId != nil {
		n += 1 + sovPulsarApi(uint64(*m.ConsumerId))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandGetLastMessageIdResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LastMessageId != nil {
		l = m.LastMessageId.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandGetTopicsOfNamespace) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.Namespace != nil {
		l = len(*m.Namespace)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Mode != nil {
		n += 1 + sovPulsarApi(uint64(*m.Mode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandGetTopicsOfNamespaceResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if len(m.Topics) > 0 {
		for _, s := range m.Topics {
			l = len(s)
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandGetSchema) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.Topic != nil {
		l = len(*m.Topic)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.SchemaVersion != nil {
		l = len(m.SchemaVersion)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandGetSchemaResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.ErrorCode != nil {
		n += 1 + sovPulsarApi(uint64(*m.ErrorCode))
	}
	if m.ErrorMessage != nil {
		l = len(*m.ErrorMessage)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Schema != nil {
		l = m.Schema.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.SchemaVersion != nil {
		l = len(m.SchemaVersion)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandGetOrCreateSchema) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.Topic != nil {
		l = len(*m.Topic)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Schema != nil {
		l = m.Schema.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandGetOrCreateSchemaResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.ErrorCode != nil {
		n += 1 + sovPulsarApi(uint64(*m.ErrorCode))
	}
	if m.ErrorMessage != nil {
		l = len(*m.ErrorMessage)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.SchemaVersion != nil {
		l = len(m.SchemaVersion)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandNewTxn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnTtlSeconds != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnTtlSeconds))
	}
	if m.TcId != nil {
		n += 1 + sovPulsarApi(uint64(*m.TcId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandNewTxnResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.Error != nil {
		n += 1 + sovPulsarApi(uint64(*m.Error))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandAddPartitionToTxn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if len(m.Partitions) > 0 {
		for _, s := range m.Partitions {
			l = len(s)
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandAddPartitionToTxnResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.Error != nil {
		n += 1 + sovPulsarApi(uint64(*m.Error))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Subscription) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Topic != nil {
		l = len(*m.Topic)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Subscription != nil {
		l = len(*m.Subscription)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandAddSubscriptionToTxn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if len(m.Subscription) > 0 {
		for _, e := range m.Subscription {
			l = e.Size()
			n += 1 + l + sovPulsarApi(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandAddSubscriptionToTxnResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.Error != nil {
		n += 1 + sovPulsarApi(uint64(*m.Error))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandEndTxn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.TxnAction != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnAction))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandEndTxnResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.Error != nil {
		n += 1 + sovPulsarApi(uint64(*m.Error))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandEndTxnOnPartition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.Topic != nil {
		l = len(*m.Topic)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.TxnAction != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnAction))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandEndTxnOnPartitionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.Error != nil {
		n += 1 + sovPulsarApi(uint64(*m.Error))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandEndTxnOnSubscription) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.Subscription != nil {
		l = m.Subscription.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.TxnAction != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnAction))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandEndTxnOnSubscriptionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestId != nil {
		n += 1 + sovPulsarApi(uint64(*m.RequestId))
	}
	if m.TxnidLeastBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidLeastBits))
	}
	if m.TxnidMostBits != nil {
		n += 1 + sovPulsarApi(uint64(*m.TxnidMostBits))
	}
	if m.Error != nil {
		n += 1 + sovPulsarApi(uint64(*m.Error))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BaseCommand) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovPulsarApi(uint64(*m.Type))
	}
	if m.Connect != nil {
		l = m.Connect.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Connected != nil {
		l = m.Connected.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Subscribe != nil {
		l = m.Subscribe.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Producer != nil {
		l = m.Producer.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Send != nil {
		l = m.Send.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.SendReceipt != nil {
		l = m.SendReceipt.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.SendError != nil {
		l = m.SendError.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Message != nil {
		l = m.Message.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Ack != nil {
		l = m.Ack.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Flow != nil {
		l = m.Flow.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Unsubscribe != nil {
		l = m.Unsubscribe.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Success != nil {
		l = m.Success.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.CloseProducer != nil {
		l = m.CloseProducer.Size()
		n += 1 + l + sovPulsarApi(uint64(l))
	}
	if m.CloseConsumer != nil {
		l = m.CloseConsumer.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.ProducerSuccess != nil {
		l = m.ProducerSuccess.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.Ping != nil {
		l = m.Ping.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.Pong != nil {
		l = m.Pong.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.RedeliverUnacknowledgedMessages != nil {
		l = m.RedeliverUnacknowledgedMessages.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.PartitionMetadata != nil {
		l = m.PartitionMetadata.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.PartitionMetadataResponse != nil {
		l = m.PartitionMetadataResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.LookupTopic != nil {
		l = m.LookupTopic.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.LookupTopicResponse != nil {
		l = m.LookupTopicResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.ConsumerStats != nil {
		l = m.ConsumerStats.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.ConsumerStatsResponse != nil {
		l = m.ConsumerStatsResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.ReachedEndOfTopic != nil {
		l = m.ReachedEndOfTopic.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.Seek != nil {
		l = m.Seek.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.GetLastMessageId != nil {
		l = m.GetLastMessageId.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.GetLastMessageIdResponse != nil {
		l = m.GetLastMessageIdResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.ActiveConsumerChange != nil {
		l = m.ActiveConsumerChange.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.GetTopicsOfNamespace != nil {
		l = m.GetTopicsOfNamespace.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.GetTopicsOfNamespaceResponse != nil {
		l = m.GetTopicsOfNamespaceResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.GetSchema != nil {
		l = m.GetSchema.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.GetSchemaResponse != nil {
		l = m.GetSchemaResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.AuthChallenge != nil {
		l = m.AuthChallenge.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.AuthResponse != nil {
		l = m.AuthResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.AckResponse != nil {
		l = m.AckResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.GetOrCreateSchema != nil {
		l = m.GetOrCreateSchema.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.GetOrCreateSchemaResponse != nil {
		l = m.GetOrCreateSchemaResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.NewTxn != nil {
		l = m.NewTxn.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.NewTxnResponse != nil {
		l = m.NewTxnResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.AddPartitionToTxn != nil {
		l = m.AddPartitionToTxn.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.AddPartitionToTxnResponse != nil {
		l = m.AddPartitionToTxnResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.AddSubscriptionToTxn != nil {
		l = m.AddSubscriptionToTxn.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.AddSubscriptionToTxnResponse != nil {
		l = m.AddSubscriptionToTxnResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.EndTxn != nil {
		l = m.EndTxn.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.EndTxnResponse != nil {
		l = m.EndTxnResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.EndTxnOnPartition != nil {
		l = m.EndTxnOnPartition.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.EndTxnOnPartitionResponse != nil {
		l = m.EndTxnOnPartitionResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.EndTxnOnSubscription != nil {
		l = m.EndTxnOnSubscription.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.EndTxnOnSubscriptionResponse != nil {
		l = m.EndTxnOnSubscriptionResponse.Size()
		n += 2 + l + sovPulsarApi(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovPulsarApi(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPulsarApi(x uint64) (n int) {
	return sovPulsarApi(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Schema) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Schema: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Schema: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaData", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaData = append(m.SchemaData[:0], dAtA[iNdEx:postIndex]...)
			if m.SchemaData == nil {
				m.SchemaData = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Schema_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= Schema_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000004)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Properties = append(m.Properties, &KeyValue{})
			if err := m.Properties[len(m.Properties)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("schema_data")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MessageIdData) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MessageIdData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MessageIdData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LedgerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LedgerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EntryId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EntryId = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Partition", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Partition = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchIndex", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BatchIndex = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("ledgerId")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("entryId")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyValue) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Key = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("key")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyLongValue) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyLongValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyLongValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Key = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("key")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IntRange) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IntRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IntRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Start = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.End = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("start")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("end")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EncryptionKeys) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncryptionKeys: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncryptionKeys: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Key = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metadata = append(m.Metadata, &KeyValue{})
			if err := m.Metadata[len(m.Metadata)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("key")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MessageMetadata) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MessageMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MessageMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProducerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ProducerName = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SequenceId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SequenceId = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublishTime", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PublishTime = &v
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Properties = append(m.Properties, &KeyValue{})
			if err := m.Properties[len(m.Properties)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicatedFrom", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ReplicatedFrom = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartitionKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.PartitionKey = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicateTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplicateTo = append(m.ReplicateTo, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Compression", wireType)
			}
			var v CompressionType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= CompressionType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Compression = &v
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UncompressedSize", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UncompressedSize = &v
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumMessagesInBatch", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NumMessagesInBatch = &v
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventTime", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EventTime = &v
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptionKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncryptionKeys = append(m.EncryptionKeys, &EncryptionKeys{})
			if err := m.EncryptionKeys[len(m.EncryptionKeys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptionAlgo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.EncryptionAlgo = &s
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptionParam", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncryptionParam = append(m.EncryptionParam[:0], dAtA[iNdEx:postIndex]...)
			if m.EncryptionParam == nil {
				m.EncryptionParam = []byte{}
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaVersion", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaVersion = append(m.SchemaVersion[:0], dAtA[iNdEx:postIndex]...)
			if m.SchemaVersion == nil {
				m.SchemaVersion = []byte{}
			}
			iNdEx = postIndex
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartitionKeyB64Encoded", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.PartitionKeyB64Encoded = &b
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderingKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrderingKey = append(m.OrderingKey[:0], dAtA[iNdEx:postIndex]...)
			if m.OrderingKey == nil {
				m.OrderingKey = []byte{}
			}
			iNdEx = postIndex
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeliverAtTime", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DeliverAtTime = &v
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MarkerType", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MarkerType = &v
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighestSequenceId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HighestSequenceId = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("sequence_id")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("publish_time")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SingleMessageMetadata) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SingleMessageMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SingleMessageMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Properties = append(m.Properties, &KeyValue{})
			if err := m.Properties[len(m.Properties)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartitionKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.PartitionKey = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PayloadSize", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PayloadSize = &v
			hasFields[0] |= uint64(0x00000001)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompactedOut", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.CompactedOut = &b
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventTime", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EventTime = &v
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartitionKeyB64Encoded", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.PartitionKeyB64Encoded = &b
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderingKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrderingKey = append(m.OrderingKey[:0], dAtA[iNdEx:postIndex]...)
			if m.OrderingKey == nil {
				m.OrderingKey = []byte{}
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SequenceId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SequenceId = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("payload_size")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandConnect) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandConnect: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandConnect: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ClientVersion = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthMethod", wireType)
			}
			var v AuthMethod
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= AuthMethod(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AuthMethod = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthData", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuthData = append(m.AuthData[:0], dAtA[iNdEx:postIndex]...)
			if m.AuthData == nil {
				m.AuthData = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolVersion", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ProtocolVersion = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthMethodName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AuthMethodName = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyToBrokerUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ProxyToBrokerUrl = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPrincipal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.OriginalPrincipal = &s
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalAuthData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.OriginalAuthData = &s
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalAuthMethod", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.OriginalAuthMethod = &s
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FeatureFlags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FeatureFlags == nil {
				m.FeatureFlags = &FeatureFlags{}
			}
			if err := m.FeatureFlags.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("client_version")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FeatureFlags) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FeatureFlags: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FeatureFlags: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportsAuthRefresh", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.SupportsAuthRefresh = &b
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandConnected) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandConnected: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandConnected: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ServerVersion = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolVersion", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ProtocolVersion = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxMessageSize", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MaxMessageSize = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("server_version")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandAuthResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandAuthResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandAuthResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ClientVersion = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Response == nil {
				m.Response = &AuthData{}
			}
			if err := m.Response.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolVersion", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ProtocolVersion = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandAuthChallenge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandAuthChallenge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandAuthChallenge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ServerVersion = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Challenge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Challenge == nil {
				m.Challenge = &AuthData{}
			}
			if err := m.Challenge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolVersion", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ProtocolVersion = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuthData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuthData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuthData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthMethodName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AuthMethodName = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthData", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuthData = append(m.AuthData[:0], dAtA[iNdEx:postIndex]...)
			if m.AuthData == nil {
				m.AuthData = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeySharedMeta) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeySharedMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeySharedMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeySharedMode", wireType)
			}
			var v KeySharedMode
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= KeySharedMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.KeySharedMode = &v
			hasFields[0] |= uint64(0x00000001)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HashRanges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HashRanges = append(m.HashRanges, &IntRange{})
			if err := m.HashRanges[len(m.HashRanges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowOutOfOrderDelivery", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.AllowOutOfOrderDelivery = &b
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("keySharedMode")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandSubscribe) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandSubscribe: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandSubscribe: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Topic = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscription", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Subscription = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubType", wireType)
			}
			var v CommandSubscribe_SubType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= CommandSubscribe_SubType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SubType = &v
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000008)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000010)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ConsumerName = &s
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PriorityLevel", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PriorityLevel = &v
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Durable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Durable = &b
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartMessageId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartMessageId == nil {
				m.StartMessageId = &MessageIdData{}
			}
			if err := m.StartMessageId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metadata = append(m.Metadata, &KeyValue{})
			if err := m.Metadata[len(m.Metadata)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadCompacted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReadCompacted = &b
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schema == nil {
				m.Schema = &Schema{}
			}
			if err := m.Schema.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialPosition", wireType)
			}
			var v CommandSubscribe_InitialPosition
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= CommandSubscribe_InitialPosition(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InitialPosition = &v
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicateSubscriptionState", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ReplicateSubscriptionState = &b
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForceTopicCreation", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ForceTopicCreation = &b
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartMessageRollbackDurationSec", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StartMessageRollbackDurationSec = &v
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeySharedMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KeySharedMeta == nil {
				m.KeySharedMeta = &KeySharedMeta{}
			}
			if err := m.KeySharedMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("subscription")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("subType")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}
	if hasFields[0]&uint64(0x00000010) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandPartitionedTopicMetadata) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandPartitionedTopicMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandPartitionedTopicMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Topic = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPrincipal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.OriginalPrincipal = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalAuthData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.OriginalAuthData = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalAuthMethod", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.OriginalAuthMethod = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandPartitionedTopicMetadataResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandPartitionedTopicMetadataResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandPartitionedTopicMetadataResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Partitions", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Partitions = &v
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var v CommandPartitionedTopicMetadataResponse_LookupType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= CommandPartitionedTopicMetadataResponse_LookupType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Response = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Error = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandLookupTopic) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandLookupTopic: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandLookupTopic: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Topic = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authoritative", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Authoritative = &b
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPrincipal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.OriginalPrincipal = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalAuthData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.OriginalAuthData = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalAuthMethod", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.OriginalAuthMethod = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdvertisedListenerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AdvertisedListenerName = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandLookupTopicResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandLookupTopicResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandLookupTopicResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BrokerServiceUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.BrokerServiceUrl = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BrokerServiceUrlTls", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.BrokerServiceUrlTls = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var v CommandLookupTopicResponse_LookupType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= CommandLookupTopicResponse_LookupType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Response = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authoritative", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Authoritative = &b
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Error = &v
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyThroughServiceUrl", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ProxyThroughServiceUrl = &b
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandProducer) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandProducer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandProducer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Topic = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProducerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ProducerId = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProducerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ProducerName = &s
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Encrypted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Encrypted = &b
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metadata = append(m.Metadata, &KeyValue{})
			if err := m.Metadata[len(m.Metadata)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schema == nil {
				m.Schema = &Schema{}
			}
			if err := m.Schema.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Epoch = &v
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserProvidedProducerName", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.UserProvidedProducerName = &b
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_id")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandSend) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandSend: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandSend: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProducerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ProducerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SequenceId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SequenceId = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumMessages", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NumMessages = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighestSequenceId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HighestSequenceId = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("sequence_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandSendReceipt) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandSendReceipt: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandSendReceipt: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProducerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ProducerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SequenceId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SequenceId = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessageId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MessageId == nil {
				m.MessageId = &MessageIdData{}
			}
			if err := m.MessageId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighestSequenceId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HighestSequenceId = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("sequence_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandSendError) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandSendError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandSendError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProducerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ProducerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SequenceId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SequenceId = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Error = &v
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000008)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("sequence_id")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("error")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("message")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandMessage) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessageId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MessageId == nil {
				m.MessageId = &MessageIdData{}
			}
			if err := m.MessageId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RedeliveryCount", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RedeliveryCount = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("message_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandAck) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandAck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandAck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AckType", wireType)
			}
			var v CommandAck_AckType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= CommandAck_AckType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AckType = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessageId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MessageId = append(m.MessageId, &MessageIdData{})
			if err := m.MessageId[len(m.MessageId)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidationError", wireType)
			}
			var v CommandAck_ValidationError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= CommandAck_ValidationError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ValidationError = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Properties = append(m.Properties, &KeyLongValue{})
			if err := m.Properties[len(m.Properties)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("ack_type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandAckResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandAckResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandAckResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Error = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandActiveConsumerChange) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandActiveConsumerChange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandActiveConsumerChange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsActive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.IsActive = &b
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandFlow) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandFlow: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandFlow: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessagePermits", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MessagePermits = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("messagePermits")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandUnsubscribe) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandUnsubscribe: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandUnsubscribe: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandSeek) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandSeek: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandSeek: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessageId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MessageId == nil {
				m.MessageId = &MessageIdData{}
			}
			if err := m.MessageId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessagePublishTime", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MessagePublishTime = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandReachedEndOfTopic) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandReachedEndOfTopic: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandReachedEndOfTopic: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandCloseProducer) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandCloseProducer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandCloseProducer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProducerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ProducerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandCloseConsumer) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandCloseConsumer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandCloseConsumer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandRedeliverUnacknowledgedMessages) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandRedeliverUnacknowledgedMessages: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandRedeliverUnacknowledgedMessages: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MessageIds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MessageIds = append(m.MessageIds, &MessageIdData{})
			if err := m.MessageIds[len(m.MessageIds)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandSuccess) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandSuccess: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandSuccess: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schema == nil {
				m.Schema = &Schema{}
			}
			if err := m.Schema.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandProducerSuccess) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandProducerSuccess: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandProducerSuccess: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProducerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ProducerName = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastSequenceId", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LastSequenceId = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaVersion", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaVersion = append(m.SchemaVersion[:0], dAtA[iNdEx:postIndex]...)
			if m.SchemaVersion == nil {
				m.SchemaVersion = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("producer_name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandError) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Error = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("error")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("message")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandPing) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandPing: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandPing: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandPong) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandPong: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandPong: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandConsumerStats) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandConsumerStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandConsumerStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandConsumerStatsResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandConsumerStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandConsumerStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorCode", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ErrorCode = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ErrorMessage = &s
			iNdEx = postIndex
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgRateOut", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			v2 := float64(math.Float64frombits(v))
			m.MsgRateOut = &v2
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgThroughputOut", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			v2 := float64(math.Float64frombits(v))
			m.MsgThroughputOut = &v2
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgRateRedeliver", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			v2 := float64(math.Float64frombits(v))
			m.MsgRateRedeliver = &v2
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ConsumerName = &s
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvailablePermits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AvailablePermits = &v
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnackedMessages", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UnackedMessages = &v
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockedConsumerOnUnackedMsgs", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.BlockedConsumerOnUnackedMsgs = &b
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Address = &s
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectedSince", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ConnectedSince = &s
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Type = &s
			iNdEx = postIndex
		case 14:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgRateExpired", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			v2 := float64(math.Float64frombits(v))
			m.MsgRateExpired = &v2
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgBacklog", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MsgBacklog = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandGetLastMessageId) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandGetLastMessageId: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandGetLastMessageId: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("consumer_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandGetLastMessageIdResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandGetLastMessageIdResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandGetLastMessageIdResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastMessageId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastMessageId == nil {
				m.LastMessageId = &MessageIdData{}
			}
			if err := m.LastMessageId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("last_message_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandGetTopicsOfNamespace) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandGetTopicsOfNamespace: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandGetTopicsOfNamespace: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Namespace = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			var v CommandGetTopicsOfNamespace_Mode
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= CommandGetTopicsOfNamespace_Mode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Mode = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("namespace")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandGetTopicsOfNamespaceResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandGetTopicsOfNamespaceResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandGetTopicsOfNamespaceResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topics", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Topics = append(m.Topics, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandGetSchema) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandGetSchema: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandGetSchema: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Topic = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaVersion", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaVersion = append(m.SchemaVersion[:0], dAtA[iNdEx:postIndex]...)
			if m.SchemaVersion == nil {
				m.SchemaVersion = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandGetSchemaResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandGetSchemaResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandGetSchemaResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorCode", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ErrorCode = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ErrorMessage = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schema == nil {
				m.Schema = &Schema{}
			}
			if err := m.Schema.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaVersion", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaVersion = append(m.SchemaVersion[:0], dAtA[iNdEx:postIndex]...)
			if m.SchemaVersion == nil {
				m.SchemaVersion = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandGetOrCreateSchema) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandGetOrCreateSchema: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandGetOrCreateSchema: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Topic = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schema == nil {
				m.Schema = &Schema{}
			}
			if err := m.Schema.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("schema")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandGetOrCreateSchemaResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandGetOrCreateSchemaResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandGetOrCreateSchemaResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorCode", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ErrorCode = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ErrorMessage = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaVersion", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaVersion = append(m.SchemaVersion[:0], dAtA[iNdEx:postIndex]...)
			if m.SchemaVersion == nil {
				m.SchemaVersion = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandNewTxn) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandNewTxn: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandNewTxn: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnTtlSeconds", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnTtlSeconds = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TcId = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandNewTxnResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandNewTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandNewTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Error = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandAddPartitionToTxn) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandAddPartitionToTxn: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandAddPartitionToTxn: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Partitions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Partitions = append(m.Partitions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandAddPartitionToTxnResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandAddPartitionToTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandAddPartitionToTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Error = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Subscription) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subscription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subscription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Topic = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscription", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Subscription = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("topic")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("subscription")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandAddSubscriptionToTxn) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandAddSubscriptionToTxn: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandAddSubscriptionToTxn: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscription", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subscription = append(m.Subscription, &Subscription{})
			if err := m.Subscription[len(m.Subscription)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandAddSubscriptionToTxnResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandAddSubscriptionToTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandAddSubscriptionToTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Error = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandEndTxn) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandEndTxn: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandEndTxn: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnAction", wireType)
			}
			var v TxnAction
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= TxnAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnAction = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandEndTxnResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandEndTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandEndTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Error = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandEndTxnOnPartition) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandEndTxnOnPartition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandEndTxnOnPartition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Topic = &s
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnAction", wireType)
			}
			var v TxnAction
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= TxnAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnAction = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandEndTxnOnPartitionResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandEndTxnOnPartitionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandEndTxnOnPartitionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Error = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandEndTxnOnSubscription) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandEndTxnOnSubscription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandEndTxnOnSubscription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscription", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subscription == nil {
				m.Subscription = &Subscription{}
			}
			if err := m.Subscription.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnAction", wireType)
			}
			var v TxnAction
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= TxnAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnAction = &v
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandEndTxnOnSubscriptionResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandEndTxnOnSubscriptionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandEndTxnOnSubscriptionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestId", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequestId = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidLeastBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidLeastBits = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnidMostBits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TxnidMostBits = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var v ServerError
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= ServerError(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Error = &v
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("request_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BaseCommand) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BaseCommand: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BaseCommand: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v BaseCommand_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= BaseCommand_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Connect", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Connect == nil {
				m.Connect = &CommandConnect{}
			}
			if err := m.Connect.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Connected", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Connected == nil {
				m.Connected = &CommandConnected{}
			}
			if err := m.Connected.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscribe", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subscribe == nil {
				m.Subscribe = &CommandSubscribe{}
			}
			if err := m.Subscribe.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Producer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Producer == nil {
				m.Producer = &CommandProducer{}
			}
			if err := m.Producer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Send", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Send == nil {
				m.Send = &CommandSend{}
			}
			if err := m.Send.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SendReceipt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SendReceipt == nil {
				m.SendReceipt = &CommandSendReceipt{}
			}
			if err := m.SendReceipt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SendError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SendError == nil {
				m.SendError = &CommandSendError{}
			}
			if err := m.SendError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Message == nil {
				m.Message = &CommandMessage{}
			}
			if err := m.Message.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ack", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ack == nil {
				m.Ack = &CommandAck{}
			}
			if err := m.Ack.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flow", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Flow == nil {
				m.Flow = &CommandFlow{}
			}
			if err := m.Flow.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unsubscribe", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Unsubscribe == nil {
				m.Unsubscribe = &CommandUnsubscribe{}
			}
			if err := m.Unsubscribe.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Success", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Success == nil {
				m.Success = &CommandSuccess{}
			}
			if err := m.Success.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &CommandError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloseProducer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CloseProducer == nil {
				m.CloseProducer = &CommandCloseProducer{}
			}
			if err := m.CloseProducer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloseConsumer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CloseConsumer == nil {
				m.CloseConsumer = &CommandCloseConsumer{}
			}
			if err := m.CloseConsumer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProducerSuccess", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProducerSuccess == nil {
				m.ProducerSuccess = &CommandProducerSuccess{}
			}
			if err := m.ProducerSuccess.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ping", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ping == nil {
				m.Ping = &CommandPing{}
			}
			if err := m.Ping.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pong", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Pong == nil {
				m.Pong = &CommandPong{}
			}
			if err := m.Pong.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RedeliverUnacknowledgedMessages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RedeliverUnacknowledgedMessages == nil {
				m.RedeliverUnacknowledgedMessages = &CommandRedeliverUnacknowledgedMessages{}
			}
			if err := m.RedeliverUnacknowledgedMessages.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartitionMetadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PartitionMetadata == nil {
				m.PartitionMetadata = &CommandPartitionedTopicMetadata{}
			}
			if err := m.PartitionMetadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartitionMetadataResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PartitionMetadataResponse == nil {
				m.PartitionMetadataResponse = &CommandPartitionedTopicMetadataResponse{}
			}
			if err := m.PartitionMetadataResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LookupTopic", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LookupTopic == nil {
				m.LookupTopic = &CommandLookupTopic{}
			}
			if err := m.LookupTopic.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LookupTopicResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LookupTopicResponse == nil {
				m.LookupTopicResponse = &CommandLookupTopicResponse{}
			}
			if err := m.LookupTopicResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConsumerStats == nil {
				m.ConsumerStats = &CommandConsumerStats{}
			}
			if err := m.ConsumerStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerStatsResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConsumerStatsResponse == nil {
				m.ConsumerStatsResponse = &CommandConsumerStatsResponse{}
			}
			if err := m.ConsumerStatsResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReachedEndOfTopic", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReachedEndOfTopic == nil {
				m.ReachedEndOfTopic = &CommandReachedEndOfTopic{}
			}
			if err := m.ReachedEndOfTopic.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seek", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Seek == nil {
				m.Seek = &CommandSeek{}
			}
			if err := m.Seek.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetLastMessageId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetLastMessageId == nil {
				m.GetLastMessageId = &CommandGetLastMessageId{}
			}
			if err := m.GetLastMessageId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetLastMessageIdResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetLastMessageIdResponse == nil {
				m.GetLastMessageIdResponse = &CommandGetLastMessageIdResponse{}
			}
			if err := m.GetLastMessageIdResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveConsumerChange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ActiveConsumerChange == nil {
				m.ActiveConsumerChange = &CommandActiveConsumerChange{}
			}
			if err := m.ActiveConsumerChange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetTopicsOfNamespace", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetTopicsOfNamespace == nil {
				m.GetTopicsOfNamespace = &CommandGetTopicsOfNamespace{}
			}
			if err := m.GetTopicsOfNamespace.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetTopicsOfNamespaceResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetTopicsOfNamespaceResponse == nil {
				m.GetTopicsOfNamespaceResponse = &CommandGetTopicsOfNamespaceResponse{}
			}
			if err := m.GetTopicsOfNamespaceResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetSchema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetSchema == nil {
				m.GetSchema = &CommandGetSchema{}
			}
			if err := m.GetSchema.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetSchemaResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetSchemaResponse == nil {
				m.GetSchemaResponse = &CommandGetSchemaResponse{}
			}
			if err := m.GetSchemaResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthChallenge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AuthChallenge == nil {
				m.AuthChallenge = &CommandAuthChallenge{}
			}
			if err := m.AuthChallenge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AuthResponse == nil {
				m.AuthResponse = &CommandAuthResponse{}
			}
			if err := m.AuthResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 38:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AckResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AckResponse == nil {
				m.AckResponse = &CommandAckResponse{}
			}
			if err := m.AckResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 39:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetOrCreateSchema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetOrCreateSchema == nil {
				m.GetOrCreateSchema = &CommandGetOrCreateSchema{}
			}
			if err := m.GetOrCreateSchema.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 40:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetOrCreateSchemaResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetOrCreateSchemaResponse == nil {
				m.GetOrCreateSchemaResponse = &CommandGetOrCreateSchemaResponse{}
			}
			if err := m.GetOrCreateSchemaResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 50:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NewTxn == nil {
				m.NewTxn = &CommandNewTxn{}
			}
			if err := m.NewTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 51:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewTxnResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NewTxnResponse == nil {
				m.NewTxnResponse = &CommandNewTxnResponse{}
			}
			if err := m.NewTxnResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 52:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddPartitionToTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AddPartitionToTxn == nil {
				m.AddPartitionToTxn = &CommandAddPartitionToTxn{}
			}
			if err := m.AddPartitionToTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 53:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddPartitionToTxnResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AddPartitionToTxnResponse == nil {
				m.AddPartitionToTxnResponse = &CommandAddPartitionToTxnResponse{}
			}
			if err := m.AddPartitionToTxnResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 54:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddSubscriptionToTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AddSubscriptionToTxn == nil {
				m.AddSubscriptionToTxn = &CommandAddSubscriptionToTxn{}
			}
			if err := m.AddSubscriptionToTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 55:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddSubscriptionToTxnResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AddSubscriptionToTxnResponse == nil {
				m.AddSubscriptionToTxnResponse = &CommandAddSubscriptionToTxnResponse{}
			}
			if err := m.AddSubscriptionToTxnResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 56:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTxn == nil {
				m.EndTxn = &CommandEndTxn{}
			}
			if err := m.EndTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 57:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTxnResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTxnResponse == nil {
				m.EndTxnResponse = &CommandEndTxnResponse{}
			}
			if err := m.EndTxnResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 58:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTxnOnPartition", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTxnOnPartition == nil {
				m.EndTxnOnPartition = &CommandEndTxnOnPartition{}
			}
			if err := m.EndTxnOnPartition.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 59:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTxnOnPartitionResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTxnOnPartitionResponse == nil {
				m.EndTxnOnPartitionResponse = &CommandEndTxnOnPartitionResponse{}
			}
			if err := m.EndTxnOnPartitionResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 60:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTxnOnSubscription", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTxnOnSubscription == nil {
				m.EndTxnOnSubscription = &CommandEndTxnOnSubscription{}
			}
			if err := m.EndTxnOnSubscription.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 61:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTxnOnSubscriptionResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPulsarApi
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTxnOnSubscriptionResponse == nil {
				m.EndTxnOnSubscriptionResponse = &CommandEndTxnOnSubscriptionResponse{}
			}
			if err := m.EndTxnOnSubscriptionResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPulsarApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPulsarApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPulsarApi(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPulsarApi
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPulsarApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPulsarApi
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupPulsarApi
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthPulsarApi
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthPulsarApi        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPulsarApi          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupPulsarApi = fmt.Errorf("proto: unexpected end of group")
)
