/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.namespace.TopicExistsInfo;
import org.apache.pulsar.broker.resources.ClusterResources;
import org.apache.pulsar.broker.service.TopicEventsListener;
import org.apache.pulsar.broker.service.TopicPoliciesService;
import org.apache.pulsar.broker.service.plugin.InvalidEntryFilterException;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.TopicsImpl;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.EntryFilters;
import org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.policies.data.TopicType;
import org.apache.pulsar.common.policies.data.impl.AutoSubscriptionCreationOverrideImpl;
import org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdminResource
extends PulsarWebResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminResource.class);
    protected NamespaceName namespaceName;
    protected TopicName topicName;

    protected BookKeeper bookKeeper() {
        return this.pulsar().getBookKeeperClient();
    }

    protected String domain() {
        if (this.uri.getPath().startsWith("persistent/")) {
            return "persistent";
        }
        if (this.uri.getPath().startsWith("non-persistent/")) {
            return "non-persistent";
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "domain() invoked from wrong resource");
    }

    @Override
    public void validateSuperUserAccess() {
        super.validateSuperUserAccess();
    }

    @Override
    protected void validateAdminAccessForTenant(String property) {
        super.validateAdminAccessForTenant(property);
    }

    @Override
    protected void validateBundleOwnership(String property, String cluster, String namespace, boolean authoritative, boolean readOnly, NamespaceBundle bundle) {
        super.validateBundleOwnership(property, cluster, namespace, authoritative, readOnly, bundle);
    }

    @Override
    protected boolean isLeaderBroker() {
        return super.isLeaderBroker();
    }

    @Override
    public void validatePoliciesReadOnlyAccess() {
        try {
            this.validatePoliciesReadOnlyAccessAsync().join();
        }
        catch (CompletionException ce) {
            throw new RestException(ce.getCause());
        }
    }

    @Override
    public CompletableFuture<Void> validatePoliciesReadOnlyAccessAsync() {
        return this.pulsar().getPulsarResources().getNamespaceResources().getPoliciesReadOnlyAsync().thenAccept(arePoliciesReadOnly -> {
            if (arePoliciesReadOnly.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Policies are read-only. Broker cannot do read-write operations");
                }
                throw new RestException(Response.Status.FORBIDDEN, "Broker is forbidden to do read-write operations");
            }
            if (log.isDebugEnabled()) {
                log.debug("Broker is allowed to make read-write operations");
            }
        });
    }

    protected CompletableFuture<Void> tryCreatePartitionsAsync(int numPartitions) {
        if (!this.topicName.isPersistent()) {
            for (int i = 0; i < numPartitions; ++i) {
                this.pulsar().getBrokerService().getTopicEventsDispatcher().notify(this.topicName.getPartition(i).toString(), TopicEventsListener.TopicEvent.CREATE, TopicEventsListener.EventStage.SUCCESS);
            }
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            futures.add(this.tryCreatePartitionAsync(i));
        }
        return FutureUtil.waitForAll(futures);
    }

    private CompletableFuture<Void> tryCreatePartitionAsync(int partition) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.getPulsarResources().getTopicResources().createPersistentTopicAsync(this.topicName.getPartition(partition)).thenAccept(r -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Topic partition {} created.", (Object)this.clientAppId(), (Object)this.topicName.getPartition(partition));
            }
            result.complete(null);
        })).exceptionally(ex -> {
            if (ex.getCause() instanceof MetadataStoreException.AlreadyExistsException) {
                log.info("[{}] Topic partition {} is exists, doing nothing.", (Object)this.clientAppId(), (Object)this.topicName.getPartition(partition));
                result.complete(null);
            } else if (ex.getCause() instanceof MetadataStoreException.BadVersionException) {
                log.warn("[{}] Partitioned topic {} is already created.", (Object)this.clientAppId(), (Object)this.topicName.getPartition(partition));
                result.complete(null);
            } else {
                log.error("[{}] Fail to create topic partition {}", new Object[]{this.clientAppId(), this.topicName.getPartition(partition), ex.getCause()});
                result.completeExceptionally(ex.getCause());
            }
            return null;
        });
        this.pulsar().getBrokerService().getTopicEventsDispatcher().notifyOnCompletion(result, this.topicName.getPartition(partition).toString(), TopicEventsListener.TopicEvent.CREATE);
        return result;
    }

    protected void validateNamespaceName(String property, String namespace) {
        try {
            this.namespaceName = NamespaceName.get((String)property, (String)namespace);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Invalid namespace name [{}/{}]", new Object[]{this.clientAppId(), property, namespace});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Namespace name is not valid");
        }
    }

    protected void validateGlobalNamespaceOwnership() {
        try {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        catch (IllegalArgumentException e) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Tenant name or namespace is not valid");
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.warn("Failed to validate global cluster configuration : ns={}  emsg={}", (Object)this.namespaceName, (Object)e.getMessage());
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Failed to validate global cluster configuration");
        }
    }

    @Deprecated
    protected void validateNamespaceName(String property, String cluster, String namespace) {
        try {
            this.namespaceName = NamespaceName.get((String)property, (String)cluster, (String)namespace);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Invalid namespace name [{}/{}/{}]", new Object[]{this.clientAppId(), property, cluster, namespace});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Namespace name is not valid");
        }
    }

    protected void validateTopicName(String property, String namespace, String encodedTopic) {
        String topic = Codec.decode((String)encodedTopic);
        try {
            this.namespaceName = NamespaceName.get((String)property, (String)namespace);
            this.topicName = TopicName.get((String)this.domain(), (NamespaceName)this.namespaceName, (String)topic);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Invalid topic name [{}://{}/{}/{}]", new Object[]{this.clientAppId(), this.domain(), property, namespace, topic});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic name is not valid");
        }
    }

    protected void validatePersistentTopicName(String property, String namespace, String encodedTopic) {
        this.validateTopicName(property, namespace, encodedTopic);
        if (this.topicName.getDomain() != TopicDomain.persistent) {
            throw new RestException(Response.Status.NOT_ACCEPTABLE, "Need to provide a persistent topic name");
        }
    }

    protected void validatePartitionedTopicName(String tenant, String namespace, String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        if (encodedTopic.contains("-partition-")) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Partitioned Topic Name should not contain '-partition-'");
        }
    }

    protected CompletableFuture<Void> validatePartitionedTopicMetadataAsync() {
        return this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(this.topicName).thenAccept(metadata -> {
            if (metadata.partitions < 1) {
                throw new RestException(Response.Status.CONFLICT, "Topic is not partitioned topic");
            }
        });
    }

    @Deprecated
    protected void validateTopicName(String property, String cluster, String namespace, String encodedTopic) {
        String topic = Codec.decode((String)encodedTopic);
        try {
            this.namespaceName = NamespaceName.get((String)property, (String)cluster, (String)namespace);
            this.topicName = TopicName.get((String)this.domain(), (NamespaceName)this.namespaceName, (String)topic);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Invalid topic name {}://{}/{}/{}/{}", new Object[]{this.clientAppId(), this.domain(), property, cluster, namespace, topic});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic name is not valid");
        }
    }

    @Deprecated
    protected void validatePersistentTopicName(String property, String cluster, String namespace, String encodedTopic) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        if (this.topicName.getDomain() != TopicDomain.persistent) {
            throw new RestException(Response.Status.NOT_ACCEPTABLE, "Need to provide a persistent topic name");
        }
    }

    protected WorkerService validateAndGetWorkerService() {
        try {
            return this.pulsar().getWorkerService();
        }
        catch (UnsupportedOperationException e) {
            throw new RestException(Response.Status.CONFLICT, e.getMessage());
        }
    }

    @Deprecated
    protected Policies getNamespacePolicies(NamespaceName namespaceName) {
        try {
            Policies policies = (Policies)this.namespaceResources().getPolicies(namespaceName).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            BundlesData bundleData = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(namespaceName).getBundlesData();
            Optional localPolicies = this.getLocalPolicies().getLocalPolicies(namespaceName);
            policies.bundles = bundleData != null ? bundleData : policies.bundles;
            boolean bl = policies.migrated = localPolicies.isPresent() ? ((LocalPolicies)localPolicies.get()).migrated : false;
            if (policies.is_allow_auto_update_schema == null) {
                policies.is_allow_auto_update_schema = this.pulsar().getConfig().isAllowAutoUpdateSchemaEnabled();
            }
            return policies;
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespace policies {}", new Object[]{this.clientAppId(), namespaceName, e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Policies> getNamespacePoliciesAsync(NamespaceName namespaceName) {
        CompletableFuture<Policies> result = new CompletableFuture<Policies>();
        ((CompletableFuture)this.namespaceResources().getPoliciesAsync(namespaceName).thenCombine((CompletionStage)this.getLocalPolicies().getLocalPoliciesAsync(namespaceName), (pl, localPolicies) -> {
            if (pl.isPresent()) {
                Policies policies = (Policies)pl.get();
                if (localPolicies.isPresent()) {
                    policies.bundles = ((LocalPolicies)localPolicies.get()).bundles;
                    policies.migrated = ((LocalPolicies)localPolicies.get()).migrated;
                }
                if (policies.is_allow_auto_update_schema == null) {
                    policies.is_allow_auto_update_schema = this.pulsar().getConfig().isAllowAutoUpdateSchemaEnabled();
                }
                result.complete(policies);
            } else {
                result.completeExceptionally((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
            }
            return null;
        })).exceptionally(ex -> {
            result.completeExceptionally(ex.getCause());
            return null;
        });
        return result;
    }

    protected BacklogQuota namespaceBacklogQuota(NamespaceName namespace, BacklogQuota.BacklogQuotaType backlogQuotaType) {
        return this.pulsar().getBrokerService().getBacklogQuotaManager().getBacklogQuota(namespace, backlogQuotaType);
    }

    protected CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsyncWithRetry(TopicName topicName) {
        return this.getTopicPoliciesAsyncWithRetry(topicName, false);
    }

    protected CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsyncWithRetry(TopicName topicName, boolean isGlobal) {
        TopicPoliciesService.GetType type = isGlobal ? TopicPoliciesService.GetType.GLOBAL_ONLY : TopicPoliciesService.GetType.LOCAL_ONLY;
        return this.pulsar().getTopicPoliciesService().getTopicPoliciesAsync(topicName, type);
    }

    protected boolean checkBacklogQuota(BacklogQuota quota, RetentionPolicies retention) {
        if (retention == null || retention.getRetentionSizeInMB() <= 0L && retention.getRetentionTimeInMinutes() <= 0) {
            return true;
        }
        if (quota == null) {
            quota = this.pulsar().getBrokerService().getBacklogQuotaManager().getDefaultQuota();
        }
        if (retention.getRetentionSizeInMB() > 0L && quota.getLimitSize() >= retention.getRetentionSizeInMB() * 1024L * 1024L) {
            return false;
        }
        return retention.getRetentionTimeInMinutes() <= 0 || quota.getLimitTime() < retention.getRetentionTimeInMinutes() * 60;
    }

    protected DispatchRateImpl dispatchRate() {
        return DispatchRateImpl.builder().dispatchThrottlingRateInMsg(this.config().getDispatchThrottlingRatePerTopicInMsg()).dispatchThrottlingRateInByte(this.config().getDispatchThrottlingRatePerTopicInByte()).ratePeriodInSecond(1).build();
    }

    protected DispatchRateImpl subscriptionDispatchRate() {
        return DispatchRateImpl.builder().dispatchThrottlingRateInMsg(this.config().getDispatchThrottlingRatePerSubscriptionInMsg()).dispatchThrottlingRateInByte(this.config().getDispatchThrottlingRatePerSubscriptionInByte()).ratePeriodInSecond(1).build();
    }

    protected DispatchRateImpl replicatorDispatchRate() {
        return DispatchRateImpl.builder().dispatchThrottlingRateInMsg(this.config().getDispatchThrottlingRatePerReplicatorInMsg()).dispatchThrottlingRateInByte(this.config().getDispatchThrottlingRatePerReplicatorInByte()).ratePeriodInSecond(1).build();
    }

    protected SubscribeRate subscribeRate() {
        return new SubscribeRate(this.pulsar().getConfiguration().getSubscribeThrottlingRatePerConsumer(), this.pulsar().getConfiguration().getSubscribeRatePeriodPerConsumerInSecond());
    }

    protected AutoSubscriptionCreationOverrideImpl autoSubscriptionCreationOverride() {
        boolean allowAutoSubscriptionCreation = this.pulsar().getConfiguration().isAllowAutoSubscriptionCreation();
        return AutoSubscriptionCreationOverrideImpl.builder().allowAutoSubscriptionCreation(allowAutoSubscriptionCreation).build();
    }

    protected ObjectWriter objectWriter() {
        return ObjectMapperFactory.getMapper().writer();
    }

    protected ObjectReader objectReader() {
        return ObjectMapperFactory.getMapper().reader();
    }

    protected Set<String> clusters() {
        try {
            Set<String> clusters = this.clusterResources().list().stream().filter(cluster -> !"global".equals(cluster)).collect(Collectors.toSet());
            return clusters;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Set<String>> clustersAsync() {
        return this.clusterResources().listAsync().thenApply(list -> list.stream().filter(cluster -> !"global".equals(cluster)).collect(Collectors.toSet()));
    }

    protected void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected PartitionedTopicMetadata getPartitionedTopicMetadata(TopicName topicName, boolean authoritative, boolean checkAllowAutoCreation) {
        return (PartitionedTopicMetadata)this.sync(() -> this.getPartitionedTopicMetadataAsync(topicName, authoritative, checkAllowAutoCreation));
    }

    protected CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadataAsync(TopicName topicName, boolean authoritative, boolean checkAllowAutoCreation) {
        return ((CompletableFuture)((CompletableFuture)this.validateTopicOperationAsync(topicName, TopicOperation.LOOKUP).thenCompose(__ -> this.validateClusterOwnershipAsync(topicName.getCluster()))).thenCompose(__ -> this.validateGlobalNamespaceOwnershipAsync(topicName.getNamespaceObject()))).thenCompose(__ -> {
            if (checkAllowAutoCreation) {
                return this.pulsar().getBrokerService().fetchPartitionedTopicMetadataCheckAllowAutoCreationAsync(topicName);
            }
            return this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(topicName);
        });
    }

    @Override
    protected void validateClusterExists(String cluster) {
        try {
            if (!this.clusterResources().getCluster(cluster).isPresent()) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cluster " + cluster + " does not exist.");
            }
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    protected Policies getNamespacePolicies(String tenant, String cluster, String namespace) {
        NamespaceName ns = NamespaceName.get((String)tenant, (String)cluster, (String)namespace);
        return this.getNamespacePolicies(ns);
    }

    protected CompletableFuture<Set<String>> getNamespaceReplicatedClustersAsync(NamespaceName namespaceName) {
        return this.namespaceResources().getPoliciesAsync(namespaceName).thenApply(policies -> {
            if (policies.isPresent()) {
                return ((Policies)policies.get()).replication_clusters;
            }
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        });
    }

    protected List<String> getPartitionedTopicList(TopicDomain topicDomain) {
        try {
            return (List)this.namespaceResources().getPartitionedTopicResources().listPartitionedTopicsAsync(this.namespaceName, topicDomain).join();
        }
        catch (Exception e) {
            log.error("[{}] Failed to get partitioned topic list for namespace {}", new Object[]{this.clientAppId(), this.namespaceName.toString(), e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<List<String>> getPartitionedTopicListAsync(TopicDomain topicDomain) {
        return this.namespaceResources().getPartitionedTopicResources().listPartitionedTopicsAsync(this.namespaceName, topicDomain);
    }

    @Deprecated
    protected List<String> getTopicPartitionList(TopicDomain topicDomain) {
        try {
            return (List)this.getPulsarResources().getTopicResources().getExistingPartitions(this.topicName).get(this.config().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("[{}] Failed to get topic partition list for namespace {}", new Object[]{this.clientAppId(), this.namespaceName.toString(), e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<List<String>> getTopicPartitionListAsync() {
        return this.getPulsarResources().getTopicResources().getExistingPartitions(this.topicName);
    }

    protected void internalCreatePartitionedTopic(AsyncResponse asyncResponse, int numPartitions, boolean createLocalTopicOnly) {
        this.internalCreatePartitionedTopic(asyncResponse, numPartitions, createLocalTopicOnly, null);
    }

    protected void internalCreatePartitionedTopic(AsyncResponse asyncResponse, int numPartitions, boolean createLocalTopicOnly, Map<String, String> properties) {
        if (numPartitions <= 0) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be more than 0")));
            return;
        }
        int maxPartitions = this.pulsar().getConfig().getMaxNumPartitionsPerPartitionedTopic();
        if (maxPartitions > 0 && numPartitions > maxPartitions) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be less than or equal to " + maxPartitions)));
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespaceOperationAsync(this.topicName.getNamespaceObject(), NamespaceOperation.CREATE_TOPIC).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName).exceptionally(ex -> {
            RestException re;
            Throwable unwrapped = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (unwrapped instanceof RestException && (re = (RestException)((Object)((Object)((Object)unwrapped)))).getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw FutureUtil.wrapToCompletionException((Throwable)ex);
        }))).thenCompose(policies -> {
            int maxTopicsPerNamespace;
            int n = maxTopicsPerNamespace = policies != null && policies.max_topics_per_namespace != null ? policies.max_topics_per_namespace.intValue() : this.pulsar().getConfig().getMaxTopicsPerNamespace();
            if (maxTopicsPerNamespace > 0 && !this.pulsar().getBrokerService().isSystemTopic(this.topicName)) {
                return this.getTopicPartitionListAsync().thenAccept(partitionedTopics -> {
                    long topicsCount = partitionedTopics.stream().filter(t -> !this.pulsar().getBrokerService().isSystemTopic(TopicName.get((String)t))).count();
                    if (topicsCount + (long)numPartitions > (long)maxTopicsPerNamespace) {
                        log.error("[{}] Failed to create partitioned topic {}, exceed maximum number of topics in namespace", (Object)this.clientAppId(), (Object)this.topicName);
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "Exceed maximum number of topics in namespace.");
                    }
                });
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(__ -> this.checkTopicExistsAsync(this.topicName))).thenAccept(topicExistsInfo -> {
            try {
                if (topicExistsInfo.isExists() && (topicExistsInfo.getTopicType().equals((Object)TopicType.NON_PARTITIONED) || topicExistsInfo.getTopicType().equals((Object)TopicType.PARTITIONED) && !createLocalTopicOnly)) {
                    log.warn("[{}] Failed to create already existing topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                    throw new RestException(Response.Status.CONFLICT, "This topic already exists");
                }
            }
            finally {
                topicExistsInfo.recycle();
            }
        })).thenCompose(__ -> this.getMaxPartitionIndex(this.topicName).thenAccept(existingMaxPartitionIndex -> {
            if (existingMaxPartitionIndex >= numPartitions) {
                int requiredMinPartitions = existingMaxPartitionIndex + 1;
                throw new RestException(Response.Status.CONFLICT, String.format("The topic has a max partition index of %d, the number of partitions must be at least %d", existingMaxPartitionIndex, requiredMinPartitions));
            }
        }))).thenRun(() -> {
            for (int i = 0; i < numPartitions; ++i) {
                this.pulsar().getBrokerService().getTopicEventsDispatcher().notify(this.topicName.getPartition(i).toString(), TopicEventsListener.TopicEvent.CREATE, TopicEventsListener.EventStage.BEFORE);
            }
        })).thenCompose(__ -> this.provisionPartitionedTopicPath(numPartitions, createLocalTopicOnly, properties))).thenCompose(__ -> this.tryCreatePartitionsAsync(numPartitions))).thenRun(() -> {
            if (!createLocalTopicOnly && this.topicName.isGlobal() && this.pulsar().getConfig().isCreateTopicToRemoteClusterForReplication()) {
                this.internalCreatePartitionedTopicToReplicatedClustersInBackground(numPartitions);
                log.info("[{}] Successfully created partitioned for topic {} for the remote clusters", (Object)this.clientAppId(), (Object)this.topicName);
            } else {
                log.info("[{}] Skip creating partitioned for topic {} for the remote clusters", (Object)this.clientAppId(), (Object)this.topicName);
            }
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            if (AdminResource.isConflictException(ex)) {
                log.info("[{}] Failed to create partitioned topic {}: {}", new Object[]{this.clientAppId(), this.topicName, ex.getMessage()});
            } else {
                log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
            AdminResource.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private CompletableFuture<Integer> getMaxPartitionIndex(TopicName topicName) {
        if (topicName.getDomain() == TopicDomain.persistent) {
            return this.getPulsarResources().getTopicResources().listPersistentTopicsAsync(topicName.getNamespaceObject()).thenApply(list -> {
                int maxIndex = -1;
                for (String s : list) {
                    TopicName item = TopicName.get((String)s);
                    if (!item.isPartitioned() || !item.getPartitionedTopicName().equals(topicName.getPartitionedTopicName()) || item.getPartitionIndex() <= maxIndex) continue;
                    maxIndex = item.getPartitionIndex();
                }
                return maxIndex;
            });
        }
        return CompletableFuture.completedFuture(-1);
    }

    private void internalCreatePartitionedTopicToReplicatedClustersInBackground(int numPartitions) {
        this.getNamespaceReplicatedClustersAsync(this.namespaceName).thenAccept(clusters -> this.internalCreatePartitionedTopicToReplicatedClustersInBackground((Set<String>)clusters, numPartitions));
    }

    protected Map<String, CompletableFuture<Void>> internalCreatePartitionedTopicToReplicatedClustersInBackground(Set<String> clusters, int numPartitions) {
        String shortTopicName = this.topicName.getPartitionedTopicName();
        HashMap<String, CompletableFuture<Void>> tasksForAllClusters = new HashMap<String, CompletableFuture<Void>>();
        for (String cluster : clusters) {
            if (cluster.equals(this.pulsar().getConfiguration().getClusterName())) continue;
            ClusterResources clusterResources = this.pulsar().getPulsarResources().getClusterResources();
            CompletableFuture createRemoteTopicFuture = new CompletableFuture();
            tasksForAllClusters.put(cluster, createRemoteTopicFuture);
            clusterResources.getClusterAsync(cluster).whenComplete((clusterData, ex1) -> {
                PulsarAdmin remotePulsarAdmin;
                if (ex1 != null) {
                    log.error("[{}] An un-expected error occurs when trying to create partitioned topic {} in cluster {}.", new Object[]{this.clientAppId(), this.topicName, cluster, ex1});
                    createRemoteTopicFuture.completeExceptionally((Throwable)((Object)new RestException((Throwable)ex1)));
                    return;
                }
                try {
                    remotePulsarAdmin = this.pulsar().getBrokerService().getClusterPulsarAdmin(cluster, (Optional<ClusterData>)clusterData);
                }
                catch (Exception ex) {
                    log.error("[{}] [{}] An un-expected error occurs when trying to create remote pulsar admin for cluster {}", new Object[]{this.clientAppId(), this.topicName, cluster, ex});
                    createRemoteTopicFuture.completeExceptionally((Throwable)((Object)new RestException(ex)));
                    return;
                }
                TopicsImpl topics = (TopicsImpl)remotePulsarAdmin.topics();
                topics.createPartitionedTopicAsync(shortTopicName, numPartitions, true, null).whenComplete((ignore, ex2) -> {
                    if (ex2 == null) {
                        log.info("[{}] Successfully created partitioned topic {} in cluster {}", new Object[]{this.clientAppId(), this.topicName, cluster});
                        createRemoteTopicFuture.complete(null);
                        return;
                    }
                    Throwable unwrapEx2 = FutureUtil.unwrapCompletionException((Throwable)ex2);
                    if (unwrapEx2 instanceof PulsarAdminException.ConflictException) {
                        topics.getPartitionedTopicMetadataAsync(shortTopicName).whenComplete((topicMeta, ex3) -> {
                            if (ex3 != null) {
                                log.error("[{}] Failed to check remote-cluster's topic metadata when creating partitioned topic {} in cluster {}.", new Object[]{this.clientAppId(), this.topicName, cluster, ex3});
                                createRemoteTopicFuture.completeExceptionally((Throwable)((Object)new RestException((Throwable)ex3)));
                            }
                            if (topicMeta.partitions == numPartitions) {
                                log.info("[{}] Skip created partitioned topic {} in cluster {},  because that {}", new Object[]{this.clientAppId(), this.topicName, cluster, unwrapEx2.getMessage()});
                                createRemoteTopicFuture.complete(null);
                            } else {
                                String errorMsg = String.format("[%s] There is an exists topic %s with different partitions %s on the remote cluster %s, you want to create it with partitions %s", this.clientAppId(), shortTopicName, topicMeta.partitions, cluster, numPartitions);
                                log.error(errorMsg);
                                createRemoteTopicFuture.completeExceptionally((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, errorMsg)));
                            }
                        });
                    } else {
                        log.error("[{}] Failed to create partitioned topic {} in cluster {}.", new Object[]{this.clientAppId(), this.topicName, cluster, ex2});
                        createRemoteTopicFuture.completeExceptionally((Throwable)((Object)new RestException(unwrapEx2)));
                    }
                });
            });
        }
        return tasksForAllClusters;
    }

    protected CompletableFuture<TopicExistsInfo> checkTopicExistsAsync(TopicName topicName) {
        return this.pulsar().getNamespaceService().checkTopicExistsAsync(topicName);
    }

    private CompletableFuture<Void> provisionPartitionedTopicPath(int numPartitions, boolean createLocalTopicOnly, Map<String, String> properties) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.namespaceResources().getPartitionedTopicResources().createPartitionedTopicAsync(this.topicName, new PartitionedTopicMetadata(numPartitions, properties)).whenComplete((ignored, ex) -> {
            if (ex != null) {
                if (ex instanceof MetadataStoreException.AlreadyExistsException) {
                    if (createLocalTopicOnly) {
                        future.complete(null);
                        return;
                    }
                    log.warn("[{}] Failed to create already existing partitioned topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                    future.completeExceptionally((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Partitioned topic already exists")));
                } else if (ex instanceof MetadataStoreException.BadVersionException) {
                    log.warn("[{}] Failed to create partitioned topic {}: concurrent modification", (Object)this.clientAppId(), (Object)this.topicName);
                    future.completeExceptionally((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Concurrent modification")));
                } else {
                    log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
                    future.completeExceptionally((Throwable)((Object)new RestException(ex.getCause())));
                }
                return;
            }
            log.info("[{}] Successfully created partitioned topic {}", (Object)this.clientAppId(), (Object)this.topicName);
            future.complete(null);
        });
        return future;
    }

    protected CompletableFuture<SchemaCompatibilityStrategy> getSchemaCompatibilityStrategyAsync() {
        return this.getSchemaCompatibilityStrategyAsyncWithoutAuth().whenComplete((__, ex) -> {
            if (ex != null) {
                log.error("[{}] Failed to get schema compatibility strategy of topic {} {}", new Object[]{this.clientAppId(), this.topicName, ex});
            }
        });
    }

    protected CompletableFuture<SchemaCompatibilityStrategy> getSchemaCompatibilityStrategyAsyncWithoutAuth() {
        CompletionStage future = this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getSchemaCompatibilityStrategy).orElse(null));
        return ((CompletableFuture)future).thenCompose(topicSchemaCompatibilityStrategy -> {
            if (!SchemaCompatibilityStrategy.isUndefined((SchemaCompatibilityStrategy)topicSchemaCompatibilityStrategy)) {
                return CompletableFuture.completedFuture(topicSchemaCompatibilityStrategy);
            }
            return this.getNamespacePoliciesAsync(this.namespaceName).thenApply(policies -> {
                SchemaCompatibilityStrategy schemaCompatibilityStrategy = policies.schema_compatibility_strategy;
                if (SchemaCompatibilityStrategy.isUndefined((SchemaCompatibilityStrategy)schemaCompatibilityStrategy) && SchemaCompatibilityStrategy.isUndefined((SchemaCompatibilityStrategy)(schemaCompatibilityStrategy = SchemaCompatibilityStrategy.fromAutoUpdatePolicy((SchemaAutoUpdateCompatibilityStrategy)policies.schema_auto_update_compatibility_strategy)))) {
                    schemaCompatibilityStrategy = this.pulsar().getConfig().getSchemaCompatibilityStrategy();
                }
                return schemaCompatibilityStrategy;
            });
        });
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T reference) {
        return Objects.requireNonNull(reference);
    }

    protected void checkNotNull(Object o, String errorMessage) {
        if (o == null) {
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
    }

    protected boolean isManagedLedgerNotFoundException(Throwable cause) {
        return cause instanceof ManagedLedgerException.MetadataNotFoundException || cause instanceof MetadataStoreException.NotFoundException;
    }

    protected void checkArgument(boolean b, String errorMessage) {
        if (!b) {
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
    }

    protected void validatePersistencePolicies(PersistencePolicies persistence) {
        this.checkNotNull(persistence, "persistence policies should not be null");
        ServiceConfiguration config = this.pulsar().getConfiguration();
        this.checkArgument(persistence.getBookkeeperEnsemble() <= config.getManagedLedgerMaxEnsembleSize() && persistence.getBookkeeperEnsemble() > 0, "Bookkeeper-Ensemble must be <= " + config.getManagedLedgerMaxEnsembleSize() + " and > 0.");
        this.checkArgument(persistence.getBookkeeperWriteQuorum() <= config.getManagedLedgerMaxWriteQuorum() && persistence.getBookkeeperWriteQuorum() > 0, "Bookkeeper-WriteQuorum must be <= " + config.getManagedLedgerMaxWriteQuorum() + " and > 0.");
        this.checkArgument(persistence.getBookkeeperAckQuorum() <= config.getManagedLedgerMaxAckQuorum() && persistence.getBookkeeperAckQuorum() > 0, "Bookkeeper-AckQuorum must be <= " + config.getManagedLedgerMaxAckQuorum() + " and > 0.");
        this.checkArgument(persistence.getBookkeeperEnsemble() >= persistence.getBookkeeperWriteQuorum() && persistence.getBookkeeperWriteQuorum() >= persistence.getBookkeeperAckQuorum(), String.format("Bookkeeper Ensemble (%s) >= WriteQuorum (%s) >= AckQuorum (%s)", persistence.getBookkeeperEnsemble(), persistence.getBookkeeperWriteQuorum(), persistence.getBookkeeperAckQuorum()));
    }

    protected void validateRetentionPolicies(RetentionPolicies retention) {
        if (retention == null) {
            return;
        }
        this.checkArgument(retention.getRetentionSizeInMB() >= -1L, "Invalid retention policy: size limit must be >= -1");
        this.checkArgument(retention.getRetentionTimeInMinutes() >= -1, "Invalid retention policy: time limit must be >= -1");
        this.checkArgument(retention.getRetentionTimeInMinutes() != 0 && retention.getRetentionSizeInMB() != 0L || retention.getRetentionTimeInMinutes() == 0 && retention.getRetentionSizeInMB() == 0L, "Invalid retention policy: Setting a single time or size limit to 0 is invalid when one of the limits has a non-zero value. Use the value of -1 instead of 0 to ignore a specific limit. To disable retention both limits must be set to 0.");
    }

    protected void validateEntryFilters(EntryFilters entryFilters) {
        if (entryFilters == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)entryFilters.getEntryFilterNames()) || Arrays.stream(entryFilters.getEntryFilterNames().split(",")).filter(n -> StringUtils.isNotBlank((CharSequence)n)).findAny().isEmpty()) {
            throw new RestException((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, "entryFilterNames can't be empty. To remove entry filters use the remove method.")));
        }
        try {
            this.pulsar().getBrokerService().getEntryFilterProvider().validateEntryFilters(entryFilters.getEntryFilterNames());
        }
        catch (InvalidEntryFilterException ex) {
            throw new RestException((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, ex)));
        }
    }

    protected static boolean isRedirectException(Throwable ex) {
        Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
        return realCause instanceof WebApplicationException && ((WebApplicationException)realCause).getResponse().getStatus() == Response.Status.TEMPORARY_REDIRECT.getStatusCode();
    }

    protected static boolean isNotFoundOrConflictException(Throwable ex) {
        return AdminResource.isNotFoundException(ex) || AdminResource.isConflictException(ex);
    }

    protected static boolean isNotFoundException(Throwable ex) {
        Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
        return realCause instanceof WebApplicationException && ((WebApplicationException)realCause).getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode();
    }

    protected static boolean is4xxRestException(Throwable ex) {
        Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
        return realCause instanceof WebApplicationException && ((WebApplicationException)realCause).getResponse().getStatus() % 100 == 4;
    }

    protected static boolean isConflictException(Throwable ex) {
        Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
        return realCause instanceof WebApplicationException && ((WebApplicationException)realCause).getResponse().getStatus() == Response.Status.CONFLICT.getStatusCode();
    }

    protected static boolean isBadRequest(Throwable ex) {
        Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
        return realCause instanceof WebApplicationException && ((WebApplicationException)realCause).getResponse().getStatus() == Response.Status.BAD_REQUEST.getStatusCode();
    }

    protected static boolean isNot307And404Exception(Throwable ex) {
        return !AdminResource.isRedirectException(ex) && !AdminResource.isNotFoundException(ex);
    }

    protected static boolean isNot307And404And400Exception(Throwable ex) {
        return !AdminResource.isRedirectException(ex) && !AdminResource.isNotFoundException(ex) && !AdminResource.isBadRequest(ex);
    }

    protected static boolean isNot307And4xxException(Throwable ex) {
        return !AdminResource.isRedirectException(ex) && !AdminResource.is4xxRestException(ex);
    }

    protected static String getTopicNotFoundErrorMessage(String topic) {
        return String.format("Topic %s not found", topic);
    }

    protected static String getPartitionedTopicNotFoundErrorMessage(String topic) {
        return String.format("Partitioned Topic %s not found", topic);
    }

    protected static String getSubNotFoundErrorMessage(String topic, String subscription) {
        return String.format("Subscription %s not found for topic %s", subscription, topic);
    }

    protected List<String> filterSystemTopic(List<String> topics, boolean includeSystemTopic) {
        return topics.stream().filter(topic -> includeSystemTopic ? true : !this.pulsar().getBrokerService().isSystemTopic((String)topic)).collect(Collectors.toList());
    }

    protected AuthorizationService getAuthorizationService() {
        return this.pulsar().getBrokerService().getAuthorizationService();
    }

    protected void validateOffloadPolicies(OffloadPoliciesImpl offloadPolicies) {
        if (offloadPolicies == null) {
            log.warn("[{}] Failed to update offload configuration for namespace {}: offloadPolicies is null", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "The offloadPolicies must be specified for namespace offload.");
        }
        if (!offloadPolicies.driverSupported()) {
            log.warn("[{}] Failed to update offload configuration for namespace {}: driver is not supported, support value: {}", new Object[]{this.clientAppId(), this.namespaceName, OffloadPoliciesImpl.getSupportedDriverNames()});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "The driver is not supported, support value: " + OffloadPoliciesImpl.getSupportedDriverNames());
        }
        if (!offloadPolicies.bucketValid()) {
            log.warn("[{}] Failed to update offload configuration for namespace {}: bucket must be specified", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "The bucket must be specified for namespace offload.");
        }
    }

    protected CompletableFuture<Void> internalCheckTopicExists(TopicName topicName) {
        return this.pulsar().getNamespaceService().checkTopicExistsAsync(topicName).thenAccept(info -> {
            boolean exists = info.isExists();
            info.recycle();
            if (!exists) {
                throw new RestException(Response.Status.NOT_FOUND, AdminResource.getTopicNotFoundErrorMessage(topicName.toString()));
            }
        });
    }
}

