/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.topics;

import com.google.re2j.PatternSyntaxException;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.pulsar.common.topics.JDKTopicsPattern;
import org.apache.pulsar.common.topics.MatchAllTopicsPattern;
import org.apache.pulsar.common.topics.RE2JTopicsPattern;
import org.apache.pulsar.common.topics.TopicList;
import org.apache.pulsar.common.topics.TopicsPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TopicsPatternFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopicsPatternFactory.class);

    public static TopicsPattern create(Pattern jdkPattern) {
        String removedTopicDomainScheme;
        String currentRegex = jdkPattern.pattern();
        if (currentRegex.equals(removedTopicDomainScheme = TopicList.removeTopicDomainScheme(currentRegex))) {
            return new JDKTopicsPattern(jdkPattern);
        }
        return TopicsPatternFactory.internalCreate(currentRegex, removedTopicDomainScheme, TopicsPattern.RegexImplementation.RE2J_WITH_JDK_FALLBACK);
    }

    public static TopicsPattern create(String regex, TopicsPattern.RegexImplementation implementation) {
        return TopicsPatternFactory.internalCreate(regex, TopicList.removeTopicDomainScheme(regex), implementation);
    }

    public static TopicsPattern matchAll() {
        return MatchAllTopicsPattern.INSTANCE;
    }

    private static TopicsPattern internalCreate(String inputPattern, String regexWithoutTopicDomainScheme, TopicsPattern.RegexImplementation implementation) {
        if (".*".equals(regexWithoutTopicDomainScheme)) {
            return TopicsPatternFactory.matchAll();
        }
        switch (implementation) {
            case RE2J: {
                return new RE2JTopicsPattern(inputPattern, regexWithoutTopicDomainScheme);
            }
            case JDK: {
                return new JDKTopicsPattern(inputPattern, regexWithoutTopicDomainScheme);
            }
            case RE2J_WITH_JDK_FALLBACK: {
                try {
                    return new RE2JTopicsPattern(inputPattern, regexWithoutTopicDomainScheme);
                }
                catch (PatternSyntaxException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Failed to compile regex pattern '{}' with RE2J, fallback to JDK", (Object)regexWithoutTopicDomainScheme, (Object)e);
                    }
                    return new JDKTopicsPattern(inputPattern, regexWithoutTopicDomainScheme);
                }
            }
        }
        throw new IllegalArgumentException("Unknown RegexImplementation: " + implementation);
    }

    @Generated
    private TopicsPatternFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

