/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import io.netty.util.Recycler;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.ReferenceCountedEntry;
import org.apache.bookkeeper.mledger.impl.cache.RangeCache;

class RangeCacheEntryWrapper {
    private final Recycler.Handle<RangeCacheEntryWrapper> recyclerHandle;
    private static final Recycler<RangeCacheEntryWrapper> RECYCLER = new Recycler<RangeCacheEntryWrapper>(){

        protected RangeCacheEntryWrapper newObject(Recycler.Handle<RangeCacheEntryWrapper> recyclerHandle) {
            return new RangeCacheEntryWrapper(recyclerHandle);
        }
    };
    private final StampedLock lock = new StampedLock();
    Position key;
    ReferenceCountedEntry value;
    RangeCache rangeCache;
    long size;
    long timestampNanos;
    int requeueCount;
    volatile boolean accessed;

    private RangeCacheEntryWrapper(Recycler.Handle<RangeCacheEntryWrapper> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R> R withNewInstance(RangeCache rangeCache, Position key, ReferenceCountedEntry value, long size, Function<RangeCacheEntryWrapper, R> function) {
        RangeCacheEntryWrapper entryWrapper = (RangeCacheEntryWrapper)RECYCLER.get();
        StampedLock lock = entryWrapper.lock;
        long stamp = lock.writeLock();
        try {
            entryWrapper.rangeCache = rangeCache;
            entryWrapper.key = key;
            entryWrapper.value = value;
            entryWrapper.size = size;
            entryWrapper.timestampNanos = System.nanoTime();
            R r = function.apply(entryWrapper);
            return r;
        }
        finally {
            lock.unlockWrite(stamp);
        }
    }

    ReferenceCountedEntry getValue(Position key) {
        return this.getValueInternal(key, false);
    }

    static ReferenceCountedEntry getValueMatchingMapEntry(Map.Entry<Position, RangeCacheEntryWrapper> entry) {
        return entry.getValue().getValueInternal(entry.getKey(), true);
    }

    private ReferenceCountedEntry getValueInternal(Position key, boolean requireSameKeyInstance) {
        long stamp = this.lock.tryOptimisticRead();
        Position localKey = this.key;
        ReferenceCountedEntry localValue = this.value;
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            localKey = this.key;
            localValue = this.value;
            this.lock.unlockRead(stamp);
        }
        if (localKey != key && (requireSameKeyInstance || localKey == null || !localKey.equals(key))) {
            return null;
        }
        this.accessed = true;
        return localValue;
    }

    long markRemoved(Position key, ReferenceCountedEntry value) {
        if (this.key != key || this.value != value) {
            return -1L;
        }
        this.rangeCache = null;
        this.key = null;
        this.value = null;
        long removedSize = this.size;
        this.size = 0L;
        this.timestampNanos = 0L;
        this.requeueCount = 0;
        return removedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> R withWriteLock(Function<RangeCacheEntryWrapper, R> function) {
        long stamp = this.lock.writeLock();
        try {
            R r = function.apply(this);
            return r;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    void markRequeued() {
        this.timestampNanos = System.nanoTime();
        this.accessed = false;
        ++this.requeueCount;
    }

    void recycle() {
        this.rangeCache = null;
        this.key = null;
        this.value = null;
        this.size = 0L;
        this.timestampNanos = 0L;
        this.requeueCount = 0;
        this.accessed = false;
        this.recyclerHandle.recycle((Object)this);
    }
}

