/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntSupplier;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.EntryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.cache.EntryCache;
import org.apache.bookkeeper.mledger.impl.cache.ReadEntryUtils;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;

public class EntryCacheDisabled
implements EntryCache {
    private final ManagedLedgerImpl ml;
    private final ManagedLedgerInterceptor interceptor;

    public EntryCacheDisabled(ManagedLedgerImpl ml) {
        this.ml = ml;
        this.interceptor = ml.getManagedLedgerInterceptor();
    }

    @Override
    public String getName() {
        return this.ml.getName();
    }

    @Override
    public boolean insert(Entry entry) {
        return false;
    }

    @Override
    public void invalidateEntries(Position lastPosition) {
    }

    @Override
    public void invalidateAllEntries(long ledgerId) {
    }

    @Override
    public void clear() {
    }

    @Override
    public void asyncReadEntry(ReadHandle lh, long firstEntry, long lastEntry, IntSupplier expectedReadCount, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
        ((CompletableFuture)ReadEntryUtils.readAsync(this.ml, lh, firstEntry, lastEntry).thenAcceptAsync(ledgerEntries -> {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            long totalSize = 0L;
            try {
                for (LedgerEntry e : ledgerEntries) {
                    EntryImpl entry = EntryImpl.create(e, this.interceptor, 0);
                    entries.add(entry);
                    totalSize += (long)entry.getLength();
                }
            }
            finally {
                ledgerEntries.close();
            }
            this.ml.getMbean().recordReadEntriesOpsCacheMisses(entries.size(), totalSize);
            this.ml.getFactory().getMbean().recordCacheMiss(entries.size(), totalSize);
            this.ml.getMbean().addReadEntriesSample(entries.size(), totalSize);
            callback.readEntriesComplete(entries, ctx);
        }, (Executor)this.ml.getExecutor())).exceptionally(exception -> {
            callback.readEntriesFailed(ManagedLedgerImpl.createManagedLedgerException(exception), ctx);
            return null;
        });
    }

    @Override
    public void asyncReadEntry(ReadHandle lh, Position position, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        ReadEntryUtils.readAsync(this.ml, lh, position.getEntryId(), position.getEntryId()).whenCompleteAsync((ledgerEntries, exception) -> {
            if (exception != null) {
                this.ml.invalidateLedgerHandle(lh);
                callback.readEntryFailed(ManagedLedgerImpl.createManagedLedgerException(exception), ctx);
                return;
            }
            try {
                Iterator iterator = ledgerEntries.iterator();
                if (iterator.hasNext()) {
                    LedgerEntry ledgerEntry = (LedgerEntry)iterator.next();
                    EntryImpl returnEntry = EntryImpl.create(ledgerEntry, this.interceptor, 0);
                    this.ml.getMbean().recordReadEntriesOpsCacheMisses(1, returnEntry.getLength());
                    this.ml.getFactory().getMbean().recordCacheMiss(1, returnEntry.getLength());
                    this.ml.getMbean().addReadEntriesSample(1, returnEntry.getLength());
                    callback.readEntryComplete(returnEntry, ctx);
                } else {
                    callback.readEntryFailed(new ManagedLedgerException("Could not read given position"), ctx);
                }
            }
            finally {
                ledgerEntries.close();
            }
        }, (Executor)this.ml.getExecutor());
    }

    @Override
    public long getSize() {
        return 0L;
    }
}

