/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.exceptions;

import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStoreState;
import org.apache.pulsar.transaction.coordinator.proto.TxnStatus;

public abstract class CoordinatorException
extends Exception {
    private static final long serialVersionUID = 0L;

    public CoordinatorException(String message) {
        super(message);
    }

    public CoordinatorException(String message, Throwable cause) {
        super(message, cause);
    }

    public CoordinatorException(Throwable cause) {
        super(cause);
    }

    public static class ReachMaxActiveTxnException
    extends CoordinatorException {
        private static final long serialVersionUID = 0L;

        public ReachMaxActiveTxnException(String message) {
            super(message);
        }
    }

    public static class TransactionMetadataStoreStateException
    extends CoordinatorException {
        private static final long serialVersionUID = 0L;

        public TransactionMetadataStoreStateException(String message) {
            super(message);
        }

        public TransactionMetadataStoreStateException(TransactionCoordinatorID tcID, TransactionMetadataStoreState.State expectedState, TransactionMetadataStoreState.State currentState, String operation) {
            super("Expect Transaction Coordinator `" + tcID + "` to be in " + expectedState + " status but it is in " + currentState + " state for " + operation);
        }
    }

    public static class TransactionNotFoundException
    extends CoordinatorException {
        private static final long serialVersionUID = 0L;

        public TransactionNotFoundException(String message) {
            super(message);
        }

        public TransactionNotFoundException(TxnID txnID) {
            super("The transaction with this txdID `" + txnID + "`not found ");
        }

        public TransactionNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }

        public TransactionNotFoundException(Throwable cause) {
            super(cause);
        }
    }

    public static class InvalidTxnStatusException
    extends CoordinatorException {
        private static final long serialVersionUID = 0L;

        public InvalidTxnStatusException(String message) {
            super(message);
        }

        public InvalidTxnStatusException(TxnID txnID, TxnStatus expectedStatus, TxnStatus actualStatus) {
            super("Expect Txn `" + txnID + "` to be in " + expectedStatus + " status but it is in " + actualStatus + " status");
        }
    }

    public static class CoordinatorNotFoundException
    extends CoordinatorException {
        public CoordinatorNotFoundException(String msg) {
            super(msg);
        }

        public CoordinatorNotFoundException(TransactionCoordinatorID tcId) {
            super(String.format("Transaction coordinator with id %s not found!", tcId.getId()));
        }
    }
}

