/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.base.Splitter;
import com.google.re2j.Pattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.util.Codec;

public class TopicName
implements ServiceUnitId {
    public static final String PUBLIC_TENANT = "public";
    public static final String DEFAULT_NAMESPACE = "default";
    public static final String PARTITIONED_TOPIC_SUFFIX = "-partition-";
    private final String completeTopicName;
    private final TopicDomain domain;
    private final String tenant;
    private final String cluster;
    private final String namespacePortion;
    private final String localName;
    private final NamespaceName namespaceName;
    private final int partitionIndex;
    private static final ConcurrentHashMap<String, TopicName> cache = new ConcurrentHashMap();

    public static void clearIfReachedMaxCapacity(int maxCapacity) {
        if (maxCapacity < 0) {
            return;
        }
        if (cache.size() > maxCapacity) {
            cache.clear();
        }
    }

    public static TopicName get(String domain, NamespaceName namespaceName, String topic) {
        String name = domain + "://" + namespaceName.toString() + '/' + topic;
        return TopicName.get(name);
    }

    public static TopicName get(String domain, String tenant, String namespace, String topic) {
        String name = domain + "://" + tenant + '/' + namespace + '/' + topic;
        return TopicName.get(name);
    }

    public static TopicName get(String domain, String tenant, String cluster, String namespace, String topic) {
        String name = domain + "://" + tenant + '/' + cluster + '/' + namespace + '/' + topic;
        return TopicName.get(name);
    }

    public static TopicName get(String topic) {
        TopicName tp = cache.get(topic);
        if (tp != null) {
            return tp;
        }
        return cache.computeIfAbsent(topic, k -> new TopicName((String)k));
    }

    public static TopicName getPartitionedTopicName(String topic) {
        TopicName topicName = TopicName.get(topic);
        if (topicName.isPartitioned()) {
            return TopicName.get(topicName.getPartitionedTopicName());
        }
        return topicName;
    }

    public static boolean isValid(String topic) {
        try {
            TopicName.get(topic);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getPartitionPattern(String topic) {
        return "^" + Pattern.quote((String)TopicName.get(topic).getPartitionedTopicName().toString()) + "-partition-[0-9]+$";
    }

    public static String getPattern(String topic) {
        return "^" + Pattern.quote((String)TopicName.get(topic).getPartitionedTopicName().toString()) + "$";
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    private TopicName(String completeTopicName) {
        try {
            Object parts;
            if (!completeTopicName.contains("://")) {
                parts = StringUtils.split((String)completeTopicName, (char)'/');
                if (((String[])parts).length == 3) {
                    completeTopicName = TopicDomain.persistent.name() + "://" + completeTopicName;
                } else if (((String[])parts).length == 1) {
                    completeTopicName = TopicDomain.persistent.name() + "://" + PUBLIC_TENANT + "/" + DEFAULT_NAMESPACE + "/" + (String)parts[0];
                } else {
                    throw new IllegalArgumentException("Invalid short topic name '" + completeTopicName + "', it should be in the format of <tenant>/<namespace>/<topic> or <topic>");
                }
            }
            parts = Splitter.on((String)"://").limit(2).splitToList((CharSequence)completeTopicName);
            this.domain = TopicDomain.getEnum((String)((String)parts.get(0)));
            String rest = (String)parts.get(1);
            parts = Splitter.on((String)"/").limit(4).splitToList((CharSequence)rest);
            if (parts.size() == 3) {
                this.tenant = (String)parts.get(0);
                this.cluster = null;
                this.namespacePortion = (String)parts.get(1);
                this.localName = (String)parts.get(2);
                this.partitionIndex = TopicName.getPartitionIndex(completeTopicName);
                this.namespaceName = NamespaceName.get(this.tenant, this.namespacePortion);
            } else if (parts.size() == 4) {
                this.tenant = (String)parts.get(0);
                this.cluster = (String)parts.get(1);
                this.namespacePortion = (String)parts.get(2);
                this.localName = (String)parts.get(3);
                this.partitionIndex = TopicName.getPartitionIndex(completeTopicName);
                this.namespaceName = NamespaceName.get(this.tenant, this.cluster, this.namespacePortion);
            } else {
                throw new IllegalArgumentException("Invalid topic name: " + completeTopicName);
            }
            if (StringUtils.isBlank((CharSequence)this.localName)) {
                throw new IllegalArgumentException(String.format("Invalid topic name: %s. Topic local name must not be blank.", completeTopicName));
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid topic name: " + completeTopicName, e);
        }
        this.completeTopicName = this.isV2() ? String.format("%s://%s/%s/%s", this.domain, this.tenant, this.namespacePortion, this.localName) : String.format("%s://%s/%s/%s/%s", this.domain, this.tenant, this.cluster, this.namespacePortion, this.localName);
    }

    public boolean isPersistent() {
        return TopicDomain.persistent == this.domain;
    }

    public String getNamespace() {
        return this.namespaceName.toString();
    }

    @Override
    public NamespaceName getNamespaceObject() {
        return this.namespaceName;
    }

    public TopicDomain getDomain() {
        return this.domain;
    }

    public String getTenant() {
        return this.tenant;
    }

    @Deprecated
    public String getCluster() {
        return this.cluster;
    }

    public String getNamespacePortion() {
        return this.namespacePortion;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getEncodedLocalName() {
        return Codec.encode(this.localName);
    }

    public TopicName getPartition(int index) {
        if (index == -1 || this.toString().endsWith(PARTITIONED_TOPIC_SUFFIX + index)) {
            return this;
        }
        String partitionName = this.toString() + PARTITIONED_TOPIC_SUFFIX + index;
        return TopicName.get(partitionName);
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public boolean isPartitioned() {
        return this.partitionIndex != -1;
    }

    public String getPartitionedTopicName() {
        if (this.isPartitioned()) {
            return this.completeTopicName.substring(0, this.completeTopicName.lastIndexOf(PARTITIONED_TOPIC_SUFFIX));
        }
        return this.completeTopicName;
    }

    public static int getPartitionIndex(String topic) {
        int partitionIndex = -1;
        if (topic.contains(PARTITIONED_TOPIC_SUFFIX)) {
            try {
                String idx = StringUtils.substringAfterLast((String)topic, (String)PARTITIONED_TOPIC_SUFFIX);
                partitionIndex = Integer.parseInt(idx);
                if (partitionIndex < 0) {
                    partitionIndex = -1;
                } else if (StringUtils.length((CharSequence)idx) != String.valueOf(partitionIndex).length()) {
                    partitionIndex = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return partitionIndex;
    }

    public static String getTopicPartitionNameString(String topic, int partitionIndex) {
        return topic + PARTITIONED_TOPIC_SUFFIX + partitionIndex;
    }

    public String getRestPath() {
        return this.getRestPath(true);
    }

    public String getRestPath(boolean includeDomain) {
        String domainName;
        String string = domainName = includeDomain ? this.domain + "/" : "";
        if (this.isV2()) {
            return String.format("%s%s/%s/%s", domainName, this.tenant, this.namespacePortion, this.getEncodedLocalName());
        }
        return String.format("%s%s/%s/%s/%s", domainName, this.tenant, this.cluster, this.namespacePortion, this.getEncodedLocalName());
    }

    public String getPersistenceNamingEncoding() {
        if (this.isV2()) {
            return String.format("%s/%s/%s/%s", this.tenant, this.namespacePortion, this.domain, this.getEncodedLocalName());
        }
        return String.format("%s/%s/%s/%s/%s", this.tenant, this.cluster, this.namespacePortion, this.domain, this.getEncodedLocalName());
    }

    public static String fromPersistenceNamingEncoding(String mlName) {
        if (mlName == null || mlName.length() == 0) {
            return mlName;
        }
        List parts = Splitter.on((String)"/").splitToList((CharSequence)mlName);
        if (parts.size() == 4) {
            String tenant = (String)parts.get(0);
            String namespacePortion = (String)parts.get(1);
            String domain = (String)parts.get(2);
            String localName = Codec.decode((String)parts.get(3));
            return String.format("%s://%s/%s/%s", domain, tenant, namespacePortion, localName);
        }
        if (parts.size() == 5) {
            String tenant = (String)parts.get(0);
            String cluster = (String)parts.get(1);
            String namespacePortion = (String)parts.get(2);
            String domain = (String)parts.get(3);
            String localName = Codec.decode((String)parts.get(4));
            return String.format("%s://%s/%s/%s/%s", domain, tenant, cluster, namespacePortion, localName);
        }
        throw new IllegalArgumentException("Invalid managedLedger name: " + mlName);
    }

    public String getLookupName() {
        if (this.isV2()) {
            return String.format("%s/%s/%s/%s", this.domain, this.tenant, this.namespacePortion, this.getEncodedLocalName());
        }
        return String.format("%s/%s/%s/%s/%s", this.domain, this.tenant, this.cluster, this.namespacePortion, this.getEncodedLocalName());
    }

    public boolean isGlobal() {
        return this.cluster == null || "global".equalsIgnoreCase(this.cluster);
    }

    public String getSchemaName() {
        return this.getTenant() + "/" + this.getNamespacePortion() + "/" + TopicName.get(this.getPartitionedTopicName()).getEncodedLocalName();
    }

    @Override
    public String toString() {
        return this.completeTopicName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TopicName) {
            TopicName other = (TopicName)obj;
            return Objects.equals(this.completeTopicName, other.completeTopicName);
        }
        return false;
    }

    public int hashCode() {
        return this.completeTopicName.hashCode();
    }

    @Override
    public boolean includes(TopicName otherTopicName) {
        return this.equals(otherTopicName);
    }

    public boolean isV2() {
        return this.cluster == null;
    }
}

