/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.opentelemetry.OpenTelemetryAttributes;

public class ManagedCursorAttributes {
    private final Attributes attributes;
    private final Attributes attributesOperationSucceed;
    private final Attributes attributesOperationFailure;

    public ManagedCursorAttributes(ManagedCursor cursor) {
        String mlName = cursor.getManagedLedger().getName();
        TopicName topicName = TopicName.get((String)TopicName.fromPersistenceNamingEncoding((String)mlName));
        this.attributes = Attributes.of((AttributeKey)OpenTelemetryAttributes.ML_CURSOR_NAME, (Object)cursor.getName(), (AttributeKey)OpenTelemetryAttributes.ML_LEDGER_NAME, (Object)mlName, (AttributeKey)OpenTelemetryAttributes.PULSAR_NAMESPACE, (Object)topicName.getNamespace());
        this.attributesOperationSucceed = Attributes.builder().putAll(this.attributes).putAll(OpenTelemetryAttributes.ManagedCursorOperationStatus.SUCCESS.attributes).build();
        this.attributesOperationFailure = Attributes.builder().putAll(this.attributes).putAll(OpenTelemetryAttributes.ManagedCursorOperationStatus.FAILURE.attributes).build();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Attributes getAttributesOperationSucceed() {
        return this.attributesOperationSucceed;
    }

    public Attributes getAttributesOperationFailure() {
        return this.attributesOperationFailure;
    }
}

