/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.api;

import io.opentelemetry.api.OpenTelemetry;
import org.apache.pulsar.metadata.api.MetadataEventSynchronizer;

public class MetadataStoreConfig {
    public static final String METADATA_STORE = "metadata-store";
    public static final String STATE_METADATA_STORE = "state-metadata-store";
    public static final String CONFIGURATION_METADATA_STORE = "configuration-metadata-store";
    private final int sessionTimeoutMillis;
    private final boolean allowReadOnlyOperations;
    private final String configFilePath;
    private final boolean batchingEnabled;
    private final int batchingMaxDelayMillis;
    private final int batchingMaxOperations;
    private final int batchingMaxSizeKb;
    private final String metadataStoreName;
    private final boolean fsyncEnable;
    private MetadataEventSynchronizer synchronizer;
    private OpenTelemetry openTelemetry;

    private static int $default$sessionTimeoutMillis() {
        return 30000;
    }

    private static boolean $default$allowReadOnlyOperations() {
        return false;
    }

    private static String $default$configFilePath() {
        return null;
    }

    private static boolean $default$batchingEnabled() {
        return true;
    }

    private static int $default$batchingMaxDelayMillis() {
        return 5;
    }

    private static int $default$batchingMaxOperations() {
        return 1000;
    }

    private static int $default$batchingMaxSizeKb() {
        return 128;
    }

    private static String $default$metadataStoreName() {
        return "";
    }

    private static boolean $default$fsyncEnable() {
        return true;
    }

    private static OpenTelemetry $default$openTelemetry() {
        return OpenTelemetry.noop();
    }

    MetadataStoreConfig(int sessionTimeoutMillis, boolean allowReadOnlyOperations, String configFilePath, boolean batchingEnabled, int batchingMaxDelayMillis, int batchingMaxOperations, int batchingMaxSizeKb, String metadataStoreName, boolean fsyncEnable, MetadataEventSynchronizer synchronizer, OpenTelemetry openTelemetry) {
        this.sessionTimeoutMillis = sessionTimeoutMillis;
        this.allowReadOnlyOperations = allowReadOnlyOperations;
        this.configFilePath = configFilePath;
        this.batchingEnabled = batchingEnabled;
        this.batchingMaxDelayMillis = batchingMaxDelayMillis;
        this.batchingMaxOperations = batchingMaxOperations;
        this.batchingMaxSizeKb = batchingMaxSizeKb;
        this.metadataStoreName = metadataStoreName;
        this.fsyncEnable = fsyncEnable;
        this.synchronizer = synchronizer;
        this.openTelemetry = openTelemetry;
    }

    public static MetadataStoreConfigBuilder builder() {
        return new MetadataStoreConfigBuilder();
    }

    public int getSessionTimeoutMillis() {
        return this.sessionTimeoutMillis;
    }

    public boolean isAllowReadOnlyOperations() {
        return this.allowReadOnlyOperations;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }

    public int getBatchingMaxDelayMillis() {
        return this.batchingMaxDelayMillis;
    }

    public int getBatchingMaxOperations() {
        return this.batchingMaxOperations;
    }

    public int getBatchingMaxSizeKb() {
        return this.batchingMaxSizeKb;
    }

    public String getMetadataStoreName() {
        return this.metadataStoreName;
    }

    public boolean isFsyncEnable() {
        return this.fsyncEnable;
    }

    public MetadataEventSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public String toString() {
        return "MetadataStoreConfig(sessionTimeoutMillis=" + this.getSessionTimeoutMillis() + ", allowReadOnlyOperations=" + this.isAllowReadOnlyOperations() + ", configFilePath=" + this.getConfigFilePath() + ", batchingEnabled=" + this.isBatchingEnabled() + ", batchingMaxDelayMillis=" + this.getBatchingMaxDelayMillis() + ", batchingMaxOperations=" + this.getBatchingMaxOperations() + ", batchingMaxSizeKb=" + this.getBatchingMaxSizeKb() + ", metadataStoreName=" + this.getMetadataStoreName() + ", fsyncEnable=" + this.isFsyncEnable() + ", synchronizer=" + String.valueOf(this.getSynchronizer()) + ", openTelemetry=" + String.valueOf(this.getOpenTelemetry()) + ")";
    }

    public static class MetadataStoreConfigBuilder {
        private boolean sessionTimeoutMillis$set;
        private int sessionTimeoutMillis$value;
        private boolean allowReadOnlyOperations$set;
        private boolean allowReadOnlyOperations$value;
        private boolean configFilePath$set;
        private String configFilePath$value;
        private boolean batchingEnabled$set;
        private boolean batchingEnabled$value;
        private boolean batchingMaxDelayMillis$set;
        private int batchingMaxDelayMillis$value;
        private boolean batchingMaxOperations$set;
        private int batchingMaxOperations$value;
        private boolean batchingMaxSizeKb$set;
        private int batchingMaxSizeKb$value;
        private boolean metadataStoreName$set;
        private String metadataStoreName$value;
        private boolean fsyncEnable$set;
        private boolean fsyncEnable$value;
        private MetadataEventSynchronizer synchronizer;
        private boolean openTelemetry$set;
        private OpenTelemetry openTelemetry$value;

        MetadataStoreConfigBuilder() {
        }

        public MetadataStoreConfigBuilder sessionTimeoutMillis(int sessionTimeoutMillis) {
            this.sessionTimeoutMillis$value = sessionTimeoutMillis;
            this.sessionTimeoutMillis$set = true;
            return this;
        }

        public MetadataStoreConfigBuilder allowReadOnlyOperations(boolean allowReadOnlyOperations) {
            this.allowReadOnlyOperations$value = allowReadOnlyOperations;
            this.allowReadOnlyOperations$set = true;
            return this;
        }

        public MetadataStoreConfigBuilder configFilePath(String configFilePath) {
            this.configFilePath$value = configFilePath;
            this.configFilePath$set = true;
            return this;
        }

        public MetadataStoreConfigBuilder batchingEnabled(boolean batchingEnabled) {
            this.batchingEnabled$value = batchingEnabled;
            this.batchingEnabled$set = true;
            return this;
        }

        public MetadataStoreConfigBuilder batchingMaxDelayMillis(int batchingMaxDelayMillis) {
            this.batchingMaxDelayMillis$value = batchingMaxDelayMillis;
            this.batchingMaxDelayMillis$set = true;
            return this;
        }

        public MetadataStoreConfigBuilder batchingMaxOperations(int batchingMaxOperations) {
            this.batchingMaxOperations$value = batchingMaxOperations;
            this.batchingMaxOperations$set = true;
            return this;
        }

        public MetadataStoreConfigBuilder batchingMaxSizeKb(int batchingMaxSizeKb) {
            this.batchingMaxSizeKb$value = batchingMaxSizeKb;
            this.batchingMaxSizeKb$set = true;
            return this;
        }

        public MetadataStoreConfigBuilder metadataStoreName(String metadataStoreName) {
            this.metadataStoreName$value = metadataStoreName;
            this.metadataStoreName$set = true;
            return this;
        }

        public MetadataStoreConfigBuilder fsyncEnable(boolean fsyncEnable) {
            this.fsyncEnable$value = fsyncEnable;
            this.fsyncEnable$set = true;
            return this;
        }

        public MetadataStoreConfigBuilder synchronizer(MetadataEventSynchronizer synchronizer) {
            this.synchronizer = synchronizer;
            return this;
        }

        public MetadataStoreConfigBuilder openTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry$value = openTelemetry;
            this.openTelemetry$set = true;
            return this;
        }

        public MetadataStoreConfig build() {
            int sessionTimeoutMillis$value = this.sessionTimeoutMillis$value;
            if (!this.sessionTimeoutMillis$set) {
                sessionTimeoutMillis$value = MetadataStoreConfig.$default$sessionTimeoutMillis();
            }
            boolean allowReadOnlyOperations$value = this.allowReadOnlyOperations$value;
            if (!this.allowReadOnlyOperations$set) {
                allowReadOnlyOperations$value = MetadataStoreConfig.$default$allowReadOnlyOperations();
            }
            String configFilePath$value = this.configFilePath$value;
            if (!this.configFilePath$set) {
                configFilePath$value = MetadataStoreConfig.$default$configFilePath();
            }
            boolean batchingEnabled$value = this.batchingEnabled$value;
            if (!this.batchingEnabled$set) {
                batchingEnabled$value = MetadataStoreConfig.$default$batchingEnabled();
            }
            int batchingMaxDelayMillis$value = this.batchingMaxDelayMillis$value;
            if (!this.batchingMaxDelayMillis$set) {
                batchingMaxDelayMillis$value = MetadataStoreConfig.$default$batchingMaxDelayMillis();
            }
            int batchingMaxOperations$value = this.batchingMaxOperations$value;
            if (!this.batchingMaxOperations$set) {
                batchingMaxOperations$value = MetadataStoreConfig.$default$batchingMaxOperations();
            }
            int batchingMaxSizeKb$value = this.batchingMaxSizeKb$value;
            if (!this.batchingMaxSizeKb$set) {
                batchingMaxSizeKb$value = MetadataStoreConfig.$default$batchingMaxSizeKb();
            }
            String metadataStoreName$value = this.metadataStoreName$value;
            if (!this.metadataStoreName$set) {
                metadataStoreName$value = MetadataStoreConfig.$default$metadataStoreName();
            }
            boolean fsyncEnable$value = this.fsyncEnable$value;
            if (!this.fsyncEnable$set) {
                fsyncEnable$value = MetadataStoreConfig.$default$fsyncEnable();
            }
            OpenTelemetry openTelemetry$value = this.openTelemetry$value;
            if (!this.openTelemetry$set) {
                openTelemetry$value = MetadataStoreConfig.$default$openTelemetry();
            }
            return new MetadataStoreConfig(sessionTimeoutMillis$value, allowReadOnlyOperations$value, configFilePath$value, batchingEnabled$value, batchingMaxDelayMillis$value, batchingMaxOperations$value, batchingMaxSizeKb$value, metadataStoreName$value, fsyncEnable$value, this.synchronizer, openTelemetry$value);
        }

        public String toString() {
            return "MetadataStoreConfig.MetadataStoreConfigBuilder(sessionTimeoutMillis$value=" + this.sessionTimeoutMillis$value + ", allowReadOnlyOperations$value=" + this.allowReadOnlyOperations$value + ", configFilePath$value=" + this.configFilePath$value + ", batchingEnabled$value=" + this.batchingEnabled$value + ", batchingMaxDelayMillis$value=" + this.batchingMaxDelayMillis$value + ", batchingMaxOperations$value=" + this.batchingMaxOperations$value + ", batchingMaxSizeKb$value=" + this.batchingMaxSizeKb$value + ", metadataStoreName$value=" + this.metadataStoreName$value + ", fsyncEnable$value=" + this.fsyncEnable$value + ", synchronizer=" + String.valueOf(this.synchronizer) + ", openTelemetry$value=" + String.valueOf(this.openTelemetry$value) + ")";
        }
    }
}

